/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.IPlotAndImageExport;
import com.comsol.model.dbimodel.Information;
import com.comsol.model.dbimodel.InformationList;
import com.comsol.model.dbimodel.MATERIAL_TYPES;
import com.comsol.model.dbimodel.MaterialList;
import com.comsol.model.dbimodel.MaterialModel;
import com.comsol.model.dbimodel.MaterialModelList;
import com.comsol.model.dbimodel.MultiphysicsContributor;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.StudyContainer;
import com.comsol.model.dbimodel.XDLocalSelection;
import com.comsol.model.method.MaterialMethod;
import com.comsol.model.operations.IMaterialOperation;
import com.comsol.model.operations.IPropBlock;
import com.comsol.model.savepoint.interfaces.IMaterial;
import java.util.Collection;
import java.util.Map;

@PrimitiveModelEntity.TypeDoc(value="Material")
public interface Material
extends IPlotAndImageExport,
MultiphysicsContributor,
PropFeature,
StudyContainer,
IMaterial {
    @Override
    public MaterialMethod method();

    @Override
    public IMaterialOperation<IPropBlock> getOperation();

    public void touch();

    public void setEventType(int var1);

    public int getEventType();

    @Override
    public void setValid(boolean var1);

    public String[][] getTmpProp();

    public void setTmpProp(String[][] var1);

    public MATERIAL_TYPES getMaterialType();

    public MaterialList<? extends Material> getMaterialListGen();

    public void setMaterialType(MATERIAL_TYPES var1);

    public Map<String, Collection<String>> getUsedPhysicalQuantityMap();

    public String getUsedRule(String var1, String var2);

    public void setUsedRule(String var1, String var2, String var3, boolean var4);

    public void clearUsedRule();

    public String getIdentifier();

    public void setIdentifier(String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns a list of material information objects", ret="A list of material information objects", type=PrimitiveModelEntity.MethodType.ACCESS)
    public InformationList<? extends Information> info();

    @PrimitiveModelEntity.MethodDoc(doc="Returns a material information object", ret="Material information", type=PrimitiveModelEntity.MethodType.ACCESS)
    public Information info(@PrimitiveModelEntity.ParamDoc(name="name", doc="Material information tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns material property groups", ret="List of material property groups", type=PrimitiveModelEntity.MethodType.ACCESS)
    public MaterialModelList<? extends MaterialModel> propertyGroup();

    @PrimitiveModelEntity.MethodDoc(doc="Returns a material property group", ret="Material property group", type=PrimitiveModelEntity.MethodType.ACCESS)
    public MaterialModel propertyGroup(@PrimitiveModelEntity.ParamDoc(name="group", doc="Material property group tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns all material subfeatures", ret="List of materials", type=PrimitiveModelEntity.MethodType.ACCESS)
    public MaterialList<? extends PropFeature> feature();

    @PrimitiveModelEntity.MethodDoc(doc="Returns a material subfeature", ret="Material", type=PrimitiveModelEntity.MethodType.ACCESS)
    public Material feature(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Material tag") String var1);

    public void createReset(Material var1, boolean var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns material type", ret="Material type", type=PrimitiveModelEntity.MethodType.READ)
    public String materialType();

    @PrimitiveModelEntity.MethodDoc(doc="Sets material type", ret="Material", type=PrimitiveModelEntity.MethodType.WRITE)
    public Material materialType(@PrimitiveModelEntity.ParamDoc(name="name", doc="Material type") String var1);

    public String[][] definedAndUsedParameters();

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Returns the material's selection", ret="Selection", type=PrimitiveModelEntity.MethodType.ACCESS)
    public XDLocalSelection selection();

    public boolean isAllowVoids();

    public void setAllowVoids(boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #propertyGroup} instead", type=PrimitiveModelEntity.MethodType.ACCESS)
    @Deprecated
    public MaterialModelList<? extends MaterialModel> materialmodel();

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #propertyGroup} instead", type=PrimitiveModelEntity.MethodType.ACCESS)
    @Deprecated
    public MaterialModel materialmodel(String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #propertyGroup} instead", type=PrimitiveModelEntity.MethodType.ACCESS)
    @Deprecated
    public MaterialModelList<? extends MaterialModel> materialModel();

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #propertyGroup(String)} instead", type=PrimitiveModelEntity.MethodType.WRITE)
    @Deprecated
    public MaterialModel materialModel(String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #tag()} instead", type=PrimitiveModelEntity.MethodType.READ)
    @Deprecated
    public String identifier();

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #tag(String)} instead", ret="Material", type=PrimitiveModelEntity.MethodType.WRITE)
    @Deprecated
    public Material identifier(String var1);
}

