/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.automodeling.AutoMeshManager;
import com.comsol.model.automodeling.IAutoMeshProvider;
import com.comsol.model.dbimodel.GeomInfo;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.IFeatureListCreate;
import com.comsol.model.dbimodel.IPlotAndImageExport;
import com.comsol.model.dbimodel.MESH_TYPES;
import com.comsol.model.dbimodel.MeshData;
import com.comsol.model.dbimodel.MeshExport;
import com.comsol.model.dbimodel.MeshFeature;
import com.comsol.model.dbimodel.MeshFeatureList;
import com.comsol.model.dbimodel.MeshImportAssocNative;
import com.comsol.model.dbimodel.MeshNative;
import com.comsol.model.dbimodel.MeshStatistics;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.Study;
import com.comsol.model.dbimodel.StudyFeature;
import com.comsol.model.method.MeshSequenceMethod;
import com.comsol.model.operations.HAutoTable;
import com.comsol.model.savepoint.interfaces.IMeshSequence;
import com.comsol.nativemph.mesh.Mesh;
import com.comsol.nativemph.xmesh.Xmesh;
import com.comsol.nativeutil.data.RenderMeshCollection;
import java.util.List;

@PrimitiveModelEntity.TypeDoc(value="Meshing sequence")
public interface MeshSequence
extends IFeatureListCreate<MeshFeature>,
IPlotAndImageExport,
ModelEntity,
IMeshSequence {
    @Override
    public GeomSequence getGeom();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the geometry", ret="Geometry sequence tag", type=PrimitiveModelEntity.MethodType.READ)
    public String geom();

    public void setGeom(GeomSequence var1);

    public MeshFeatureList getFeature();

    public MeshFeatureList getFeatureGen();

    public MeshFeature getCurrentFeature();

    public void setCurrentFeature(MeshFeature var1);

    public void createAutoSequence();

    public MeshNative getMeshnative();

    public MeshNative getMeshnativeRaw();

    public void setMeshnative(MeshNative var1);

    public MeshNative getMeshnativeCurrent();

    public void setMeshnativeCurrent(MeshNative var1);

    public void setEmptyMeshNative();

    public long getCacheTagCurrent();

    public void setCacheTagCurrent(long var1);

    public long getCacheTagCurrentCurrent();

    public void setCacheTagCurrentCurrent(long var1);

    public String getToolsSize();

    public void setToolsSize(String var1);

    public Study getAdaptionStudy();

    public void setToolsSizeGen(String var1);

    public MESH_TYPES getType();

    public void setType(MESH_TYPES var1);

    public void setTypeGen(MESH_TYPES var1);

    public boolean isAutogenerated();

    public void setAutogenerated(boolean var1);

    public int getBuildNumber();

    public int[][] getConstructionEntitiesToKeep();

    public void setConstructionEntitiesToKeep(int[][] var1);

    public void assocMigrator();

    public int[][][] getEntAssocMapCurrent();

    public void setEntAssocMapCurrent(int[][][] var1);

    public int[][][] getEntAssocMapFinal();

    public void setEntAssocMapFinal(int[][][] var1);

    public List<ModelEntity> getContributingInterfaces();

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves the minimal quality in mesh", ret="Minimal quality", type=PrimitiveModelEntity.MethodType.READ)
    public double getMinQuality();

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves the minimal quality in mesh of a certain element type", ret="Minimal quality", type=PrimitiveModelEntity.MethodType.READ)
    public double getMinQuality(@PrimitiveModelEntity.ParamDoc(name="type", doc="Element type") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves the mean quality in mesh", ret="Mean quality", type=PrimitiveModelEntity.MethodType.READ)
    public double getMeanQuality();

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves the mean quality in mesh of a certain element type", ret="Mean quality", type=PrimitiveModelEntity.MethodType.READ)
    public double getMeanQuality(@PrimitiveModelEntity.ParamDoc(name="type", doc="Element type") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves the quality distribution", ret="Number of elements in each quality distribution slices", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getQualityDistr(@PrimitiveModelEntity.ParamDoc(name="size", doc="Number of quality distribution slice") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves the quality distribution of a certain element type", ret="Number of elements in each quality distribution slices", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getQualityDistr(@PrimitiveModelEntity.ParamDoc(name="type", doc="Element type") String var1, @PrimitiveModelEntity.ParamDoc(name="size", doc="Number of quality distribution slices") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves the maximum growth rate in mesh", ret="Maximum growth rate", type=PrimitiveModelEntity.MethodType.READ)
    public double getMaxGrowthRate();

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves the mean growth rate in mesh", ret="Mean growth rate", type=PrimitiveModelEntity.MethodType.READ)
    public double getMeanGrowthRate();

    public double[] getGeomDimension();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the minimum element volume", ret="Minimum element volume", type=PrimitiveModelEntity.MethodType.READ)
    public double getMinVolume();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the minimum element volume of a certain element type", ret="Minimum element volume", type=PrimitiveModelEntity.MethodType.READ)
    public double getMinVolume(@PrimitiveModelEntity.ParamDoc(name="type", doc="Element type") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the maximum element volume", ret="Maximum element volume", type=PrimitiveModelEntity.MethodType.READ)
    public double getMaxVolume();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the maximum element volume of a certain element type", ret="Maximum element volume", type=PrimitiveModelEntity.MethodType.READ)
    public double getMaxVolume(@PrimitiveModelEntity.ParamDoc(name="type", doc="element type") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Gets the total mesh volume", ret="Mesh volume", type=PrimitiveModelEntity.MethodType.READ)
    public double getVolume();

    @PrimitiveModelEntity.MethodDoc(doc="Gets the total mesh volume for a certain element type", ret="Mesh volume", type=PrimitiveModelEntity.MethodType.READ)
    public double getVolume(@PrimitiveModelEntity.ParamDoc(name="type", doc="Element type") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns mesh statistics object", ret="Mesh statistics object", type=PrimitiveModelEntity.MethodType.ACCESS)
    public MeshStatistics stat();

    public void notifyGeometryChanged();

    @PrimitiveModelEntity.MethodDoc(doc="Gets space dimension of mesh", ret="Space dimension", type=PrimitiveModelEntity.MethodType.READ)
    public int getSDim();

    @PrimitiveModelEntity.MethodDoc(doc="Gets the number of elements in a mesh", ret="Number of elements", type=PrimitiveModelEntity.MethodType.READ)
    public int getNumElem();

    @PrimitiveModelEntity.MethodDoc(doc="Gets the number of elements of a certain mesh type", ret="Number of elements", type=PrimitiveModelEntity.MethodType.READ)
    public int getNumElem(@PrimitiveModelEntity.ParamDoc(name="type", doc="Element type") String var1);

    public int getNumElem(int var1, int[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the types in a mesh", ret="Vector of mesh types", type=PrimitiveModelEntity.MethodType.READ)
    public String[] getTypes();

    @PrimitiveModelEntity.MethodDoc(doc="Checks if the entire selected geometry has a mesh", ret="<code>true</code> if the entire selected geometry has a mesh", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isComplete();

    @PrimitiveModelEntity.MethodDoc(doc="Checks if the mesh is empty", ret="<code>true</code> if the mesh is empty", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isEmpty();

    public void registerAutoModeler(IAutoMeshProvider var1);

    public void unregisterAutoModeler(IAutoMeshProvider var1);

    public String getKeyForEntitiesToKeep();

    public boolean hasMesh();

    @Override
    public Mesh getMesh();

    public Mesh getMeshCurrent();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the mesh export tool", ret="Mesh export tool", type=PrimitiveModelEntity.MethodType.ACCESS)
    public MeshExport export();

    public MeshExport getExportGen();

    public String getPreceding(String var1, boolean var2);

    public boolean isBuiltUntil(String var1);

    public MeshSequence getMasterSequence();

    public MeshFeature getFinalizeFeature();

    public void createFinalizeFeature();

    public void setMeshCurrent(Mesh var1, long var2);

    @PrimitiveModelEntity.MethodDoc(doc="Checks if the sequence is in an automatic state", ret="<code>true</code> if the sequence is in an automatic state", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isAutomatic();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the state of the sequence", type=PrimitiveModelEntity.MethodType.WRITE)
    public void automatic(@PrimitiveModelEntity.ParamDoc(name="automatic", doc="Specifies if the sequence is in an automatic state") boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Gets the size adjustment number", ret="The size adjustment number", type=PrimitiveModelEntity.MethodType.READ)
    public double autoMeshSize();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the size adjustment number", ret="Mesh sequence", type=PrimitiveModelEntity.MethodType.WRITE)
    public MeshSequence autoMeshSize(@PrimitiveModelEntity.ParamDoc(name="size", doc="The size adjustment number") double var1);

    @PrimitiveModelEntity.MethodDoc(doc="Removes all features from the sequence and clears the mesh", type=PrimitiveModelEntity.MethodType.WRITE)
    public void clearMesh();

    public void runAuto();

    public void synchronizeMesh();

    public MeshFeature getSizeDefaultFeature();

    public void createReset(MeshSequence var1, boolean var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns geometric entity indices for a certain mesh type", ret="Vector of geometric entity indices", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getGeomEntities(@PrimitiveModelEntity.ParamDoc(name="type", doc="Element type") String var1);

    public int[] getMeshedEntities(int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Gets number of mesh vertices", ret="Number of mesh vertices", type=PrimitiveModelEntity.MethodType.READ)
    public int getNumVertex();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the mesh data", ret="Mesh data", type=PrimitiveModelEntity.MethodType.ACCESS)
    public MeshData data();

    @PrimitiveModelEntity.MethodDoc(doc="Gets the coordinates of the mesh vertices", ret="Matrix where each column corresponds to a mesh vertex", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] getVertex();

    @PrimitiveModelEntity.MethodDoc(doc="Gets block of coordinates of the mesh vertices", ret="Matrix where each column corresponds to a mesh vertex", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] getVertex(@PrimitiveModelEntity.ParamDoc(name="position", doc="Start index") int var1, @PrimitiveModelEntity.ParamDoc(name="number", doc="Length of block") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Gets elements from the mesh", ret="Matrix where each column contains the mesh vertex indices of an element's corners", type=PrimitiveModelEntity.MethodType.READ)
    public int[][] getElem(@PrimitiveModelEntity.ParamDoc(name="type", doc="Mesh type") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Gets blocks of elements from the mesh", ret="Matrix where each column contains the mesh vertex indices of an element's corners", type=PrimitiveModelEntity.MethodType.READ)
    public int[][] getElem(@PrimitiveModelEntity.ParamDoc(name="type", doc="Mesh type") String var1, @PrimitiveModelEntity.ParamDoc(name="position", doc="Start index") int var2, @PrimitiveModelEntity.ParamDoc(name="number", doc=" Length of block") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Gets geometric entity number for the elements of a specific type", ret="Vector of geometric entity numbers", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getElemEntity(@PrimitiveModelEntity.ParamDoc(name="type", doc="Mesh type") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Gets blocks of geometric entity number for the elements of a specific type", ret="Vector of geometric entity numbers", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getElemEntity(@PrimitiveModelEntity.ParamDoc(name="type", doc="Mesh type") String var1, @PrimitiveModelEntity.ParamDoc(name="position", doc="Start index") int var2, @PrimitiveModelEntity.ParamDoc(name="number", doc="Length of block") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Export mesh to file. MPHBIN, MPHTXT, and STL (3D only) formats are supported", ret="Full path of exported file.", type=PrimitiveModelEntity.MethodType.READ)
    public String export(@PrimitiveModelEntity.ParamDoc(name="filename", doc="File name") String var1);

    public void refresh();

    @Override
    public void setMesh(Mesh var1, long var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns <code>true</code> if meshing sequence has problems", ret="<code>true</code> if meshing sequence has problems", type=PrimitiveModelEntity.MethodType.READ)
    public boolean hasProblems();

    public RenderMeshCollection getRenderMeshCollection();

    @PrimitiveModelEntity.MethodDoc(doc="Returns mesh feature list", ret="Mesh feature list", type=PrimitiveModelEntity.MethodType.ACCESS)
    public MeshFeatureList<? extends MeshFeature> feature();

    @PrimitiveModelEntity.MethodDoc(doc="Returns mesh feature", ret="Mesh feature list", type=PrimitiveModelEntity.MethodType.ACCESS)
    public MeshFeature feature(@PrimitiveModelEntity.ParamDoc(name="fname", doc="Mesh feature tag") String var1);

    public MeshSequence[] getDependencySequence();

    public HAutoTable getHAutoTable();

    @PrimitiveModelEntity.MethodDoc(doc="Builds the current mesh feature", type=PrimitiveModelEntity.MethodType.WRITE)
    public void runCurrent();

    @PrimitiveModelEntity.MethodDoc(doc="Builds all mesh features", type=PrimitiveModelEntity.MethodType.WRITE)
    public void run();

    @PrimitiveModelEntity.MethodDoc(doc="Builds named mesh feature", ret="", type=PrimitiveModelEntity.MethodType.WRITE)
    public void run(@PrimitiveModelEntity.ParamDoc(name="fname", doc="Mesh feature tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns tag of current mesh feature", ret="Current mesh feature tag", type=PrimitiveModelEntity.MethodType.READ)
    public String current();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the current feature", ret="The sequence itself", type=PrimitiveModelEntity.MethodType.WRITE)
    public MeshSequence current(@PrimitiveModelEntity.ParamDoc(name="fname", doc="New current feature tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns mesh information object", ret="Mesh information object", type=PrimitiveModelEntity.MethodType.ACCESS)
    public GeomInfo info();

    @PrimitiveModelEntity.MethodDoc(doc="Returns mesh information object for the current mesh of a import sequence", ret="Mesh information object", type=PrimitiveModelEntity.MethodType.ACCESS)
    public GeomInfo infoCurrent();

    public void initialize(Xmesh var1, int var2, MESH_TYPES var3);

    public void initialize(Mesh var1, MESH_TYPES var2);

    public void setLastBuiltFeature(MeshFeature var1);

    public MeshFeature getLastBuiltFeature();

    public void setStatistics(MeshStatistics var1);

    public void setGlobalStatistics(MeshStatistics var1);

    public MeshStatistics getStatistics();

    public MeshStatistics getGlobalStatistics(boolean var1, boolean var2);

    default public MeshStatistics getGlobalStatistics() {
        return this.getGlobalStatistics(true, false);
    }

    public MeshNative getNewMeshNative(Mesh var1);

    public void setLockedMesh(boolean var1);

    public boolean isLockedMesh();

    public AutoMeshManager getAutoMeshManager();

    public MeshImportAssocNative getImportAssoc();

    public void setImportAssoc(MeshImportAssocNative var1);

    @Override
    public MeshSequenceMethod method();

    public boolean isFinalized();

    public boolean hasDataFeature();

    public boolean isMeshPart();

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Creates a mesh feature", ret="Created mesh feature", type=PrimitiveModelEntity.MethodType.WRITE)
    public MeshFeature create(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Mesh feature tag") String var1, @PrimitiveModelEntity.ParamDoc(name="oper", doc="Mesh feature type") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Return features with errors or warnings", ret="Array with feature tags", type=PrimitiveModelEntity.MethodType.READ)
    public String[] problems();

    public boolean updateHashKey(boolean var1);

    public long getHashKey();

    public void setHashKey(long var1);

    public int[] mapFinalizedToCurrent(int var1, int[] var2);

    public int[] mapMeshControlEntitiesToMeshGeom(int var1, int[] var2);

    public void initializeTransientData();

    public boolean isGeneratingSequence();

    public boolean isImportSequence();

    public boolean isGeneratedUsingAPI();

    @PrimitiveModelEntity.MethodDoc(doc="Returns <code>true</code> if meshing sequence has second order elements", ret="<code>true</code> if meshing sequence has second order elements", type=PrimitiveModelEntity.MethodType.READ)
    public boolean hasSecondOrderElements();

    @PrimitiveModelEntity.MethodDoc(doc="Returns path to adaptation study feature", ret="Path to adaptation study feature", type=PrimitiveModelEntity.MethodType.READ)
    public String adaptationStudyFeature();

    @PrimitiveModelEntity.MethodDoc(doc="Sets adaptation study feature", type=PrimitiveModelEntity.MethodType.WRITE)
    public void adaptationStudyFeature(@PrimitiveModelEntity.ParamDoc(name="tag", doc="A path of tags to the adaptation study feature") String var1);

    public StudyFeature getAdapStudyFeature();

    public void setAdapStudyFeature(StudyFeature var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns contributing status of a physics interface or other contributing feature", ret="<code>true</code> if contributing", type=PrimitiveModelEntity.MethodType.READ)
    public boolean contributing(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Tag of a physics interface or other contributing feature") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets contributing status of a physics interface or other contributing feature", ret="Study feature", type=PrimitiveModelEntity.MethodType.WRITE)
    public MeshSequence contribute(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Tag of a physics interface or other contributing feature") String var1, @PrimitiveModelEntity.ParamDoc(name="state", doc="Contributing state") boolean var2);

    public List<ModelEntity> getAllSuggestionProviders();

    public void runInternal();

    public void setForceUsingHashKey(boolean var1);

    public MeshNodeType getNodeType();

    public String getMeshNodeDescriptor();

    public void setZoomExtentsOnBuild(boolean var1);

    public boolean isZoomExtentsOnBuild();

    public static enum MeshNodeType {
        Undefined,
        AdaptedLegacy,
        StudyControlled,
        APIGenerated,
        PhysicsControlled,
        Manual,
        Import,
        MeshPart;

    }
}

