/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.AbstractSelection;
import com.comsol.model.dbimodel.HL_TYPES;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.SEL_TYPES;
import com.comsol.model.dbimodel.SavePointGeom;
import com.comsol.model.savepoint.interfaces.IGeomSequence;
import com.comsol.model.selections.SelectionMethod;
import java.util.List;

@PrimitiveModelEntity.TypeDoc(value="Selection")
public interface Selection
extends AbstractSelection {
    public boolean isAllgeom();

    public boolean isAllvoids();

    public List<HL_TYPES> getTypeList();

    public boolean isIncludeMeshInterior();

    @PrimitiveModelEntity.MethodDoc(doc="Makes the selection global", ret="Selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public Selection global();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the selection to a geometry <code>geom</code>", ret="Selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public Selection geom(@PrimitiveModelEntity.ParamDoc(name="geom", doc="Geometry tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the selection to the be geometric entities of level <code>dim</code> on geometry <code>geom</code>", ret="Selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public Selection geom(@PrimitiveModelEntity.ParamDoc(name="geom", doc="Geometry tag") String var1, @PrimitiveModelEntity.ParamDoc(name="dim", doc="Geometry entity level") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the selection to the be geometric entities of level <code>lowdim</code> on geometry <code>geom</code>. The input is given on level <code>highdim</code> and the output is calculated using the given types, which can be <code>exterior</code>, <code>interior</code>, <code>meshinterior</code>", ret="Selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public Selection geom(@PrimitiveModelEntity.ParamDoc(name="geom", doc="Geometry tag") String var1, @PrimitiveModelEntity.ParamDoc(name="highdim", doc="Geometric entity level for selection input") int var2, @PrimitiveModelEntity.ParamDoc(name="lowdim", doc="Geometric entity level for selection output") int var3, @PrimitiveModelEntity.ParamDoc(name="typelist", doc="Types included in output") String[] var4);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the selection to the be geometric entities of level <code>dim</code>. Can be used instead of {@link #geom(String, int)} when the geometry is unambiguous.", ret="Selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public Selection geom(@PrimitiveModelEntity.ParamDoc(name="dim", doc="Geometric entity level") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the selection to the whole geometry. Can be used instead of {@link #geom(String)} when the geometry is unambiguous", ret="Selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public Selection allGeom();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the selected domains to be all geometric entities", ret="Selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public Selection all();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the selected domains to include all voids", ret="Selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public Selection allVoids();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the selection to use the given geometric entities", ret="Selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public Selection set(int ... var1);

    @PrimitiveModelEntity.MethodDoc(doc="Adds the given entities to the selection", ret="Selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public Selection add(int ... var1);

    @PrimitiveModelEntity.MethodDoc(doc="Removes the given entities from the selection", ret="Selection", type=PrimitiveModelEntity.MethodType.READ)
    public Selection remove(int ... var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the inherit flag", ret="Selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public Selection inherit(@PrimitiveModelEntity.ParamDoc(name="flag", doc="Inherit flag") boolean var1);

    public Selection intersection(Selection var1);

    public Selection union(Selection var1);

    public Selection difference(Selection var1);

    @PrimitiveModelEntity.MethodDoc(doc="The dimension of the domains used as input. If the selection is of the type <code>interior</code>, <code>exterior</code>, or <code>meshinterior</code>, this method returns the higher dimension with the input domains. If the selection is not a selection of domains at a certain level, this returns -1", ret="Selection input dimension", type=PrimitiveModelEntity.MethodType.READ)
    public int inputDimension();

    @PrimitiveModelEntity.MethodDoc(doc="The domains used as input to the selection. If the selection is of the type  <code>interior</code>, <code>exterior</code>, or <code>meshinterior</code>. this method returns the unfiltered list of domains at the higher dimension which are used as the input. If the selection is not a selection of domains at a certain level or the selection is not of the types Explicit or FromGeom (derived from a geometry feature), this method returns null", ret="Selection input dimension", type=PrimitiveModelEntity.MethodType.READ)
    public int[] inputEntities();

    @PrimitiveModelEntity.MethodDoc(doc="Returns <code>true</code> if the selection is global", ret="<code>true</code> if a global selection", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isGlobal();

    @PrimitiveModelEntity.MethodDoc(doc="Returns <code>true</code> if the selection is a whole geometry", ret="<code>true</code> if a whole geometry", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isGeom();

    @PrimitiveModelEntity.MethodDoc(doc="If the selection is on a geometry, return the geometric entities on the given dimension", ret="Vector of geometric entities", type=PrimitiveModelEntity.MethodType.READ)
    public int[] entities(@PrimitiveModelEntity.ParamDoc(name="dim", doc="Dimension to analyze") int var1);

    public int[] unfilteredEntities(int var1);

    public boolean inputIsEmpty();

    @PrimitiveModelEntity.MethodDoc(doc="If the selection is on a geometry, return the interior entities of the given dimension", ret="List of interior entities", type=PrimitiveModelEntity.MethodType.READ)
    public int[] interiorEntities(@PrimitiveModelEntity.ParamDoc(name="dim", doc="Dimension to analyze") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns <code>true</code> if the selection is inherited to lower dimension levels", ret="<code>true</code> if the selection is inherited", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isInheriting();

    public Selection useSelectionCache(boolean var1);

    public IGeomSequence getGeomSequence();

    public boolean selectOnMeshGeom();

    public void copy(Selection var1, boolean var2);

    public int getNEntities(int var1);

    public int[] getAssocUpdatedSelection(int[][] var1, int var2, int var3, int var4, int var5, int var6, int[] var7);

    @Override
    public SEL_TYPES getSelType();

    public int getDim();

    public int getHDim();

    public SavePointGeom getSavePointGeom();

    @Override
    public SelectionMethod selectionMethod();

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #allGeom()} instead")
    @Deprecated
    public Selection allgeom();

    public Selection newInstance();
}

