/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.applapi.IApplPostInfo;
import com.comsol.model.automodeling.AutoSolverProvider;
import com.comsol.model.dbimodel.LocalSelection;
import com.comsol.model.dbimodel.MatchTagContainer;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.MultigridLevel;
import com.comsol.model.dbimodel.MultigridLevelList;
import com.comsol.model.dbimodel.MultiphysicsContributor;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.StudyContainer;

@PrimitiveModelEntity.TypeDoc(value="Study step")
public interface StudyFeature
extends MatchTagContainer,
MultiphysicsContributor,
PropFeature,
StudyContainer {
    public MultigridLevelList<? extends PropFeature> getMglevel();

    @PrimitiveModelEntity.MethodDoc(doc="Tries to load a file content into the study feature. Returns the success of the operation", ret="<code>true</code> if success", type=PrimitiveModelEntity.MethodType.WRITE)
    public boolean loadFile(@PrimitiveModelEntity.ParamDoc(name="filePath", doc="Path of the file") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Tries to save the content of the study feature to a file. Returns the success of the operation", ret="<code>true</code> if active", type=PrimitiveModelEntity.MethodType.READ)
    public boolean saveFile(@PrimitiveModelEntity.ParamDoc(name="filePath", doc="Path of the file") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the study type", ret="Study type", type=PrimitiveModelEntity.MethodType.READ)
    public String type();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the mesh selected for the given geometry", ret="Mesh sequence tag", type=PrimitiveModelEntity.MethodType.READ)
    public String mesh(@PrimitiveModelEntity.ParamDoc(name="geom", doc="Geometry sequence tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Specifies which mesh to use for the geometry", ret="Study feature", type=PrimitiveModelEntity.MethodType.READ)
    public StudyFeature mesh(@PrimitiveModelEntity.ParamDoc(name="geom", doc="Geometry sequence tag") String var1, @PrimitiveModelEntity.ParamDoc(name="mesh", doc="Mesh sequence tag") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns multigrid level list for this study step", ret="List of multigrid levels", type=PrimitiveModelEntity.MethodType.ACCESS)
    public MultigridLevelList<? extends PropFeature> mglevel();

    @PrimitiveModelEntity.MethodDoc(doc="Sets a multigrid level for this study step", ret="Multigrid level", type=PrimitiveModelEntity.MethodType.WRITE)
    public MultigridLevel mglevel(@PrimitiveModelEntity.ParamDoc(name="level", doc="Multigrid level tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets activation status of a physics interface or a physics interface feature", ret="Study feature", type=PrimitiveModelEntity.MethodType.WRITE)
    public StudyFeature activate(@PrimitiveModelEntity.ParamDoc(name="physics", doc="Physics interface or physics feature") String var1, @PrimitiveModelEntity.ParamDoc(name="state", doc="Activation state") boolean var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns activation status of a physics interface or a physics interface feature", ret="<code>true</code> if active", type=PrimitiveModelEntity.MethodType.READ)
    public boolean activate(@PrimitiveModelEntity.ParamDoc(name="physics", doc="Physics interface or physics feature") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Assigns discretization for a multigrid level", ret="Study feature", type=PrimitiveModelEntity.MethodType.WRITE)
    public StudyFeature discretization(@PrimitiveModelEntity.ParamDoc(name="physics", doc="Physics interface or physics feature") String var1, @PrimitiveModelEntity.ParamDoc(name="disc", doc="Discretization feature under a physics mode") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns discretization for a multigrid level", ret="Discretization feature under a physics mode", type=PrimitiveModelEntity.MethodType.READ)
    public String discretization(@PrimitiveModelEntity.ParamDoc(name="physics", doc="Physics interface or physics feature") String var1);

    public boolean contributesPhysics();

    public AutoSolverProvider getSolverSuggestions();

    public StudyFeature getNotStudyFeature();

    public void touch();

    public void requestRedraw();

    public IApplPostInfo getPostInfo();

    public boolean isMoving();

    public void setupAnalysisCase();

    public boolean revertAnalysisCase();

    public AnalysisCaseStatus getAnalysisCaseStatus(ModelEntity var1);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Returns a study feature's selection property", ret="Selection", type=PrimitiveModelEntity.MethodType.ACCESS)
    public LocalSelection selection(@PrimitiveModelEntity.ParamDoc(name="name", doc="The selection property name") String var1);

    public static enum AnalysisCaseStatus {
        NONE,
        NO_FRAME_CONTROL,
        DISABLED;

    }
}

