/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.ResultBaseFeature;

@PrimitiveModelEntity.TypeDoc(value="Base class for table features.")
public interface TableBaseFeature
extends ResultBaseFeature {
    @PrimitiveModelEntity.MethodDoc(doc="Get the real data in the table. This method always uses the <code>all</code> format", ret="Matrix of real table data", type=PrimitiveModelEntity.MethodType.WRITE)
    public double[][] getReal();

    @PrimitiveModelEntity.MethodDoc(doc="Get the real data in a row (0-index)", ret="Vector of real table data", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getRealRow(@PrimitiveModelEntity.ParamDoc(name="index", doc="Row index") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Get the imaginary data in the table. This method will allocate imaginary data if none. This method always uses the <code>all</code> format.", ret="Matrix of imaginary table data", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] getImag();

    @PrimitiveModelEntity.MethodDoc(doc="Get the imaginary data in a row (0-index)", ret="Vector of imaginary table data", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getImagRow(@PrimitiveModelEntity.ParamDoc(name="index", doc="Row index") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Check if the table has allocated complex data", ret="<code>true</code> if complex", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isComplex();

    @PrimitiveModelEntity.MethodDoc(doc="Remove all data in the table", type=PrimitiveModelEntity.MethodType.WRITE)
    public void clearTableData();

    @PrimitiveModelEntity.MethodDoc(doc="Set the real data in the table", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setTableData(@PrimitiveModelEntity.ParamDoc(name="realData", doc="Matrix of real table data") double[][] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Set the real and imaginary data in the table. The latter can be null if none", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setTableData(@PrimitiveModelEntity.ParamDoc(name="realData", doc="Matrix of real table data") double[][] var1, @PrimitiveModelEntity.ParamDoc(name="imagData", doc="Matrix of imaginary table data") double[][] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Get the table data as a string matrix, with or without full precision", type=PrimitiveModelEntity.MethodType.WRITE)
    public String[][] getTableData(@PrimitiveModelEntity.ParamDoc(name="fullPrecision", doc="<code>true</code> for full precision") boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Get the table data of one row as a string array", ret="String vector of table row data", type=PrimitiveModelEntity.MethodType.WRITE)
    public String[] getTableRow(@PrimitiveModelEntity.ParamDoc(name="index", doc="Row index") int var1, @PrimitiveModelEntity.ParamDoc(name="fullPrecision", doc="<code>true</code> for full precision") boolean var2);

    public String[] getTableRow(int var1, boolean var2, Notation var3, ComplexNotation var4);

    public String[] getTableRow(int var1, double[][] var2, boolean var3, Notation var4, ComplexNotation var5);

    @PrimitiveModelEntity.MethodDoc(doc="Get the table's column headers", ret="Vector with column headers", type=PrimitiveModelEntity.MethodType.READ)
    public String[] getColumnHeaders();

    @PrimitiveModelEntity.MethodDoc(doc="Set the table's column headers, but leave the table's data unchanged.")
    public void setColumnHeaders(@PrimitiveModelEntity.ParamDoc(name="value", doc="The column headers.") String[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Get the number of rows in the table", ret="Number of rows", type=PrimitiveModelEntity.MethodType.READ)
    public int getNRows();

    public boolean isAllDataInModel();

    public void setWarnings(boolean[][] var1);

    public void setWarningRow(int var1, boolean[] var2);

    public boolean hasWarnings();

    public boolean[] getWarningsRow(int var1);

    public boolean[][] getWarningData();

    public boolean isFilledPresentation();

    public String[][] getModelData(boolean var1, Notation var2, ComplexNotation var3);

    @PrimitiveModelEntity.MethodDoc(doc="Save the table data in full precision to a text file", type=PrimitiveModelEntity.MethodType.READ)
    public void save(@PrimitiveModelEntity.ParamDoc(name="filename", doc="File name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Save the table data to a text file", type=PrimitiveModelEntity.MethodType.READ)
    public void save(@PrimitiveModelEntity.ParamDoc(name="filename", doc="File name") String var1, @PrimitiveModelEntity.ParamDoc(name="fullPrecision", doc="<code>true</code> for full precision") boolean var2);

    public void save(String var1, boolean var2, boolean var3, boolean var4, boolean var5);

    @PrimitiveModelEntity.MethodDoc(doc="Saves to a file.")
    public void saveFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Saves to an Excel-file in a specified range, or at a cell to start from, in a specified sheet.")
    public void saveFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="sheet", doc="The Excel-sheet to use") String var2, @PrimitiveModelEntity.ParamDoc(name="range", doc="The range, or a starting cell") String var3, @PrimitiveModelEntity.ParamDoc(name="includeHeaders", doc="True if column headers are to be written") boolean var4, @PrimitiveModelEntity.ParamDoc(name="overwrite", doc="True if an existing file is to be overwritten, or if an error should be cast in that instance.") boolean var5);

    @PrimitiveModelEntity.MethodDoc(doc="Saves to an Excel-file in a specified range, or at a cell to start from, in a specified sheet.")
    public void saveFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="fullPrecision", doc="<code>true</code> for full precision") boolean var2, @PrimitiveModelEntity.ParamDoc(name="sheet", doc="The Excel-sheet to use") String var3, @PrimitiveModelEntity.ParamDoc(name="range", doc="The range, or a starting cell") String var4, @PrimitiveModelEntity.ParamDoc(name="includeHeaders", doc="True if column headers are to be written") boolean var5, @PrimitiveModelEntity.ParamDoc(name="overwrite", doc="True if an existing file is to be overwritten, or if an error should be cast in that instance.") boolean var6);

    @PrimitiveModelEntity.MethodDoc(doc="Remove a row with a given index, if it exists.", type=PrimitiveModelEntity.MethodType.WRITE)
    public void removeRow(@PrimitiveModelEntity.ParamDoc(name="index", doc="Row index") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Remove a column with a given index, if it exists", type=PrimitiveModelEntity.MethodType.WRITE)
    public void removeColumn(@PrimitiveModelEntity.ParamDoc(name="index", doc="Column index") int var1);

    public void update(boolean var1);

    public boolean hasRowHeaders();

    public String[] getRowHeaders();

    public void scrollToLastRow();

    public static enum ComplexNotation {
        RECTANGULAR,
        POLAR;

    }

    public static enum Notation {
        AUTO,
        SCIENTIFIC,
        ENGINEERING,
        DECIMAL;

    }
}

