/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.PropFeatureList;
import com.comsol.model.dbimodel.SOL_ANALYSIS_TYPES;
import com.comsol.model.dbimodel.TableBaseFeature;
import com.comsol.nativemph.post.PostData;

@PrimitiveModelEntity.TypeDoc(value="Contains numerical results, possibly from different sources")
public interface TableFeature
extends TableBaseFeature {
    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Returns the list of features in this table", ret="List of table features", type=PrimitiveModelEntity.MethodType.ACCESS)
    public PropFeatureList<? extends PropFeature> feature();

    public int[] getSolnum();

    public void setSolnum(int[] var1);

    public int[] getOuterSolnum();

    public void setOuterSolnum(int[] var1);

    public SOL_ANALYSIS_TYPES getInputType();

    public void setInputType(SOL_ANALYSIS_TYPES var1);

    public double[] getT();

    public void setT(double[] var1);

    public int getNInput();

    public void setNInput(int var1);

    public String[] getFilledPNames();

    public void setFilledPNames(String[] var1);

    public String[] getFilledPDescriptions();

    public void setFilledPDescriptions(String[] var1);

    public double[][] getFilledPVals();

    public void setFilledPVals(double[][] var1);

    public String[] getHeaderData();

    public void setHeaderData(String[] var1);

    public int[] getFilledPColumnIndex();

    public void setFilledPColumnIndex(int[] var1);

    public boolean isFilled();

    public void setFilled(boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Add columns with given headers and real data", type=PrimitiveModelEntity.MethodType.WRITE)
    public void addColumns(@PrimitiveModelEntity.ParamDoc(name="headers", doc="Vector of header texts") String[] var1, @PrimitiveModelEntity.ParamDoc(name="realData", doc="Matrix of real data") double[][] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Add columns with given headers and real and imaginary data. The latter can be null if none", type=PrimitiveModelEntity.MethodType.WRITE)
    public void addColumns(@PrimitiveModelEntity.ParamDoc(name="headers", doc="Vector of header texts") String[] var1, @PrimitiveModelEntity.ParamDoc(name="realData", doc="Matrix of real data") double[][] var2, @PrimitiveModelEntity.ParamDoc(name="imagData", doc="Matrix of imaginary data") double[][] var3);

    @PrimitiveModelEntity.MethodDoc(doc="Add a row with real data", type=PrimitiveModelEntity.MethodType.WRITE)
    public void addRow(@PrimitiveModelEntity.ParamDoc(name="realData", doc="Matrix of real data") double[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Add a row with real data", type=PrimitiveModelEntity.MethodType.WRITE)
    public void addRowAndWarnings(@PrimitiveModelEntity.ParamDoc(name="realData", doc="Matrix of real data") double[] var1, @PrimitiveModelEntity.ParamDoc(name="warning", doc="Matrix of boolean data") boolean[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Add a row with real and imaginary data", type=PrimitiveModelEntity.MethodType.WRITE)
    public void addRow(@PrimitiveModelEntity.ParamDoc(name="realData", doc="Matrix of real data") double[] var1, @PrimitiveModelEntity.ParamDoc(name="imagData", doc="Matrix of imaginary data") double[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Add a row with real and imaginary data", type=PrimitiveModelEntity.MethodType.WRITE)
    public void addRowAndWarnings(@PrimitiveModelEntity.ParamDoc(name="realData", doc="Matrix of real data") double[] var1, @PrimitiveModelEntity.ParamDoc(name="imagData", doc="Matrix of imaginary data") double[] var2, @PrimitiveModelEntity.ParamDoc(name="warnings", doc="Matrix of boolean data") boolean[] var3);

    @PrimitiveModelEntity.MethodDoc(doc="Get the real data in the table on the filled format", ret="Matrix of real table data", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] getFilledReal();

    @PrimitiveModelEntity.MethodDoc(doc="Get the imaginary data in the table on the filled format. This method will allocate imaginary data if none.", ret="Matrix of imaginary table data", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] getFilledImag();

    public void clearTableDataNoProbeReset();

    public void addPData(String[] var1, String[] var2, double[][] var3, int[] var4);

    public void updateIfBuilt();

    public String[] getFilledFixedDescriptions(String var1, String var2);

    public void makeUserDefined();

    public PostData copyFilledToPostData(String var1, String var2, int var3, int var4, boolean var5);

    public String[] getAllColumnHeaders();

    public void setProbeRunning(boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Fill the table with real or complex data from a file", type=PrimitiveModelEntity.MethodType.WRITE)
    public void importData(@PrimitiveModelEntity.ParamDoc(name="filename", doc="File name") String var1);

    public String[][] getModelData(boolean var1);

    public void ensureUpdated(boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Loads from a file.")
    public void loadFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Loads from an Excel-file with a specified range to read, or a cell to start from, in the specified sheet.")
    public void loadFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="sheet", doc="The Excel-sheet to use") String var2, @PrimitiveModelEntity.ParamDoc(name="range", doc="The range, or a starting cell") String var3);
}

