/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.IntRule;
import com.comsol.model.dbimodel.MatchTagContainer;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.SelectionEntity;
import com.comsol.model.dbimodel.StudyContainer;
import com.comsol.model.dbimodel.XDLocalSelection;
import java.util.List;

@PrimitiveModelEntity.TypeDoc(value="Weak form equations.")
public interface Weak
extends MatchTagContainer,
SelectionEntity,
StudyContainer {
    public List<? extends IntRule> getIntrules();

    public List<? extends IntRule> getXdIntrules();

    public List<String> getEquations();

    @PrimitiveModelEntity.MethodDoc(doc="Assigns the integration rules to the weak form equations", ret="Weak form equations", type=PrimitiveModelEntity.MethodType.WRITE)
    public Weak intRule(@PrimitiveModelEntity.ParamDoc(name="irlist", doc="List of integration rule tags") String[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Assigns an integration rule to a position in the weak form equations", ret="Weak form equations", type=PrimitiveModelEntity.MethodType.WRITE)
    public Weak intRule(@PrimitiveModelEntity.ParamDoc(name="pos", doc="Position") int var1, @PrimitiveModelEntity.ParamDoc(name="irule", doc="Integration rule tag") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns list of integration rules", ret="List of integration rules", type=PrimitiveModelEntity.MethodType.READ)
    public String[] intRule();

    @PrimitiveModelEntity.MethodDoc(doc="Assigns an integration rule to the weak form equations", ret="Weak form equations", type=PrimitiveModelEntity.MethodType.WRITE)
    public Weak intRule(@PrimitiveModelEntity.ParamDoc(name="irule", doc="Integration rule tag") String var1);

    public void setAbsorbingBCDD(boolean var1);

    public boolean getAbsorbingBCDD();

    public void setShiftedLaplaceMain(boolean var1);

    public void setShiftedLaplaceMG(boolean var1);

    public boolean getShiftedLaplaceMain();

    public boolean getShiftedLaplaceMG();

    @PrimitiveModelEntity.MethodDoc(doc="Assigns the extra dimension integration rules to the weak form feature", ret="Weak form equations", type=PrimitiveModelEntity.MethodType.WRITE)
    public Weak xdIntRule(@PrimitiveModelEntity.ParamDoc(name="irlist", doc="List of integration rule tags") String[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Assigns an extra dimension integration rule to a position in the weak form feature", ret="Weak form equations", type=PrimitiveModelEntity.MethodType.WRITE)
    public Weak xdIntRule(@PrimitiveModelEntity.ParamDoc(name="pos", doc="Position") int var1, @PrimitiveModelEntity.ParamDoc(name="irule", doc="Integration rule tag") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns list of extra dimension integration rules", ret="List of extra dimension integration rules", type=PrimitiveModelEntity.MethodType.READ)
    public String[] xdIntRule();

    @PrimitiveModelEntity.MethodDoc(doc="Assigns an extra dimension integration rule to the weak form feature", ret="Weak form equations", type=PrimitiveModelEntity.MethodType.WRITE)
    public Weak xdIntRule(@PrimitiveModelEntity.ParamDoc(name="irule", doc="Integration rule tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns weak expressions", ret="List of weak expressions", type=PrimitiveModelEntity.MethodType.READ)
    public String[] weak();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the weak expressions", ret="Weak form equations", type=PrimitiveModelEntity.MethodType.WRITE)
    public Weak weak(@PrimitiveModelEntity.ParamDoc(name="wlist", doc="List of weak expressions") String[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Set a weak expression", ret="Weak form equations", type=PrimitiveModelEntity.MethodType.WRITE)
    public Weak weak(@PrimitiveModelEntity.ParamDoc(name="wname", doc="Weak expression.") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Set a weak expression at a position", ret="Weak form equations", type=PrimitiveModelEntity.MethodType.WRITE)
    public Weak weak(@PrimitiveModelEntity.ParamDoc(name="pow", doc="Position") int var1, @PrimitiveModelEntity.ParamDoc(name="wexpr", doc="Weak expression") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the conditional assembly expression", ret="Conditional assembly expression", type=PrimitiveModelEntity.MethodType.READ)
    public String condition();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the conditional assembly expression", ret="Weak form equations", type=PrimitiveModelEntity.MethodType.WRITE)
    public Weak condition(@PrimitiveModelEntity.ParamDoc(name="condition", doc="Conditional assembly expression") String var1);

    public void createReset(Weak var1, boolean var2);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Returns the weak form equation's selection", ret="Selection", type=PrimitiveModelEntity.MethodType.READ)
    public XDLocalSelection selection();

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #intRule} instead", type=PrimitiveModelEntity.MethodType.WRITE)
    @Deprecated
    public Weak intrule(String[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #intRule} instead", type=PrimitiveModelEntity.MethodType.WRITE)
    @Deprecated
    public Weak intrule(int var1, String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #intRule} instead", type=PrimitiveModelEntity.MethodType.READ)
    @Deprecated
    public String[] intrule();

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #intRule} ", type=PrimitiveModelEntity.MethodType.WRITE)
    @Deprecated
    public Weak intrule(String var1);
}

