/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel.physics;

import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.ParamValue;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import java.util.List;

@PrimitiveModelEntity.TypeDoc(value="Variable and system of equation changes")
public interface FeatureInfo
extends ModelEntity {
    public boolean isVisible();

    public void setVisible(boolean var1);

    public void touch();

    public List<? extends ParamValue> getLock();

    @PrimitiveModelEntity.MethodDoc(doc="Returns a table with information about all variables, weak equations, constraints, and shapes that the parent contributes with.", ret="A double string array with the information about an item in each row (first index)", type=PrimitiveModelEntity.MethodType.READ)
    public String[][] getInfoTable(@PrimitiveModelEntity.ParamDoc(name="id", doc="The type of table to return. Can be any of the following strings<br> <ul> <li><code>Expression</code> Returns information about variables.</li> <li><code>Shape</code> Returns information about shape declarations.</li> <li><code>Weak</code> Returns information about weak equations.</li> <li><code>Constraint</code> Returns information about constraints.</li> </ul>") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns a table with information about all variables, weak equations, constraints, and shapes that the parent contributes with", ret="A double string array with the information about an item in each row (first index)", type=PrimitiveModelEntity.MethodType.READ)
    public String[][] getInfoTable(@PrimitiveModelEntity.ParamDoc(name="id", doc="The type of table to return. Can be any of the following strings<br> <ul> <li><code>Expression</code> Returns information about variables.</li> <li><code>Shape</code> Returns information about shape declarations.</li> <li><code>Weak</code> Returns information about weak equations.</li> <li><code>Constraint</code> Returns information about constraints.</li> </ul>") String var1, String ... var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the user-defined expressions for first definition", ret="Feautre information", type=PrimitiveModelEntity.MethodType.WRITE)
    public FeatureInfo set(@PrimitiveModelEntity.ParamDoc(name="name", doc="The identifier name (e.g. variable name)") String var1, @PrimitiveModelEntity.ParamDoc(name="expr", doc="The user-defined values as a string array. Use two elements for constraints, one for the constraint and one for the constraint force") String[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the user-defined expressions for the given definition.", ret="Feautre information", type=PrimitiveModelEntity.MethodType.WRITE)
    public FeatureInfo set(@PrimitiveModelEntity.ParamDoc(name="name", doc="The identifier name (e.g. variable name)") String var1, @PrimitiveModelEntity.ParamDoc(name="sdim", doc="The occurrence of the definition, which can be larger than zero for variables that have more than one definition on different geometric entities for instance") int var2, @PrimitiveModelEntity.ParamDoc(name="expr", doc="The user-defined values as a string array. Use two elements for constraints, one for the constraint and one for the constraint force") String[] var3);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the user-defined expressions for the first definition", ret="A string array with the user-defined expressions", type=PrimitiveModelEntity.MethodType.WRITE)
    public String[] getStringArray(@PrimitiveModelEntity.ParamDoc(name="name", doc="The identifier name (e.g. variable name)") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the user-defined expressions for the given definition", ret="A string array with the user-defined expressions", type=PrimitiveModelEntity.MethodType.WRITE)
    public String[] getStringArray(@PrimitiveModelEntity.ParamDoc(name="name", doc="The identifier name (e.g. variable name)") String var1, @PrimitiveModelEntity.ParamDoc(name="sdim", doc="The occurrence of the definition, which can be larger than zero for variables that have more than one definition on different geometric entities for instance") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Check if the given identifier name (e.g. variable name) has a user-defined expression (locked)", ret="<code>true</code> if locked", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isLocked(@PrimitiveModelEntity.ParamDoc(name="name", doc="The identifier name (e.g. variable name)") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Removes the lock of the given identifier name (e.g. variable name), so it uses the expression defined by the parent {@link PhysicsFeature}", ret="The identifier name if found else <code>null</code>", type=PrimitiveModelEntity.MethodType.READ)
    public String removeLock(@PrimitiveModelEntity.ParamDoc(name="name", doc="The identifier name (e.g. variable name)") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Clear all user-defined expressions (locked expressions) for the parent {@link PhysicsFeature}", ret="Feature information", type=PrimitiveModelEntity.MethodType.WRITE)
    public FeatureInfo clearLocks();

    public void createReset(FeatureInfo var1, boolean var2);

    public ModelEntity getParentEntity();

    @PrimitiveModelEntity.MethodDoc(doc="@deprecated Use {@link #set(String, String[])} instead")
    @Deprecated
    public FeatureInfo lock(String var1, String[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="@deprecated Use {@link #set(String, int, String[])} instead")
    @Deprecated
    public FeatureInfo lock(String var1, int var2, String[] var3);

    @PrimitiveModelEntity.MethodDoc(doc="@deprecated Use {@link #getStringArray(String)} instead")
    @Deprecated
    public String[] lock(String var1);

    @PrimitiveModelEntity.MethodDoc(doc="@deprecated Use {@link #getStringArray(String, int)} instead")
    @Deprecated
    public String[] lock(String var1, int var2);

    public int getSortedColumn();

    public void setSortedColumn(int var1);

    public String getStudyType();

    public FeatureInfoType getFeatureInfoType();

    public void setStudyType(String var1);

    public void updateTableContent();

    public static enum FeatureInfoType {
        FEATURE_WARNING,
        FEATURE_ERROR,
        EQUATION_VIEW,
        EQUATION_VIEW_NO_EDIT,
        EQUATION_VIEW_VARIABLES,
        EQUATION_VIEW_VARIABLES_NO_EDIT,
        EMPTY;

    }
}

