/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.functions;

import com.comsol.model.dbimodel.FunctionFeature;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.Material;
import com.comsol.model.dbimodel.MaterialModel;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.ModelNode;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.TableBaseFeature;
import com.comsol.model.util.MultiphysicsException;
import com.comsol.systemutils.SystemUtil;
import com.comsol.util.methods.FlFileUtil;
import com.comsol.util.methods.q;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;

public abstract class FunctionUtil {
    public static String updateHideFrameSetting(PropFeature propFeature, boolean bl2) {
        boolean bl3 = !bl2 && propFeature.hasProperty("hideFrameSettings");
        ModelNode modelNode = propFeature.getParentModel();
        if (modelNode == null) {
            if (bl3) {
                propFeature.set("hideFrameSettings", "on");
            }
            return "on";
        }
        GeomSequence geomSequence = modelNode.getGeom();
        if (geomSequence != null) {
            if (geomSequence.getSDim() > 1 && (!propFeature.hasPropValue("source") || "table".equals(propFeature.getString("source")))) {
                if (bl3) {
                    propFeature.set("hideFrameSettings", "on");
                }
                return "on";
            }
            if (bl3) {
                propFeature.set("hideFrameSettings", "off");
            }
            return "off";
        }
        return "on";
    }

    public static File getTempResultTableFile(PropFeature propFeature) {
        if (!"resultTable".equals(propFeature.getString("source"))) {
            throw new RuntimeException("Internal_error_in_interpolation_function");
        }
        ModelEntity modelEntity = propFeature.getPropertyReference("resultTable");
        if (modelEntity instanceof TableBaseFeature) {
            TableBaseFeature tableBaseFeature = (TableBaseFeature)modelEntity;
            if (tableBaseFeature.isComplex() && !q.h((double[][])tableBaseFeature.getImag())) {
                throw new MultiphysicsException("No_complex_data_allowed_in_interpolation_function");
            }
            File file = null;
            try {
                String string = propFeature.getString("resultTableFile");
                if (!string.isEmpty()) {
                    file = new File(string);
                    if (!string.startsWith(SystemUtil.getTempDir()) || !FlFileUtil.a((String)string)) {
                        file = null;
                    }
                }
                if (file == null) {
                    file = SystemUtil.createTempFile((String)"resulttabledata", (String)".csv");
                    file.deleteOnExit();
                    propFeature.setWithoutLogging("resultTableFile", file.getAbsolutePath());
                }
                try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
                    double[][] dArray;
                    double[][] dArray2 = dArray = tableBaseFeature.getReal();
                    int n2 = dArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        double[] dArray3 = dArray2[n3];
                        int n4 = 0;
                        while (n4 < dArray3.length) {
                            if (n4 > 0) {
                                bufferedWriter.write(" ");
                            }
                            bufferedWriter.write(Double.toString(dArray3[n4]));
                            ++n4;
                        }
                        bufferedWriter.newLine();
                        ++n3;
                    }
                }
            }
            catch (IOException iOException) {
                throw new MultiphysicsException("Failed_to_create_file");
            }
            return file;
        }
        throw new MultiphysicsException("No_result_table_selected_in_interpolation_function");
    }

    public static FunctionFeature[] getFunctionsInModel(Model model) {
        ArrayList arrayList = new ArrayList(model.func().getListView());
        for (Material object2 : model.material()) {
            for (MaterialModel materialModel : object2.propertyGroup()) {
                for (FunctionFeature functionFeature : materialModel.func()) {
                    arrayList.add(functionFeature);
                }
            }
        }
        Stack<Object> stack = new Stack<Object>();
        stack.addAll(model.capeopen().feature().getListView());
        while (!stack.isEmpty()) {
            FunctionFeature functionFeature = (FunctionFeature)stack.pop();
            arrayList.add(functionFeature);
            for (FunctionFeature functionFeature2 : functionFeature.feature()) {
                stack.add(functionFeature2);
            }
        }
        return (FunctionFeature[])arrayList.stream().toArray(FunctionFeature[]::new);
    }
}

