/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.matlib;

import com.comsol.model.applapi.IExternalMaterialProvider;
import com.comsol.model.applapi.IVariableData;
import com.comsol.model.applapi.VariableInfo;
import com.comsol.model.dbimodel.FileResource;
import com.comsol.model.dbimodel.Information;
import com.comsol.model.dbimodel.Init;
import com.comsol.model.dbimodel.Material;
import com.comsol.model.dbimodel.MaterialModel;
import com.comsol.model.dbimodel.MaterialModelList;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.Selection;
import com.comsol.model.matlib.IExternalMaterialSocket;
import com.comsol.model.matlib.IVariableID;
import com.comsol.model.matlib.MaterialLibraryUtil;
import com.comsol.model.matlib.MaterialSocketUtil;
import com.comsol.model.matlib.TensorSpecCommon;
import com.comsol.model.matlib.VariableIDUtil;
import com.comsol.model.param.ParamSpec;
import com.comsol.model.savepoint.interfaces.IModelEntityList;
import com.comsol.model.util.ModelInternalUtil;
import com.comsol.model.util.MultiphysicsException;
import com.comsol.systemutils.SystemUtil;
import com.comsol.util.classes.an;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.interfaces.IUnitConverter;
import com.comsol.util.methods.FlLocale;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.o;
import com.comsol.util.methods.q;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class AbstractMaterialSocket
implements IExternalMaterialSocket {
    @Override
    public void writeElementSyntax(Material material, Selection selection, int n2) {
        Object object;
        MaterialSocketUtil.ExternalInterfaceMaker externalInterfaceMaker = new MaterialSocketUtil.ExternalInterfaceMaker(material.tag());
        externalInterfaceMaker.setDerivedFrom(material);
        externalInterfaceMaker.addSpecialId(SpecialVarID.c.toString(), MaterialSocketUtil.SpecialValue.NTHREADS);
        externalInterfaceMaker.addSpecialId(SpecialVarID.e.toString(), MaterialSocketUtil.SpecialValue.THREADID);
        externalInterfaceMaker.addSpecialId(SpecialVarID.d.toString(), MaterialSocketUtil.SpecialValue.INTERFACEID);
        List<IFunctionCallSpecification> list = this.getCallSpecifications(material);
        for (IFunctionCallSpecification object42 : list) {
            object42.addFunctionCall(material, externalInterfaceMaker);
        }
        externalInterfaceMaker.writeElementSyntax(material.getModel());
        IExternalMaterialProvider iExternalMaterialProvider = (IExternalMaterialProvider)((Object)material.getOperation());
        String string = FlStringUtil.getXmeshVarName((String)iExternalMaterialProvider.getOutputScopeDot(material, false));
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (IVariableID iVariableID : this.getNonStateOutputs()) {
            object = iVariableID.getTensorComponentNames(string);
            String[][] stringArray = iVariableID.getTensorComponentNames("output.");
            RowColPair[][] rowColPairArray = this.getOutputComponentMap(iVariableID);
            int n3 = 0;
            while (n3 < ((String[][])object).length) {
                int n4 = 0;
                while (n4 < object[n3].length) {
                    arrayList.add(object[n3][n4]);
                    if (rowColPairArray == null) {
                        arrayList2.add(stringArray[n3][n4]);
                    } else {
                        arrayList2.add(stringArray[((RowColPair)rowColPairArray[n3][n4]).row][((RowColPair)rowColPairArray[n3][n4]).col]);
                    }
                    ++n4;
                }
                ++n3;
            }
        }
        String string2 = FlStringUtil.getXmeshVarName((String)(String.valueOf(material.scopeDot()) + "state."));
        ArrayList<String> arrayList3 = new ArrayList();
        object = new ArrayList();
        for (IExternalMaterialSocket.StateDeclaration stateDeclaration : this.getStates(material)) {
            arrayList3.addAll(Arrays.asList(stateDeclaration.getStateArgumentNames(string2)));
            object.addAll(Arrays.asList(stateDeclaration.getStateArgumentNames("input.")));
            String[][] stringArray = stateDeclaration.getStateOutputNames(string);
            String[] stringArray2 = stateDeclaration.getStateArgumentNames("output.");
            int n5 = 0;
            while (n5 < stringArray.length) {
                int n6 = 0;
                while (n6 < stringArray[n5].length) {
                    arrayList.add(stringArray[n5][n6]);
                    arrayList2.add(stringArray2[n5]);
                    ++n6;
                }
                ++n5;
            }
        }
        for (IFunctionCallSpecification iFunctionCallSpecification : list) {
            iFunctionCallSpecification.addExtraExprIDs(material, (List<String>)arrayList3, (List<String>)object);
        }
        for (IFunctionCallSpecification iFunctionCallSpecification : list) {
            iFunctionCallSpecification.addExtraVarIDs(material, arrayList, arrayList2);
        }
        MaterialSocketUtil.VariableDefinitionMaker variableDefinitionMaker = new MaterialSocketUtil.VariableDefinitionMaker(material.tag());
        variableDefinitionMaker.setDerivedFrom(material);
        int n7 = material.getModel().geom().index(selection.geom()) + 1;
        int n8 = selection.getDim();
        int[] nArray = selection.entities(n8);
        variableDefinitionMaker.setGeom(n7);
        variableDefinitionMaker.setEdim(n8);
        variableDefinitionMaker.setEntities(nArray);
        variableDefinitionMaker.setExpressions(arrayList3.toArray(new String[0]));
        variableDefinitionMaker.setExpressionIds(object.toArray(new String[0]));
        variableDefinitionMaker.setVars(arrayList.toArray(new String[0]));
        variableDefinitionMaker.setVarIds(arrayList2.toArray(new String[0]));
        variableDefinitionMaker.writeElementSyntax(material.getModel());
        IVariableData iVariableData = material.getModel().physics().getVarData();
        VariableInfo variableInfo = VariableInfo.xmesh(material).doPlot(false);
        String string3 = FlStringUtil.getXmeshVarName((String)iExternalMaterialProvider.getInputScopeDot(material, false));
        Boolean[] booleanArray = new Boolean[]{false, true};
        int n9 = booleanArray.length;
        int n10 = 0;
        while (n10 < n9) {
            Object object2;
            Object object3;
            boolean bl2 = booleanArray[n10];
            arrayList = new ArrayList();
            arrayList3 = new ArrayList<String>();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            ArrayList<String> arrayList5 = new ArrayList<String>();
            int n11 = 0;
            for (IExternalMaterialSocket.StateDeclaration stateDeclaration : this.getStates(material)) {
                if (!stateDeclaration.isComplex() == bl2) continue;
                object3 = stateDeclaration.getStateArgumentNames(string2);
                arrayList.addAll(Arrays.asList(object3));
                arrayList4.addAll(Arrays.asList(FlStringUtil.array((int)((String[])object3).length, (String)("state." + stateDeclaration.getBaseName()))));
                arrayList3.addAll(Arrays.asList(stateDeclaration.getStateArgumentNames(string)));
                arrayList5.addAll(Arrays.asList(stateDeclaration.getStateInitExpressions(material, n11)));
                n11 += stateDeclaration.getStateVariables().size();
                object2 = new VariableIDUtil.DynamicVariableID("not_used", stateDeclaration.getBaseName(), stateDeclaration.getDescription(), TensorSpecCommon.SCALAR, "", null, null);
                variableInfo.description(stateDeclaration.getDescription());
                iVariableData.declareXmeshVariable((IVariableID)object2, "root." + string2, selection, variableInfo);
            }
            if (!arrayList.isEmpty()) {
                MaterialSocketUtil.ElStateVarMaker elStateVarMaker = new MaterialSocketUtil.ElStateVarMaker();
                elStateVarMaker.setDerivedFrom(material);
                elStateVarMaker.setGeom(n7);
                elStateVarMaker.setEdim(n8);
                elStateVarMaker.setEntities(nArray);
                elStateVarMaker.setComplex(bl2);
                elStateVarMaker.setGpOrder(n2);
                elStateVarMaker.setVariables(arrayList.toArray(new String[0]));
                elStateVarMaker.setFieldNames(arrayList4.toArray(new String[0]));
                elStateVarMaker.setExpressions(arrayList3.toArray(new String[0]));
                elStateVarMaker.writeElementSyntax(material.getModel());
            }
            if (!arrayList.isEmpty()) {
                Init init = (Init)material.getModel().init().create(material.getModel().init().uniquetag("state"));
                init.selection().global();
                init.setDerivedFrom(material);
                int n12 = 0;
                while (n12 < arrayList.size()) {
                    init.set((String)arrayList.get(n12), (String)arrayList5.get(n12));
                    ++n12;
                }
            }
            arrayList.clear();
            arrayList3.clear();
            arrayList4.clear();
            for (OldInputComplexPair oldInputComplexPair : this.getOldInputs(material)) {
                if (!oldInputComplexPair.isComplex == bl2) continue;
                object3 = oldInputComplexPair.variable.getBaseName();
                object2 = oldInputComplexPair.variable.getTensorComponentNames(string2);
                String[][] stringArray = oldInputComplexPair.variable.getTensorComponentNames(string3);
                int n13 = 0;
                while (n13 < ((String[][])object2).length) {
                    int n14 = 0;
                    while (n14 < object2[n13].length) {
                        arrayList.add(object2[n13][n14]);
                        arrayList4.add("state." + (String)object3);
                        arrayList3.add(stringArray[n13][n14]);
                        ++n14;
                    }
                    ++n13;
                }
                variableInfo.description(oldInputComplexPair.variable.getDescription());
                iVariableData.declareXmeshVariable(oldInputComplexPair.variable, "root." + string2, selection, variableInfo);
            }
            if (!arrayList.isEmpty()) {
                MaterialSocketUtil.ElStateVarMaker elStateVarMaker = new MaterialSocketUtil.ElStateVarMaker();
                elStateVarMaker.setDerivedFrom(material);
                elStateVarMaker.setGeom(n7);
                elStateVarMaker.setEdim(n8);
                elStateVarMaker.setEntities(nArray);
                elStateVarMaker.setComplex(bl2);
                elStateVarMaker.setGpOrder(n2);
                elStateVarMaker.setVariables(arrayList.toArray(new String[0]));
                elStateVarMaker.setFieldNames(arrayList4.toArray(new String[0]));
                elStateVarMaker.setPreviousExpressions(arrayList3.toArray(new String[0]));
                elStateVarMaker.writeElementSyntax(material.getModel());
            }
            ++n10;
        }
    }

    protected List<OldInputComplexPair> getOldInputs(Material material) {
        return Collections.EMPTY_LIST;
    }

    protected abstract List<IVariableID> getNonStateOutputs();

    @Override
    public final List<IVariableID> getOutputs(Material material) {
        ArrayList<IVariableID> arrayList = new ArrayList<IVariableID>();
        arrayList.addAll(this.getNonStateOutputs());
        for (IExternalMaterialSocket.StateDeclaration stateDeclaration : this.getStates(material)) {
            if (!stateDeclaration.isOutput()) continue;
            arrayList.addAll(stateDeclaration.getStateVariables());
        }
        return arrayList;
    }

    protected MaterialSocketUtil.ArgClass getNumArgClass(Material material) {
        if (this.showStandardProperty(IExternalMaterialSocket.StandardProperty.complex.name())) {
            return material.getBoolean(IExternalMaterialSocket.StandardProperty.complex.name()) ? MaterialSocketUtil.ArgClass.DCOMPLEX : MaterialSocketUtil.ArgClass.DOUBLE;
        }
        return MaterialSocketUtil.ArgClass.DOUBLE;
    }

    protected abstract List<IFunctionCallSpecification> getCallSpecifications(Material var1);

    protected RowColPair[][] getOutputComponentMap(IVariableID iVariableID) {
        return null;
    }

    public final String getGroupTag() {
        return this.getID().replaceAll("\\.", "");
    }

    @Override
    public final void addPropertyGroup(MaterialModelList materialModelList) {
        if (this.getMaterialParameters().isEmpty()) {
            return;
        }
        MaterialModel materialModel = materialModelList.create(this.getGroupTag(), FlLocale.getString((String)this.getDescription()));
        ((Information)materialModel.info().create("category")).body("External_material_parameters");
        materialModel.addFlag(ModelEntity.Flags.NORETAG);
        for (IVariableID iVariableID : this.getMaterialParameters()) {
            ParamSpec paramSpec = iVariableID.getParamSpecOrNull();
            if (paramSpec == null) continue;
            materialModel.setOutput(iVariableID.getBaseName(), paramSpec);
        }
    }

    @Override
    public boolean hasCompatibleOutput(Material material, IVariableID iVariableID) {
        for (IVariableID iVariableID2 : this.getOutputs(material)) {
            if (!iVariableID.canAssignFrom(iVariableID2, true)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<IVariableID> findCompatibleInputsOrNull(Material material, Collection<IVariableID> collection) {
        ArrayList<IVariableID> arrayList = new ArrayList<IVariableID>();
        for (IVariableID iVariableID : this.getInputs(material)) {
            boolean bl2 = false;
            for (IVariableID iVariableID2 : collection) {
                if (!iVariableID.canAssignFrom(iVariableID2, true)) continue;
                arrayList.add(iVariableID2);
                bl2 = true;
            }
            if (bl2) continue;
            return null;
        }
        return arrayList;
    }

    public static void addStandardParametersArgument(AbstractMaterialSocket abstractMaterialSocket, Material material, List<IFunctionArgument> list) {
        if (abstractMaterialSocket.showStandardProperty(IExternalMaterialSocket.StandardProperty.parameters.name())) {
            IVariableID iVariableID = AbstractMaterialSocket.getStandardMaterialParameters(abstractMaterialSocket);
            list.add(new FunctionParameterArraySizeArgument(material, iVariableID));
            list.add(new FunctionParameterArrayArgument(abstractMaterialSocket.getNumArgClass(material), material, iVariableID));
        }
    }

    public static void addStandardStateArguments(AbstractMaterialSocket abstractMaterialSocket, Material material, List<IFunctionArgument> list) {
        if (abstractMaterialSocket.showStandardProperty(IExternalMaterialSocket.StandardProperty.stateName.name())) {
            ArrayList<IExternalMaterialSocket.StateDeclaration> arrayList = new ArrayList<IExternalMaterialSocket.StateDeclaration>();
            AbstractMaterialSocket.collectStandardUserDefinedStates(material, arrayList);
            for (IExternalMaterialSocket.StateDeclaration stateDeclaration : arrayList) {
                list.add(new FunctionFixedIntArgument("input." + stateDeclaration.getBaseName() + ".size", stateDeclaration.getStateArgumentNames("").length));
                list.add(new FunctionStateArgument(abstractMaterialSocket.getNumArgClass(material), stateDeclaration));
            }
        }
    }

    public static void addStandardStringParametersArgument(AbstractMaterialSocket abstractMaterialSocket, Material material, List<IFunctionArgument> list) {
        if (abstractMaterialSocket.showStandardProperty(IExternalMaterialSocket.StandardProperty.stringParameters.name())) {
            IVariableID.GroupPropertyPair groupPropertyPair = AbstractMaterialSocket.getStandardStringParameters(abstractMaterialSocket).getGroupPropertyPairOrNull();
            if (material.propertyGroup().hasTag(groupPropertyPair.group) && material.propertyGroup(groupPropertyPair.group).hasParam(groupPropertyPair.property)) {
                String[][] stringArray = material.propertyGroup(groupPropertyPair.group).getParamValue(groupPropertyPair.property).getValue();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (stringArray[n2][0].length() > 0) {
                        list.add(new FunctionFixedStringInputArgument(FlStringUtil.stripSingleQuotes((String)stringArray[n2][0])));
                    }
                    ++n2;
                }
            }
        }
    }

    public static void addStandardErrorDetailsArgument(AbstractMaterialSocket abstractMaterialSocket, Material material, List<IFunctionArgument> list) {
        if (abstractMaterialSocket.showStandardProperty(IExternalMaterialSocket.StandardProperty.errorMessage.name()) && material.getBoolean(IExternalMaterialSocket.StandardProperty.errorMessage.name())) {
            list.add(new FunctionErrorDetailsArgument(material.getInt(IExternalMaterialSocket.StandardProperty.errorMessageSize.name())));
        }
    }

    public static void addStandardErrors(Collection<ErrorInfo> collection) {
        collection.add(ErrorInfo.error(1, "Wrong_number_of_parameters", true));
        collection.add(ErrorInfo.error(2, "Wrong_number_of_states", true));
        collection.add(ErrorInfo.warning(-1, "Problem_in_external_material_evaluation"));
        collection.add(ErrorInfo.logMessage(-2, ""));
    }

    public static void addAllStandardArguments(AbstractMaterialSocket abstractMaterialSocket, Material material, List<IFunctionArgument> list) {
        AbstractMaterialSocket.addStandardParametersArgument(abstractMaterialSocket, material, list);
        AbstractMaterialSocket.addStandardStateArguments(abstractMaterialSocket, material, list);
        AbstractMaterialSocket.addStandardErrorDetailsArgument(abstractMaterialSocket, material, list);
        AbstractMaterialSocket.addStandardStringParametersArgument(abstractMaterialSocket, material, list);
    }

    public static void collectStandardUserDefinedStates(Material material, List<IExternalMaterialSocket.StateDeclaration> list) {
        String[] stringArray = material.getStringArray(IExternalMaterialSocket.StandardProperty.stateName.name());
        String[] stringArray2 = material.getStringArray(IExternalMaterialSocket.StandardProperty.numberOfStates.name());
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (n2 < stringArray2.length && !stringArray2[n2].isEmpty()) {
                list.add(new MaterialSocketUtil.UserStateArray(material, n2));
            }
            ++n2;
        }
    }

    public static void collectStandardRuntimeParameters(AbstractMaterialSocket abstractMaterialSocket, List<IVariableID> list) {
        if (abstractMaterialSocket.showStandardProperty(IExternalMaterialSocket.StandardProperty.parameters.name())) {
            list.add(AbstractMaterialSocket.getStandardMaterialParameters(abstractMaterialSocket));
        }
        if (abstractMaterialSocket.showStandardProperty(IExternalMaterialSocket.StandardProperty.stringParameters.name())) {
            list.add(AbstractMaterialSocket.getStandardStringParameters(abstractMaterialSocket));
        }
    }

    public static IVariableID getStandardMaterialParameters(AbstractMaterialSocket abstractMaterialSocket) {
        String string = abstractMaterialSocket.getGroupTag();
        return new VariableIDUtil.VariableSizeParameterArrayID("par", "Material_model_parameters", string);
    }

    public static IVariableID getStandardStringParameters(AbstractMaterialSocket abstractMaterialSocket) {
        String string = abstractMaterialSocket.getGroupTag();
        return new VariableIDUtil.VariableSizeParameterArrayID("args", "Extra_library_function_string_arguments", string);
    }

    public static void addStandardInitFunctionCall(final AbstractMaterialSocket abstractMaterialSocket, Material material, List<IFunctionCallSpecification> list) {
        if (abstractMaterialSocket.showStandardProperty(IExternalMaterialSocket.StandardProperty.callInit.name()) && material.getBoolean(IExternalMaterialSocket.StandardProperty.callInit.name())) {
            list.add(new FunctionCallAdapter(MaterialSocketUtil.FuncType.INIT){

                @Override
                protected String getFunctionName(Material material) {
                    return "init";
                }

                @Override
                protected Collection<IFunctionArgument> getArguments(Material material) {
                    ArrayList<IFunctionArgument> arrayList = new ArrayList<IFunctionArgument>();
                    AbstractMaterialSocket.addStandardNumberOfParametersArgument(abstractMaterialSocket, material, arrayList);
                    AbstractMaterialSocket.addStandardNumberOfStateArraysArgument(abstractMaterialSocket, material, arrayList);
                    AbstractMaterialSocket.addStandardNumberStateArraySizesArgument(abstractMaterialSocket, material, arrayList);
                    AbstractMaterialSocket.addStandardErrorDetailsSizeArgument(abstractMaterialSocket, material, arrayList);
                    AbstractMaterialSocket.addStandardNumberOfStringParametersArgument(abstractMaterialSocket, material, arrayList);
                    AbstractMaterialSocket.addStandardErrorDetailsArgument(abstractMaterialSocket, material, arrayList);
                    AbstractMaterialSocket.addStandardStringParametersArgument(abstractMaterialSocket, material, arrayList);
                    return arrayList;
                }

                @Override
                protected Collection<ErrorInfo> getErrors(Material material) {
                    ArrayList<ErrorInfo> arrayList = new ArrayList<ErrorInfo>();
                    arrayList.add(ErrorInfo.noError(0));
                    arrayList.add(ErrorInfo.defaultError("External_material_initialization_error", true));
                    arrayList.add(ErrorInfo.error(1, "Wrong_number_of_parameters", true));
                    arrayList.add(ErrorInfo.error(2, "Wrong_number_of_states", true));
                    arrayList.add(ErrorInfo.error(3, "Wrong_number_of_arguments", true));
                    arrayList.add(ErrorInfo.error(4, "Insufficient_error_message_storage", true));
                    arrayList.add(ErrorInfo.warning(-1, "Problem_in_external_material_evaluation"));
                    arrayList.add(ErrorInfo.logMessage(-2, ""));
                    return arrayList;
                }
            });
        }
    }

    public static void addStandardNumberOfParametersArgument(AbstractMaterialSocket abstractMaterialSocket, Material material, List<IFunctionArgument> list) {
        if (abstractMaterialSocket.showStandardProperty(IExternalMaterialSocket.StandardProperty.parameters.name())) {
            IVariableID iVariableID = AbstractMaterialSocket.getStandardMaterialParameters(abstractMaterialSocket);
            int n2 = 0;
            IVariableID.GroupPropertyPair groupPropertyPair = iVariableID.getGroupPropertyPairOrNull();
            if (material.propertyGroup().hasTag(groupPropertyPair.group) && material.propertyGroup(groupPropertyPair.group).hasParam(groupPropertyPair.property)) {
                n2 = material.propertyGroup(groupPropertyPair.group).getParamValue(groupPropertyPair.property).getValue().length;
            }
            list.add(new FunctionFixedIntArrayArgument(new int[]{n2}));
        }
    }

    public static void addStandardNumberOfStateArraysArgument(AbstractMaterialSocket abstractMaterialSocket, Material material, List<IFunctionArgument> list) {
        if (abstractMaterialSocket.showStandardProperty(IExternalMaterialSocket.StandardProperty.stateName.name())) {
            ArrayList<IExternalMaterialSocket.StateDeclaration> arrayList = new ArrayList<IExternalMaterialSocket.StateDeclaration>();
            AbstractMaterialSocket.collectStandardUserDefinedStates(material, arrayList);
            list.add(new FunctionFixedIntArrayArgument(new int[]{arrayList.size()}));
        }
    }

    public static void addStandardNumberStateArraySizesArgument(AbstractMaterialSocket abstractMaterialSocket, Material material, List<IFunctionArgument> list) {
        if (abstractMaterialSocket.showStandardProperty(IExternalMaterialSocket.StandardProperty.stateName.name())) {
            ArrayList<IExternalMaterialSocket.StateDeclaration> arrayList = new ArrayList<IExternalMaterialSocket.StateDeclaration>();
            AbstractMaterialSocket.collectStandardUserDefinedStates(material, arrayList);
            an an2 = new an();
            for (IExternalMaterialSocket.StateDeclaration stateDeclaration : arrayList) {
                an2.add(stateDeclaration.getStateArgumentNames("").length);
            }
            list.add(new FunctionFixedIntArrayArgument(an2.toArray()));
        }
    }

    public static void addStandardErrorDetailsSizeArgument(AbstractMaterialSocket abstractMaterialSocket, Material material, List<IFunctionArgument> list) {
        if (abstractMaterialSocket.showStandardProperty(IExternalMaterialSocket.StandardProperty.errorMessage.name())) {
            int n2 = material.getBoolean(IExternalMaterialSocket.StandardProperty.errorMessage.name()) ? material.getInt(IExternalMaterialSocket.StandardProperty.errorMessageSize.name()) : -1;
            list.add(new FunctionFixedIntArrayArgument(new int[]{n2}));
        }
    }

    public static void addStandardNumberOfStringParametersArgument(AbstractMaterialSocket abstractMaterialSocket, Material material, List<IFunctionArgument> list) {
        if (abstractMaterialSocket.showStandardProperty(IExternalMaterialSocket.StandardProperty.stringParameters.name())) {
            IVariableID.GroupPropertyPair groupPropertyPair = AbstractMaterialSocket.getStandardStringParameters(abstractMaterialSocket).getGroupPropertyPairOrNull();
            int n2 = 0;
            if (material.propertyGroup().hasTag(groupPropertyPair.group) && material.propertyGroup(groupPropertyPair.group).hasParam(groupPropertyPair.property)) {
                String[][] stringArray = material.propertyGroup(groupPropertyPair.group).getParamValue(groupPropertyPair.property).getValue();
                int n3 = 0;
                while (n3 < stringArray.length) {
                    if (stringArray[n3][0].length() > 0) {
                        ++n2;
                    }
                    ++n3;
                }
            }
            list.add(new FunctionFixedIntArrayArgument(new int[]{n2}));
        }
    }

    public static void addCleanupFunctionCall(final AbstractMaterialSocket abstractMaterialSocket, Material material, List<IFunctionCallSpecification> list) {
        if (abstractMaterialSocket.showStandardProperty(IExternalMaterialSocket.StandardProperty.callCleanup.name()) && material.getBoolean(IExternalMaterialSocket.StandardProperty.callCleanup.name())) {
            list.add(new FunctionCallAdapter(MaterialSocketUtil.FuncType.CLEANUP){

                @Override
                protected String getFunctionName(Material material) {
                    return "cleanup";
                }

                @Override
                protected Collection<IFunctionArgument> getArguments(Material material) {
                    ArrayList<IFunctionArgument> arrayList = new ArrayList<IFunctionArgument>();
                    AbstractMaterialSocket.addStandardErrorDetailsArgument(abstractMaterialSocket, material, arrayList);
                    AbstractMaterialSocket.addStandardStringParametersArgument(abstractMaterialSocket, material, arrayList);
                    return arrayList;
                }

                @Override
                protected Collection<ErrorInfo> getErrors(Material material) {
                    ArrayList<ErrorInfo> arrayList = new ArrayList<ErrorInfo>();
                    arrayList.add(ErrorInfo.noError(0));
                    arrayList.add(ErrorInfo.defaultError("External_material_cleanup_error", true));
                    return arrayList;
                }
            });
        }
    }

    public static abstract class AbstractFunctionArgument
    implements IFunctionArgument {
        public final ArgumentType argumentType;

        public AbstractFunctionArgument(ArgumentType argumentType) {
            this.argumentType = argumentType;
        }

        @Override
        public final ArgumentType getArgumentType() {
            return this.argumentType;
        }

        @Override
        public void addExtraVarIDs(String string, List<String> list, List<String> list2) {
        }

        @Override
        public void addExtraExprIDs(Material material, List<String> list, List<String> list2) {
        }
    }

    public static enum ArgumentType {
        INPUT,
        OUTPUT,
        JACOBIAN,
        STATE,
        PARAMETER,
        ERROR_CODE,
        ERROR_DETAILS,
        FIXED_INT,
        FIXED_INT_ARRAY;

    }

    public static class ErrorInfo {
        public final int errorCode;
        public final String message;
        public final boolean isError;
        public final boolean isWarning;
        public final boolean isLog;
        public final boolean addDetails;

        private ErrorInfo(int n2, String string, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
            this.errorCode = n2;
            this.message = string;
            this.isError = bl2;
            this.isWarning = bl3;
            this.isLog = bl4;
            this.addDetails = bl5;
        }

        public static ErrorInfo noError(int n2) {
            return new ErrorInfo(n2, "", false, false, false, false);
        }

        public static ErrorInfo defaultError(String string, boolean bl2) {
            return new ErrorInfo(Integer.MIN_VALUE, string, true, false, false, bl2);
        }

        public static ErrorInfo error(int n2, String string, boolean bl2) {
            return new ErrorInfo(n2, string, true, false, false, bl2);
        }

        public static ErrorInfo warning(int n2, String string) {
            return new ErrorInfo(n2, string, false, true, false, true);
        }

        public static ErrorInfo logMessage(int n2, String string) {
            return new ErrorInfo(n2, string, false, false, true, true);
        }
    }

    public static abstract class FunctionCallAdapter
    implements IFunctionCallSpecification {
        private final MaterialSocketUtil.FuncType a;

        public FunctionCallAdapter(MaterialSocketUtil.FuncType funcType) {
            this.a = funcType;
        }

        @Override
        public void addFunctionCall(Material material, MaterialSocketUtil.ExternalInterfaceMaker externalInterfaceMaker) {
            String string = this.getModelResourceTag(material);
            externalInterfaceMaker.addFunction(this.a, string, this.getFunctionName(material), this.isThreadSafe(material));
            boolean bl2 = false;
            boolean bl3 = false;
            for (IFunctionArgument object : this.getArguments(material)) {
                object.addFunctionArgument(externalInterfaceMaker);
                switch (object.getArgumentType()) {
                    case INPUT: 
                    case OUTPUT: 
                    case JACOBIAN: 
                    case STATE: 
                    case PARAMETER: {
                        break;
                    }
                    case ERROR_CODE: {
                        bl2 = true;
                        break;
                    }
                    case ERROR_DETAILS: {
                        bl3 = true;
                    }
                }
            }
            externalInterfaceMaker.setErrorId(SpecialVarID.a.toString());
            if (!bl2) {
                externalInterfaceMaker.setReturn(MaterialSocketUtil.ArgClass.INT, SpecialVarID.a.toString());
            }
            for (ErrorInfo errorInfo : this.getErrors(material)) {
                String string2 = bl3 && errorInfo.addDetails ? SpecialVarID.b.toString() : "";
                String string3 = "";
                if (!errorInfo.message.isEmpty()) {
                    string3 = String.valueOf(FlLocale.getErrorString((String)errorInfo.message)) + (string2.isEmpty() ? "" : ":");
                }
                if (errorInfo.isError) {
                    if (errorInfo.errorCode > Integer.MIN_VALUE) {
                        externalInterfaceMaker.addErrorCode(errorInfo.errorCode, string3, string2);
                        continue;
                    }
                    externalInterfaceMaker.addDefaultErrorCode(string3, string2);
                    continue;
                }
                if (!(!errorInfo.isWarning || string3.isEmpty() && string2.isEmpty())) {
                    externalInterfaceMaker.addWarningCode(errorInfo.errorCode, bl3 ? "" : string3, string2);
                    continue;
                }
                if (!(!errorInfo.isLog || string3.isEmpty() && string2.isEmpty())) {
                    externalInterfaceMaker.addLogCode(errorInfo.errorCode, bl3 ? "" : string3, string2);
                    continue;
                }
                if (errorInfo.errorCode > Integer.MIN_VALUE) {
                    externalInterfaceMaker.addErrorCode(errorInfo.errorCode);
                    continue;
                }
                externalInterfaceMaker.addDefaultErrorCode();
            }
        }

        @Override
        public void addExtraVarIDs(Material material, List<String> list, List<String> list2) {
            for (IFunctionArgument iFunctionArgument : this.getArguments(material)) {
                iFunctionArgument.addExtraVarIDs(material.scopeDot(), list, list2);
            }
        }

        @Override
        public void addExtraExprIDs(Material material, List<String> list, List<String> list2) {
            for (IFunctionArgument iFunctionArgument : this.getArguments(material)) {
                iFunctionArgument.addExtraExprIDs(material, list, list2);
            }
        }

        protected abstract String getFunctionName(Material var1);

        protected String getFileName(Material material) {
            return material.getString(MaterialLibraryUtil.extLibPropName("filename"));
        }

        protected boolean isThreadSafe(Material material) {
            return material.getBoolean("threadSafe");
        }

        protected abstract Collection<IFunctionArgument> getArguments(Material var1);

        protected Collection<ErrorInfo> getErrors(Material material) {
            ArrayList<ErrorInfo> arrayList = new ArrayList<ErrorInfo>();
            arrayList.add(ErrorInfo.noError(0));
            arrayList.add(ErrorInfo.defaultError("External_material_evaluation_error", true));
            return arrayList;
        }

        protected final String getModelResourceTag(Material material) {
            Object object;
            Object object2;
            Object object3;
            String string = MaterialLibraryUtil.extLibPropName("modelres");
            String string2 = material.getString(string);
            Model model = material.getModel();
            IModelEntityList iModelEntityList = model.file();
            String string3 = material.getString(MaterialLibraryUtil.extLibPropName("state"));
            boolean bl2 = "show".equals(string3);
            if (!bl2) {
                object3 = this.getFileName(material);
                try {
                    object2 = ModelInternalUtil.getExistingFileOrThrow((String)object3, model);
                }
                catch (FlException flException) {
                    flException.addParameterPair("Feature", material.getDisplayString());
                    throw new MultiphysicsException(flException);
                }
                if (string2.length() == 0 || !iModelEntityList.hasTag(string2)) {
                    string2 = iModelEntityList.uniquetag("extLib");
                    object = (FileResource)iModelEntityList.create(string2);
                    object.setIgnoreWhenResettingHistory(true);
                    object.addFlag(ModelEntity.Flags.NOREMOVE);
                    object.addFlag(ModelEntity.Flags.NORETAG);
                    object.resource(((File)object2).getAbsolutePath(), false);
                    material.set(string, string2);
                }
            }
            object3 = (FileResource)iModelEntityList.get(string2);
            object3.setXmeshResource(null);
            object2 = bl2 ? object3.resource() : this.getFileName(material);
            String string4 = object3.getClusterResourcePath();
            if (string4 != null && SystemUtil.isCluster()) {
                if (string4.length() == 0 || !((File)(object = new File(string4))).exists()) {
                    FlException flException = new FlException("File_does_not_exist");
                    flException.addParameterPair("Filename", (String)object2);
                    flException.addParameterPair("Feature", material.getDisplayString());
                    throw new MultiphysicsException(flException);
                }
            } else {
                object = ModelInternalUtil.getExistingFileOrThrow((String)object2, model, true, true, bl2);
            }
            object3.setXmeshResource(((File)object).getAbsolutePath());
            return string2;
        }
    }

    public static class FunctionErrorCodeArgument
    extends AbstractFunctionArgument {
        public FunctionErrorCodeArgument() {
            super(ArgumentType.ERROR_CODE);
        }

        @Override
        public void addFunctionArgument(MaterialSocketUtil.ExternalInterfaceMaker externalInterfaceMaker) {
            externalInterfaceMaker.addArgument(MaterialSocketUtil.ArgClass.INT, MaterialSocketUtil.ArgFormat.SCALAR);
            externalInterfaceMaker.setArgIds(MaterialSocketUtil.ArgType.ERROR, SpecialVarID.a.toString());
        }
    }

    public static class FunctionErrorDetailsArgument
    extends AbstractFunctionArgument {
        private int a;

        public FunctionErrorDetailsArgument(int n2) {
            super(ArgumentType.ERROR_DETAILS);
            this.a = n2;
        }

        @Override
        public void addFunctionArgument(MaterialSocketUtil.ExternalInterfaceMaker externalInterfaceMaker) {
            externalInterfaceMaker.addStringErrorArg(SpecialVarID.b.toString(), this.a);
        }
    }

    public static class FunctionFixedIntArgument
    extends AbstractFunctionArgument {
        private String b;
        protected int a;

        public FunctionFixedIntArgument(String string, int n2) {
            super(ArgumentType.FIXED_INT);
            this.b = string;
            this.a = n2;
        }

        @Override
        public void addFunctionArgument(MaterialSocketUtil.ExternalInterfaceMaker externalInterfaceMaker) {
            externalInterfaceMaker.addArgument(MaterialSocketUtil.ArgClass.INT, MaterialSocketUtil.ArgFormat.SCALAR);
            externalInterfaceMaker.setArgIds(MaterialSocketUtil.ArgType.INPUT, this.b);
        }

        @Override
        public void addExtraExprIDs(Material material, List<String> list, List<String> list2) {
            list.add(String.valueOf(this.a));
            list2.add(this.b);
        }
    }

    public static class FunctionFixedIntArrayArgument
    extends AbstractFunctionArgument {
        private int[] a;

        public FunctionFixedIntArrayArgument(int[] nArray) {
            super(ArgumentType.FIXED_INT_ARRAY);
            this.a = q.d((int[])nArray);
        }

        @Override
        public void addFunctionArgument(MaterialSocketUtil.ExternalInterfaceMaker externalInterfaceMaker) {
            externalInterfaceMaker.addStaticIntInputArg(this.a);
        }
    }

    public static class FunctionFixedStringInputArgument
    extends AbstractFunctionArgument {
        private String a;

        public FunctionFixedStringInputArgument(String string) {
            super(ArgumentType.INPUT);
            this.a = string;
        }

        @Override
        public void addFunctionArgument(MaterialSocketUtil.ExternalInterfaceMaker externalInterfaceMaker) {
            externalInterfaceMaker.addStringInputArg(this.a);
        }
    }

    public static class FunctionInputArgument
    extends AbstractFunctionArgument {
        private MaterialSocketUtil.ArgClass a;
        private String[] b;

        public FunctionInputArgument(MaterialSocketUtil.ArgClass argClass, IVariableID iVariableID, List<RowColPair> list) {
            super(ArgumentType.INPUT);
            this.a = argClass;
            this.b = new String[list.size()];
            String[][] stringArray = iVariableID.getTensorComponentNames("");
            int n2 = 0;
            for (RowColPair rowColPair : list) {
                this.b[n2++] = stringArray[rowColPair.row][rowColPair.col];
            }
        }

        @Override
        public void addFunctionArgument(MaterialSocketUtil.ExternalInterfaceMaker externalInterfaceMaker) {
            externalInterfaceMaker.addArgument(this.a, MaterialSocketUtil.ArgFormat.VECTOR);
            externalInterfaceMaker.setArgIds(MaterialSocketUtil.ArgType.INPUT, FlStringUtil.prepend((String)this.a(), (String[])this.b));
        }

        @Override
        public void addExtraExprIDs(Material material, List<String> list, List<String> list2) {
            list2.addAll(Arrays.asList(FlStringUtil.prepend((String)this.a(), (String[])this.b)));
            list.addAll(Arrays.asList(FlStringUtil.prepend((String)this.a(material), (String[])this.b)));
        }

        protected String a() {
            return "input.";
        }

        protected String a(Material material) {
            IExternalMaterialProvider iExternalMaterialProvider = (IExternalMaterialProvider)((Object)material.getOperation());
            return FlStringUtil.getXmeshVarName((String)iExternalMaterialProvider.getInputScopeDot(material, false));
        }
    }

    public static class FunctionJacobianArgument
    extends AbstractFunctionArgument {
        private MaterialSocketUtil.ArgClass c;
        private MaterialSocketUtil.MatrixOrder d;
        protected String[] a;
        protected String[] b;

        protected FunctionJacobianArgument(MaterialSocketUtil.ArgClass argClass, boolean bl2) {
            super(ArgumentType.JACOBIAN);
            this.c = argClass;
            this.d = bl2 ? MaterialSocketUtil.MatrixOrder.ROW : MaterialSocketUtil.MatrixOrder.COL;
        }

        public FunctionJacobianArgument(MaterialSocketUtil.ArgClass argClass, boolean bl2, IVariableID iVariableID, IVariableID iVariableID2, List<RowColPair> list, List<RowColPair> list2) {
            this(argClass, bl2);
            this.b = new String[list.size()];
            this.a = new String[list2.size()];
            String[][] stringArray = iVariableID2.getTensorComponentNames("input.");
            String[][] stringArray2 = iVariableID.getTensorComponentNames("output.");
            int n2 = 0;
            for (RowColPair rowColPair : list2) {
                this.a[n2++] = stringArray[rowColPair.row][rowColPair.col];
            }
            n2 = 0;
            for (RowColPair rowColPair : list) {
                this.b[n2++] = stringArray2[rowColPair.row][rowColPair.col];
            }
        }

        @Override
        public void addFunctionArgument(MaterialSocketUtil.ExternalInterfaceMaker externalInterfaceMaker) {
            externalInterfaceMaker.addArgument(this.c, MaterialSocketUtil.ArgFormat.MATRIX);
            externalInterfaceMaker.setMatrixPart(MaterialSocketUtil.ArgType.OUTPUT, MaterialSocketUtil.MatrixPart.FULL);
            externalInterfaceMaker.setMatrixOrder(MaterialSocketUtil.ArgType.OUTPUT, this.d);
            externalInterfaceMaker.setArgIds(MaterialSocketUtil.ArgType.OUTPUT, this.b, this.a);
        }

        @Override
        public void addExtraVarIDs(String string, List<String> list, List<String> list2) {
            String[] stringArray = this.b;
            int n2 = this.b.length;
            int n3 = 0;
            while (n3 < n2) {
                String string2 = stringArray[n3];
                String[] stringArray2 = this.a;
                int n4 = this.a.length;
                int n5 = 0;
                while (n5 < n4) {
                    String string3 = stringArray2[n5];
                    list.add(String.valueOf(string) + "diff." + string2.substring("output.".length()) + "." + string3.substring("input.".length()));
                    list2.add("d(" + string2 + "," + string3 + ")");
                    ++n5;
                }
                ++n3;
            }
        }
    }

    public static class FunctionOldInputArgument
    extends FunctionInputArgument {
        public FunctionOldInputArgument(MaterialSocketUtil.ArgClass argClass, IVariableID iVariableID, List<RowColPair> list) {
            super(argClass, iVariableID, list);
        }

        @Override
        protected String a() {
            return "state.";
        }

        @Override
        protected String a(Material material) {
            return FlStringUtil.getXmeshVarName((String)(String.valueOf(material.scopeDot()) + "state."));
        }
    }

    public static class FunctionOutputArgument
    extends AbstractFunctionArgument {
        private MaterialSocketUtil.ArgClass a;
        private String[] b;

        public FunctionOutputArgument(MaterialSocketUtil.ArgClass argClass, IVariableID iVariableID, List<RowColPair> list) {
            super(ArgumentType.OUTPUT);
            this.a = argClass;
            this.b = new String[list.size()];
            String[][] stringArray = iVariableID.getTensorComponentNames("output.");
            int n2 = 0;
            for (RowColPair rowColPair : list) {
                this.b[n2++] = stringArray[rowColPair.row][rowColPair.col];
            }
        }

        @Override
        public void addFunctionArgument(MaterialSocketUtil.ExternalInterfaceMaker externalInterfaceMaker) {
            externalInterfaceMaker.addArgument(this.a, MaterialSocketUtil.ArgFormat.VECTOR);
            externalInterfaceMaker.setArgIds(MaterialSocketUtil.ArgType.OUTPUT, this.b);
        }
    }

    public static class FunctionParameterArgument
    extends AbstractFunctionArgument {
        private MaterialSocketUtil.ArgClass a;
        private Collection<String> b = new ArrayList<String>();
        private Collection<String> c = new ArrayList<String>();

        public FunctionParameterArgument(MaterialSocketUtil.ArgClass argClass, Material material, Collection<IVariableID> collection) {
            super(ArgumentType.PARAMETER);
            this.a = argClass;
            for (IVariableID iVariableID : collection) {
                String[][] stringArray;
                IVariableID.GroupPropertyPair groupPropertyPair = iVariableID.getGroupPropertyPairOrNull();
                if (groupPropertyPair == null || !material.propertyGroup().hasTag(groupPropertyPair.group) || !material.propertyGroup(groupPropertyPair.group).hasParam(groupPropertyPair.property) || material.propertyGroup(groupPropertyPair.group).getString(groupPropertyPair.property).isEmpty()) continue;
                String[][] stringArray2 = material.propertyGroup(groupPropertyPair.group).getParamValue(groupPropertyPair.property).getMatrix(iVariableID.getTensorType().getVariableSize());
                if (stringArray2.length != (stringArray = iVariableID.getTensorComponentNames("input.")).length) {
                    throw new MultiphysicsException("External_material_property_X_has_wrong_size#" + iVariableID.getBaseName());
                }
                IVariableData iVariableData = material.getModel().physics().getVarData();
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    if (stringArray2[n2].length != stringArray[n2].length) {
                        throw new MultiphysicsException("External_material_property_X_has_wrong_size#" + iVariableID.getBaseName());
                    }
                    int n3 = 0;
                    while (n3 < stringArray2[n2].length) {
                        String string = iVariableData.checkRemoveRoot(iVariableData.replaceWithCompleteNames(stringArray2[n2][n3], material.scopeDot()));
                        string = o.a((String)string, (IUnitConverter)material.getConverter(), (boolean[])new boolean[0]);
                        this.c.add(string);
                        this.b.add(stringArray[n2][n3]);
                        ++n3;
                    }
                    ++n2;
                }
            }
        }

        @Override
        public void addFunctionArgument(MaterialSocketUtil.ExternalInterfaceMaker externalInterfaceMaker) {
            externalInterfaceMaker.addArgument(this.a, MaterialSocketUtil.ArgFormat.VECTOR);
            externalInterfaceMaker.setArgIds(MaterialSocketUtil.ArgType.INPUT, this.b.toArray(new String[0]));
        }

        @Override
        public void addExtraExprIDs(Material material, List<String> list, List<String> list2) {
            list.addAll(this.c);
            list2.addAll(this.b);
        }
    }

    public static class FunctionParameterArrayArgument
    extends AbstractFunctionArgument {
        private MaterialSocketUtil.ArgClass a;
        private String[] b;
        private String[] c;

        public FunctionParameterArrayArgument(MaterialSocketUtil.ArgClass argClass, Material material, IVariableID iVariableID) {
            super(ArgumentType.PARAMETER);
            this.a = argClass;
            IVariableID.GroupPropertyPair groupPropertyPair = iVariableID.getGroupPropertyPairOrNull();
            if (material.propertyGroup().hasTag(groupPropertyPair.group) && material.propertyGroup(groupPropertyPair.group).hasParam(groupPropertyPair.property)) {
                String[][] stringArray = material.propertyGroup(groupPropertyPair.group).getParamValue(groupPropertyPair.property).getValue();
                this.b = new String[stringArray.length];
                this.c = new String[stringArray.length];
                IVariableData iVariableData = material.getModel().physics().getVarData();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    String string = iVariableData.checkRemoveRoot(iVariableData.replaceWithCompleteNames(stringArray[n2][0], material.scopeDot()));
                    this.c[n2] = string = o.a((String)string, (IUnitConverter)material.getConverter(), (boolean[])new boolean[0]);
                    this.b[n2] = "input." + groupPropertyPair.property + n2;
                    ++n2;
                }
            }
        }

        @Override
        public void addFunctionArgument(MaterialSocketUtil.ExternalInterfaceMaker externalInterfaceMaker) {
            externalInterfaceMaker.addArgument(this.a, MaterialSocketUtil.ArgFormat.VECTOR);
            if (this.b != null) {
                externalInterfaceMaker.setArgIds(MaterialSocketUtil.ArgType.INPUT, this.b);
            } else {
                externalInterfaceMaker.setArgIds(MaterialSocketUtil.ArgType.INPUT, new String[0]);
            }
        }

        @Override
        public void addExtraExprIDs(Material material, List<String> list, List<String> list2) {
            if (this.b != null) {
                list.addAll(Arrays.asList(this.c));
                list2.addAll(Arrays.asList(this.b));
            }
        }
    }

    public static class FunctionParameterArraySizeArgument
    extends FunctionFixedIntArgument {
        public FunctionParameterArraySizeArgument(Material material, IVariableID iVariableID) {
            super("input." + iVariableID.getBaseName() + ".size", 0);
            IVariableID.GroupPropertyPair groupPropertyPair = iVariableID.getGroupPropertyPairOrNull();
            if (material.propertyGroup().hasTag(groupPropertyPair.group) && material.propertyGroup(groupPropertyPair.group).hasParam(groupPropertyPair.property)) {
                this.a = material.propertyGroup(groupPropertyPair.group).getParamValue(groupPropertyPair.property).getValue().length;
            }
        }
    }

    public static class FunctionStateArgument
    extends AbstractFunctionArgument {
        private MaterialSocketUtil.ArgClass a;
        private String[] b;
        private String[] c;

        public FunctionStateArgument(MaterialSocketUtil.ArgClass argClass, IExternalMaterialSocket.StateDeclaration stateDeclaration) {
            super(ArgumentType.STATE);
            this.a = argClass;
            this.b = stateDeclaration.getStateArgumentNames("input.");
            this.c = stateDeclaration.getStateArgumentNames("output.");
        }

        @Override
        public void addFunctionArgument(MaterialSocketUtil.ExternalInterfaceMaker externalInterfaceMaker) {
            externalInterfaceMaker.addArgument(this.a, MaterialSocketUtil.ArgFormat.VECTOR);
            externalInterfaceMaker.setArgIds(MaterialSocketUtil.ArgType.INPUT, this.b);
            externalInterfaceMaker.setArgIds(MaterialSocketUtil.ArgType.OUTPUT, this.c);
        }
    }

    public static class FunctionStateJacobianArgument
    extends FunctionJacobianArgument {
        public FunctionStateJacobianArgument(MaterialSocketUtil.ArgClass argClass, boolean bl2, IExternalMaterialSocket.StateDeclaration stateDeclaration, IVariableID iVariableID, List<RowColPair> list) {
            super(argClass, bl2);
            this.b = stateDeclaration.getStateArgumentNames("output.");
            this.a = new String[list.size()];
            String[][] stringArray = iVariableID.getTensorComponentNames("input.");
            int n2 = 0;
            for (RowColPair rowColPair : list) {
                this.a[n2++] = stringArray[rowColPair.row][rowColPair.col];
            }
        }
    }

    public static interface IFunctionArgument {
        public ArgumentType getArgumentType();

        public void addFunctionArgument(MaterialSocketUtil.ExternalInterfaceMaker var1);

        public void addExtraVarIDs(String var1, List<String> var2, List<String> var3);

        public void addExtraExprIDs(Material var1, List<String> var2, List<String> var3);
    }

    public static interface IFunctionCallSpecification {
        public void addFunctionCall(Material var1, MaterialSocketUtil.ExternalInterfaceMaker var2);

        public void addExtraVarIDs(Material var1, List<String> var2, List<String> var3);

        public void addExtraExprIDs(Material var1, List<String> var2, List<String> var3);
    }

    public static class OldInputComplexPair {
        public final IVariableID variable;
        public final boolean isComplex;

        public OldInputComplexPair(IVariableID iVariableID, boolean bl2) {
            this.variable = iVariableID;
            this.isComplex = bl2;
        }
    }

    public static class RowColPair {
        private static final int a = 6;
        public final int row;
        public final int col;

        public RowColPair(int n2, int n3) {
            this.row = n2;
            this.col = n3;
        }

        public int hashCode() {
            return this.col + 6 * this.row;
        }
    }

    private static enum SpecialVarID {
        a("special.errorCodeID"),
        b("special.detailsID"),
        c("special.nThreads"),
        d("special.interfaceID"),
        e("special.threadID");

        private String varID;

        private SpecialVarID(String string2) {
            this.varID = string2;
        }

        public String toString() {
            return this.varID;
        }
    }
}

