/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.matlib;

import com.comsol.model.matlib.MaterialLibrary;
import com.comsol.model.matlib.MaterialNode;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;

public class MaterialGroupNode {
    public static final String DESCRIPTION_PROP = "description";
    protected LoadState a = LoadState.NOT_LOADED;
    private MaterialLibrary e;
    private MaterialGroupNode f = null;
    protected HashMap<String, MaterialGroupNode> b = new LinkedHashMap<String, MaterialGroupNode>();
    private String g = null;
    private String h = null;
    private String i = null;
    private String j = null;
    protected PropertyChangeSupport c = new PropertyChangeSupport(this);
    protected boolean d = false;

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.c.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.c.removePropertyChangeListener(string, propertyChangeListener);
    }

    protected LoadState a() {
        return this.getLibrary().getLoadState();
    }

    protected void c() {
        if (this.a != LoadState.LOADED) {
            this.a = LoadState.FORCE_LOAD;
        }
    }

    public String getFullName() {
        return this.j;
    }

    public boolean isReadOnly() {
        return this.getLibrary().isReadOnly() || this.d;
    }

    protected void a(boolean bl2) {
        this.d = bl2;
    }

    protected final void a(MaterialGroupNode materialGroupNode) {
        String string = materialGroupNode.getName();
        if (this.b.containsKey(string)) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getSimpleName()) + " already contains child " + materialGroupNode.getClass().getSimpleName() + " '" + string + "'");
        }
        this.b.put(string, materialGroupNode);
        materialGroupNode.f = this;
        materialGroupNode.j = String.valueOf(this.getFullName()) + "." + string;
    }

    protected final void b(MaterialGroupNode materialGroupNode) {
        String string = materialGroupNode.getName();
        if (!this.b.containsKey(string)) {
            throw new IllegalArgumentException("There is no child '" + materialGroupNode + "' in '" + this + "'.");
        }
        this.b.remove(string);
        materialGroupNode.f = null;
    }

    public MaterialGroupNode[] getChildren() {
        this.e();
        return this.b.values().toArray(new MaterialGroupNode[this.b.size()]);
    }

    public final MaterialGroupNode getChild(String string) {
        this.e();
        return this.b.get(string);
    }

    public boolean hasChildren(boolean bl2) {
        if (bl2) {
            return this.b.size() > 0;
        }
        for (MaterialGroupNode materialGroupNode : this.b.values()) {
            if (materialGroupNode.d()) continue;
            return true;
        }
        return false;
    }

    protected boolean d() {
        return false;
    }

    protected boolean removeMaterial(MaterialNode materialNode) {
        MaterialGroupNode[] materialGroupNodeArray = this.getChildren();
        int n2 = materialGroupNodeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            MaterialGroupNode materialGroupNode = materialGroupNodeArray[n3];
            if (materialGroupNode.d()) {
                if (materialGroupNode.getName().equals(materialNode.getName())) {
                    this.b(materialGroupNode);
                    return true;
                }
            } else if (materialNode.getFullName().startsWith(materialGroupNode.getFullName()) && materialGroupNode.removeMaterial(materialNode)) {
                if (materialGroupNode.b.isEmpty()) {
                    this.b(materialGroupNode);
                }
                return true;
            }
            ++n3;
        }
        return false;
    }

    protected void e() {
        if (this.a.doLoad()) {
            try {
                this.a = this.a == LoadState.NOT_LOADED && this.getLibrary().f() ? LoadState.SCANNING : LoadState.LOADING;
                this.a = this.a();
            }
            catch (RuntimeException runtimeException) {
                this.a = LoadState.FAILED;
                runtimeException.printStackTrace();
                throw runtimeException;
            }
        }
    }

    public MaterialGroupNode getParent() {
        return this.f;
    }

    public MaterialLibrary getLibrary() {
        return this.e;
    }

    protected void a(MaterialLibrary materialLibrary) {
        this.e = materialLibrary;
    }

    public String getName() {
        return this.h;
    }

    public String getDescriptiveName() {
        return this.i;
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException("Material group name cannot be null.");
        }
        this.i = string.trim();
        this.h = string = MaterialGroupNode.a(string);
    }

    public String getDescription() {
        return this.g;
    }

    public void setDescription(String string) {
        if (string == null) {
            throw new NullPointerException("Material group description cannot be null.");
        }
        if (!string.equals(this.g)) {
            String string2 = this.g;
            this.g = string;
            this.c.firePropertyChange(DESCRIPTION_PROP, string2, string);
        }
    }

    public String toString() {
        return this.getFullName();
    }

    static String a(String string) {
        return string.toLowerCase(Locale.ENGLISH).trim().replace(' ', '_').replace('.', '_');
    }

    public static enum LoadState {
        NOT_LOADED{

            @Override
            public boolean doLoad() {
                return true;
            }
        }
        ,
        FORCE_LOAD{

            @Override
            public boolean doLoad() {
                return true;
            }
        }
        ,
        SCANNING,
        SCANNED{

            @Override
            public boolean hasLoadedChildren() {
                return true;
            }
        }
        ,
        LOADING,
        LOADED{

            @Override
            public boolean hasLoadedChildren() {
                return true;
            }
        }
        ,
        FAILED{

            @Override
            public boolean needLoadingOfChildren() {
                return false;
            }
        };


        public boolean doLoad() {
            return false;
        }

        public boolean needLoadingOfChildren() {
            return !this.hasLoadedChildren();
        }

        public boolean hasLoadedChildren() {
            return false;
        }
    }
}

