/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.matlib;

import com.comsol.model.applapi.IPhysicalQuantity;
import com.comsol.model.applapi.MaterialDB;
import com.comsol.model.applapi.PhysicalQuantityManager;
import com.comsol.model.dbimodel.MaterialModel;
import com.comsol.model.matlib.MatLibMaterialModel;
import com.comsol.model.matlib.MaterialFunction;
import com.comsol.model.matlib.MaterialGroupNode;
import com.comsol.model.matlib.MaterialUtil;
import com.comsol.model.matlib.RecentMaterialNode;
import com.comsol.model.param.ParamSpec;
import com.comsol.model.plugin.internal.CsPlugin;
import com.comsol.model.simple.SimpleMaterialModel;
import com.comsol.model.util.UnitUtil;
import com.comsol.nativeutil.properties.Property;
import com.comsol.nativeutil.properties.de;
import com.comsol.nativeutil.properties.dk;
import com.comsol.nativeutil.properties.ds;
import com.comsol.util.classes.CsAbstractPlugin;
import com.comsol.util.logger.FlLogger;
import com.comsol.util.methods.FlLocale;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class MaterialNode
extends MaterialGroupNode {
    protected final Map<String, String> e = new LinkedHashMap<String, String>();
    private final Map<String, MatLibMaterialModel> g = new LinkedHashMap<String, MatLibMaterialModel>();
    protected String f;

    public MaterialNode() {
        MatLibMaterialModel matLibMaterialModel = new MatLibMaterialModel(MaterialDB.MatRes.def.name(), "");
        this.g.put(matLibMaterialModel.getName(), matLibMaterialModel);
    }

    public boolean equals(Object object) {
        if (!(object instanceof MaterialNode)) {
            return false;
        }
        MaterialNode materialNode = (MaterialNode)object;
        if (materialNode instanceof RecentMaterialNode) {
            RecentMaterialNode recentMaterialNode = (RecentMaterialNode)materialNode;
            return recentMaterialNode.getActualMaterial().equals(this);
        }
        return this == object;
    }

    public String getIcon() {
        return "material.png";
    }

    public Map<String, String> getMaterialInfo() {
        this.c();
        this.e();
        if (this.a == MaterialGroupNode.LoadState.SCANNED) {
            throw new IllegalStateException("Cannot access material data when it is scanned");
        }
        return this.e;
    }

    protected void a(String string, String string2) {
        if (this.getLibrary().useLocalization()) {
            string = FlLocale.getString((String)string);
        }
        this.e.put(string, string2);
        for (MaterialGroupNode materialGroupNode : this.b.values()) {
            MaterialNode materialNode = (MaterialNode)materialGroupNode;
            materialNode.a(string, string2);
        }
    }

    protected void b(String string) {
        this.f = string;
        for (MaterialGroupNode materialGroupNode : this.b.values()) {
            MaterialNode materialNode = (MaterialNode)materialGroupNode;
            materialNode.b(string);
        }
    }

    protected de b(String string, String string2) {
        de de2 = null;
        if (string2.equals(MaterialDB.MatRes.def.name())) {
            if (PhysicalQuantityManager.isID(string)) {
                ParamSpec paramSpec = ParamSpec.fromMaterialProperty(PhysicalQuantityManager.getID(string));
                de2 = this.e(string, FlLocale.getString((String)paramSpec.getDescr()));
                de2.set("unit", paramSpec.getUnit(new SimpleMaterialModel(MaterialDB.MatRes.def.name())));
            } else {
                de2 = this.e(string, string);
                FlLogger.b((String)("Unknown material property '" + string + "'."));
                de2.set("unit", "");
            }
        } else {
            MaterialModel materialModel = PhysicalQuantityManager.getApplMaterialModel(string2);
            de2 = this.a(materialModel, string);
        }
        this.a(string2, de2);
        return de2;
    }

    protected de a(MaterialModel materialModel, String string) {
        ParamSpec paramSpec = materialModel.getSpec(string);
        de de2 = this.e(string, FlLocale.getString((String)paramSpec.getDescr()));
        String string2 = paramSpec.getUnit(materialModel);
        if (string2 == null) {
            string2 = "";
        }
        de2.set("unit", string2);
        return de2;
    }

    private final de e(String string, String string2) {
        de de2 = new de(string, string2);
        de2.registerProp((Property)new dk("expression", "Expression", new String[0]));
        de2.registerProp((Property)new ds("unit", "Unit", ""));
        return de2;
    }

    private void a(String string, de de2) {
        MatLibMaterialModel matLibMaterialModel = this.getMaterialModel(string);
        if (matLibMaterialModel == null) {
            Object object = PhysicalQuantityManager.getApplMaterialModel(string);
            matLibMaterialModel = this.a((MaterialModel)object);
        }
        matLibMaterialModel.a(de2);
        for (Object object : this.b.values()) {
            MaterialNode materialNode = (MaterialNode)object;
            materialNode.a(string, de2);
        }
    }

    protected MatLibMaterialModel a(MaterialModel materialModel) {
        MatLibMaterialModel matLibMaterialModel = new MatLibMaterialModel(materialModel.tag(), materialModel.label());
        this.g.put(matLibMaterialModel.getName(), matLibMaterialModel);
        return matLibMaterialModel;
    }

    protected boolean c(String string) {
        if (this.a == MaterialGroupNode.LoadState.SCANNED) {
            throw new IllegalStateException("Cannot access material data when it is scanned");
        }
        return this.g.containsKey(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void c(String string, String string2) {
        IPhysicalQuantity iPhysicalQuantity = MaterialUtil.findPhysicalQuantity(string);
        if (iPhysicalQuantity == null) {
            boolean bl2 = false;
            if (string2.equals(MaterialDB.MatRes.def.name())) {
                bl2 = true;
            } else {
                MaterialModel materialModel = PhysicalQuantityManager.getApplMaterialModel(string2);
                if (materialModel.hasParam(string)) {
                    return;
                }
                bl2 = true;
            }
            if (!bl2) return;
            this.d(string, string2);
            return;
        } else {
            de de2 = new de(iPhysicalQuantity.fieldName(), FlLocale.getString((String)iPhysicalQuantity.descr()));
            de2.registerProp((Property)new ds("unit", "Unit", ""));
            String string3 = UnitUtil.getUnitConverter().toString(iPhysicalQuantity.dimension(), new String[0]);
            de2.set("unit", string3);
            de2.registerProp((Property)new ds("variable", "Variable", ""));
            String string4 = iPhysicalQuantity.varName();
            de2.set("variable", string4);
            this.a(de2, string2);
        }
    }

    protected void d(String string, String string2) {
        CsPlugin.log(CsAbstractPlugin.LogLevel.WARNING, "Unknown material model input '" + string + "'. Adding as a local parameter.");
        this.b(string, string2);
    }

    protected void a(de de2, String string) {
        MatLibMaterialModel matLibMaterialModel = this.getMaterialModel(string);
        matLibMaterialModel.b(de2);
        for (MaterialGroupNode materialGroupNode : this.b.values()) {
            MaterialNode materialNode = (MaterialNode)materialGroupNode;
            materialNode.a(de2, string);
        }
    }

    protected void a(MaterialFunction materialFunction, String string) {
        MatLibMaterialModel matLibMaterialModel = this.getMaterialModel(string);
        matLibMaterialModel.a(materialFunction);
        for (MaterialGroupNode materialGroupNode : this.b.values()) {
            MaterialNode materialNode = (MaterialNode)materialGroupNode;
            materialNode.a(materialFunction, string);
        }
    }

    public Collection<MatLibMaterialModel> getMaterialModels() {
        this.c();
        this.e();
        if (this.a == MaterialGroupNode.LoadState.SCANNED) {
            throw new IllegalStateException("Cannot access material data when it is scanned");
        }
        return Collections.unmodifiableCollection(this.g.values());
    }

    public MatLibMaterialModel getMaterialModel(String string) {
        if (this.a == MaterialGroupNode.LoadState.SCANNED) {
            throw new IllegalStateException("Cannot access material data when it is scanned");
        }
        return this.g.get(string);
    }

    public String getAppearance() {
        if (this.a == MaterialGroupNode.LoadState.SCANNED) {
            throw new IllegalStateException("Cannot access material data when it is scanned");
        }
        return this.f;
    }

    public boolean isRemovable() {
        return !this.getLibrary().isReadOnly() && !this.d;
    }

    @Override
    protected boolean d() {
        return true;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ": " + this.getFullName();
    }

    public boolean meetsCondition(Map<String, String> map) {
        return this.getParent() instanceof MaterialNode && ((MaterialNode)this.getParent()).meetsCondition(map);
    }

    public boolean isCommonMaterial() {
        return true;
    }
}

