/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.matlib;

import com.comsol.loader.ModelLoader;
import com.comsol.model.dbimodel.FileResource;
import com.comsol.model.dbimodel.FileResourceList;
import com.comsol.model.dbimodel.Material;
import com.comsol.model.dbimodel.MaterialList;
import com.comsol.model.dbimodel.MaterialModel;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelNode;
import com.comsol.model.matlib.MaterialGroupNode;
import com.comsol.model.matlib.MaterialLibrary;
import com.comsol.model.matlib.MaterialLibraryUtil;
import com.comsol.model.matlib.MaterialNode;
import com.comsol.model.matlib.MaterialUtil;
import com.comsol.model.matlib.MphExternalMaterialNode;
import com.comsol.model.matlib.MphLayeredShellMaterialNode;
import com.comsol.model.matlib.MphMaterialNode;
import com.comsol.model.matlib.MphSingleLayerMaterialNode;
import com.comsol.model.method.ModelEntityMethod;
import com.comsol.model.operations.IMaterialOperation;
import com.comsol.model.operations.OperationManager;
import com.comsol.model.operations.OperationType;
import com.comsol.model.savepoint.interfaces.IModel;
import com.comsol.model.savepoint.interfaces.IModelEntityList;
import com.comsol.model.util.LocalModel;
import com.comsol.model.util.ModelCustomDataTypeConverter;
import com.comsol.model.util.ModelInternalUtil;
import com.comsol.model.util.saveload.MemoryLoaderHelper;
import com.comsol.util.classes.FileManagerUtil;
import com.comsol.util.classes.StringStringPair;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.exceptions.UnknownEntityException;
import com.comsol.util.interfaces.m;
import com.comsol.util.logger.FlLogger;
import com.comsol.util.methods.FlLocale;
import com.comsol.util.methods.FlStringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class MphMaterialLibrary
extends MaterialLibrary {
    public static final boolean SUPPORT_SCANNING_OF_LIBRARIES = true;
    private static final a i = new a();
    private static String j;
    private LocalModel k;
    private StringStringPair l = null;
    private MaterialLibraryUtil.a m = null;
    private Map<String, a> n = new LinkedHashMap<String, a>();
    private d o = null;

    static {
        MphMaterialLibrary.i.a = "";
        MphMaterialLibrary.i.b = "";
        MphMaterialLibrary.i.c = "";
        MphMaterialLibrary.i.d = new String[0][];
        j = "Materials";
    }

    public MphMaterialLibrary(String string, boolean bl2, boolean bl3) {
        super(string, bl3, bl2);
        String string2 = bl3 ? FlStringUtil.getFileName((File)new File(string), (boolean)false) : FileManagerUtil.k((String)string, (String)com.comsol.util.interfaces.m.a);
        String string3 = FlStringUtil.subStringBeforeLast((String)string2, (String)".");
        this.setName(string3);
        this.b(bl2);
        this.setDescription(bl2 ? FlLocale.getString((String)this.m.a, (boolean)true) : this.m.a);
    }

    private void b(boolean bl2) {
        if (this.m == null) {
            this.m = MaterialLibraryUtil.quickReadAttributes(this, new String[0]);
            if (this.m.a == null || j.equals(this.m.a)) {
                this.m.a = bl2 ? String.valueOf(this.getName()) + "_descr" : this.getDescriptiveName().replace("_", " ");
            }
        }
    }

    @Override
    protected boolean f() {
        if (this.getLoadState() == MaterialGroupNode.LoadState.LOADED) {
            return false;
        }
        return this.getVersionNo() >= 1001;
    }

    private String[] i() throws ModelLoader.NotConvertedException {
        this.n.clear();
        this.l = null;
        MaterialLibraryUtil.ScannedData scannedData = MaterialLibraryUtil.scanLibrary(this, new String[0]);
        int n2 = 0;
        while (n2 < scannedData.a.length) {
            Object object;
            a a2 = new a();
            a2.a = scannedData.a[n2];
            a2.b = scannedData.b[n2];
            a2.c = scannedData.c[n2];
            if (scannedData.d != null && scannedData.d[n2] != null) {
                a2.d = ModelCustomDataTypeConverter.createStringDblArrayFromString(scannedData.d[n2]);
            }
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            if (scannedData.e != null && scannedData.e[n2] != null && ((String[][])(object = ModelCustomDataTypeConverter.createStringDblArrayFromString(scannedData.e[n2]))).length == 1) {
                Stream.of(object[0]).filter(string -> string != null && !string.isEmpty()).forEach(string -> {
                    boolean bl2 = linkedHashSet.add(string);
                });
            }
            if (scannedData.f != null && scannedData.f[n2] != null && ((String[][])(object = ModelCustomDataTypeConverter.createStringDblArrayFromString(scannedData.f[n2]))).length == 1) {
                Stream.of(object[0]).filter(string -> string != null && !string.isEmpty()).forEach(string -> {
                    boolean bl2 = linkedHashSet.add(string);
                });
            }
            if (scannedData.g != null) {
                a2.g = "shell".equals(scannedData.g[n2]);
            }
            if (!linkedHashSet.isEmpty()) {
                a2.e = linkedHashSet.toArray(new String[linkedHashSet.size()]);
            }
            if (scannedData.h.length > 0) {
                a2.f = scannedData.h[n2];
            }
            this.n.put(a2.a, a2);
            object = MphMaterialLibrary.a(a2.a);
            if (!a2.a.equals(object)) {
                this.n.put((String)object, a2);
            }
            ++n2;
        }
        Pattern pattern = Pattern.compile("<FileResource\\s+tag=\"");
        if (scannedData.i != null && pattern.matcher(scannedData.i).find()) {
            this.m.d = scannedData.i;
        }
        return scannedData.a;
    }

    public void addMaterial(Material material) {
        this.c();
        this.e();
        String string = "";
        Material material2 = this.j().addCopy(material, string);
        MphMaterialNode mphMaterialNode = this.a(material2.tag(), material2.getOperationID(), material.propertyGroup().hasTag("shell"));
        if (mphMaterialNode == null) {
            this.j().remove(material2.tag());
            throw new IllegalStateException("The material of type '" + material.getOperationID() + "' cannot be added to the library '" + this.getName() + "'.");
        }
        this.a((MaterialGroupNode)mphMaterialNode);
        this.a(material2);
        this.a(mphMaterialNode);
    }

    private MphMaterialNode a(String string, String string2, boolean bl2) {
        switch (string2) {
            case "Common": {
                return bl2 ? new MphSingleLayerMaterialNode(string, this) : new MphMaterialNode(string, this);
            }
            case "LayeredMaterial": {
                return new MphLayeredShellMaterialNode(string, this);
            }
            case "External": {
                return new MphExternalMaterialNode(string, this);
            }
        }
        return null;
    }

    public void addMaterial(MaterialNode materialNode) {
        this.c();
        this.e();
        String string = this.j().uniquetag("mat");
        Material material = MaterialUtil.addMaterialToModel(this.j(), materialNode, string, "");
        material.set("groups", new String[0][]);
        MphMaterialNode mphMaterialNode = this.a(string, material.getOperationID(), materialNode.c("shell"));
        if (mphMaterialNode == null) {
            this.j().remove(string);
            throw new IllegalStateException("The material of type '" + material.getOperationID() + "' cannot be added to the library '" + this.getName() + "'.");
        }
        this.a((MaterialGroupNode)mphMaterialNode);
        this.a(material);
        this.a(mphMaterialNode);
    }

    protected void a(LocalModel localModel) {
        ModelNode modelNode;
        if (this.k != null && (localModel == null || this.k.getModel() != localModel.getModel())) {
            this.k.dispose();
        }
        if (localModel != null && (modelNode = ((ModelEntityMethod)localModel.getModel().material().method()).getDefaultModelNode()) != null) {
            throw new IllegalStateException("The material library model has a default model node.");
        }
        this.k = localModel;
    }

    protected Model b() {
        return this.k != null ? this.k.getModel() : null;
    }

    @Override
    public void dispose() {
        this.clearLibrary();
    }

    /*
     * WARNING - void declaration
     */
    Material b(String string) {
        this.e();
        a a2 = this.n.getOrDefault(string, i);
        if (this.j().hasTag(string)) {
            return (Material)this.j().get(string);
        }
        if (this.j().hasTag(a2.a)) {
            return (Material)this.j().get(a2.a);
        }
        if (a2 != i && this.getLoadState() == MaterialGroupNode.LoadState.SCANNED) {
            void var5_8;
            String[] stringArray;
            int n2;
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(a2.e));
            arrayList.add(a2.a);
            Material material = MaterialLibraryUtil.quickReadMaterial(this, arrayList, this.b(), true, new String[0]);
            if (material == null) {
                throw this.e(string);
            }
            if (this.useLocalization()) {
                for (MaterialModel object2 : material.propertyGroup()) {
                    String[] stringArray2 = object2.param();
                    int n3 = stringArray2.length;
                    n2 = 0;
                    while (n2 < n3) {
                        String string2 = stringArray2[n2];
                        if (!object2.isOutput(string2)) {
                            String string3 = FlLocale.getString((String)object2.descr(string2));
                            object2.descr(string2, string3);
                        }
                        ++n2;
                    }
                }
            }
            MphMaterialLibrary mphMaterialLibrary = this;
            String[][] stringArray3 = a2.d;
            n2 = a2.d.length;
            int n4 = 0;
            while (n4 < n2) {
                stringArray = stringArray3[n4];
                MaterialGroupNode materialGroupNode = var5_8.getChild(MphMaterialLibrary.a(stringArray[0]));
                ++n4;
            }
            stringArray = MphMaterialLibrary.a(string);
            MaterialGroupNode materialGroupNode = var5_8.getChild((String)stringArray);
            materialGroupNode.c();
            materialGroupNode.e();
            if (!Arrays.deepEquals((Object[])a2.d, (Object[])material.getStringMatrix("groups"))) {
                FlLogger.c((String)("Groups differ between loaded and scanned material '" + string + "'."));
            }
            Material material2 = material;
            return material2;
        }
        throw this.e(string);
    }

    private FlException e(String string) {
        UnknownEntityException unknownEntityException = new UnknownEntityException("Unknown_material");
        unknownEntityException.addParameterPair("Tag", string);
        return unknownEntityException;
    }

    String c(String string) {
        this.e();
        a a2 = this.n.getOrDefault(string, i);
        if (this.j().hasTag(string)) {
            return this.b(string).label();
        }
        if (this.j().hasTag(a2.a)) {
            return this.b(a2.a).label();
        }
        if (this.getLoadState() == MaterialGroupNode.LoadState.SCANNED) {
            return a2.b;
        }
        throw this.e(string);
    }

    void a(String string, String string2) {
        this.c();
        this.b(string).label(string2);
        Optional.ofNullable(this.n.get(string)).ifPresent(a2 -> {
            String string2 = a2.b = string2;
        });
    }

    private MaterialList<? extends Material> j() {
        return this.b().material();
    }

    @Override
    public boolean removeMaterial(MaterialNode materialNode) {
        this.c();
        boolean bl2 = super.removeMaterial(materialNode);
        if (bl2) {
            String string = this.f(materialNode.getName());
            this.j().remove(string);
            this.b(materialNode);
        }
        return bl2;
    }

    @Override
    public List<MaterialNode> findMaterials(Map<String, String> map) {
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        String string2 = Optional.ofNullable(map.get("name")).map(string -> string.toLowerCase(Locale.ENGLISH)).orElse(null);
        String string3 = Optional.ofNullable(map.get("uns")).map(string -> string.toLowerCase(Locale.ENGLISH)).orElse(null);
        String string4 = Optional.ofNullable(map.get("din")).map(string -> string.toLowerCase(Locale.ENGLISH)).orElse(null);
        this.e();
        ArrayList<MaterialNode> arrayList = new ArrayList<MaterialNode>();
        MphMaterialLibrary.a(this, string2, string4, string3, arrayList);
        return arrayList;
    }

    private static void a(MaterialGroupNode materialGroupNode, String string, String string2, String string3, List<MaterialNode> list) {
        MaterialGroupNode[] materialGroupNodeArray;
        MaterialGroupNode[] materialGroupNodeArray2 = materialGroupNodeArray = materialGroupNode.getChildren();
        int n2 = materialGroupNodeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            MphMaterialNode mphMaterialNode;
            MaterialGroupNode materialGroupNode2 = materialGroupNodeArray2[n3];
            if (materialGroupNode2.d() && (mphMaterialNode = (MphMaterialNode)materialGroupNode2).meetsCondition(string, string2, string3)) {
                list.add((MaterialNode)materialGroupNode2);
            }
            MphMaterialLibrary.a(materialGroupNode2, string, string2, string3, list);
            ++n3;
        }
    }

    public String embedInXml(String string) {
        if (this.l == null) {
            this.l = this.g() ? MaterialLibraryUtil.createPartialLibraryXml(this, this.m.d) : MaterialLibraryUtil.createPartialLibraryXml(this, new String[0]);
        }
        return this.l.first + string + this.l.second;
    }

    public int getVersionNo() {
        this.b(this.useLocalization());
        return this.m.b;
    }

    public String getVersionName() {
        this.b(this.useLocalization());
        return this.m.c;
    }

    boolean g() {
        return !FlStringUtil.isNullOrEmpty((String)this.m.d);
    }

    long d(String string) {
        a a2 = this.n.get(string);
        return a2 != null ? a2.f : 0L;
    }

    MemoryLoaderHelper h() {
        if (this.o == null) {
            this.o = new d(this);
        }
        return this.o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearLibrary() {
        Object object = this.f;
        synchronized (object) {
            super.clearLibrary();
            this.n.clear();
            if (this.o != null) {
                this.o.a();
            }
            this.o = null;
            this.a((LocalModel)null);
            this.m = null;
            this.l = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected MaterialGroupNode.LoadState a() {
        MaterialGroupNode.LoadState loadState;
        Object object;
        try {
            void var3_7;
            Object object2 = object = this.h ? FlStringUtil.getFileName((File)new File(this.getFileName()), (boolean)true) : FlStringUtil.subStringBeforeLast((String)FileManagerUtil.k((String)this.getFileName(), (String)com.comsol.util.interfaces.m.a), (String)".");
            if (this.getLoadState() == MaterialGroupNode.LoadState.SCANNING) {
                LocalModel object22 = this.k;
                if (object22 == null) {
                    LocalModel flException = ModelInternalUtil.createLocalModel();
                    flException.getModel().setTag((String)object);
                    flException.getModel().setDisableUpdates(true);
                    flException.getModel().paramDatabase().getFunctionModificationLock();
                    flException.getModel().hist().disable();
                }
                this.i();
                Object object3 = this.f;
                synchronized (object3) {
                    this.a = loadState = MaterialGroupNode.LoadState.SCANNED;
                }
            } else {
                LocalModel localModel = ModelInternalUtil.loadMaterialLibrary((String)object, this.getFileName(), this.h);
                loadState = MaterialGroupNode.LoadState.LOADED;
                for (Material material : localModel.getModel().material()) {
                    this.a(material);
                }
            }
            this.a((LocalModel)var3_7);
        }
        catch (ModelLoader.NotConvertedException | IOException throwable) {
            FlException flException = new FlException("Error_reading_file", throwable);
            flException.addParameterPair("File", this.getFileName());
            throw flException;
        }
        object = new b(this);
        for (Map.Entry<String, a> entry : this.n.entrySet()) {
            MphMaterialNode mphMaterialNode;
            IMaterialOperation iMaterialOperation;
            a a2 = entry.getValue();
            if (!entry.getKey().equals(a2.a) || !(iMaterialOperation = (IMaterialOperation)OperationManager.create(OperationType.MATERIAL, a2.c)).showInContextMenu(null) || (mphMaterialNode = this.a(a2.a, a2.c, a2.g)) == null) continue;
            Object object4 = object;
            String[][] stringArray = a2.d;
            int n2 = a2.d.length;
            int n3 = 0;
            while (n3 < n2) {
                String[] stringArray2 = stringArray[n3];
                b b2 = ((b)object4).b.get(stringArray2[0]);
                if (b2 == null) {
                    MaterialGroupNode materialGroupNode = new MaterialGroupNode();
                    materialGroupNode.a(this);
                    materialGroupNode.setName(stringArray2[0]);
                    materialGroupNode.setDescription(stringArray2[1]);
                    ((b)object4).a.a(materialGroupNode);
                    b2 = new b(materialGroupNode);
                    ((b)object4).b.put(stringArray2[0], b2);
                }
                object4 = b2;
                ++n3;
            }
            ((b)object4).a.a(mphMaterialNode);
        }
        return loadState;
    }

    private String f(String string) {
        a a2 = this.n.remove(string);
        if (a2 != null && !a2.a.equals(string)) {
            this.n.remove(a2.a);
        }
        return a2 != null ? a2.a : string;
    }

    private void a(Material material) {
        a a2 = new a();
        a2.a = material.tag();
        a2.b = material.label();
        a2.c = material.getOperationID();
        a2.d = material.getStringMatrix("groups");
        a2.g = material.hasProperty("bndType") && "shell".equals(material.getString("bndType"));
        this.n.put(a2.a, a2);
        String string = MphMaterialLibrary.a(a2.a);
        if (!a2.a.equals(string)) {
            this.n.put(string, a2);
        }
    }

    @Override
    public boolean hasChildren(boolean bl2) {
        return bl2 && (this.getLoadState() != MaterialGroupNode.LoadState.LOADED || this.j().size() > 0);
    }

    @Override
    public void saveLibrary() {
        if (this.isReadOnly()) {
            throw new FlException("The_material_library_is_read_only");
        }
        this.c();
        this.e();
        try {
            if (!this.useLocalization()) {
                this.j().label(this.getDescription());
            }
            ModelInternalUtil.saveMatLibModel(this.b());
            if (this.g != null && !FileManagerUtil.a()) {
                this.g.delete();
                this.g = null;
            }
        }
        catch (IOException iOException) {
            throw new FlException((Throwable)iOException);
        }
    }

    static class a {
        String a;
        String b;
        String c;
        String[][] d = new String[0][];
        String[] e = new String[0];
        long f = 0L;
        boolean g = false;

        a() {
        }
    }

    private static class b {
        MaterialGroupNode a;
        Map<String, b> b;

        public b(MaterialGroupNode materialGroupNode) {
            this.a = materialGroupNode;
            this.b = new HashMap<String, b>();
        }
    }

    private static class c {
        String a;
        String b;
        String c;

        private c() {
        }
    }

    private static class d
    implements MemoryLoaderHelper {
        private Map<String, c> a = new LinkedHashMap<String, c>();
        private com.comsol.util.file.b b;

        public d(MphMaterialLibrary mphMaterialLibrary) {
            if (mphMaterialLibrary.g()) {
                try {
                    this.b = new com.comsol.util.file.b(mphMaterialLibrary.getFile());
                }
                catch (IOException iOException) {
                    FlLogger.b((Throwable)iOException);
                    this.b = null;
                }
            } else {
                this.b = null;
            }
        }

        @Override
        public com.comsol.util.file.b getExternalZipFile() {
            return this.b;
        }

        void a() {
            if (this.b != null) {
                try {
                    this.b.close();
                }
                catch (IOException iOException) {
                    FlLogger.b((Throwable)iOException);
                    this.b = null;
                }
            }
        }

        @Override
        public void filterFileResources(com.comsol.util.file.b b2, IModel iModel, Map<String, String> map, Map<String, String> map2) {
            HashSet<String> hashSet = new HashSet<String>();
            for (Material iModelEntity : ((Model)iModel).material()) {
                this.a(iModelEntity, hashSet);
            }
            if (hashSet.isEmpty()) {
                map.clear();
            } else {
                IModelEntityList iModelEntityList = ((Model)iModel).file();
                this.a.forEach((arg_0, arg_1) -> d.a((FileResourceList)iModelEntityList, map, map2, arg_0, arg_1));
                Iterator<String> iterator = map.values().iterator();
                while (iterator.hasNext()) {
                    if (hashSet.contains(iterator.next())) continue;
                    iterator.remove();
                }
            }
        }

        @Override
        public void storeLoadedFileResources(Map<String, String> map, Map<String, String> map2) {
            map.forEach((string, string2) -> {
                c c2 = new c();
                c2.a = string;
                c2.b = string2;
                c2.c = (String)map2.get(string);
                this.a.put((String)string, c2);
            });
        }

        private void a(Material material, Collection<String> collection) {
            collection.addAll(material.getOperation().getUsedFileTags(material));
            material.propertyGroup().stream().flatMap(materialModel -> Stream.of(materialModel.func().files())).forEach(string -> {
                boolean bl2 = collection.add((String)string);
            });
            material.feature().stream().forEach(propFeature -> this.a((Material)propFeature, collection));
        }

        private static /* synthetic */ void a(FileResourceList fileResourceList, Map map, Map map2, String string, c c2) {
            if (fileResourceList.hasTag(c2.b) && c2.c != null) {
                FileResource fileResource = (FileResource)fileResourceList.get(c2.b);
                map.remove(c2.a);
                map2.put(c2.a, c2.c);
                fileResource.resource(c2.c, false);
                fileResource.setXmeshResource(c2.c);
            }
        }
    }
}

