/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.matlib;

import com.comsol.model.matlib.MaterialGroupNode;
import com.comsol.model.matlib.MaterialLibrary;
import com.comsol.model.matlib.MaterialLibraryListener;
import com.comsol.model.matlib.MaterialLibraryManager;
import com.comsol.model.matlib.MaterialLibraryManagerListener;
import com.comsol.model.matlib.MaterialNode;
import com.comsol.model.matlib.RecentMaterialNode;
import com.comsol.nativeutil.preferences.Preferences;
import com.comsol.util.classes.FlStringList;
import com.comsol.util.methods.FlLocale;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class RecentMaterialLibrary
extends MaterialLibrary {
    public static final int MAX_RECENT_MATERIALS = 5;
    private MaterialLibraryManagerListener i = new MaterialLibraryManagerListener(){

        @Override
        public void libraryRemoved(MaterialLibrary materialLibrary) {
            MaterialGroupNode[] materialGroupNodeArray;
            boolean bl2 = false;
            materialLibrary.removeMaterialLibraryListener(RecentMaterialLibrary.this.j);
            MaterialGroupNode[] materialGroupNodeArray2 = materialGroupNodeArray = RecentMaterialLibrary.this.getChildren();
            int n2 = materialGroupNodeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                MaterialGroupNode materialGroupNode = materialGroupNodeArray2[n3];
                MaterialLibrary materialLibrary2 = ((RecentMaterialNode)materialGroupNode).getActualMaterial().getLibrary();
                if (materialLibrary2.equals(materialLibrary)) {
                    bl2 |= RecentMaterialLibrary.this.removeMaterial((RecentMaterialNode)materialGroupNode);
                }
                ++n3;
            }
            if (bl2) {
                RecentMaterialLibrary.this.saveLibrary();
            }
        }

        @Override
        public void libraryAdded(MaterialLibrary materialLibrary) {
            materialLibrary.addMaterialLibraryListener(RecentMaterialLibrary.this.j);
        }

        @Override
        public void libraryReloaded(MaterialLibrary materialLibrary) {
            MaterialGroupNode[] materialGroupNodeArray;
            boolean bl2 = false;
            MaterialGroupNode[] materialGroupNodeArray2 = materialGroupNodeArray = RecentMaterialLibrary.this.getChildren();
            int n2 = materialGroupNodeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                MaterialGroupNode materialGroupNode = materialGroupNodeArray2[n3];
                MaterialLibrary materialLibrary2 = ((RecentMaterialNode)materialGroupNode).getActualMaterial().getLibrary();
                if (materialLibrary2.equals(materialLibrary)) {
                    bl2 |= RecentMaterialLibrary.this.removeMaterial((RecentMaterialNode)materialGroupNode);
                    materialLibrary.getChildren();
                }
                ++n3;
            }
            if (bl2) {
                RecentMaterialLibrary.this.saveLibrary();
            }
        }
    };
    private MaterialLibraryListener j = new MaterialLibraryListener(){

        @Override
        public void materialRemoved(MaterialNode materialNode) {
            if (RecentMaterialLibrary.this.removeMaterial(materialNode)) {
                RecentMaterialLibrary.this.saveLibrary();
            }
        }

        @Override
        public void materialAdded(MaterialNode materialNode) {
        }
    };

    public RecentMaterialLibrary() {
        super(null, false, true);
        this.a(false);
        this.setName("recent_materials");
        this.setDescription(FlLocale.getString((String)"Recent_materials", (boolean)true));
    }

    public boolean addMaterial(MaterialNode materialNode) {
        MaterialNode materialNode2;
        this.e();
        if (!this.b.values().contains(materialNode)) {
            materialNode2 = new RecentMaterialNode(materialNode, this);
            this.a((MaterialGroupNode)materialNode2);
            this.a(materialNode2);
        }
        if (this.b.size() > 5) {
            materialNode2 = (MaterialNode)this.b.values().iterator().next();
            this.b((MaterialGroupNode)materialNode2);
            this.b(materialNode2);
        }
        return false;
    }

    @Override
    public boolean removeMaterial(MaterialNode materialNode) {
        MaterialGroupNode[] materialGroupNodeArray;
        this.e();
        if (materialNode instanceof RecentMaterialNode) {
            materialNode = ((RecentMaterialNode)materialNode).getActualMaterial();
        }
        MaterialGroupNode[] materialGroupNodeArray2 = materialGroupNodeArray = this.getChildren();
        int n2 = materialGroupNodeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            MaterialGroupNode materialGroupNode = materialGroupNodeArray2[n3];
            if (materialGroupNode.equals(materialNode)) {
                this.b(materialGroupNode);
                this.b((RecentMaterialNode)materialGroupNode);
                return true;
            }
            ++n3;
        }
        return false;
    }

    @Override
    public List<MaterialNode> findMaterials(Map<String, String> map) {
        this.e();
        ArrayList<MaterialNode> arrayList = new ArrayList<MaterialNode>();
        for (MaterialGroupNode materialGroupNode : this.b.values()) {
            RecentMaterialNode recentMaterialNode = (RecentMaterialNode)materialGroupNode;
            if (recentMaterialNode == null || !recentMaterialNode.getActualMaterial().meetsCondition(map)) continue;
            arrayList.add(recentMaterialNode);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<?> loadLibraryBackground() {
        Object object = this.f;
        synchronized (object) {
            if (!this.a.doLoad()) {
                return this.e;
            }
            this.a = MaterialGroupNode.LoadState.LOADING;
            MaterialLibraryManager materialLibraryManager = MaterialLibraryManager.getInstance();
            String[] stringArray = Preferences.getInstance().getStringArrayPreference("materiallibraries.libraries.recentmaterials");
            int n2 = 0;
            while (n2 < stringArray.length && n2 < 5) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n2], ".");
                String string = stringTokenizer.nextToken();
                MaterialLibrary materialLibrary = materialLibraryManager.getLibrary(string);
                if (materialLibrary != null) {
                    materialLibrary.loadLibraryBackground();
                }
                ++n2;
            }
            Callable<Void> callable = new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void a() throws Exception {
                    try {
                        MaterialGroupNode.LoadState loadState = RecentMaterialLibrary.this.a();
                        Object object = RecentMaterialLibrary.this.f;
                        synchronized (object) {
                            RecentMaterialLibrary.this.a = loadState;
                        }
                    }
                    catch (Error | RuntimeException throwable) {
                        Object object = RecentMaterialLibrary.this.f;
                        synchronized (object) {
                            RecentMaterialLibrary.this.a = MaterialGroupNode.LoadState.FAILED;
                        }
                        throw throwable;
                    }
                    return null;
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.a();
                }
            };
            this.e = MaterialLibraryManager.getInstance().a().submit(callable);
            return this.e;
        }
    }

    @Override
    protected MaterialGroupNode.LoadState a() {
        MaterialLibraryManager materialLibraryManager = MaterialLibraryManager.getInstance();
        materialLibraryManager.addMaterialLibraryListener(this.i);
        List<MaterialLibrary> list = materialLibraryManager.getLibraries();
        for (MaterialLibrary object2 : list) {
            object2.addMaterialLibraryListener(this.j);
        }
        String[] stringArray = Preferences.getInstance().getStringArrayPreference("materiallibraries.libraries.recentmaterials");
        ArrayList arrayList = new ArrayList(stringArray.length);
        int throwable = 0;
        while (throwable < stringArray.length && throwable < 5) {
            MaterialNode materialNode = null;
            try {
                materialNode = materialLibraryManager.getMaterial(stringArray[throwable]);
            }
            catch (RuntimeException runtimeException) {
                arrayList.add(runtimeException);
            }
            if (materialNode != null) {
                this.a((MaterialGroupNode)new RecentMaterialNode(materialNode, this));
            }
            ++throwable;
        }
        if (arrayList.size() > 0) {
            Throwable throwable2 = (Throwable)arrayList.get(0);
            if (throwable2 instanceof Error) {
                throw (Error)throwable2;
            }
            if (throwable2 instanceof RuntimeException) {
                throw (RuntimeException)throwable2;
            }
        }
        return MaterialGroupNode.LoadState.LOADED;
    }

    @Override
    public boolean hasChildren(boolean bl2) {
        String[] stringArray = Preferences.getInstance().getStringArrayPreference("materiallibraries.libraries.recentmaterials");
        return stringArray.length > 0;
    }

    @Override
    public void saveLibrary() {
        FlStringList flStringList = new FlStringList();
        for (MaterialGroupNode materialGroupNode : this.b.values()) {
            flStringList.add(((RecentMaterialNode)materialGroupNode).getActualMaterial().getFullName());
        }
        Preferences.getInstance().setPreference("materiallibraries.libraries.recentmaterials", flStringList.toArray());
    }
}

