/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.method;

import com.comsol.model.dbimodel.AbstractSelection;
import com.comsol.model.dbimodel.HideMesh;
import com.comsol.model.dbimodel.HideMeshList;
import com.comsol.model.dbimodel.MeshSelection;
import com.comsol.model.dbimodel.MeshSequence;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.View;
import com.comsol.model.method.ModelEntityListMethod;
import com.comsol.model.savepoint.interfaces.IGeomSequence;
import com.comsol.model.selections.GeometrySelectionFilter;
import com.comsol.model.selections.ISelectionFilter;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.methods.FlLocale;
import com.comsol.util.methods.q;

public class HideMeshListMethod<T extends HideMesh>
extends ModelEntityListMethod<T> {
    public HideMeshListMethod(PrimitiveModelEntity primitiveModelEntity) {
        super(primitiveModelEntity);
    }

    @Override
    public HideMeshList<T> getMe() {
        return (HideMeshList)this.u();
    }

    public HideMesh create(String string) {
        this.checkContains(string);
        IGeomSequence iGeomSequence = ((View)this.getMe().getContainer()).getGeomSequence();
        if (iGeomSequence == null) {
            throw new FlException("Hide_features_can_only_be_added_to_views_associated_with_a_geometry");
        }
        if (!iGeomSequence.isDefinedByMesh()) {
            throw new FlException("Only_supported_for_imported_meshes");
        }
        MeshSequence modelEntity2 = null;
        for (MeshSequence modelEntity3 : this.getModel().mesh()) {
            if (modelEntity3.getGeom() != iGeomSequence) continue;
            modelEntity2 = modelEntity3;
            break;
        }
        if (modelEntity2 == null) {
            throw new FlException("Only_supported_for_imported_meshes");
        }
        HideMesh hideMesh = this.getMe().createInstance(string);
        hideMesh.tag(string);
        this.getMe().internalAdd(-1, hideMesh);
        ((MeshSelection)hideMesh.getSelection()).setSourceMesh(modelEntity2);
        return hideMesh;
    }

    public ISelectionFilter getSelectionFilter(AbstractSelection abstractSelection) {
        final IGeomSequence iGeomSequence = ((View)this.getMe().getContainer()).getGeomSequence();
        return new GeometrySelectionFilter(iGeomSequence, q.a((int)0, (int)1, (int)iGeomSequence.getSDim())){

            @Override
            public boolean allowMesh(MeshSequence meshSequence) {
                return meshSequence != null && meshSequence.getGeom() == iGeomSequence;
            }
        };
    }

    public void createReset(HideMeshList<? extends HideMesh> hideMeshList, boolean bl2) {
        this.createResetCommon(hideMeshList, bl2);
        for (HideMesh hideMesh : this.getMe()) {
            HideMesh hideMesh2;
            if (hideMesh.isAutoGenerated()) continue;
            HideMesh hideMesh3 = hideMesh2 = hideMeshList.hasTag(hideMesh.tag()) ? (HideMesh)hideMeshList.get(hideMesh.tag()) : null;
            if (hideMesh2 == null) {
                hideMesh2 = hideMeshList.create(hideMesh.tag());
            }
            hideMesh.createReset(hideMesh2, bl2);
        }
    }

    @Override
    protected String a() {
        return FlLocale.getString((String)"Hidden_meshes");
    }

    @Override
    public T copy(String string, String string2) {
        String[] stringArray = string2.split("/");
        if (stringArray.length != 2) {
            throw new FlException("Found_no_feature_to_copy");
        }
        HideMesh hideMesh = this.getModel().view(stringArray[0]).hideMesh(stringArray[1]);
        HideMesh hideMesh2 = this.getMe().create(string);
        hideMesh.selectionMethod().createDuplicate(hideMesh2);
        return (T)hideMesh2;
    }

    public HideMesh duplicate(String string, String string2) {
        HideMesh hideMesh = (HideMesh)this.getMe().get(string2);
        HideMesh hideMesh2 = this.getMe().create(string);
        hideMesh.selectionMethod().createDuplicate(hideMesh2);
        return hideMesh2;
    }
}

