/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.method;

import com.comsol.model.applapi.IVariableData;
import com.comsol.model.applapi.SDimType;
import com.comsol.model.applapi.UnitConverter;
import com.comsol.model.coord.CoordinateUtil;
import com.comsol.model.dbimodel.CommonFeature;
import com.comsol.model.dbimodel.CopiedPrimitiveObject;
import com.comsol.model.dbimodel.CopyPasteInfo;
import com.comsol.model.dbimodel.Frame;
import com.comsol.model.dbimodel.FrameFeature;
import com.comsol.model.dbimodel.FrameType;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.MODEL_NODE_TYPES;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.ModelNode;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.SORDERS_TYPES;
import com.comsol.model.dbimodel.UnitSystem;
import com.comsol.model.dbimodel.physics.MultiphysicsCoupling;
import com.comsol.model.dbimodel.physics.Physics;
import com.comsol.model.dbimodel.physics.PhysicsField;
import com.comsol.model.dbmodel.FrameDb;
import com.comsol.model.method.FrameMethod;
import com.comsol.model.method.ModelEntityMethod;
import com.comsol.model.method.internal.IModelInternal;
import com.comsol.model.operations.ICoordsysOperation;
import com.comsol.model.properties.AbstractModelEntityGetSetHandler;
import com.comsol.model.properties.ModelEntityPropSet;
import com.comsol.model.savepoint.interfaces.IModelNode;
import com.comsol.model.util.LicenseRequirement;
import com.comsol.model.util.ModelEntityUtil;
import com.comsol.model.util.MultiphysicsUtil;
import com.comsol.model.util.PhysicsCompareUtil;
import com.comsol.model.util.UnitUtil;
import com.comsol.nativeutil.properties.BooleanProp;
import com.comsol.nativeutil.properties.IAnnotation;
import com.comsol.nativeutil.properties.PropAnnotationInfo;
import com.comsol.nativeutil.properties.Property;
import com.comsol.nativeutil.properties.bk;
import com.comsol.nativeutil.properties.br;
import com.comsol.nativeutil.properties.bx;
import com.comsol.nativeutil.properties.by;
import com.comsol.nativeutil.properties.dd;
import com.comsol.nativeutil.properties.de;
import com.comsol.nativeutil.properties.di;
import com.comsol.nativeutil.properties.dr;
import com.comsol.nativeutil.properties.ds;
import com.comsol.util.classes.UndoType;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.interfaces.IUnitConverter;
import com.comsol.util.license.LicenseType;
import com.comsol.util.methods.FlStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.xml.sax.helpers.AttributesImpl;

public class ModelNodeMethod
extends ModelEntityMethod {
    private static final Map<String, String> b = new LinkedHashMap<String, String>();

    static {
        b.put("baseSystem", "Unit_system");
        b.put("spatialCoord", "Spatial_frame_coordinates");
        b.put("materialCoord", "Material_frame_coordinates");
        b.put("geometryCoord", "Geometry_frame_coordinates");
        b.put("meshCoord", "Mesh_frame_coordinates");
        b.put("sorder", "Geometry_shape_order");
        b.put("curvedInterior", "Avoid_inverted_elements_by_curving_interior_domain_elements");
    }

    public ModelNodeMethod(PrimitiveModelEntity primitiveModelEntity) {
        super(primitiveModelEntity);
    }

    @Override
    public ModelNode getMe() {
        return (ModelNode)this.u();
    }

    @Override
    public String scope() {
        IModelNode iModelNode = this.getMe().getStoredParent();
        if (iModelNode == null) {
            return "root." + this.getMe().getIdentifier();
        }
        return String.valueOf(iModelNode.scope()) + "." + this.getMe().getIdentifier();
    }

    @Override
    public IModelNode deduceScope() {
        return this.getMe();
    }

    @Override
    public IUnitConverter getConverter() {
        IUnitConverter iUnitConverter = this.getMe().getStoredConverter();
        if (iUnitConverter == null) {
            iUnitConverter = new UnitConverter(this.getModel(), this.n());
            this.getMe().setConverter(iUnitConverter);
        }
        return iUnitConverter;
    }

    public GeomSequence getGeom() {
        Stream<? extends GeomSequence> stream = this.i();
        Optional<GeomSequence> optional = stream.filter(geomSequence -> geomSequence.isMainGeometry(true)).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    private Stream<? extends GeomSequence> i() {
        ModelNode modelNode = this.getMe();
        Stream<GeomSequence> stream = modelNode.isClipboardCopy() ? modelNode.getPasteInfo().entityStream(GeomSequence.class) : this.getModel().geom().stream();
        return stream.filter(geomSequence -> geomSequence.getStoredParent() == modelNode);
    }

    public String[] getAllGeom() {
        return (String[])this.i().map(geomSequence -> geomSequence.getTag()).toArray(String[]::new);
    }

    public void sorder(String string) {
        SORDERS_TYPES sORDERS_TYPES = SORDERS_TYPES.get(string);
        if (sORDERS_TYPES == null) {
            throw new FlException("Invalid_geometry_shape_order");
        }
        this.getMe().setSorder(sORDERS_TYPES);
    }

    public void baseSystem(String string) {
        this.getMe().setBaseSystem(string);
        this.updateBaseSystem();
    }

    public void updateBaseSystem() {
        this.getConverter().resetConversionFactors();
        this.getConverter().resetUnitVars();
        String[] stringArray = this.getAllGeom();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray[n3];
            this.getModel().geom(string).method().notifyUnitSystemChanged();
            ++n3;
        }
    }

    public void identifier(String string) {
        if (!FlStringUtil.checkValidTag((String)string)) {
            throw new FlException("X_is_not_a_valid_identifier#" + string);
        }
        if (MultiphysicsUtil.isReservedFirstScope(string)) {
            throw new FlException("The_identifier_X_is_reserved#" + string);
        }
        boolean bl2 = this.isInModel() && !string.equals(this.getMe().getIdentifier());
        this.getMe().setIdentifier(string);
        if (bl2) {
            IModelInternal iModelInternal = this.getModel();
            iModelInternal.getConverter().resetUnitVars();
            iModelInternal.getConverter().resetConversionFactors();
            for (ModelNode modelNode : iModelInternal.modelNode()) {
                modelNode.getConverter().resetUnitVars();
                modelNode.getConverter().resetConversionFactors();
            }
        }
    }

    public String getDefaultName() {
        switch (this.getMe().getModelType()) {
            case STANDARD: {
                return "Component[model]";
            }
            case EXTRA_DIMENSION: {
                return "Extra_dimension";
            }
            case MESH_PART: {
                return "Mesh_component";
            }
        }
        assert (false);
        return null;
    }

    @Override
    public LicenseRequirement[] getRequiredLicenses(boolean bl2) {
        Object object;
        int n2;
        int n3;
        LicenseRequirement[] licenseRequirementArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ModelNode modelNode = this.getMe();
        IModelInternal iModelInternal = this.getModel();
        for (PropFeature modelEntity : iModelInternal.func()) {
            if (modelNode != modelEntity.getParentModel()) continue;
            licenseRequirementArray = modelEntity.getRequiredLicenses(bl2);
            n3 = licenseRequirementArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = licenseRequirementArray[n2];
                arrayList.add(object);
                ++n2;
            }
        }
        for (Physics physics : iModelInternal.physics()) {
            if (modelNode != physics.getParentModel()) continue;
            licenseRequirementArray = physics.getRequiredLicenses(bl2);
            n3 = licenseRequirementArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = licenseRequirementArray[n2];
                arrayList.add(object);
                ++n2;
            }
        }
        for (GeomSequence geomSequence : iModelInternal.geom()) {
            if (modelNode != geomSequence.getParentModel()) continue;
            licenseRequirementArray = geomSequence.getRequiredLicenses(bl2);
            n3 = licenseRequirementArray.length;
            n2 = 0;
            while (n2 < n3) {
                object = licenseRequirementArray[n2];
                arrayList.add(object);
                ++n2;
            }
        }
        for (PropFeature propFeature : iModelInternal.coordSystem()) {
            if (modelNode != propFeature.getParentModel()) continue;
            object = (ICoordsysOperation)propFeature.getOperation();
            LicenseType[][] licenseTypeArray = object.getLicenseRequirements(bl2);
            int n4 = licenseTypeArray.length;
            n3 = 0;
            while (n3 < n4) {
                LicenseType[] licenseTypeArray2 = licenseTypeArray[n3];
                if (licenseTypeArray2.length > 0) {
                    arrayList.add(new LicenseRequirement(licenseTypeArray2, propFeature));
                }
                ++n3;
            }
        }
        for (MultiphysicsCoupling multiphysicsCoupling : iModelInternal.multiphysics()) {
            if (modelNode != multiphysicsCoupling.getParentModel()) continue;
            LicenseRequirement[] licenseRequirementArray2 = multiphysicsCoupling.getRequiredLicenses(bl2);
            n3 = licenseRequirementArray2.length;
            int n5 = 0;
            while (n5 < n3) {
                object = licenseRequirementArray2[n5];
                arrayList.add(object);
                ++n5;
            }
        }
        for (CommonFeature commonFeature : iModelInternal.common()) {
            if (modelNode != commonFeature.getParentModel()) continue;
            LicenseRequirement[] licenseRequirementArray3 = commonFeature.getRequiredLicenses(bl2);
            n3 = licenseRequirementArray3.length;
            int n6 = 0;
            while (n6 < n3) {
                object = licenseRequirementArray3[n6];
                arrayList.add(object);
                ++n6;
            }
        }
        return arrayList.toArray(new LicenseRequirement[arrayList.size()]);
    }

    @Override
    public ModelEntityPropSet createEntityPropSet() {
        Object object;
        ModelEntityPropSet modelEntityPropSet = new ModelEntityPropSet(this.getMe(), "settings", "General[component_settings]", true);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("useglobal", "Same_as_global_system");
        for (UnitSystem unitSystem2 : UnitUtil.unitSystem()) {
            Object object2 = object = unitSystem2.label() == null ? unitSystem2.tag() : unitSystem2.label();
            if (!"none".equals(unitSystem2.tag())) {
                object = "#" + (String)object;
            }
            linkedHashMap.put(unitSystem2.tag(), (String)object);
        }
        for (UnitSystem unitSystem : this.getModel().unitSystem()) {
            linkedHashMap.put(unitSystem.tag(), "#" + (unitSystem.label() == null ? unitSystem.tag() : unitSystem.label()));
        }
        di di2 = new di(((HashMap)linkedHashMap).keySet().toArray(new String[linkedHashMap.size()]), ((HashMap)linkedHashMap).values().toArray(new String[linkedHashMap.size()]));
        Iterator iterator = new ds("basesystem", b.get("baseSystem"), "useglobal", (dd)di2);
        iterator.annotate().bc();
        modelEntityPropSet.registerEntityProp((Property)iterator, "baseSystem", (by)new b(this.getMe(), (Property)iterator));
        if (this.getGeom() != null) {
            String[][] stringArray;
            if (this.getMe().getModelType() == MODEL_NODE_TYPES.STANDARD) {
                iterator = new BooleanProp("defineAllFrames", "Always_define_all_frames", this.getMe().isDefineAllFrames());
                object = this.getMe();
                iterator.addSideEffect((br)new bk((ModelNode)object){
                    private final /* synthetic */ ModelNode b;
                    {
                        this.b = modelNode;
                    }

                    public void activate(Property property) {
                    }

                    public UndoType getUndoType(bx bx2) {
                        return UndoType.a;
                    }

                    public String getActionName(bx bx2) {
                        return "Permanently_define_all_frames";
                    }

                    public void action(bx bx2) {
                        this.b.defineAllFrames(true);
                    }
                });
                iterator.annotate().a(IAnnotation.WidgetType.P);
                iterator.annotate().b("Frames");
                stringArray = new de("frames", "hidden_frame_settings_card");
                stringArray.registerProp((Property)iterator);
                stringArray.annotate().a(new PropAnnotationInfo.aq(){

                    public boolean isVisible(de de2) {
                        return !ModelNodeMethod.this.getMe().defineAllFrames();
                    }
                });
                modelEntityPropSet.registerEntityProp((Property)stringArray, "defineAllFrames", "defineAllFrames", "defineAllFrames");
            }
            object = new a(this.getMe(), FrameType.spatial);
            stringArray = ((a)object).getStringMatrix();
            String string = b.get("spatialCoord");
            iterator = new dr("coords", string, stringArray);
            PropAnnotationInfo.TableInfo tableInfo = CoordinateUtil.getCoordNamesTableInfo(new String[]{stringArray[0][0], stringArray[0][1], stringArray[0][2]});
            tableInfo.g(string);
            iterator.annotate().a(tableInfo).b(string);
            iterator.annotate().Z().d("");
            modelEntityPropSet.registerEntityProp((Property)iterator, (String)null, (by)object);
            object = new a(this.getMe(), FrameType.material);
            stringArray = ((a)object).getStringMatrix();
            string = b.get("materialCoord");
            iterator = new dr("coords_mat", string, stringArray);
            tableInfo = CoordinateUtil.getCoordNamesTableInfo(new String[]{stringArray[0][0], stringArray[0][1], stringArray[0][2]});
            tableInfo.g(string);
            iterator.annotate().a(tableInfo).b(string);
            iterator.annotate().Z().d("");
            modelEntityPropSet.registerEntityProp((Property)iterator, (String)null, (by)object);
            object = new a(this.getMe(), FrameType.geometry);
            stringArray = ((a)object).getStringMatrix();
            string = b.get("geometryCoord");
            iterator = new dr("coords_geom", string, stringArray);
            tableInfo = CoordinateUtil.getCoordNamesTableInfo(new String[]{stringArray[0][0], stringArray[0][1], stringArray[0][2]});
            tableInfo.g(string);
            iterator.annotate().a(tableInfo).b(string);
            iterator.annotate().Z().d("");
            modelEntityPropSet.registerEntityProp((Property)iterator, (String)null, (by)object);
            object = new a(this.getMe(), FrameType.mesh);
            stringArray = ((a)object).getStringMatrix();
            string = b.get("meshCoord");
            iterator = new dr("coords_mesh", string, stringArray);
            tableInfo = CoordinateUtil.getCoordNamesTableInfo(new String[]{stringArray[0][0], stringArray[0][1], stringArray[0][2]});
            tableInfo.g(string);
            iterator.annotate().a(tableInfo).b(string);
            iterator.annotate().Z().d("");
            modelEntityPropSet.registerEntityProp((Property)iterator, (String)null, (by)object);
            ((HashMap)linkedHashMap).clear();
            for (SORDERS_TYPES sORDERS_TYPES : SORDERS_TYPES.VALUES) {
                linkedHashMap.put(sORDERS_TYPES.getLiteral(), sORDERS_TYPES.getDisplayName());
            }
            di di3 = new di(((HashMap)linkedHashMap).keySet().toArray(new String[linkedHashMap.size()]), ((HashMap)linkedHashMap).values().toArray(new String[linkedHashMap.size()]));
            iterator = new ds("sorderprop", b.get("sorder"), this.getMe().sorder(), (dd)di3);
            iterator.annotate().bc();
            modelEntityPropSet.registerEntityProp((Property)iterator, "sorder", "sorder");
            iterator = new BooleanProp("curvedinterior", b.get("curvedInterior"), true);
            GeomSequence geomSequence = this.getGeom();
            if (geomSequence.getSDim() < 2) {
                iterator.annotate().r();
            }
            modelEntityPropSet.registerEntityProp((Property)iterator, "curvedInterior", "curvedInterior");
        }
        return modelEntityPropSet;
    }

    public void createReset(ModelNode modelNode, boolean bl2) {
        ModelNode modelNode2 = this.getMe();
        this.createResetCommon(modelNode, bl2);
        if (!bl2) {
            if (!modelNode2.getIdentifier().equals(modelNode.getIdentifier())) {
                modelNode.identifier(modelNode2.getIdentifier());
            }
            if (!this.model().equals(modelNode.model())) {
                modelNode.model(this.model());
            }
            this.a(modelNode, modelNode2, new int[1]);
        }
    }

    private void a(ModelNode modelNode, ModelNode modelNode2, int[] nArray) {
        switch (nArray[0]) {
            case 0: {
                nArray[0] = nArray[0] + 1;
                if (!FlStringUtil.equals((String)modelNode2.baseSystem().tag(), (String)modelNode.baseSystem().tag())) {
                    modelNode.baseSystem(modelNode2.baseSystem().tag());
                }
            }
            case 1: {
                nArray[0] = nArray[0] + 1;
                if (!FlStringUtil.equals((String)modelNode2.sorder(), (String)modelNode.sorder())) {
                    modelNode.sorder(modelNode2.sorder());
                }
            }
            case 2: {
                nArray[0] = nArray[0] + 1;
                if (modelNode2.defineLocalCoord() != modelNode.defineLocalCoord()) {
                    modelNode.defineLocalCoord(modelNode2.defineLocalCoord());
                }
            }
            case 3: {
                nArray[0] = nArray[0] + 1;
                if (modelNode2.defineAllFrames() != modelNode.defineAllFrames()) {
                    modelNode.setDefineAllFrames(modelNode2.defineAllFrames());
                }
            }
            case 4: {
                nArray[0] = nArray[0] + 1;
                if (!modelNode2.isDefaultSpatialCoord()) {
                    modelNode.spatialCoord(modelNode2.spatialCoord());
                }
            }
            case 5: {
                nArray[0] = nArray[0] + 1;
                if (!modelNode2.isDefaultMaterialCoord()) {
                    modelNode.materialCoord(modelNode2.materialCoord());
                }
            }
            case 6: {
                nArray[0] = nArray[0] + 1;
                if (!modelNode2.isDefaultGeometryCoord()) {
                    modelNode.geometryCoord(modelNode2.geometryCoord());
                }
            }
            case 7: {
                nArray[0] = nArray[0] + 1;
                if (!modelNode2.isDefaultMeshCoord()) {
                    modelNode.meshCoord(modelNode2.meshCoord());
                }
            }
            case 8: {
                nArray[0] = nArray[0] + 1;
                if (modelNode2.groupByType() != modelNode.groupByType()) {
                    modelNode.setGroupByType(modelNode2.groupByType());
                }
            }
            case 9: {
                nArray[0] = nArray[0] + 1;
                if (modelNode2.getModelType() == MODEL_NODE_TYPES.GLOBAL || modelNode2.getModelType() == MODEL_NODE_TYPES.MESH_PART || modelNode2.curvedInterior() == modelNode.curvedInterior()) break;
                modelNode.curvedInterior(modelNode2.curvedInterior());
            }
        }
        nArray[0] = Integer.MAX_VALUE;
    }

    public ModelNode copyToModel(Model model) {
        return null;
    }

    public void disposeThis() {
    }

    @Override
    protected String a(String string, String string2) {
        return String.valueOf(string) + ".create(\"" + this.getMe().tag() + "\");";
    }

    @Override
    public void changeTag(String string, String string2) {
        this.getMe().setIdentifier(string2);
        super.changeTag(string, string2);
    }

    public void defineAllFrames(boolean bl2) {
        if (!bl2) {
            throw new FlException("Once_all_frames_are_defined_they_cannot_be_removed_instead_set_attribute_when_creating_the_component");
        }
        if (bl2 != this.getMe().isDefineAllFrames()) {
            this.getMe().setDefineAllFrames(bl2);
            this.updateFrames();
        }
    }

    public void updateFrames() {
        if (this.getMe().isDefineAllFrames()) {
            this.l();
        } else {
            this.m();
        }
    }

    private String[] a(FrameType frameType) {
        GeomSequence geomSequence = this.getGeom();
        if (geomSequence == null || this.getMe().getModelType() != MODEL_NODE_TYPES.STANDARD && this.getMe().getModelType() != MODEL_NODE_TYPES.EXTRA_DIMENSION) {
            return null;
        }
        Frame frame = geomSequence.getFrame(frameType.name());
        if (frame == null || ((FrameDb)frame).isRenameCoordinates()) {
            return null;
        }
        String[] stringArray = null;
        if (frame.isSpatialFrame()) {
            if (frameType == FrameType.spatial) {
                stringArray = ((FrameDb)frame).getCoord();
            }
        } else if (frame.isMaterialFrame()) {
            if (frameType == FrameType.material) {
                stringArray = ((FrameDb)frame).getCoord();
            }
        } else if (frame.isGeometryFrame()) {
            if (frameType == FrameType.geometry) {
                stringArray = ((FrameDb)frame).getCoord();
            }
        } else if (frame.isMeshFrame() && frameType == FrameType.mesh) {
            stringArray = ((FrameDb)frame).getCoord();
        }
        if (stringArray == null || stringArray.length != 3) {
            return null;
        }
        return stringArray;
    }

    public String[] doCoord(FrameType frameType) {
        Object object;
        String[] stringArray = this.b(frameType);
        if ((stringArray == null || stringArray.length == 0) && this.c(frameType)) {
            String[] stringArray2;
            FrameType frameType2;
            object = new ArrayList<FrameType>(Arrays.asList(FrameType.values()));
            Collections.reverse(object);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                frameType2 = (FrameType)((Object)iterator.next());
                stringArray2 = this.b(frameType2);
                if (stringArray2 != null && stringArray2.length != 0 || !this.c(frameType2) || (stringArray2 = this.a(frameType2)) == null || !this.a(stringArray2, false, true, frameType2) || FlStringUtil.equals((String[])stringArray2, (String[])this.b(frameType2, true))) continue;
                this.a(frameType2, stringArray2);
                this.a(frameType2, false);
            }
            iterator = object.iterator();
            while (iterator.hasNext()) {
                frameType2 = (FrameType)((Object)iterator.next());
                stringArray2 = this.b(frameType2);
                if (stringArray2 != null && stringArray2.length != 0 || !this.c(frameType2) || (stringArray2 = this.b(frameType2, true)) == null || !this.a(stringArray2, false, true, frameType2)) continue;
                this.a(frameType2, stringArray2);
            }
            stringArray = this.b(frameType);
        }
        if (stringArray == null) {
            return new String[0];
        }
        object = new String[stringArray.length];
        System.arraycopy(stringArray, 0, object, 0, stringArray.length);
        return object;
    }

    public void doCoord(FrameType frameType, String[] stringArray) {
        String[] stringArray2 = this.b(frameType);
        if (!FlStringUtil.equals((String[])stringArray, (String[])stringArray2)) {
            this.a(stringArray, true, false, frameType);
            this.a(frameType, stringArray);
            this.a(frameType, false);
            this.r();
        }
    }

    private String[] b(FrameType frameType) {
        switch (frameType) {
            case spatial: {
                return this.getMe().getSpatialCoord();
            }
            case material: {
                return this.getMe().getMaterialCoord();
            }
            case geometry: {
                return this.getMe().getGeometryCoord();
            }
            case mesh: {
                return this.getMe().getMeshCoord();
            }
        }
        return null;
    }

    private void a(FrameType frameType, String[] stringArray) {
        switch (frameType) {
            case spatial: {
                this.getMe().setSpatialCoord(stringArray);
                break;
            }
            case material: {
                this.getMe().setMaterialCoord(stringArray);
                break;
            }
            case geometry: {
                this.getMe().setGeometryCoord(stringArray);
                break;
            }
            case mesh: {
                this.getMe().setMeshCoord(stringArray);
            }
        }
    }

    private boolean c(FrameType frameType) {
        switch (frameType) {
            case spatial: {
                return this.getMe().isDefaultSpatialCoord();
            }
            case material: {
                return this.getMe().isDefaultMaterialCoord();
            }
            case geometry: {
                return this.getMe().isDefaultGeometryCoord();
            }
            case mesh: {
                return this.getMe().isDefaultMeshCoord();
            }
        }
        return false;
    }

    private void a(FrameType frameType, boolean bl2) {
        switch (frameType) {
            case spatial: {
                this.getMe().setDefaultSpatialCoord(bl2);
                break;
            }
            case material: {
                this.getMe().setDefaultMaterialCoord(bl2);
                break;
            }
            case geometry: {
                this.getMe().setDefaultGeometryCoord(bl2);
                break;
            }
            case mesh: {
                this.getMe().setDefaultMeshCoord(bl2);
            }
        }
    }

    private boolean a(String[] stringArray, boolean bl2, boolean bl3, FrameType frameType) {
        Object object;
        if (stringArray == null || stringArray.length != 3) {
            if (bl3) {
                return false;
            }
            throw new FlException("Wrong_number_of_coordinates");
        }
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = stringArray2[n3];
            if (!FlStringUtil.isVariableName((String)object) || ((String)object).contains(".")) {
                if (bl3) {
                    return false;
                }
                throw new FlException("X_is_not_a_valid_coordinate_name#" + (String)object);
            }
            ++n3;
        }
        object = this.getGeom();
        String[] stringArray3 = stringArray;
        if (object != null) {
            SDimType sDimType = SDimType.settingsToType(object.getSDim(), object.isAxisymmetric());
            stringArray3 = sDimType.makeNSDimVector(stringArray);
        }
        String[] stringArray4 = stringArray3;
        int n4 = stringArray3.length;
        int n5 = 0;
        while (n5 < n4) {
            String string = stringArray4[n5];
            if (!this.a(string)) {
                String string2 = "The_coordinate_name_must_not_be_equal_to_a_dependent_variable";
                if (bl3) {
                    return false;
                }
                throw new FlException(string2);
            }
            ++n5;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        FrameType[] frameTypeArray = FrameType.values();
        int n6 = frameTypeArray.length;
        n4 = 0;
        while (n4 < n6) {
            String[] stringArray5;
            FrameType frameType2 = frameTypeArray[n4];
            if (frameType2 != frameType && (stringArray5 = this.b(frameType2)) != null) {
                String[] stringArray6 = stringArray5;
                int n7 = stringArray5.length;
                int n8 = 0;
                while (n8 < n7) {
                    String string = stringArray6[n8];
                    arrayList.add(string);
                    ++n8;
                }
            }
            ++n4;
        }
        for (String string : arrayList) {
            if (!FlStringUtil.contains((String[])stringArray, (String)string)) continue;
            if (bl2) {
                throw new FlException("Duplicate_variable_name_X#" + string);
            }
            return false;
        }
        return true;
    }

    private boolean a(String string) {
        ModelNode modelNode = this.getMe();
        for (Physics physics : this.getModel().physics()) {
            if (physics.getParentModel() != modelNode) continue;
            for (PhysicsField physicsField : physics.field()) {
                String[] stringArray = physicsField.getComponents();
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string2 = stringArray[n3];
                    if (string2.equals(string)) {
                        return false;
                    }
                    ++n3;
                }
            }
        }
        return true;
    }

    public void updateDefaultCoordNames(boolean bl2, boolean bl3) {
        FrameType[] frameTypeArray = FrameType.values();
        int n2 = frameTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FrameType frameType = frameTypeArray[n3];
            if (this.c(frameType)) {
                this.a(frameType, this.b(frameType, bl3));
            }
            ++n3;
        }
        if (bl2) {
            this.r();
        }
    }

    private boolean k() {
        return this.getGeom() != null && this.getGeom().isAxisymmetric();
    }

    private String[] b(FrameType frameType, boolean bl2) {
        String string;
        String[] stringArray;
        if (this.k()) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "r";
            stringArray2[1] = "phi";
            stringArray = stringArray2;
            stringArray2[2] = "z";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "x";
            stringArray3[1] = "y";
            stringArray = stringArray3;
            stringArray3[2] = "z";
        }
        String[] stringArray4 = stringArray;
        if (frameType != FrameType.spatial) {
            string = "";
            if (frameType == FrameType.geometry) {
                string = "g";
            } else if (frameType == FrameType.mesh) {
                string = "m";
            }
            int n2 = 0;
            while (n2 < stringArray4.length) {
                stringArray4[n2] = String.valueOf(stringArray4[n2].toUpperCase(Locale.ENGLISH)) + string;
                ++n2;
            }
        }
        if (this.getMe().getModelType() == MODEL_NODE_TYPES.EXTRA_DIMENSION) {
            string = this.n().startsWith("xdim") ? this.n().substring(4) : "_" + this.n();
            stringArray4 = FlStringUtil.append((String)string, (String[])stringArray4);
        }
        if (this.a(stringArray4, false, bl2, frameType)) {
            return stringArray4;
        }
        int n3 = 1;
        String[] stringArray5;
        while (!this.a(stringArray5 = FlStringUtil.append((String)String.valueOf(n3), (String[])stringArray4), false, bl2, frameType)) {
            ++n3;
        }
        return stringArray5;
    }

    private void l() {
        Object object;
        Object object2;
        Frame frame;
        Object object3;
        GeomSequence geomSequence = this.getGeom();
        if (geomSequence == null) {
            return;
        }
        IModelInternal iModelInternal = this.getModel();
        Frame frame2 = geomSequence.getMaterialFrame();
        ModelEntity modelEntity = geomSequence.getDerivedFrom();
        boolean bl2 = geomSequence.hasFlag(ModelEntity.Flags.AUTOGENERATED);
        if (frame2.tag().equals(geomSequence.getSpatialFrame().tag())) {
            object3 = iModelInternal.frame().uniquetag(FrameType.spatial.name());
            frame = iModelInternal.frame().create((String)object3, geomSequence.tag());
            if (modelEntity != null) {
                frame.setDerivedFrom(modelEntity);
            }
            if (bl2) {
                frame.addFlag(ModelEntity.Flags.AUTOGENERATED);
            }
            frame.spatialFrame();
            object2 = frame.sshape().uniquetag("fixed");
            object = frame.sshape().create((String)object2, "fixed_ref");
            object.refframe(frame2.tag());
            object.selection().geom(geomSequence.tag());
        }
        if (frame2.tag().equals(geomSequence.getGeometryFrame().tag())) {
            object3 = iModelInternal.frame().uniquetag(FrameType.geometry.name());
            frame = iModelInternal.frame().create((String)object3, geomSequence.tag());
            if (modelEntity != null) {
                frame.setDerivedFrom(modelEntity);
            }
            if (bl2) {
                frame.addFlag(ModelEntity.Flags.AUTOGENERATED);
            }
            frame.geometryFrame();
            frame.meshFrame();
            object2 = frame2.sshape().uniquetag("fixed");
            object = frame2.sshape().create((String)object2, "fixed_ref");
            object.refframe(frame.tag());
            object.selection().geom(geomSequence.tag());
        }
        if (geomSequence.getGeometryFrame().tag().equals(geomSequence.getMeshFrame().tag())) {
            object3 = iModelInternal.frame().uniquetag(FrameType.mesh.name());
            frame = iModelInternal.frame().create((String)object3, geomSequence.tag());
            if (modelEntity != null) {
                frame.setDerivedFrom(modelEntity);
            }
            if (bl2) {
                frame.addFlag(ModelEntity.Flags.AUTOGENERATED);
            }
            frame.meshFrame();
            object2 = geomSequence.getGeometryFrame();
            object = object2.sshape().uniquetag("fixed");
            FrameFeature frameFeature = object2.sshape().create((String)object, "fixed_ref");
            frameFeature.refframe(frame.tag());
            frameFeature.selection().geom(geomSequence.tag());
        }
        object = FrameType.values();
        int n2 = ((FrameType[])object).length;
        int n3 = 0;
        while (n3 < n2) {
            object3 = object[n3];
            if (object3 != FrameType.material) {
                geomSequence.getFrame(((Enum)object3).name()).setRemovableFrame(false);
            }
            ++n3;
        }
        this.r();
    }

    private void m() {
        Frame frame;
        GeomSequence geomSequence = this.getGeom();
        if (geomSequence == null) {
            return;
        }
        IModelInternal iModelInternal = this.getModel();
        Frame frame2 = geomSequence.getMaterialFrame();
        if (!frame2.tag().equals(geomSequence.getSpatialFrame().tag())) {
            frame = geomSequence.getSpatialFrame();
            frame.setRemovableFrame(true);
            if (frame.getPhysics().isEmpty()) {
                try {
                    frame2.spatialFrame();
                }
                finally {
                    iModelInternal.frame().remove(frame.tag());
                }
            }
        }
        if (!geomSequence.getGeometryFrame().tag().equals(geomSequence.getMeshFrame().tag())) {
            frame = geomSequence.getMeshFrame();
            Frame frame3 = geomSequence.getGeometryFrame();
            frame.setRemovableFrame(true);
            if (frame.getPhysics().isEmpty()) {
                try {
                    frame3.meshFrame();
                }
                finally {
                    iModelInternal.frame().remove(frame.tag());
                    frame3.sshape().clear();
                }
            }
        }
        if (!frame2.tag().equals(geomSequence.getGeometryFrame().tag())) {
            frame = geomSequence.getGeometryFrame();
            frame.setRemovableFrame(true);
            if (frame.getPhysics().isEmpty()) {
                try {
                    frame2.geometryFrame();
                    frame2.meshFrame();
                }
                finally {
                    iModelInternal.frame().remove(frame.tag());
                    frame2.sshape().clear();
                }
            }
        }
        this.r();
    }

    private void r() {
        this.getConverter().resetUnitVars();
        if (!this.getModel().isDisableUpdates() && this.getGeom() != null) {
            ArrayList<Physics> arrayList = new ArrayList<Physics>();
            String string = this.getGeom().tag();
            for (Physics object2 : this.getModel().physics()) {
                if (object2.geom() == null || !object2.geom().equals(string)) continue;
                arrayList.add(object2);
            }
            IVariableData iVariableData = this.getModel().physics().getVarData();
            iVariableData.updateVariables(null, this.getGeom(), null, false, true, false, true);
            for (Object object3 : arrayList) {
                object3.getApp().updateDefaultsAndValidValues();
                iVariableData.updateVariables(null, (ModelEntity)object3, null, false, true, false, true);
            }
        }
    }

    public void postLoadInitialize() {
        GeomSequence geomSequence = this.getGeom();
        if (geomSequence != null && (this.getMe().getModelType() == MODEL_NODE_TYPES.STANDARD || this.getMe().getModelType() == MODEL_NODE_TYPES.EXTRA_DIMENSION)) {
            Frame frame;
            FrameType frameType;
            FrameType[] frameTypeArray = FrameType.values();
            int n2 = frameTypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                frameType = frameTypeArray[n3];
                frame = geomSequence.getFrame(frameType.name());
                if (frame != null && ((FrameMethod)frame.method()).getStoredCoordNames() == null) {
                    return;
                }
                ++n3;
            }
            frameTypeArray = FrameType.values();
            n2 = frameTypeArray.length;
            n3 = 0;
            while (n3 < n2) {
                frameType = frameTypeArray[n3];
                if (this.c(frameType)) {
                    this.a(frameType, null);
                }
                ++n3;
            }
            frameTypeArray = FrameType.values();
            n2 = frameTypeArray.length;
            n3 = 0;
            while (n3 < n2) {
                String[] stringArray;
                frameType = frameTypeArray[n3];
                frame = geomSequence.getFrame(frameType.name());
                if (frame != null && (stringArray = ((FrameMethod)frame.method()).getStoredCoordNames()) != null && stringArray.length == 3) {
                    FrameType frameType2 = null;
                    if (frame.isSpatialFrame()) {
                        frameType2 = FrameType.spatial;
                    } else if (frame.isMaterialFrame()) {
                        frameType2 = FrameType.material;
                    } else if (frame.isGeometryFrame()) {
                        frameType2 = FrameType.geometry;
                    } else if (frame.isMeshFrame()) {
                        frameType2 = FrameType.mesh;
                    }
                    if (frameType2 != null && !FlStringUtil.equals((String[])stringArray, (String[])this.b(frameType2, true))) {
                        this.a(frameType2, stringArray);
                        this.a(frameType2, false);
                    }
                }
                ++n3;
            }
            this.updateDefaultCoordNames(false, true);
        }
    }

    @Override
    public void createDuplicate(ModelEntity modelEntity) {
        super.createDuplicate(modelEntity);
        ModelNode modelNode = (ModelNode)modelEntity;
        ModelNode modelNode2 = this.getMe();
        int[] nArray = new int[]{-1};
        while (nArray[0] < 11) {
            try {
                if (nArray[0] < 0) {
                    nArray[0] = nArray[0] + 1;
                    if (!modelNode2.tag().equals(modelNode2.getIdentifier()) && !modelNode2.getIdentifier().equals(modelNode.getIdentifier())) {
                        modelNode.identifier(modelNode2.getIdentifier());
                    }
                }
                this.a((ModelNode)modelEntity, modelNode2, nArray);
            }
            catch (FlException flException) {}
        }
    }

    @Override
    public void collectObjectsToCopy(Collection<PrimitiveModelEntity> collection, CopyPasteInfo copyPasteInfo) {
        super.collectObjectsToCopy(collection, copyPasteInfo);
        for (Stream<? extends ModelEntity> stream : ModelEntityUtil.getCopiedComponentLists(this.getMe(), false)) {
            stream.forEach(modelEntity -> this.a(collection, copyPasteInfo, (ModelEntity)modelEntity));
        }
    }

    private void a(Collection<PrimitiveModelEntity> collection, CopyPasteInfo copyPasteInfo, ModelEntity modelEntity) {
        if (modelEntity.getDerivedFrom() != null) {
            throw new IllegalArgumentException("Cannot include derived entities in a copy operation");
        }
        if (!collection.contains(modelEntity)) {
            String string = ModelEntityUtil.getEntityPath(modelEntity);
            CopiedPrimitiveObject copiedPrimitiveObject = copyPasteInfo.addReference(string);
            copyPasteInfo.addCopiedObject(collection, modelEntity, copiedPrimitiveObject, true);
            modelEntity.collectObjectsToCopy(collection, copyPasteInfo);
            String string2 = ModelEntityUtil.getEntityPath(this.getMe());
            CopiedPrimitiveObject copiedPrimitiveObject2 = copyPasteInfo.getReferencedObject(string2);
            if (copiedPrimitiveObject2 != null && copiedPrimitiveObject2.getPasteBeforeIndex() >= 0) {
                copiedPrimitiveObject.setPasteBeforeIndex(copiedPrimitiveObject2.getPasteBeforeIndex());
            }
            ModelEntityUtil.collectGlobalParameters(modelEntity, collection, copyPasteInfo);
        }
    }

    @Override
    protected boolean a(ModelEntity modelEntity, AttributesImpl attributesImpl, AttributesImpl attributesImpl2, AttributesImpl attributesImpl3) {
        boolean bl2 = super.a(modelEntity, attributesImpl, attributesImpl2, attributesImpl3);
        ModelNode modelNode = this.getMe();
        if (this.e(modelEntity)) {
            return bl2;
        }
        ModelNode modelNode2 = (ModelNode)modelEntity;
        bl2 |= this.a("baseSystem", modelNode.baseSystem().tag(), modelNode2.baseSystem().tag(), attributesImpl, attributesImpl2, attributesImpl3);
        bl2 |= this.a("spatialCoord", modelNode.spatialCoord(), modelNode2.spatialCoord(), attributesImpl, attributesImpl2, attributesImpl3);
        bl2 |= this.a("materialCoord", modelNode.materialCoord(), modelNode2.materialCoord(), attributesImpl, attributesImpl2, attributesImpl3);
        bl2 |= this.a("geometryCoord", modelNode.geometryCoord(), modelNode2.geometryCoord(), attributesImpl, attributesImpl2, attributesImpl3);
        bl2 |= this.a("meshCoord", modelNode.meshCoord(), modelNode2.meshCoord(), attributesImpl, attributesImpl2, attributesImpl3);
        bl2 |= this.a("sorder", modelNode.sorder(), modelNode2.sorder(), attributesImpl, attributesImpl2, attributesImpl3);
        PhysicsCompareUtil.addOrAppendStringMap(attributesImpl, b);
        return bl2 |= this.a("curvedInterior", modelNode.curvedInterior(), modelNode2.curvedInterior(), attributesImpl, attributesImpl2, attributesImpl3);
    }

    static class a
    extends AbstractModelEntityGetSetHandler {
        private final ModelNode a;
        private final FrameType b;

        public a(ModelNode modelNode, FrameType frameType) {
            super(modelNode);
            this.a = modelNode;
            this.b = frameType;
        }

        @Override
        public String[][] getStringMatrix() {
            return new String[][]{((ModelNodeMethod)this.a.method()).doCoord(this.b)};
        }

        @Override
        public void setIndex(String string, int n2, int n3) {
            String[] stringArray = ((ModelNodeMethod)this.a.method()).doCoord(this.b);
            stringArray[n3] = string;
            switch (this.b) {
                case spatial: {
                    this.a.spatialCoord(stringArray);
                    break;
                }
                case material: {
                    this.a.materialCoord(stringArray);
                    break;
                }
                case geometry: {
                    this.a.geometryCoord(stringArray);
                    break;
                }
                case mesh: {
                    this.a.meshCoord(stringArray);
                }
            }
        }
    }

    static class b
    extends AbstractModelEntityGetSetHandler {
        Property a;
        ModelNode b;

        public b(ModelNode modelNode, Property property) {
            super(modelNode);
            this.a = property;
            this.b = modelNode;
        }

        @Override
        public void set(String string) {
            if (string.equals("useglobal")) {
                this.b.baseSystem(null);
            } else {
                this.b.baseSystem(string);
            }
        }

        @Override
        public String getString() {
            String string = this.b.getBaseSystem();
            if (string == null) {
                string = "useglobal";
            }
            this.a.set(string);
            return string;
        }
    }
}

