/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.method;

import com.comsol.model.applapi.IVariableData;
import com.comsol.model.applapi.PhysicalQuantityID;
import com.comsol.model.applapi.PhysicalQuantityManager;
import com.comsol.model.applapi.SimpleSelection;
import com.comsol.model.applapi.VariableInfo;
import com.comsol.model.dbimodel.CopiedPrimitiveObject;
import com.comsol.model.dbimodel.CopyPasteInfo;
import com.comsol.model.dbimodel.EVAL;
import com.comsol.model.dbimodel.FrameType;
import com.comsol.model.dbimodel.GeomObjectSelectionFeature;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.LocalSelection;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.Pair;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.SelectionFeature;
import com.comsol.model.dbimodel.StudyFeature;
import com.comsol.model.method.ModelEntityMethod;
import com.comsol.model.method.internal.IAbstractSelectionInternal;
import com.comsol.model.method.internal.ILocalSelectionInternal;
import com.comsol.model.method.internal.IModelInternal;
import com.comsol.model.method.internal.IPairInternal;
import com.comsol.model.properties.FrameCheck;
import com.comsol.model.properties.ModelEntityPropSet;
import com.comsol.model.properties.StringEntityGetSetHandler;
import com.comsol.model.savepoint.interfaces.IGeomSequence;
import com.comsol.model.savepoint.interfaces.IModelNode;
import com.comsol.model.selections.GeometrySelectionFilter;
import com.comsol.model.selections.ISelectionFilter;
import com.comsol.model.util.LicenseRequirement;
import com.comsol.model.util.ModelEntityUtil;
import com.comsol.model.util.MultiphysicsException;
import com.comsol.model.util.MultiphysicsUtil;
import com.comsol.model.util.PhysicsCompareUtil;
import com.comsol.nativeutil.ComparisonResult;
import com.comsol.nativeutil.parser.ParseUtil;
import com.comsol.nativeutil.properties.BooleanProp;
import com.comsol.nativeutil.properties.Property;
import com.comsol.nativeutil.properties.UnitCheck;
import com.comsol.nativeutil.properties.af;
import com.comsol.nativeutil.properties.ag;
import com.comsol.nativeutil.properties.ay;
import com.comsol.nativeutil.properties.by;
import com.comsol.nativeutil.properties.dd;
import com.comsol.nativeutil.properties.df;
import com.comsol.nativeutil.properties.di;
import com.comsol.nativeutil.properties.ds;
import com.comsol.nativeutil.properties.i;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.interfaces.IUnitConverter;
import com.comsol.util.interfaces.w;
import com.comsol.util.methods.FlLocale;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.l;
import com.comsol.util.methods.o;
import com.comsol.util.methods.q;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class PairMethod
extends ModelEntityMethod {
    private static final Map<String, String> b = new LinkedHashMap<String, String>();
    private boolean c = false;

    static {
        b.put("type", "Pair_type");
        b.put("pairName", "Pair_name");
        b.put("srcFrame", "Source_frame");
        b.put("dstFrame", "Destination_frame");
        b.put("mapping", "Mapping_method");
        b.put("searchMethod", "Search_method");
        b.put("manualDist", "Manual_control_of_search_distance");
        b.put("searchDist", "Distance");
        b.put("manualSelection", "Manual_control_of_selections_and_pair_type");
        b.put("searchTol", "Extrapolation_tolerance");
    }

    public PairMethod(PrimitiveModelEntity primitiveModelEntity) {
        super(primitiveModelEntity);
    }

    @Override
    public IPairInternal getMe() {
        return (IPairInternal)this.u();
    }

    @Override
    public IModelNode deduceScope() {
        IGeomSequence iGeomSequence = this.getMe().source().getGeomSequence();
        return iGeomSequence != null ? iGeomSequence.getParentModel() : null;
    }

    public void updateSelections(boolean bl2) {
        if (!this.getMe().hasAutoSelection()) {
            return;
        }
        this.getMe().source().setLocked(false);
        this.getMe().destination().setLocked(false);
        if (!bl2) {
            Object object;
            GeomObjectSelectionFeature geomObjectSelectionFeature = this.getMe().getSourceAutoSelection();
            if (geomObjectSelectionFeature != null && geomObjectSelectionFeature.dimension().length > 0 && geomObjectSelectionFeature.objects().length > 0) {
                object = geomObjectSelectionFeature.mapEntitiesToFinalizedGeometry(false);
                this.getMe().source().set((int[])object);
            }
            if ((object = this.getMe().getDestAutoSelection()) != null && object.dimension().length > 0 && object.objects().length > 0) {
                int[] nArray = object.mapEntitiesToFinalizedGeometry(false);
                this.getMe().destination().set(nArray);
            }
            this.getMe().source().setLocked(true);
            this.getMe().destination().setLocked(true);
        }
    }

    public void type(String string) {
        if (!string.equals("Identity") && !string.equals("Contact")) {
            throw new FlException("Pair_type_must_be_Identity_or_Contact");
        }
        String string2 = FlLocale.getString((String)this.getMe().getDefaultName(), (boolean)true);
        boolean bl2 = this.getMe().label().startsWith(string2);
        this.getMe().setType(string);
        if (bl2) {
            string2 = this.getMe().getDefaultName();
            int n2 = ModelEntityUtil.getFeatureNumber(this.getMe());
            String string3 = FlLocale.getString((String)string2, (boolean)true);
            if (n2 > 0) {
                string3 = String.valueOf(string3) + " " + n2;
            }
            string3 = ModelEntityUtil.uniqueNameWithinList(this.getMe(), string3, n2);
            this.label(string3);
        }
    }

    public void swap() {
        LocalSelection localSelection = this.getMe().source();
        LocalSelection localSelection2 = this.getMe().destination();
        boolean bl2 = localSelection.isLocked();
        boolean bl3 = localSelection2.isLocked();
        try {
            localSelection.setLocked(false);
            localSelection2.setLocked(false);
            String string = localSelection.named();
            int n2 = localSelection.dimension()[0];
            int[] nArray = localSelection.entities(n2);
            String string2 = localSelection2.named();
            int[] nArray2 = localSelection2.entities(n2);
            if (string.length() == 0) {
                localSelection2.geom(n2);
                localSelection2.set(nArray);
            } else {
                localSelection2.named(string);
            }
            if (string2.length() == 0) {
                localSelection.geom(n2);
                localSelection.set(nArray2);
            } else {
                localSelection.named(string2);
            }
        }
        finally {
            localSelection.setLocked(bl2);
            localSelection2.setLocked(bl3);
        }
    }

    public String opName(boolean bl2) {
        String string = bl2 ? "src2dst" : "dst2src";
        return String.valueOf(string) + "_" + this.getMe().pairName();
    }

    public String gapName(boolean bl2) {
        assert (this.getMe().type().equals("Contact"));
        return "geomgap_" + (bl2 ? "dst_" : "src_") + this.getMe().pairName();
    }

    public String initGapName(boolean bl2) {
        assert (this.getMe().type().equals("Contact"));
        return "initgap_" + (bl2 ? "dst_" : "src_") + this.getMe().pairName();
    }

    public String getDefaultName() {
        if (this.getMe().type().equals("Identity")) {
            int n2;
            IGeomSequence iGeomSequence = this.getMe().source().getGeomSequence();
            int n3 = n2 = iGeomSequence != null ? iGeomSequence.getSDim() : 1;
            if (n2 == 1) {
                return "Identity_pair";
            }
            int n4 = this.getMe().source().dimension()[0];
            return "Identity_" + l.a((int)n2, (int)n4, (boolean)false).toLowerCase(Locale.ENGLISH) + "_pair";
        }
        return "Contact_pair";
    }

    @Override
    public String scope() {
        return String.valueOf(super.scope()) + "." + this.getMe().pairName();
    }

    public void checkPairName(String string) {
        if (!FlStringUtil.checkValidTag((String)string)) {
            FlException flException = new FlException("Invalid_identifier_name");
            flException.addParameterPair("Pair_name", string);
            throw flException;
        }
        if (!MultiphysicsUtil.checkIdentifier(string, this.getMe(), "Pair", new String[0])) {
            throw new FlException("Identifier_X_is_already_used_in_this_model#" + string);
        }
    }

    public static ISelectionFilter getSelectionFilter(final IGeomSequence iGeomSequence, final int n2) {
        GeometrySelectionFilter geometrySelectionFilter = new GeometrySelectionFilter(iGeomSequence, new int[]{n2}){

            @Override
            public ISelectionFilter.DomainStatusInfo getDomainStatus(int n22, boolean bl2) {
                IGeomSequence iGeomSequence2 = this.j();
                if (iGeomSequence2 instanceof GeomSequence && iGeomSequence2.getSDim() == 2 && iGeomSequence2.isAxisymmetric() && n22 == 1 && q.c((int[])this.getAllowedEDims(), (int)n22)) {
                    GeomSequence geomSequence = (GeomSequence)iGeomSequence2;
                    int n3 = iGeomSequence2.getNEntities()[n22];
                    ISelectionFilter.DomainStatusInfo domainStatusInfo = new ISelectionFilter.DomainStatusInfo(n3, n2, ISelectionFilter.DomainStatus.VALID);
                    double d2 = geomSequence.getGScale();
                    double d3 = geomSequence.getGTol();
                    double d4 = d3 * d2;
                    double[][] dArray = geomSequence.getVertexCoord();
                    boolean[] blArray = geomSequence.getEntityLinear(1);
                    int n4 = 1;
                    while (n4 <= n3) {
                        if (blArray[n4 - 1]) {
                            int[] nArray = geomSequence.getAdj(1, 0, n4);
                            boolean bl3 = true;
                            int[] nArray2 = nArray;
                            int n5 = nArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                int n7 = nArray2[n6];
                                if (Math.abs(dArray[0][n7 - 1]) > d4) {
                                    bl3 = false;
                                    break;
                                }
                                ++n6;
                            }
                            if (bl3) {
                                domainStatusInfo.setStatus(n4, ISelectionFilter.DomainStatus.NOTAPPLICABLE);
                            }
                        }
                        ++n4;
                    }
                    return domainStatusInfo;
                }
                return super.getDomainStatus(n22, bl2);
            }

            @Override
            public boolean domainFiltering() {
                return iGeomSequence instanceof GeomSequence && iGeomSequence.getSDim() == 2 && iGeomSequence.isAxisymmetric() && q.c((int[])this.getAllowedEDims(), (int)1);
            }
        };
        geometrySelectionFilter.setAllowEntireGeometry(false);
        geometrySelectionFilter.setAllowInheritance(false);
        geometrySelectionFilter.setAllowMeshInterior(false);
        return geometrySelectionFilter;
    }

    @Override
    public ModelEntityPropSet createEntityPropSet() {
        ds ds2;
        ds ds3;
        Object object;
        IModelInternal iModelInternal = this.getModel();
        String string = this.getMe().source().geom();
        GeomSequence geomSequence = iModelInternal.geom(string);
        boolean bl2 = this.getMe().source().dimension()[0] == geomSequence.getSDim() - 1;
        ModelEntityPropSet modelEntityPropSet = new ModelEntityPropSet(this.getMe(), "param", "pair_property");
        IUnitConverter iUnitConverter = geomSequence.getUnitConverter();
        modelEntityPropSet.setUnitConverter(iUnitConverter);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getMe().hasAutoSelection()) {
            object = new i("manualselection", b.get("manualSelection"), false);
            modelEntityPropSet.registerEntityProp((Property)object, "manualSelection", "manualSelection");
            arrayList.add(object.getName());
            ds3 = new ay("pairtype", b.get("type"), "Identity", new String[]{"Identity", "Contact"}, new String[]{"Identity_pair", "Contact_pair"});
            modelEntityPropSet.registerEntityProp((Property)ds3, "type", "type");
            object.registerProp("on", (Property)ds3);
        } else if (bl2) {
            object = new ay("pairtype", b.get("type"), "Identity", new String[]{"Identity", "Contact"}, new String[]{"Identity_pair", "Contact_pair"});
            modelEntityPropSet.registerEntityProp((Property)object, "type", "type");
            arrayList.add(object.getName());
        }
        modelEntityPropSet.registerPropertyGroup("general", "Pair_type", arrayList.toArray(new String[0]), false);
        arrayList.clear();
        if (iModelInternal.frame().nFrames(string) > 1) {
            object = FrameType.spatial.name();
            ds3 = new ds("srcframe", b.get("srcFrame"), (String)object, (dd)new FrameCheck(geomSequence));
            modelEntityPropSet.registerEntityProp((Property)ds3, "srcFrame", "srcFrame");
            arrayList.add(ds3.getName());
            ds2 = new ds("dstframe", b.get("dstFrame"), (String)object, (dd)new FrameCheck(geomSequence));
            modelEntityPropSet.registerEntityProp((Property)ds2, "dstFrame", "dstFrame");
            arrayList.add(ds2.getName());
            modelEntityPropSet.registerPropertyGroup("frame", "Frame", arrayList.toArray(new String[0]), true);
        }
        arrayList.clear();
        object = new di(new String[]{"fast", "direct"}, new String[]{"Fast", "Direct"});
        ds3 = new ds("searchmethod", b.get("searchMethod"), "fast", (dd)object);
        modelEntityPropSet.registerEntityProp((Property)ds3, "searchMethod", "searchMethod");
        arrayList.add(ds3.getName());
        object = new di(new String[]{"deformed", "initial"}, new String[]{"Deformed_configuration", "Initial_configuration"});
        ds2 = new ds("mapping", b.get("mapping"), "deformed", (dd)object);
        modelEntityPropSet.registerEntityProp((Property)ds2, "mapping", "mapping");
        arrayList.add(ds2.getName());
        i i2 = new i("manualdist", b.get("manualDist"), BooleanProp.OnOff.b.toString());
        boolean bl3 = false;
        try {
            o.a((String)this.getMe().searchDist());
            o.a((String)this.getMe().searchTol());
        }
        catch (FlException flException) {
            bl3 = true;
        }
        com.comsol.nativeutil.properties.o o2 = new com.comsol.nativeutil.properties.o(new dd[]{new af(0.0), new UnitCheck(PhysicalQuantityID.LENGTH.dimension(), iUnitConverter, (w)this.getMe())});
        a a2 = new a("searchdist", b.get("searchDist"), 0.01, (dd)o2, bl3);
        i2.registerProp("on", (Property)a2);
        modelEntityPropSet.registerEntityProp((Property)a2, "searchDist", (by)new StringEntityGetSetHandler(this.getMe(), (Property)a2, "searchDist", "searchDist"));
        modelEntityPropSet.registerEntityProp((Property)i2, "manualDist", "manualDist");
        arrayList.add(i2.getName());
        com.comsol.nativeutil.properties.o o3 = new com.comsol.nativeutil.properties.o(new dd[]{new af(0.0), new UnitCheck(iUnitConverter, (w)this.getMe()).setCheckRule(UnitCheck.CheckRule.b)});
        a a3 = new a("searchtol", b.get("searchTol"), 1.0E-4, (dd)o3, bl3);
        arrayList.add(a3.getName());
        modelEntityPropSet.registerEntityProp((Property)a3, "searchTol", (by)new StringEntityGetSetHandler(this.getMe(), (Property)a3, "searchTol", "searchTol"));
        modelEntityPropSet.registerPropertyGroup("advanced", "Advanced", arrayList.toArray(new String[0]), false);
        return modelEntityPropSet;
    }

    private static int[] a(LocalSelection localSelection) {
        if (localSelection.dimension().length == 0) {
            return new int[0];
        }
        int n2 = q.b((int[])localSelection.dimension());
        return localSelection.entities(n2);
    }

    public double evalSearchDist() {
        double d2;
        assert (this.getMe().type().equals("Contact"));
        GeomSequence geomSequence = this.getModel().geom(this.getMe().source().geom());
        if (this.getMe().manualDist()) {
            String string = this.getMe().searchDist();
            d2 = this.getModel().getParamDatabase().evaluateScalar(geomSequence, string).a();
        } else {
            double[] dArray = geomSequence.getBoundingBox();
            d2 = 0.0;
            int n2 = 0;
            while (n2 < dArray.length) {
                double d3 = dArray[n2 + 1] - dArray[n2];
                d2 += d3 * d3;
                n2 += 2;
            }
            d2 = Math.sqrt(d2) * 0.01;
        }
        return d2 * geomSequence.geomScaleFactor();
    }

    public double evalSearchTol() {
        assert (this.getMe().type().equals("Contact"));
        GeomSequence geomSequence = this.getModel().geom(this.getMe().source().geom());
        String string = this.getMe().searchTol();
        return this.getModel().getParamDatabase().evaluateScalar(geomSequence, string).a();
    }

    public void createReset(Pair pair, boolean bl2) {
        boolean bl3;
        this.createResetCommon(pair, bl2);
        if (this.getMe().hasAutoSelection() && this.getMe().manualSelection() != pair.manualSelection()) {
            pair.manualSelection(this.getMe().manualSelection());
        }
        boolean bl4 = bl3 = this.getMe().hasAutoSelection() && !this.getMe().manualSelection();
        if (!bl3) {
            ((ILocalSelectionInternal)this.getMe().source()).createReset(pair.source(), bl2);
            ((ILocalSelectionInternal)this.getMe().destination()).createReset(pair.destination(), bl2);
        } else {
            boolean bl5 = this.getMe().source().isLocked();
            boolean bl6 = this.getMe().destination().isLocked();
            this.getMe().source().setLocked(false);
            this.getMe().destination().setLocked(false);
            pair.getModel().hist().disable();
            try {
                ((ILocalSelectionInternal)this.getMe().source()).createReset(pair.source(), bl2);
                ((ILocalSelectionInternal)this.getMe().destination()).createReset(pair.destination(), bl2);
            }
            finally {
                pair.getModel().hist().enable();
                this.getMe().source().setLocked(bl5);
                this.getMe().destination().setLocked(bl6);
            }
        }
        if (!bl2) {
            if (!this.getMe().pairName().equals(pair.pairName())) {
                pair.pairName(this.getMe().pairName());
            }
            if (bl3) {
                int[] nArray;
                int[] nArray2 = PairMethod.a(this.getMe().source());
                int[] nArray3 = PairMethod.a(this.getMe().destination());
                int[] nArray4 = this.getMe().getSourceAutoSelection() != null ? this.getMe().getSourceAutoSelection().mapEntitiesToFinalizedGeometry(false) : new int[]{};
                int[] nArray5 = nArray = this.getMe().getDestAutoSelection() != null ? this.getMe().getDestAutoSelection().mapEntitiesToFinalizedGeometry(false) : new int[]{};
                if ((!Arrays.equals(nArray2, nArray4) || !Arrays.equals(nArray3, nArray)) && Arrays.equals(nArray2, nArray) && Arrays.equals(nArray3, nArray4)) {
                    pair.swap();
                }
            }
            if (this.getMe().type().equals("Identity")) {
                if (!this.getMe().srcFrame().equals(pair.srcFrame())) {
                    pair.srcFrame(this.getMe().srcFrame());
                }
                if (!this.getMe().dstFrame().equals(pair.dstFrame())) {
                    pair.dstFrame(this.getMe().dstFrame());
                }
            } else if (this.getMe().type().equals("Contact")) {
                if (!this.getMe().searchMethod().equals(pair.searchMethod())) {
                    pair.searchMethod(this.getMe().searchMethod());
                }
                if (!this.getMe().mapping().equals(pair.mapping())) {
                    pair.mapping(this.getMe().mapping());
                }
                if (this.getMe().manualDist() != pair.manualDist()) {
                    pair.manualDist(this.getMe().manualDist());
                }
                if (this.getMe().manualDist() && !this.getMe().searchDist().equals(pair.searchDist())) {
                    pair.searchDist(this.getMe().searchDist());
                }
                if (!this.getMe().searchTol().equals(pair.searchTol())) {
                    pair.searchTol(this.getMe().searchTol());
                }
            }
        }
    }

    @Override
    public void createDuplicate(ModelEntity modelEntity) {
        super.createDuplicate(modelEntity);
        Pair pair = (Pair)modelEntity;
        ((IAbstractSelectionInternal)((Object)this.getMe().destination())).createDuplicate(pair.destination());
        ((IAbstractSelectionInternal)((Object)this.getMe().source())).createDuplicate(pair.source());
        pair.dstFrame(this.getMe().dstFrame());
        pair.srcFrame(this.getMe().srcFrame());
        pair.mapping(this.getMe().mapping());
        pair.searchMethod(this.getMe().searchMethod());
        pair.manualDist(this.getMe().manualDist());
        pair.searchDist(this.getMe().searchDist());
        pair.searchTol(this.getMe().searchTol());
    }

    public boolean muteMultiphysics() {
        return this.c;
    }

    public LicenseRequirement[] multiphysics(StudyFeature studyFeature, EVAL eVAL) {
        block20: {
            if (this.isActive() && this.getMe().getDerivedFrom() == null) {
                try {
                    try {
                        this.c = true;
                        if (eVAL == EVAL.VARIABLES) {
                            Object object;
                            IPairInternal iPairInternal = this.getMe();
                            Model model = iPairInternal.getModel();
                            IVariableData iVariableData = model.physics().getVarData();
                            String string = iPairInternal.shortScopeDot();
                            String string2 = null;
                            SimpleSelection simpleSelection = new SimpleSelection(model);
                            VariableInfo variableInfo = this.a(iPairInternal);
                            if ("Contact".equals(iPairInternal.type())) {
                                string2 = iPairInternal.gapName(true);
                                if (string2 != null && string2.length() > 0) {
                                    iVariableData.addScalarVariable(ParseUtil.c((String)string2, (String)string), null, simpleSelection, variableInfo);
                                }
                                if ((string2 = iPairInternal.gapName(false)) != null && string2.length() > 0) {
                                    iVariableData.addScalarVariable(ParseUtil.c((String)string2, (String)string), null, simpleSelection, variableInfo);
                                }
                                if ((string2 = iPairInternal.initGapName(true)) != null && string2.length() > 0) {
                                    iVariableData.addScalarVariable(ParseUtil.c((String)string2, (String)string), null, simpleSelection, variableInfo);
                                }
                                if ((string2 = iPairInternal.initGapName(false)) != null && string2.length() > 0) {
                                    iVariableData.addScalarVariable(ParseUtil.c((String)string2, (String)string), null, simpleSelection, variableInfo);
                                }
                                if ((string2 = iPairInternal.mphOpName(true)) != null && string2.length() > 0) {
                                    object = ParseUtil.c((String)string2, (String)string);
                                    iVariableData.addFunction((String)object, this.getMe(), string);
                                    iVariableData.addScalarVariable((String)object, null, simpleSelection, variableInfo);
                                }
                                if ((string2 = iPairInternal.mphOpName(false)) != null && string2.length() > 0) {
                                    object = ParseUtil.c((String)string2, (String)string);
                                    iVariableData.addFunction((String)object, this.getMe(), string);
                                    iVariableData.addScalarVariable((String)object, null, simpleSelection, variableInfo);
                                }
                                if ((object = PhysicalQuantityManager.createMultiphysicsInstance(iPairInternal)) != null) {
                                    object.multiphysics(studyFeature, iPairInternal, eVAL);
                                }
                            }
                            if ((string2 = iPairInternal.opName(true)) != null && string2.length() > 0) {
                                object = ParseUtil.c((String)string2, (String)string);
                                iVariableData.addFunction((String)object, this.getMe(), string);
                                iVariableData.addScalarVariable((String)object, null, simpleSelection, variableInfo);
                            }
                            if ((string2 = iPairInternal.opName(false)) != null && string2.length() > 0) {
                                object = ParseUtil.c((String)string2, (String)string);
                                iVariableData.addFunction((String)object, this.getMe(), string);
                                iVariableData.addScalarVariable((String)object, null, simpleSelection, variableInfo);
                            }
                            if ((string2 = iPairInternal.inContactName()) != null && string2.length() > 0) {
                                object = ParseUtil.c((String)string2, (String)string);
                                VariableInfo variableInfo2 = VariableInfo.expression(iPairInternal).description(variableInfo.description()).group(variableInfo.group()).doPlot(variableInfo.doPlot()).add(true);
                                int n2 = iPairInternal.source().getGeomSequence().getSDim();
                                String string3 = iPairInternal.source().geom();
                                int n3 = iPairInternal.source().getDim();
                                while (n3 < n2) {
                                    SimpleSelection simpleSelection2 = new SimpleSelection(model, string3, n3).all();
                                    iVariableData.addScalarVariable((String)object, "0", simpleSelection2, variableInfo2);
                                    ++n3;
                                }
                                if ("Identity".equals(iPairInternal.type())) {
                                    variableInfo2.add(false);
                                    String string4 = ParseUtil.c((String)iPairInternal.opName(false), (String)string);
                                    iVariableData.addScalarVariable((String)object, string4, iPairInternal.source(), variableInfo2);
                                    string4 = ParseUtil.c((String)iPairInternal.opName(true), (String)string);
                                    iVariableData.addScalarVariable((String)object, string4, iPairInternal.destination(), variableInfo2);
                                }
                            }
                        }
                    }
                    catch (MultiphysicsException multiphysicsException) {
                        this.getModel().physics().getVarData().addException(multiphysicsException);
                        this.c = false;
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    this.c = false;
                    throw throwable;
                }
                this.c = false;
            }
        }
        return new LicenseRequirement[0];
    }

    protected VariableInfo a(Pair pair) {
        VariableInfo variableInfo = VariableInfo.xmesh(pair);
        variableInfo.description("").group("User_pairs");
        variableInfo.doPlot(false);
        return variableInfo;
    }

    public void handleEvent(String string, PrimitiveModelEntity primitiveModelEntity) {
        if (string.equals("ModelIdentifierChanged")) {
            String string2 = primitiveModelEntity.getTag();
            if (string2.equals(this.model())) {
                this.getModel().physics().getVarData().updateVariables(null, this.getMe(), null, false, true, false, true);
            }
        } else if (string.equals("PairIdentifierChanged")) {
            this.getModel().physics().getVarData().updateVariables(null, this.getMe(), null, false, true, false, true);
        } else if (string.equals("PairRemoved")) {
            this.getModel().physics().getVarData().updateVariables(null, this.getMe(), null, true, true, false, true);
        }
    }

    @Override
    public void collectObjectsToCopy(Collection<PrimitiveModelEntity> collection, CopyPasteInfo copyPasteInfo) {
        CopiedPrimitiveObject copiedPrimitiveObject;
        String string;
        String string2;
        SelectionFeature selectionFeature;
        super.collectObjectsToCopy(collection, copyPasteInfo);
        if (!this.getMe().source().named().isEmpty()) {
            selectionFeature = this.getMe().source().getNamedSelection();
            string2 = ModelEntityUtil.getEntityPath(selectionFeature);
            string = ModelEntityUtil.getEntityPath(this.getMe());
            copiedPrimitiveObject = copyPasteInfo.addReference(string2);
            copiedPrimitiveObject.set("dim", String.valueOf(selectionFeature.getDim()));
            copyPasteInfo.addReferenceSetting(String.valueOf(string) + ":source", string2);
        }
        if (!this.getMe().destination().named().isEmpty()) {
            selectionFeature = this.getMe().destination().getNamedSelection();
            string2 = ModelEntityUtil.getEntityPath(selectionFeature);
            string = ModelEntityUtil.getEntityPath(this.getMe());
            copiedPrimitiveObject = copyPasteInfo.addReference(string2);
            copiedPrimitiveObject.set("dim", String.valueOf(selectionFeature.getDim()));
            copyPasteInfo.addReferenceSetting(String.valueOf(string) + ":destination", string2);
        }
    }

    @Override
    public void handleReferencesInPaste(ModelEntity modelEntity, List<ModelEntity> list, CopyPasteInfo copyPasteInfo) {
        super.handleReferencesInPaste(modelEntity, list, copyPasteInfo);
        ((IAbstractSelectionInternal)((Object)((Pair)modelEntity).destination())).createDuplicate(this.getMe().destination());
        ((IAbstractSelectionInternal)((Object)((Pair)modelEntity).source())).createDuplicate(this.getMe().source());
    }

    @Override
    protected boolean a(ModelEntity modelEntity, AttributesImpl attributesImpl, AttributesImpl attributesImpl2, AttributesImpl attributesImpl3) {
        boolean bl2 = super.a(modelEntity, attributesImpl, attributesImpl2, attributesImpl3);
        IPairInternal iPairInternal = this.getMe();
        if (this.e(modelEntity)) {
            return bl2;
        }
        Pair pair = (Pair)modelEntity;
        bl2 |= this.a("type", iPairInternal.type(), pair.type(), attributesImpl, attributesImpl2, attributesImpl3);
        bl2 |= this.a("pairName", iPairInternal.pairName(), pair.pairName(), attributesImpl, attributesImpl2, attributesImpl3);
        bl2 |= this.a("srcFrame", iPairInternal.srcFrame(), pair.srcFrame(), attributesImpl, attributesImpl2, attributesImpl3);
        bl2 |= this.a("dstFrame", iPairInternal.dstFrame(), pair.dstFrame(), attributesImpl, attributesImpl2, attributesImpl3);
        bl2 |= this.a("mapping", iPairInternal.mapping(), pair.mapping(), attributesImpl, attributesImpl2, attributesImpl3);
        bl2 |= this.a("searchMethod", iPairInternal.searchMethod(), pair.searchMethod(), attributesImpl, attributesImpl2, attributesImpl3);
        bl2 |= this.a("manualDist", iPairInternal.manualDist(), pair.manualDist(), attributesImpl, attributesImpl2, attributesImpl3);
        bl2 |= this.a("searchDist", iPairInternal.searchDist(), pair.searchDist(), attributesImpl, attributesImpl2, attributesImpl3);
        bl2 |= this.a("hasAutoSelection", iPairInternal.hasAutoSelection(), pair.hasAutoSelection(), attributesImpl, attributesImpl2, attributesImpl3);
        bl2 |= this.a("manualSelection", iPairInternal.manualSelection(), pair.manualSelection(), attributesImpl, attributesImpl2, attributesImpl3);
        PhysicsCompareUtil.addOrAppendStringMap(attributesImpl, b);
        return bl2 |= this.a("searchTol", iPairInternal.searchTol(), pair.searchTol(), attributesImpl, attributesImpl2, attributesImpl3);
    }

    @Override
    protected boolean a(ModelEntity modelEntity, ComparisonResult comparisonResult) {
        boolean bl2 = super.a(modelEntity, comparisonResult);
        IPairInternal iPairInternal = this.getMe();
        if (this.e(modelEntity)) {
            return bl2;
        }
        Pair pair = (Pair)modelEntity;
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", "name", "CDATA", "source");
        AttributesImpl attributesImpl2 = new AttributesImpl();
        attributesImpl2.addAttribute("", "", "name", "CDATA", "source");
        if (iPairInternal.source().selectionMethod().compareAttributes(pair.source(), attributesImpl, attributesImpl2)) {
            attributesImpl.setValue(attributesImpl.getIndex("Description"), "Source");
            comparisonResult.startSection("Selection", (Attributes)attributesImpl);
            comparisonResult.startSection("Difference", (Attributes)attributesImpl2, true, false);
            comparisonResult.endSection();
            bl2 = true;
        }
        attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", "name", "CDATA", "destination");
        attributesImpl2 = new AttributesImpl();
        attributesImpl2.addAttribute("", "", "name", "CDATA", "destination");
        if (iPairInternal.destination().selectionMethod().compareAttributes(pair.destination(), attributesImpl, attributesImpl2)) {
            attributesImpl.setValue(attributesImpl.getIndex("Description"), "Destination");
            comparisonResult.startSection("Selection", (Attributes)attributesImpl);
            comparisonResult.startSection("Difference", (Attributes)attributesImpl2, true, false);
            comparisonResult.endSection();
            bl2 = true;
        }
        return bl2;
    }

    private static class a
    extends ag {
        public a(String string, String string2, double d2, dd dd2, boolean bl2) {
            super(string, string2, d2, dd2, bl2);
        }

        protected void a(df df2, String string, boolean bl2) throws FlException {
            super.a(df2, string, bl2);
            if (this.a(df2) == null && this.getContainingPropSet() != null) {
                this.a(df2, string);
            }
        }
    }
}

