/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.operations.cpl;

import com.comsol.model.operations.cpl.GeneralExtrusion;
import com.comsol.model.operations.cpl.GeneralProjection;
import com.comsol.model.operations.cpl.ICplOperation;
import com.comsol.model.operations.cpl.IdentityExtrusion;
import com.comsol.model.operations.cpl.LinearExtrusion;
import com.comsol.model.operations.cpl.LinearProjection;
import com.comsol.model.operations.cpl.ScalarOperation;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class CplOperationID {

    public static enum CPL_TYPE {
        EXTRUSION,
        PROJECTION,
        SCALAR,
        SUBOPERATION;

    }

    public static enum ID {
        GENERAL_EXTRUSION("GeneralExtrusion", "genext", "General_extrusion", GeneralExtrusion.class, CPL_TYPE.EXTRUSION),
        LINEAR_EXTRUSION("LinearExtrusion", "linext", "Linear_extrusion", LinearExtrusion.class, CPL_TYPE.EXTRUSION),
        SIMILARITY_EXTRUSION("BoundarySimilarity", "bndsim", "Boundary_similarity", null, CPL_TYPE.EXTRUSION, 2),
        IDENTITY_EXTRUSION("IdentityMapping", "idmap", "Identity_mapping", IdentityExtrusion.class, CPL_TYPE.EXTRUSION),
        GENERAL_PROJECTION("GeneralProjection", "genproj", "General_projection", GeneralProjection.class, CPL_TYPE.PROJECTION),
        LINEAR_PROJECTION("LinearProjection", "linproj", "Linear_projection", LinearProjection.class, CPL_TYPE.PROJECTION),
        INTEGRATION("Integration", "intop", "Integration", ScalarOperation.class, CPL_TYPE.SCALAR),
        AVERAGE("Average", "aveop", "Average", ScalarOperation.class, CPL_TYPE.SCALAR),
        MAXIMUM("Maximum", "maxop", "Maximum", ScalarOperation.class, CPL_TYPE.SCALAR),
        MINIMUM("Minimum", "minop", "Minimum", ScalarOperation.class, CPL_TYPE.SCALAR),
        POINTMAP1("OnePointMap", "pm", "One-point_map", null, CPL_TYPE.SUBOPERATION),
        POINTMAP2("TwoPointMap", "pm", "Two-point_map", null, CPL_TYPE.SUBOPERATION),
        EDGEMAP("EdgeMap", "em", "Edge_map", null, CPL_TYPE.SUBOPERATION);

        private String name;
        private String shortName;
        private String description;
        private Constructor<?> constructor;
        private CPL_TYPE type;
        private int minSdim;
        private static Map<String, ID> a;

        static {
            a = new HashMap<String, ID>();
            ID[] iDArray = ID.values();
            int n2 = iDArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ID iD = iDArray[n3];
                a.put(iD.getName(), iD);
                ++n3;
            }
        }

        private ID(String string2, String string3, String string4, Class<?> clazz, CPL_TYPE cPL_TYPE) {
            this(string2, string3, string4, clazz, cPL_TYPE, 1);
        }

        private ID(String string2, String string3, String string4, Class<?> clazz, CPL_TYPE cPL_TYPE, int n3) {
            this.name = string2;
            this.shortName = string3;
            this.description = string4;
            this.type = cPL_TYPE;
            this.minSdim = n3;
            if (clazz == null) {
                this.constructor = null;
            } else {
                try {
                    this.constructor = clazz.getConstructor(ID.class);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("Internal error in CplOperator: " + throwable.getMessage());
                }
            }
        }

        public static ICplOperation create(String string) {
            ID iD = ID.get(string);
            if (iD == null) {
                return null;
            }
            if (iD.constructor == null) {
                return null;
            }
            try {
                return (ICplOperation)iD.constructor.newInstance(new Object[]{iD});
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Internal error in CplOperation: " + throwable.getMessage());
            }
        }

        public static ID get(String string) {
            if (string == null || string.length() == 0) {
                return null;
            }
            ID[] iDArray = ID.values();
            int n2 = iDArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ID iD = iDArray[n3];
                if (iD.name.equals(string)) {
                    return iD;
                }
                ++n3;
            }
            return null;
        }

        public static String getShortName(String string) {
            ID iD = ID.get(string);
            if (iD == null) {
                return null;
            }
            return iD.getShortName();
        }

        public static String getDescription(String string) {
            ID iD = ID.get(string);
            if (iD == null) {
                return null;
            }
            return iD.getDescription();
        }

        public static String[] getAllowedNames(boolean bl2) {
            if (bl2) {
                return ID.getSubOperations();
            }
            Vector<String> vector = new Vector<String>(20);
            ID[] iDArray = ID.values();
            int n2 = iDArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ID iD = iDArray[n3];
                if (!iD.getType().equals((Object)CPL_TYPE.SUBOPERATION)) {
                    vector.add(iD.name);
                }
                ++n3;
            }
            return vector.toArray(new String[vector.size()]);
        }

        public String getDescription() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }

        public String getShortName() {
            return this.shortName;
        }

        public CPL_TYPE getType() {
            return this.type;
        }

        public int getMinSdim() {
            return this.minSdim;
        }

        public boolean isSubOperation() {
            return this.type.equals((Object)CPL_TYPE.SUBOPERATION);
        }

        public static String[] getSubOperations() {
            Vector<String> vector = new Vector<String>(5);
            ID[] iDArray = ID.values();
            int n2 = iDArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ID iD = iDArray[n3];
                if (iD.isSubOperation()) {
                    vector.add(iD.getName());
                }
                ++n3;
            }
            return vector.toArray(new String[vector.size()]);
        }

        public static ID fromOperationID(String string) {
            return a.get(string);
        }
    }
}

