/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.opt;

import com.comsol.model.dbimodel.ModelEntityList;
import com.comsol.model.dbimodel.OPTLIST_TYPE;
import com.comsol.model.dbimodel.OptFeatureList;
import com.comsol.model.operations.IOperation;
import com.comsol.model.operations.IOperationProvider;
import com.comsol.model.operations.OperationType;
import com.comsol.model.opt.OptBound;
import com.comsol.model.opt.OptGConstr;
import com.comsol.model.opt.OptGlobal;
import com.comsol.model.opt.OptLeastSquares;
import com.comsol.model.opt.OptOperationID;
import com.comsol.model.opt.OptScale;
import java.util.Locale;

public class OptOperationProvider
implements IOperationProvider {
    @Override
    public String[] getAllowedSequenceOperations(OperationType operationType, ModelEntityList<?> modelEntityList) {
        if (!operationType.equals((Object)OperationType.OPT)) {
            return null;
        }
        OPTLIST_TYPE oPTLIST_TYPE = OPTLIST_TYPE.valueOf(((OptFeatureList)modelEntityList).getOptListType().name());
        switch (oPTLIST_TYPE) {
            case BOUND: {
                return OptOperationID.BOUNDS;
            }
            case GCONSTR: {
                return OptOperationID.GCONSTRS;
            }
            case NONE: {
                return OptOperationID.NONE;
            }
            case OBJECTIVE: {
                return OptOperationID.OBJECTIVES;
            }
            case SCALE: {
                return OptOperationID.SCALES;
            }
        }
        return null;
    }

    @Override
    public IOperation create(OperationType operationType, String string) {
        if (!operationType.equals((Object)OperationType.OPT)) {
            return null;
        }
        OptOperationID optOperationID = OptOperationID.valueOf(string.toUpperCase(Locale.ENGLISH));
        switch (optOperationID) {
            case BOUND: {
                return new OptBound(string);
            }
            case GCONSTR: {
                return new OptGConstr(string);
            }
            case GLOBAL: {
                return new OptGlobal(string);
            }
            case LEASTSQUARES: {
                return new OptLeastSquares(string);
            }
            case SCALE: {
                return new OptScale(string);
            }
        }
        return null;
    }
}

