/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.properties;

import com.comsol.model.dbimodel.CumulativeSelection;
import com.comsol.model.dbimodel.GeomFeature;
import com.comsol.model.dbimodel.GeomObjectSelectionFeature;
import com.comsol.model.dbimodel.GeomObjectSelectionFeatureList;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.operations.ReferencePropCheck;
import com.comsol.model.util.GeomSequenceUtil;
import com.comsol.util.exceptions.UnknownEntityException;
import java.util.ArrayList;
import java.util.List;

public class CumulativeSelectionReferenceCheck
extends ReferencePropCheck {
    private final GeomSequence a;
    private final String b;

    public CumulativeSelectionReferenceCheck(PropFeature propFeature, GeomSequence geomSequence, GeomObjectSelectionFeatureList geomObjectSelectionFeatureList, String string) {
        super(propFeature, geomObjectSelectionFeatureList);
        this.a = geomSequence;
        this.b = string;
    }

    public String[] getAllowedValues() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = this.a();
        for (GeomObjectSelectionFeature geomObjectSelectionFeature : this.a.selection()) {
            if (!(geomObjectSelectionFeature instanceof CumulativeSelection)) continue;
            int n3 = geomObjectSelectionFeature.getDim();
            if ((n2 != -2 || n3 != -1) && (n2 != n3 || !((CumulativeSelection)geomObjectSelectionFeature).canGetContribution())) continue;
            arrayList.add(GeomSequenceUtil.trimmedTag(geomObjectSelectionFeature.tag()));
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public ModelEntity resolveEntity(String string) {
        int n2 = Math.max(-1, this.a());
        if (n2 >= 0) {
            string = String.valueOf(string) + "." + GeomSequenceUtil.getLevelLabel(this.a.getSDim(), n2);
        }
        try {
            return this.a.selection().get(string);
        }
        catch (UnknownEntityException unknownEntityException) {
            UnknownEntityException unknownEntityException2 = new UnknownEntityException("Unknown_selection");
            unknownEntityException2.addParameterPair("Cumulative_selection", GeomSequenceUtil.trimmedTag(string));
            throw unknownEntityException2;
        }
    }

    @Override
    public void handleRemove(PropFeature propFeature, String string) {
        propFeature.set(string, this.b);
    }

    public String[] describeValid() {
        return new String[]{"A_reference_to_a_cumulative_selection"};
    }

    @Override
    public String[] getDescriptions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = this.a();
        for (GeomObjectSelectionFeature geomObjectSelectionFeature : this.a.selection()) {
            if (!(geomObjectSelectionFeature instanceof CumulativeSelection)) continue;
            int n3 = geomObjectSelectionFeature.getDim();
            if ((n2 != -2 || n3 != -1) && (n2 != n3 || !((CumulativeSelection)geomObjectSelectionFeature).canGetContribution())) continue;
            arrayList.add("#" + geomObjectSelectionFeature.getDisplayString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private int a() {
        GeomFeature geomFeature = (GeomFeature)this.h;
        if (geomFeature.getOperation().isFullCumulativeContribution()) {
            return -2;
        }
        List<? extends GeomObjectSelectionFeature> list = geomFeature.getOutputSelection();
        if (list.size() == 1) {
            return list.get(0).getDim();
        }
        return -2;
    }
}

