/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.selections;

import com.comsol.model.applapi.SimpleSelection;
import com.comsol.model.dbimodel.AbstractSelection;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.Selection;
import com.comsol.model.dbimodel.physics.Physics;
import com.comsol.model.operations.CoordsysID;
import com.comsol.model.operations.ICommonFeatureOperation;
import com.comsol.model.selections.GeometrySelectionFilter;
import com.comsol.model.selections.ISelectionFilter;
import com.comsol.model.util.MixedLicenseRequirements;
import com.comsol.model.util.SelectionModelUtil;
import com.comsol.util.license.c;
import com.comsol.util.license.d;
import com.comsol.util.methods.q;
import java.util.Collection;
import java.util.function.Predicate;

public class ApplModeSelectionFilter
extends GeometrySelectionFilter {
    protected Physics a;

    public ApplModeSelectionFilter(Physics physics, GeomSequence geomSequence, int[] nArray) {
        super(geomSequence, nArray);
        this.a = physics;
    }

    @Override
    public boolean domainFiltering() {
        return true;
    }

    @Override
    public boolean allowVoidDomains() {
        return this.a.getApp().allowVoidDomains();
    }

    @Override
    public ISelectionFilter.DomainStatusInfo getDomainStatus(int n2, boolean bl2) {
        int n3;
        int[] nArray;
        Predicate<ICommonFeatureOperation.ALEType> predicate;
        Object object;
        Collection<c> collection;
        Object object2;
        Selection selection;
        int n4 = this.a.getApp().getSDimMax();
        if (n2 != n4) {
            int n5 = SelectionModelUtil.getMinEntityIndex(this.a.getGeom(), n2);
            return this.a(this.a.getGeom().getNEntities()[n2], n5, ISelectionFilter.DomainStatus.NOTAPPLICABLE);
        }
        int n6 = SelectionModelUtil.getMinEntityIndex(this.a.getGeom(), n4);
        ISelectionFilter.DomainStatusInfo domainStatusInfo = this.a(this.a.getGeom().getNEntities()[n4], n6, ISelectionFilter.DomainStatus.VALID);
        if (!this.allowVoidDomains()) {
            domainStatusInfo.setStatusToIndex(0, ISelectionFilter.DomainStatus.NOTAPPLICABLE);
        }
        MixedLicenseRequirements mixedLicenseRequirements = this.a.getApp().getMixedLicenseRequirements();
        boolean bl3 = this.a.getModel().physics().getVarData().isFullMultiphysics();
        for (PropFeature propFeature : this.a.getModel().coordSystem()) {
            int nArray2;
            int nArray3;
            ISelectionFilter.DomainStatus n10;
            if (!propFeature.isActive() || !propFeature.hasSelection() || !propFeature.selection().geom().equals(this.a.geom())) continue;
            selection = propFeature.selection();
            object2 = mixedLicenseRequirements.getAllowPMLsForLicenses();
            collection = mixedLicenseRequirements.getAllowIEsForLicenses();
            object = mixedLicenseRequirements.getAllowALsForLicenses();
            selection = ApplModeSelectionFilter.getScalingSelectionOnEdim(selection, n4);
            predicate = propFeature.getOperationID();
            if (CoordsysID.PML.name().equals(predicate)) {
                n10 = ISelectionFilter.DomainStatus.NOTAPPLICABLE_PMLDOMAIN;
                if (object2 != null) {
                    n10 = bl3 || d.a((Collection)object2) ? ISelectionFilter.DomainStatus.PMLDOMAIN : ISelectionFilter.DomainStatus.LICENSEERROR_PMLDOMAIN;
                }
                nArray = selection.entities(n4);
                nArray3 = nArray.length;
                nArray2 = 0;
                while (nArray2 < nArray3) {
                    n3 = nArray[nArray2];
                    domainStatusInfo.setStatus(n3, n10);
                    ++nArray2;
                }
                continue;
            }
            if (CoordsysID.InfiniteElement.name().equals(predicate)) {
                n10 = ISelectionFilter.DomainStatus.NOTAPPLICABLE_IEDOMAIN;
                if (collection != null) {
                    n10 = bl3 || d.a(collection) ? ISelectionFilter.DomainStatus.IEDOMAIN : ISelectionFilter.DomainStatus.LICENSEERROR_IEDOMAIN;
                }
                nArray = selection.entities(n4);
                nArray3 = nArray.length;
                nArray2 = 0;
                while (nArray2 < nArray3) {
                    n3 = nArray[nArray2];
                    domainStatusInfo.setStatus(n3, n10);
                    ++nArray2;
                }
                continue;
            }
            if (CoordsysID.AbsorbingLayer.name().equals(predicate)) {
                n10 = ISelectionFilter.DomainStatus.NOTAPPLICABLE_ABSORBINGDOMAIN;
                if (object != null) {
                    n10 = bl3 || d.a(object) ? ISelectionFilter.DomainStatus.ABSORBINGDOMAIN : ISelectionFilter.DomainStatus.LICENSEERROR_ABSORBINGDOMAIN;
                }
                nArray = selection.entities(n4);
                nArray3 = nArray.length;
                nArray2 = 0;
                while (nArray2 < nArray3) {
                    n3 = nArray[nArray2];
                    domainStatusInfo.setStatus(n3, n10);
                    ++nArray2;
                }
                continue;
            }
            if (!CoordsysID.Scaling.name().equals(predicate)) continue;
            n10 = ISelectionFilter.DomainStatus.NOTAPPLICABLE_SCALINGDOMAIN;
            if (object2 != null || collection != null) {
                n10 = bl3 || object2 != null && d.a((Collection)object2) || collection != null && d.a(collection) ? ISelectionFilter.DomainStatus.SCALINGDOMAIN : ISelectionFilter.DomainStatus.LICENSEERROR_SCALINGDOMAIN;
            }
            nArray = selection.entities(n4);
            nArray3 = nArray.length;
            nArray2 = 0;
            while (nArray2 < nArray3) {
                n3 = nArray[nArray2];
                domainStatusInfo.setStatus(n3, n10);
                ++nArray2;
            }
        }
        for (PropFeature propFeature : this.a.getModel().common()) {
            if (!propFeature.isActive() || !propFeature.hasSelection() || propFeature.selection().isGlobal() || !propFeature.selection().geom().equals(this.a.geom())) continue;
            selection = propFeature.getSelection();
            object2 = propFeature.getOperationID();
            collection = mixedLicenseRequirements.getAllowedLicensesForCommonFeature((String)object2);
            if (collection != null && !d.a(collection)) {
                int n5 = selection.getDim();
                if (n5 == n4) {
                    int[] n15 = selection.entities(n4);
                    n3 = n15.length;
                    int domainStatus = 0;
                    while (domainStatus < n3) {
                        int n7 = n15[domainStatus];
                        domainStatusInfo.setStatus(n7, ISelectionFilter.DomainStatus.LICENSEERROR);
                        ++domainStatus;
                    }
                } else if (n5 > n4) {
                    predicate = new SimpleSelection(selection);
                    ((SimpleSelection)((Object)predicate)).inherit(true);
                    int[] nArray2 = ((SimpleSelection)((Object)predicate)).entities(n4);
                    int n8 = nArray2.length;
                    n3 = 0;
                    while (n3 < n8) {
                        int n9 = nArray2[n3];
                        domainStatusInfo.setStatus(n9, ISelectionFilter.DomainStatus.LICENSEERROR);
                        ++n3;
                    }
                }
            }
            object = ((ICommonFeatureOperation)propFeature.getOperation()).getALEType();
            predicate = this.a.getApp().getALETypeFilter(this.a);
            if (!predicate.test((ICommonFeatureOperation.ALEType)((Object)object))) continue;
            ISelectionFilter.DomainStatus domainStatus = null;
            domainStatus = object == ICommonFeatureOperation.ALEType.ROTATING ? ISelectionFilter.DomainStatus.NOTAPPLICABLE_ROTATINGDOMAIN : ISelectionFilter.DomainStatus.NOTAPPLICABLE_DEFORMINGDOMAIN;
            nArray = selection.entities(n4);
            int n10 = nArray.length;
            int n11 = 0;
            while (n11 < n10) {
                n3 = nArray[n11];
                domainStatusInfo.setStatus(n3, domainStatus);
                ++n11;
            }
        }
        this.a(domainStatusInfo);
        return domainStatusInfo;
    }

    protected ISelectionFilter.DomainStatusInfo a(int n2, int n3, ISelectionFilter.DomainStatus domainStatus) {
        return new ISelectionFilter.DomainStatusInfo(n2, n3, domainStatus);
    }

    protected void a(ISelectionFilter.DomainStatusInfo domainStatusInfo) {
    }

    public static Selection getScalingSelectionOnEdim(Selection selection, int n2) {
        int n3 = q.b((int[])selection.dimension());
        if (n2 < n3) {
            GeomSequence geomSequence = selection.getModel().geom(selection.geom());
            SimpleSelection simpleSelection = new SimpleSelection(selection).inherit(true);
            SimpleSelection simpleSelection2 = new SimpleSelection(simpleSelection.getModel(), simpleSelection.geom(), n2).set(simpleSelection.entities(n2));
            int[][] nArray = geomSequence.getUpDown();
            SimpleSelection simpleSelection3 = new SimpleSelection(simpleSelection.getModel(), simpleSelection.geom(), n3 - 1);
            int n4 = 0;
            while (n4 < nArray[0].length) {
                if (nArray[0][n4] * nArray[1][n4] > 0 && !simpleSelection.containsEntities(nArray[0][n4], nArray[1][n4])) {
                    simpleSelection3.add(n4 + 1);
                }
                ++n4;
            }
            if (n2 < n3 - 1) {
                simpleSelection3.inherit(true);
                simpleSelection3 = new SimpleSelection(simpleSelection.getModel(), simpleSelection.geom(), n2).set(simpleSelection3.entities(n2));
            }
            selection = simpleSelection2.difference(simpleSelection3);
        }
        return selection;
    }

    @Override
    public final void notifySelectionChanged(AbstractSelection abstractSelection, ISelectionFilter.Notification notification) {
        if (!this.a.getGeom().isDoingAssocUpdate() && notification == ISelectionFilter.Notification.SET) {
            this.a.getModel().physics().getVarData().notifyProviderChanged(this.a);
        }
    }
}

