/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.selections;

import com.comsol.model.dbimodel.AbstractSelection;
import com.comsol.model.dbimodel.DrawObject;
import com.comsol.model.dbimodel.GeomSequenceWrapper;
import com.comsol.model.dbimodel.MeshSequence;
import com.comsol.model.dbimodel.SEL_TYPES;
import com.comsol.model.dbimodel.SelectionEntity;
import com.comsol.model.dbimodel.SelectionFeature;
import com.comsol.model.savepoint.interfaces.IGeomSequence;
import com.comsol.util.methods.FlLocale;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public interface ISelectionFilter {
    public SelectionType[] getAllowedTypes();

    public String[] getAllowedGeometries();

    public int[] getAllowedEDims();

    public boolean haveDynamicEDims();

    public boolean allowInherit();

    public boolean allowVoidDomains();

    public boolean inheritIsDefault();

    public boolean allowMeshInterior();

    public boolean singleSelection();

    public boolean doesNotAllowAll();

    public boolean allowExtraDimensions();

    public String getLastAllowedFeature();

    public String getAllowedFeature();

    public boolean domainFiltering();

    public int getSelectionCacheTag(int var1);

    public DomainStatusInfo getDomainStatus(int var1, boolean var2);

    public DomainStatus[] getDomainStatus(DrawObject var1, int var2);

    public void notifySelectionChanged(AbstractSelection var1, Notification var2);

    public GeomSequenceWrapper resolveGeometry(String var1);

    public SelectionFeature resolveNamedSelection(String var1);

    public boolean isVirtualSelection();

    public ISelectionFilter getExtraDimensionFilter(IGeomSequence var1);

    public GeomSequenceWrapper resolveDeformedGeometry(GeomSequenceWrapper var1);

    public String getPrincipalGeometry();

    public boolean allowMesh(MeshSequence var1);

    default public StatusChange filterAllDomainsAfterStatusChange(int[] nArray) {
        return null;
    }

    public void initializeSelectionFilterCache();

    public void clearSelectionFilterCache();

    public List<String> getDataBinding();

    public static enum DomainStatus {
        VALID(""),
        PATRTIAL(" (" + FlLocale.getString((String)"Partial") + ")"),
        NOTAPPLICABLE(" (" + FlLocale.getString((String)"not_applicable") + ")"),
        SHADOWED(" (" + FlLocale.getString((String)"overridden") + ")"),
        IEDOMAIN(" (" + FlLocale.getString((String)"Infinite_elements") + ")"),
        ABSORBINGDOMAIN(" (" + FlLocale.getString((String)"Absorbing_layer") + ")"),
        PMLDOMAIN(" (" + FlLocale.getString((String)"Perfectly_matched_layer") + ")"),
        SCALINGDOMAIN(" (" + FlLocale.getString((String)"Scaling_system") + ")"),
        NOTAPPLICABLE_IEDOMAIN(" (" + FlLocale.getString((String)"not_applicable") + ": " + FlLocale.getString((String)"Infinite_elements") + ")"),
        NOTAPPLICABLE_IEDOMAIN_SRC(" (" + FlLocale.getString((String)"not_applicable") + ": " + FlLocale.getString((String)"Infinite_elements") + ", src)"),
        NOTAPPLICABLE_IEDOMAIN_DST(" (" + FlLocale.getString((String)"not_applicable") + ": " + FlLocale.getString((String)"Infinite_elements") + ", dst)"),
        NOTAPPLICABLE_ABSORBINGDOMAIN(" (" + FlLocale.getString((String)"not_applicable") + ": " + FlLocale.getString((String)"Absorbing_layer") + ")"),
        NOTAPPLICABLE_ABSORBINGDOMAIN_SRC(" (" + FlLocale.getString((String)"not_applicable") + ": " + FlLocale.getString((String)"Absorbing_layer") + ", src)"),
        NOTAPPLICABLE_ABSORBINGDOMAIN_DST(" (" + FlLocale.getString((String)"not_applicable") + ": " + FlLocale.getString((String)"Absorbing_layer") + ", dst)"),
        NOTAPPLICABLE_PMLDOMAIN(" (" + FlLocale.getString((String)"not_applicable") + ": " + FlLocale.getString((String)"Perfectly_matched_layer") + ")"),
        NOTAPPLICABLE_SCALINGDOMAIN(" (" + FlLocale.getString((String)"not_applicable") + ": " + FlLocale.getString((String)"Scaling_system") + ")"),
        LICENSEERROR_IEDOMAIN(" (" + FlLocale.getErrorString((String)"License_error") + ": " + FlLocale.getString((String)"Infinite_elements") + ")"),
        LICENSEERROR_ABSORBINGDOMAIN(" (" + FlLocale.getErrorString((String)"License_error") + ": " + FlLocale.getString((String)"Absorbing_layer") + ")"),
        LICENSEERROR_PMLDOMAIN(" (" + FlLocale.getErrorString((String)"License_error") + ": " + FlLocale.getString((String)"Perfectly_matched_layer") + ")"),
        LICENSEERROR_SCALINGDOMAIN(" (" + FlLocale.getErrorString((String)"License_error") + ": " + FlLocale.getString((String)"Scaling_system") + ")"),
        LICENSEERROR(" (" + FlLocale.getErrorString((String)"License_error") + ")"),
        NOTAPPLICABLE_ROTATINGDOMAIN(" (" + FlLocale.getString((String)"not_applicable") + ": " + FlLocale.getString((String)"Rotating_domain") + ")"),
        NOTAPPLICABLE_DEFORMINGDOMAIN(" (" + FlLocale.getString((String)"not_applicable") + ": " + FlLocale.getString((String)"Deforming_domain") + ")"),
        NOTAPPLICABLE_SLIDINGDOMAIN(" (" + FlLocale.getString((String)"not_applicable") + ": " + FlLocale.getString((String)"Sliding_domain") + ")");

        private final String descr;

        private DomainStatus(String string2) {
            this.descr = string2;
        }

        public String getDescr() {
            return this.descr.toLowerCase(FlLocale.getLocale()).replaceAll("\\.", "");
        }

        public boolean isValid() {
            switch (this) {
                case VALID: 
                case IEDOMAIN: 
                case ABSORBINGDOMAIN: 
                case PMLDOMAIN: 
                case SCALINGDOMAIN: {
                    return true;
                }
            }
            return false;
        }

        public boolean isAddable() {
            switch (this) {
                case VALID: 
                case SHADOWED: 
                case IEDOMAIN: 
                case ABSORBINGDOMAIN: 
                case PMLDOMAIN: 
                case SCALINGDOMAIN: {
                    return true;
                }
            }
            return false;
        }

        public static DomainStatus[] allNotApplicable(int n2) {
            DomainStatus[] domainStatusArray = new DomainStatus[n2 + 1];
            Arrays.fill((Object[])domainStatusArray, (Object)NOTAPPLICABLE);
            return domainStatusArray;
        }
    }

    public static class DomainStatusInfo {
        protected final DomainStatus[] c;
        private String[] a;
        private final int b;
        private Map<String, SelectionEntity> d;
        private Map<String, SelectionEntity> e;
        private Map<String, SelectionEntity> f;
        private boolean g;
        private static Map<String, SelectionEntity> h = new HashMap<String, SelectionEntity>();

        public DomainStatusInfo(int n2, int n3, DomainStatus domainStatus) {
            this.b = -n3;
            this.c = new DomainStatus[n2 + 1 + this.b];
            this.a = null;
            this.setStatus(domainStatus);
        }

        public DomainStatusInfo(DomainStatusInfo domainStatusInfo) {
            this.c = (DomainStatus[])domainStatusInfo.c.clone();
            this.b = domainStatusInfo.b;
            this.g = domainStatusInfo.g;
            if (domainStatusInfo.a != null) {
                this.a = (String[])domainStatusInfo.a.clone();
            }
            if (domainStatusInfo.d != null) {
                this.d = DomainStatusInfo.a(domainStatusInfo.d);
            }
            if (domainStatusInfo.e != null) {
                this.e = DomainStatusInfo.a(domainStatusInfo.e);
            }
            if (domainStatusInfo.f != null) {
                this.f = DomainStatusInfo.a(domainStatusInfo.f);
            }
        }

        public DomainStatusInfo getNewInstance() {
            return new DomainStatusInfo(this);
        }

        private static <K, V> Map<K, V> a(Map<K, V> map) {
            return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        public DomainStatusInfo setStatus(DomainStatus domainStatus) {
            Arrays.fill((Object[])this.c, (Object)domainStatus);
            return this;
        }

        public void setStatus(int n2, DomainStatus domainStatus) {
            this.c[n2 + this.b] = domainStatus;
        }

        public String getExtraInfo(int n2) {
            return this.a == null ? null : this.a[n2 + this.b];
        }

        public void setExtraInfo(int n2, String string) {
            if (this.a == null) {
                this.a = new String[this.c.length];
            }
            this.a[n2 + this.b] = string;
        }

        public void appendExtraInfo(int n2, String string) {
            if (this.a == null) {
                this.a = new String[this.c.length];
            }
            this.a[n2 + this.b] = this.a[n2 + this.b] != null && !"".equals(this.a[n2 + this.b]) ? String.valueOf(this.a[n2 + this.b]) + "-" + string : " " + string;
        }

        public String getStatusDescr(int n2) {
            if (this.a == null || this.a[n2 + this.b] == null) {
                return this.c[n2 + this.b].getDescr();
            }
            return String.valueOf(this.c[n2 + this.b].getDescr()) + this.a[n2 + this.b];
        }

        public void setStatusToIndex(int n2, DomainStatus domainStatus) {
            int n3 = this.first();
            while (n3 <= n2) {
                this.setStatus(n3, domainStatus);
                ++n3;
            }
        }

        public int first() {
            return -this.b;
        }

        public int limit() {
            return this.c.length - this.b;
        }

        public int getOffset() {
            return this.b;
        }

        public DomainStatus getStatus(int n2) {
            return this.c[n2 + this.b];
        }

        public void setOverrideInfoAdded() {
            this.g = true;
        }

        public boolean isOverrideInfoAdded() {
            return this.g;
        }

        public void addOverriddenBy(SelectionEntity selectionEntity, String string) {
            if (this.d == null) {
                this.d = new LinkedHashMap<String, SelectionEntity>();
            }
            if (string == null) {
                this.d.put(selectionEntity.getTag(), selectionEntity);
            } else {
                this.d.put(String.valueOf(selectionEntity.getTag()) + string, selectionEntity);
            }
        }

        public void addOverrides(SelectionEntity selectionEntity, String string) {
            if (this.e == null) {
                this.e = new LinkedHashMap<String, SelectionEntity>();
            }
            if (string == null) {
                this.e.put(selectionEntity.getTag(), selectionEntity);
            } else {
                this.e.put(String.valueOf(selectionEntity.getTag()) + string, selectionEntity);
            }
        }

        public void addContributeWith(SelectionEntity selectionEntity, String string) {
            if (this.f == null) {
                this.f = new LinkedHashMap<String, SelectionEntity>();
            }
            if (string == null) {
                this.f.put(selectionEntity.getTag(), selectionEntity);
            } else {
                this.f.put(String.valueOf(selectionEntity.getTag()) + string, selectionEntity);
            }
        }

        public Map<String, SelectionEntity> getOverriddenBy() {
            return this.d != null ? this.d : h;
        }

        public Map<String, SelectionEntity> getOverrides() {
            return this.e != null ? this.e : h;
        }

        public Map<String, SelectionEntity> getContributesWith() {
            return this.f != null ? this.f : h;
        }
    }

    public static enum Notification {
        FILTER,
        SET,
        UPDATE,
        OTHER;

    }

    public static enum SelectionType {
        GLOBAL("Global"),
        GEOM("Entire geometry"),
        GEOMDIM("Geometric entities"),
        OBJECT("Geometry objects"),
        OBJECTDIM("Geometry object entities"),
        OBJECTGROUP("Group of geometry object entities"),
        VIRTUALOBJECTDIM("Virtual geometry object entities"),
        MESHREMAINING("Remaining entities");

        private final String descr;

        private SelectionType(String string2) {
            this.descr = string2;
        }

        public String getDescr() {
            return this.descr;
        }

        public static SelectionType getType(SEL_TYPES sEL_TYPES) {
            switch (sEL_TYPES) {
                case GLOBAL: {
                    return GLOBAL;
                }
                case GEOM: {
                    return GEOM;
                }
                case GEOMDIM: 
                case GEOMDIMTYPE: {
                    return GEOMDIM;
                }
                case OBJECT: {
                    return OBJECT;
                }
                case OBJECTDIM: {
                    return OBJECTDIM;
                }
                case MESHREMAINING: {
                    return MESHREMAINING;
                }
            }
            throw new IllegalStateException("Unknown selection type.");
        }
    }

    public static class StatusChange {
        public int[] manualEntities;
        public boolean updateGui;

        public StatusChange(int[] nArray) {
            this.manualEntities = nArray;
        }
    }
}

