/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.simulation.components;

import com.comsol.model.simulation.SimEqSyst;
import com.comsol.model.simulation.components.Annotatable;
import com.comsol.model.simulation.components.Component;
import com.comsol.model.simulation.components.ComponentConst;
import com.comsol.model.simulation.components.ComponentField;
import com.comsol.model.simulation.components.ComponentVar;
import com.comsol.model.simulation.components.Connection;
import com.comsol.model.simulation.components.Equation;
import com.comsol.model.simulation.components.Event;
import com.comsol.model.simulation.components.IOUtil;
import com.comsol.model.simulation.components.InstContext;
import com.comsol.model.simulation.components.Mod;
import com.comsol.model.simulation.components.NamedComponent;
import com.comsol.model.simulation.components.UniqueList;
import com.comsol.util.exceptions.FlException;
import java.util.ArrayList;
import java.util.Iterator;

public class ComponentModel
implements Annotatable,
NamedComponent {
    private Component a;
    private final String b;
    private UniqueList<Component> c = new UniqueList();
    private UniqueList<ComponentVar> d = new UniqueList();
    private UniqueList<ComponentConst> e = new UniqueList();
    private ArrayList<Connection> f = new ArrayList();
    private UniqueList<Equation> g = new UniqueList();
    private ArrayList<Event> h = new ArrayList();
    private String i = null;

    public ComponentModel(Component component, String string) {
        this.a = component;
        this.b = string;
    }

    @Override
    public String getName() {
        return this.b;
    }

    public String getType() {
        return this.b;
    }

    public ComponentVar getVar(String string) {
        Iterator<ComponentVar> iterator = this.d.iterator();
        while (iterator.hasNext()) {
            ComponentVar componentVar = iterator.next();
            if (!componentVar.getName().equals(string)) continue;
            return componentVar;
        }
        return null;
    }

    public ComponentField getField(String string) {
        UniqueList[] uniqueListArray = new UniqueList[]{this.d, this.e};
        int n2 = 0;
        while (n2 < uniqueListArray.length) {
            ComponentField componentField = (ComponentField)uniqueListArray[n2].get(string);
            if (componentField != null) {
                return componentField;
            }
            ++n2;
        }
        return null;
    }

    public void addVar(ComponentVar componentVar) {
        this.d.add(componentVar);
    }

    public void addConst(ComponentConst componentConst) {
        this.e.add(componentConst);
    }

    public void addComponent(Component component) {
        this.c.add(component);
        component.setEnclosingModel(this);
    }

    public void addConn(Connection connection) {
        this.f.add(connection);
    }

    public void addEq(Equation equation) {
        this.g.add(equation);
    }

    public void addEvent(Event event) {
        this.h.add(event);
    }

    @Override
    public void setAnn(String string) {
        this.i = string;
    }

    @Override
    public String getAnn() {
        return this.i;
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Analysis type: ");
        if (this.b == null || this.b.length() == 0) {
            stringBuilder.append("<universal>");
        } else {
            stringBuilder.append(this.b);
        }
        stringBuilder.append("\n");
        String string2 = String.valueOf(string) + "  ";
        if (this.e.size() > 0) {
            stringBuilder.append(String.valueOf(string) + "Constants:\n").append(IOUtil.toString(this.e.iterator(), string2));
        }
        if (this.d.size() > 0) {
            stringBuilder.append(String.valueOf(string) + "Variables:\n").append(IOUtil.toString(this.d.iterator(), string2));
        }
        if (this.f.size() > 0) {
            stringBuilder.append(String.valueOf(string) + "Connections:\n").append(IOUtil.toString(this.f.iterator(), string2));
        }
        if (this.g.size() > 0) {
            stringBuilder.append(String.valueOf(string) + "Equations:\n").append(IOUtil.toString(this.g.iterator(), string2));
        }
        if (this.h.size() > 0) {
            stringBuilder.append(String.valueOf(string) + "Events:\n").append(IOUtil.toString(this.h.iterator(), string2));
        }
        return stringBuilder.toString();
    }

    @Override
    public String toModelica(String string, String string2) throws FlException {
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = String.valueOf(string2) + "  ";
        if (this.e.size() + this.d.size() + this.c.size() > 0) {
            stringBuilder.append(string2).append("private\n");
            stringBuilder.append(IOUtil.toModelica(this.e.iterator(), string, string3));
            stringBuilder.append(IOUtil.toModelica(this.d.iterator(), string, string3));
            stringBuilder.append(IOUtil.toModelica(this.c.iterator(), string, string3));
        }
        if (this.f.size() + this.g.size() + this.h.size() > 0) {
            stringBuilder.append(string2).append("equation\n");
            stringBuilder.append(IOUtil.toModelica(this.f.iterator(), string, string3));
            stringBuilder.append(IOUtil.toModelica(this.g.iterator(), string, string3));
            stringBuilder.append(IOUtil.toModelica(this.h.iterator(), string, string3));
        }
        return stringBuilder.toString();
    }

    public void installLocal(InstContext instContext) {
        this.a.installLocal(instContext);
        this.a(instContext);
    }

    private void a(InstContext instContext) {
        Iterator<Component> iterator = this.c.iterator();
        while (iterator.hasNext()) {
            instContext.addLocalClass(iterator.next());
        }
    }

    public void instantiate(InstContext instContext, SimEqSyst simEqSyst, long l2) throws FlException {
        this.a(instContext);
        Mod mod = new Mod();
        instContext.instantiateFields(this.e.iterator(), simEqSyst, 0x1000000L, mod);
        instContext.instantiateFields(this.d.iterator(), simEqSyst, 0x100000L, mod);
        Iterator<Annotatable> iterator = this.g.iterator();
        while (iterator.hasNext()) {
            iterator.next().instantiate(instContext, simEqSyst, this);
        }
        iterator = this.f.iterator();
        while (iterator.hasNext()) {
            ((Connection)iterator.next()).instantiate(instContext, simEqSyst, this);
        }
        iterator = this.h.iterator();
        while (iterator.hasNext()) {
            ((Event)iterator.next()).instantiate(instContext, simEqSyst, this);
        }
    }
}

