/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util;

import com.comsol.model.applapi.IPhysicalQuantity;
import com.comsol.model.applapi.IVariableData;
import com.comsol.model.applapi.MaterialDB;
import com.comsol.model.applapi.VariableDataBase;
import com.comsol.model.dbimodel.CommonFeature;
import com.comsol.model.dbimodel.CommonList;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.ModelNode;
import com.comsol.model.operations.ICommonFeatureOperation;
import com.comsol.model.operations.operationID.CommonFeatureOperationID;
import com.comsol.model.selections.ISelectionFilter;
import com.comsol.model.util.ModelInputRequestedData;
import com.comsol.model.util.SelectionModelUtil;
import com.comsol.nativeutil.parser.ParseUtil;
import com.comsol.nativeutil.properties.bf;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.methods.FlLocale;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.q;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommonFeatureUtil {
    private static final Pattern a = Pattern.compile("[^{}]+(?=\\})");

    public static CommonFeature getCommonModelInput(Model model) {
        return (CommonFeature)model.common().get(CommonFeatureOperationID.CommonModelInputDefault.shortName());
    }

    public static String[][] getDefaultPQValue(CommonFeature commonFeature, IPhysicalQuantity iPhysicalQuantity) {
        if (CommonFeatureOperationID.CommonModelInputDefault.isOfType(commonFeature)) {
            String[][] stringArray = commonFeature.getStringMatrix(MaterialDB.ModelInputPropID.modified.getName());
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2][0].equals(iPhysicalQuantity.fieldName())) {
                    int[] nArray = iPhysicalQuantity.size();
                    String string = stringArray[n2][1];
                    if (Arrays.equals(nArray, VariableDataBase.SCALAR)) {
                        return new String[][]{{string}};
                    }
                    if (Arrays.equals(nArray, VariableDataBase.VECTOR)) {
                        return q.d((String[][])new String[][]{CommonFeatureUtil.getPQStringArrayValue(string, nArray)});
                    }
                    return CommonFeatureUtil.getPQStringMatrixValue(string, nArray);
                }
                ++n2;
            }
            return iPhysicalQuantity.getDefaultValue();
        }
        int[] nArray = iPhysicalQuantity.size();
        String string = commonFeature.getString(MaterialDB.ModelInputPropID.value.getName());
        if (Arrays.equals(nArray, VariableDataBase.SCALAR)) {
            String string2 = string;
            return new String[][]{{string2}};
        }
        if (Arrays.equals(nArray, VariableDataBase.VECTOR)) {
            if ("".equals(string)) {
                string = "{1,2,3}";
            }
            String[] stringArray = CommonFeatureUtil.getPQStringArrayValue(string, nArray);
            String[][] stringArray2 = new String[nArray[0]][nArray[1]];
            int n3 = 0;
            while (n3 < nArray[0]) {
                stringArray2[n3][0] = stringArray[n3];
                ++n3;
            }
            return stringArray2;
        }
        return CommonFeatureUtil.getPQStringMatrixValue(string, nArray);
    }

    public static void reInitializeSelection(CommonFeature commonFeature) {
        ISelectionFilter iSelectionFilter;
        Object object;
        int n2;
        if (commonFeature == null || !commonFeature.hasSelection()) {
            return;
        }
        ModelNode modelNode = commonFeature.getParentModel();
        GeomSequence geomSequence = modelNode.getGeom();
        if (geomSequence == null) {
            return;
        }
        String string = geomSequence.getTag();
        int n3 = n2 = geomSequence.getSDim();
        ICommonFeatureOperation iCommonFeatureOperation = commonFeature.getOperation();
        ISelectionFilter iSelectionFilter2 = iCommonFeatureOperation.getSelectionFilter(commonFeature.selection());
        if (iSelectionFilter2 != null && ((int[])(object = iSelectionFilter2.getAllowedEDims())).length > 0) {
            n3 = SelectionModelUtil.getSDimMax(commonFeature.getModel(), geomSequence, (int[])object, -1);
        }
        if ((iSelectionFilter = (object = (Object)commonFeature.selection()).getSelectionFilter()) == null || q.c((int[])iSelectionFilter.getAllowedEDims(), (int)n3)) {
            object.geom(string, n3);
        }
        if (commonFeature.getContainer() instanceof CommonList) {
            ArrayList arrayList = new ArrayList(((CommonList)commonFeature.getContainer()).getListView());
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                CommonFeature commonFeature2 = (CommonFeature)iterator.next();
                if (commonFeature2.isActive() && commonFeature2.hasSelection() && string.equals(commonFeature2.selection().geom())) continue;
                iterator.remove();
            }
            if (arrayList.size() == 1) {
                commonFeature.selection().all();
            }
        }
    }

    public static boolean hasPQValue(CommonFeature commonFeature, String string) {
        String[][] stringArray = commonFeature.getStringMatrix(MaterialDB.ModelInputPropID.modified.getName());
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2][0].equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String[][] getPQStringMatrixValue(String string, int[] nArray) {
        String[][] stringArray = new String[nArray[0]][];
        if ("".equals(string)) {
            int n2 = 0;
            while (n2 < nArray[0]) {
                stringArray[n2] = new String[nArray[1]];
                Arrays.fill(stringArray[n2], "0");
                ++n2;
            }
            return stringArray;
        }
        if (string == null) {
            return null;
        }
        Matcher matcher = a.matcher(string);
        int n3 = 0;
        while (matcher.find()) {
            String[] stringArray2 = ParseUtil.i((String)matcher.group());
            if (stringArray2.length != nArray[1]) {
                throw new FlException("Wrong_size_of_input_argument");
            }
            stringArray[n3++] = stringArray2;
        }
        if (n3 != nArray[0]) {
            throw new FlException("Wrong_size_of_input_argument");
        }
        return stringArray;
    }

    public static String[] getPQStringArrayValue(String string, int[] nArray) {
        if (string == null) {
            return null;
        }
        if ("".equals(string)) {
            if (nArray[0] == 3) {
                return new String[]{"1", "2", "3"};
            }
            Object[] objectArray = new String[nArray[0]];
            Arrays.fill(objectArray, "0");
            return objectArray;
        }
        String[] stringArray = ParseUtil.i((String)string);
        if (stringArray.length != nArray[0]) {
            throw new FlException("Wrong_size_of_input_argument");
        }
        return stringArray;
    }

    public static String encodePQValue(IPhysicalQuantity iPhysicalQuantity, String[][] stringArray) {
        return CommonFeatureUtil.encodePQValue(iPhysicalQuantity.size(), stringArray);
    }

    public static String encodePQValue(int[] nArray, String[][] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("{");
        int n2 = 0;
        while (n2 < nArray[0]) {
            stringBuffer.append("{");
            int n3 = 0;
            while (n3 < nArray[1] - 1) {
                stringBuffer.append(stringArray[n2][n3]).append(",");
                ++n3;
            }
            stringBuffer.append(stringArray[n2][n3]).append("}");
            if (n2 < nArray[0] - 1) {
                stringBuffer.append(",");
            }
            ++n2;
        }
        stringBuffer.append("}");
        String string = stringBuffer.toString();
        return string;
    }

    public static String encodePQValue(String[] stringArray) {
        return "{" + FlStringUtil.delimitedString((String[])stringArray, (String)",") + "}";
    }

    public static String[][] getModelInputValues(CommonFeature commonFeature, IPhysicalQuantity iPhysicalQuantity) {
        String[][] stringArray = CommonFeatureUtil.getDefaultPQValue(commonFeature, iPhysicalQuantity);
        IVariableData iVariableData = commonFeature.getModel().physics().getVarData();
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3 = 0;
            while (n3 < stringArray[n2].length) {
                stringArray[n2][n3] = iVariableData.replaceWithCompleteNames(stringArray[n2][n3], commonFeature.scopeDot());
                ++n3;
            }
            ++n2;
        }
        return stringArray;
    }

    public static String getDefaultValue(GetSetPhysicalQuantity getSetPhysicalQuantity, IPhysicalQuantity iPhysicalQuantity) {
        if (getSetPhysicalQuantity != null && getSetPhysicalQuantity.hasPQValue(iPhysicalQuantity.fieldName())) {
            return getSetPhysicalQuantity.getPQStringValue(iPhysicalQuantity.fieldName());
        }
        return CommonFeatureUtil.encodePQValues(iPhysicalQuantity, iPhysicalQuantity.getDefaultValue());
    }

    public static String encodePQValues(IPhysicalQuantity iPhysicalQuantity, String[][] stringArray) {
        int[] nArray = iPhysicalQuantity.size();
        if (Arrays.equals(nArray, VariableDataBase.SCALAR)) {
            return stringArray[0][0];
        }
        if (Arrays.equals(nArray, VariableDataBase.VECTOR)) {
            return CommonFeatureUtil.encodePQValue(new String[]{stringArray[0][0], stringArray[1][0], stringArray[2][0]});
        }
        return CommonFeatureUtil.encodePQValue(iPhysicalQuantity, stringArray);
    }

    public static String encodePQValues(IPhysicalQuantity iPhysicalQuantity, String[] stringArray) {
        int[] nArray = iPhysicalQuantity.size();
        if (Arrays.equals(nArray, VariableDataBase.SCALAR)) {
            return stringArray[0];
        }
        if (Arrays.equals(nArray, VariableDataBase.VECTOR)) {
            return CommonFeatureUtil.encodePQValue(stringArray);
        }
        String[][] stringArray2 = new String[nArray[0]][nArray[1]];
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray[0]) {
            int n4 = 0;
            while (n4 < nArray[1]) {
                stringArray2[n3][n4] = stringArray[n2++];
                ++n4;
            }
            ++n3;
        }
        return CommonFeatureUtil.encodePQValue(nArray, stringArray2);
    }

    public static void setVisibleOnDemand(Model model, ModelEntity modelEntity) {
        Map<String, Set<ModelInputRequestedData>> map;
        CommonFeature commonFeature = CommonFeatureUtil.getCommonModelInput(model);
        boolean bl2 = commonFeature.getBoolean(MaterialDB.ModelInputPropID.minpVisibility.getName());
        if (!bl2 && !(map = model.physics().getVarData().getRequestedModelInputs(modelEntity == null ? model : modelEntity)).isEmpty()) {
            commonFeature.setWithoutLogging(MaterialDB.ModelInputPropID.minpVisibility.getName(), true);
            commonFeature.setWithoutLogging(MaterialDB.ModelInputPropID.showOnlyNeeded.getName(), "");
        }
    }

    public static class GetSetPhysicalQuantity {
        protected final CommonFeature a;
        private Map<String, String> b;
        private Consumer<String[][]> c;

        public GetSetPhysicalQuantity(CommonFeature commonFeature, Consumer<String[][]> consumer) {
            this.a = commonFeature;
            this.b = new HashMap<String, String>();
            this.c = consumer;
        }

        public void populatePQMap() {
            this.populatePQMap(this.a.getStringMatrix(MaterialDB.ModelInputPropID.modified.getName()));
        }

        public void populatePQMap(String[][] stringArray) {
            this.b.clear();
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.b.put(stringArray[n2][0], stringArray[n2][1]);
                ++n2;
            }
        }

        public void storePQValues() {
            String[][] stringArray = new String[this.b.size()][2];
            int n2 = 0;
            for (Map.Entry<String, String> entry : this.b.entrySet()) {
                stringArray[n2][0] = entry.getKey();
                stringArray[n2][1] = entry.getValue();
                ++n2;
            }
            this.c.accept(stringArray);
        }

        public void addPQParam(IPhysicalQuantity iPhysicalQuantity, String string) {
            this.b.put(iPhysicalQuantity.fieldName(), string);
            this.storePQValues();
        }

        public void addPQParam(IPhysicalQuantity iPhysicalQuantity, String[] stringArray) {
            this.b.put(iPhysicalQuantity.fieldName(), CommonFeatureUtil.encodePQValue(stringArray));
            this.storePQValues();
        }

        public void addPQParam(IPhysicalQuantity iPhysicalQuantity, String[][] stringArray) {
            this.b.put(iPhysicalQuantity.fieldName(), CommonFeatureUtil.encodePQValue(iPhysicalQuantity, stringArray));
            this.storePQValues();
        }

        public void removePQParam(String string) {
            this.b.remove(string);
            this.storePQValues();
        }

        public boolean hasPQValue(String string) {
            return this.b.containsKey(string);
        }

        public String getPQStringValue(String string) {
            return this.b.get(string);
        }

        public boolean isEmpty() {
            return this.b.isEmpty();
        }
    }

    public static class PhysicalCategoryComparator
    implements Comparator<bf> {
        private final Collator a = Collator.getInstance(FlLocale.getLocale());

        @Override
        public int compare(bf bf2, bf bf3) {
            Object object = bf2.c();
            Object object2 = bf3.c();
            if (object instanceof IPhysicalQuantity.PQCategory && object2 instanceof IPhysicalQuantity.PQCategory) {
                double d2;
                double d3 = ((IPhysicalQuantity.PQCategory)((Object)object)).ordinal();
                return d3 > (d2 = (double)((IPhysicalQuantity.PQCategory)((Object)object2)).ordinal()) ? -1 : (d3 < d2 ? 1 : 0);
            }
            if (object instanceof IPhysicalQuantity && object2 instanceof IPhysicalQuantity) {
                return this.a.compare(((IPhysicalQuantity)object).descr(), ((IPhysicalQuantity)object2).descr());
            }
            return 0;
        }
    }
}

