/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util;

import com.comsol.model.dbimodel.GEOMSEQUENCE_TYPES;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.MeshSequence;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.StudyFeature;
import com.comsol.model.method.internal.IGeomListInternal;
import com.comsol.model.savepoint.interfaces.IGeomSequence;
import com.comsol.util.methods.q;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DeformedConfigUtil {
    public static List<GeomSequence> getDeformedConfigs(GeomSequence geomSequence) {
        ArrayList<GeomSequence> arrayList = new ArrayList<GeomSequence>();
        if (geomSequence == null || !geomSequence.supportsPhysics() || geomSequence.isDeformed()) {
            throw new RuntimeException("Illegal input geometry.");
        }
        for (GeomSequence geomSequence2 : geomSequence.getModel().geom()) {
            if (geomSequence != geomSequence2.getUndefGeom()) continue;
            arrayList.add(geomSequence2);
        }
        return arrayList;
    }

    public static List<MeshSequence> getAllMeshes(GeomSequence geomSequence) {
        List<GeomSequence> list = DeformedConfigUtil.getDeformedConfigs(geomSequence);
        ArrayList<MeshSequence> arrayList = new ArrayList<MeshSequence>();
        String[] stringArray = geomSequence.meshes();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String object = stringArray[n3];
            arrayList.add(geomSequence.getModel().mesh(object));
            ++n3;
        }
        for (GeomSequence geomSequence2 : list) {
            String[] stringArray2 = geomSequence2.meshes();
            int n4 = stringArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                String string = stringArray2[n5];
                arrayList.add(geomSequence2.getModel().mesh(string));
                ++n5;
            }
        }
        return arrayList;
    }

    public static GeomSequence createDeformedGeom(Model model, int n2, String string) {
        return ((IGeomListInternal)model.geom()).doCreate(string, n2, GEOMSEQUENCE_TYPES.DEFORMED_CONFIGURATION, null, null);
    }

    public static GeomSequence getUndefGeom(GeomSequence geomSequence) {
        if (geomSequence == null) {
            return null;
        }
        if (geomSequence.isDeformed()) {
            return geomSequence.getUndefGeom();
        }
        return geomSequence;
    }

    public static GeomSequence getSolvedForConfig(GeomSequence geomSequence, StudyFeature studyFeature) {
        if (geomSequence == null) {
            return null;
        }
        if (studyFeature == null) {
            return DeformedConfigUtil.getUndefGeom(geomSequence);
        }
        if (!(geomSequence = DeformedConfigUtil.getUndefGeom(geomSequence)).isMainGeometry(false)) {
            return geomSequence;
        }
        Model model = geomSequence.getModel();
        String string = studyFeature.mesh(geomSequence.tag());
        if (!"nomesh".equals(string) && !model.mesh(string).getGeom().tag().equals(geomSequence.tag())) {
            return model.mesh(string).getGeom();
        }
        return geomSequence;
    }

    public static boolean equal(IGeomSequence iGeomSequence, IGeomSequence iGeomSequence2) {
        if (iGeomSequence == null && iGeomSequence2 == null) {
            return true;
        }
        if (iGeomSequence == null || iGeomSequence2 == null) {
            return false;
        }
        if (iGeomSequence.getSDim() != iGeomSequence2.getSDim()) {
            return false;
        }
        if (!Arrays.equals(iGeomSequence.getNEntities(), iGeomSequence2.getNEntities())) {
            return false;
        }
        int n2 = 0;
        while (n2 < iGeomSequence.getSDim()) {
            int n3 = n2;
            while (n3 < iGeomSequence.getSDim()) {
                if (!q.a((int[][])iGeomSequence.getAdj(n2, n3), (int[][])iGeomSequence2.getAdj(n2, n3))) {
                    return false;
                }
                ++n3;
            }
            ++n2;
        }
        return true;
    }
}

