/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util;

import com.comsol.model.data.Node;
import com.comsol.model.dbimodel.FEATURE_STATUS;
import com.comsol.model.dbimodel.GEOMSEQUENCE_TYPES;
import com.comsol.model.dbimodel.GeomFeature;
import com.comsol.model.dbimodel.GeomInfo;
import com.comsol.model.dbimodel.GeomObject;
import com.comsol.model.dbimodel.GeomObjectSelectionFeature;
import com.comsol.model.dbimodel.GeomObjectSelectionFeatureList;
import com.comsol.model.dbimodel.GeomProblemFeature;
import com.comsol.model.dbimodel.GeomProblemFeatureList;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.GeomSubsequenceCallFeature;
import com.comsol.model.dbimodel.HL_TYPES;
import com.comsol.model.dbimodel.History;
import com.comsol.model.dbimodel.MODEL_NODE_TYPES;
import com.comsol.model.dbimodel.MeshSequence;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelNode;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.SelectionFeature;
import com.comsol.model.dbimodel.UNIT_TYPES;
import com.comsol.model.dbimodel.Unit;
import com.comsol.model.dbimodel.UnitList;
import com.comsol.model.dbimodel.WorkPlaneFeature;
import com.comsol.model.method.GeomContainerMethod;
import com.comsol.model.method.GeomObjectMethod;
import com.comsol.model.method.UnitSystemMethod;
import com.comsol.model.method.internal.IGeomSequenceInternal;
import com.comsol.model.method.internal.IModelInternal;
import com.comsol.model.method.internal.IUnitInternal;
import com.comsol.model.method.internal.IUnitSystemInternal;
import com.comsol.model.operations.IGeomOperation;
import com.comsol.model.savepoint.interfaces.IGeomContainer;
import com.comsol.model.savepoint.interfaces.IGeomSequence;
import com.comsol.model.savepoint.interfaces.IMeshSequence;
import com.comsol.model.savepoint.interfaces.IModel;
import com.comsol.model.util.AppMethodFileUtil;
import com.comsol.model.util.IModelManager;
import com.comsol.model.util.LicenseRequirement;
import com.comsol.model.util.ModelInternalUtil;
import com.comsol.model.util.ModelType;
import com.comsol.nativemph.a.g;
import com.comsol.nativemph.a.h;
import com.comsol.nativemph.cache.CacheManager;
import com.comsol.nativemph.geom.Geom;
import com.comsol.nativemph.geom.Geom3;
import com.comsol.nativemph.util.b;
import com.comsol.nativeutil.d.b;
import com.comsol.nativeutil.data.RenderDraw;
import com.comsol.nativeutil.data.RenderDrawGeom;
import com.comsol.nativeutil.data.RenderGeom;
import com.comsol.nativeutil.data.RenderLevel;
import com.comsol.nativeutil.preferences.Preferences;
import com.comsol.nativeutil.properties.InvalidPropertyValueException;
import com.comsol.systemutils.SystemUtil;
import com.comsol.util.classes.CsAngleInfo;
import com.comsol.util.classes.CsBitSet;
import com.comsol.util.classes.FileManagerUtil;
import com.comsol.util.classes.FlFileTypes;
import com.comsol.util.classes.GeomAdj;
import com.comsol.util.classes.af;
import com.comsol.util.exceptions.CadKernelException;
import com.comsol.util.exceptions.CsParserException;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.exceptions.LicenseException;
import com.comsol.util.interfaces.m;
import com.comsol.util.license.LicenseType;
import com.comsol.util.methods.FlFileUtil;
import com.comsol.util.methods.q;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class GeomSequenceUtil {
    private static /* synthetic */ int[] b;

    public static IUnitSystemInternal createBaseUnitSystem(IGeomSequence iGeomSequence, Model model, IUnitSystemInternal iUnitSystemInternal) {
        Node node = model.getNode().createNode("baseUnitSystem", "UnitSystem");
        IUnitSystemInternal iUnitSystemInternal2 = (IUnitSystemInternal)((Object)node.getObjectEntity());
        iGeomSequence.setBaseUnitSystem(iUnitSystemInternal2);
        GeomSequenceUtil.setBaseUnits(iUnitSystemInternal2, iUnitSystemInternal, iGeomSequence.lengthUnit(), iGeomSequence.angularUnit());
        iUnitSystemInternal2.resetConversionFactors();
        return iUnitSystemInternal2;
    }

    public static void setBaseUnits(IUnitSystemInternal iUnitSystemInternal, IUnitSystemInternal iUnitSystemInternal2, String string, String string2) {
        IUnitInternal iUnitInternal = iUnitSystemInternal2.getUnit(string);
        IUnitInternal iUnitInternal2 = iUnitSystemInternal2.getUnit("1");
        IUnitInternal iUnitInternal3 = iUnitSystemInternal2.getUnit("rad");
        IUnitInternal iUnitInternal4 = iUnitSystemInternal2.getUnit("deg");
        UnitList<? extends Unit> unitList = iUnitSystemInternal.getBaseUnit();
        unitList.clear();
        GeomSequenceUtil.a(unitList, iUnitInternal);
        unitList = iUnitSystemInternal.getDerivedUnit();
        unitList.clear();
        GeomSequenceUtil.a(unitList, iUnitInternal2);
        GeomSequenceUtil.a(unitList, iUnitInternal3);
        GeomSequenceUtil.a(unitList, iUnitInternal4);
        ((UnitSystemMethod)iUnitSystemInternal.method()).setupUnitHash(true);
    }

    private static Unit a(UnitList<?> unitList, IUnitInternal iUnitInternal) {
        IUnitInternal iUnitInternal2 = (IUnitInternal)unitList.create(iUnitInternal.tag(), iUnitInternal.dimension());
        if (UNIT_TYPES.BASE == unitList.getListType()) {
            iUnitInternal2.scale(1.0);
            iUnitInternal2.setSiScale(iUnitInternal.scale() * iUnitInternal.getSiScale());
        } else {
            iUnitInternal2.scale(iUnitInternal.scale());
            iUnitInternal2.setSiScale(iUnitInternal.getSiScale());
        }
        iUnitInternal2.symbol(iUnitInternal.symbol());
        iUnitInternal2.aliases(iUnitInternal.aliases());
        iUnitInternal2.quantity(iUnitInternal.quantity());
        return iUnitInternal2;
    }

    public static RenderGeom getRenderGeom(IGeomContainer iGeomContainer, RenderLevel renderLevel, int n2, String string, int[][] nArray, String string2, boolean bl2, boolean bl3) {
        Object object;
        IGeomSequence iGeomSequence;
        IGeomSequence iGeomSequence2 = iGeomSequence = iGeomContainer instanceof IGeomSequence ? (IGeomSequence)iGeomContainer : ((GeomObject)iGeomContainer).getSequence();
        if ("".equals(string)) {
            string = null;
        }
        long l2 = 0L;
        if (string != null) {
            l2 = ((IGeomSequenceInternal)iGeomSequence).getMeshKeepEntitiesKey(string);
        } else if (nArray != null) {
            l2 = GeomContainerMethod.calculateMeshControlHashKey(nArray);
        }
        long l3 = GeomSequenceUtil.a(iGeomContainer, l2, renderLevel.level);
        CacheManager cacheManager = CacheManager.getCacheManager();
        RenderGeom renderGeom = cacheManager.getRenderGeom(l3);
        if (bl2 && renderGeom != null && renderGeom.r()) {
            renderGeom = null;
        }
        if (renderGeom != null) {
            renderGeom.g(n2);
            return renderGeom;
        }
        long l4 = System.currentTimeMillis();
        if (iGeomSequence.isDefinedByMesh()) {
            object = null;
            IModel iModel = iGeomSequence.getModel();
            if (string == null) {
                for (IMeshSequence iMeshSequence : iModel.mesh()) {
                    if (!iMeshSequence.getGeom().equals(iGeomSequence)) continue;
                    object = iMeshSequence;
                    break;
                }
            } else {
                object = iModel.mesh(string);
            }
            if (object == null) {
                return null;
            }
            if (string != null) {
                if (!(object instanceof MeshSequence)) {
                    return null;
                }
                if (((MeshSequence)object).getMeshCurrent() == null) {
                    return null;
                }
                renderGeom = ((MeshSequence)object).getMeshCurrent().o(n2);
            } else {
                if (object.getMesh() == null) {
                    return null;
                }
                renderGeom = object.getMesh().o(n2);
            }
        } else {
            int[][] nArray2;
            object = iGeomContainer.getGeom();
            if (object == null) {
                return null;
            }
            if (string != null) {
                MeshSequence meshSequence = (MeshSequence)iGeomSequence.getModel().mesh(string);
                nArray2 = meshSequence.getConstructionEntitiesToKeep();
            } else {
                nArray2 = nArray != null ? nArray : new int[0][0];
            }
            renderGeom = object.a(renderLevel.level, n2, nArray2, string2, bl2);
        }
        int n3 = (int)(System.currentTimeMillis() - l4);
        cacheManager.addRenderGeom(l3, n3, renderGeom, bl3);
        return renderGeom;
    }

    private static long a(IGeomContainer iGeomContainer, long l2, int n2) {
        if (iGeomContainer instanceof IGeomSequence) {
            return CacheManager.getKey((long)(((IGeomSequence)iGeomContainer).getGeomId() + l2), (String)("RenderGeom" + n2));
        }
        return ((GeomObjectMethod)((GeomObject)iGeomContainer).method()).getRenderCacheTag(n2);
    }

    public static String[] meshes(IGeomSequence iGeomSequence) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IMeshSequence iMeshSequence : iGeomSequence.getModel().mesh()) {
            if (!iMeshSequence.getGeom().tag().equals(iGeomSequence.tag())) continue;
            arrayList.add(iMeshSequence.tag());
        }
        return arrayList.toArray(new String[0]);
    }

    public static IMeshSequence getMeshMaster(IGeomSequence iGeomSequence) {
        if (iGeomSequence.isDefinedByMesh()) {
            for (IMeshSequence iMeshSequence : iGeomSequence.getModel().mesh()) {
                if (!iMeshSequence.getGeom().tag().equals(iGeomSequence.tag())) continue;
                return iMeshSequence;
            }
        }
        return null;
    }

    public static MeshSequence meshMaster(GeomSequence geomSequence) {
        if (geomSequence.isDefinedByMesh()) {
            for (MeshSequence meshSequence : geomSequence.getModel().mesh()) {
                if (!meshSequence.getGeom().tag().equals(geomSequence.tag())) continue;
                return meshSequence;
            }
        }
        return null;
    }

    public static double getRadian(double d2, String string) {
        if (string.equals("deg")) {
            return d2 * Math.PI / 180.0;
        }
        if (string.equals("rad")) {
            return d2;
        }
        throw new RuntimeException("Unknown angular unit. " + string);
    }

    public static double getRotation(double d2, String string) {
        if (string.equals("deg")) {
            return d2 * 180.0 / Math.PI;
        }
        if (string.equals("rad")) {
            return d2;
        }
        throw new RuntimeException("Unknown angular unit. " + string);
    }

    public static double getRotationFromDegree(double d2, String string) {
        if (string.equals("deg")) {
            return d2;
        }
        if (string.equals("rad")) {
            return d2 * Math.PI / 180.0;
        }
        throw new RuntimeException("Unknown angular unit. " + string);
    }

    public static boolean isInValidState(GeomFeature geomFeature) {
        GeomFeature geomFeature2 = geomFeature.getOperation().getSelectionEnd();
        if (geomFeature2 == null) {
            geomFeature2 = geomFeature;
        }
        GeomSequence geomSequence = geomFeature2.getSequence();
        return geomSequence.isCurrentStateCorrect(geomSequence.getPreceding(geomFeature2.tag()));
    }

    public static boolean isInValidStateIgnoreCumSelKey(GeomFeature geomFeature) {
        GeomFeature geomFeature2 = geomFeature.getOperation().getSelectionEnd();
        if (geomFeature2 == null) {
            geomFeature2 = geomFeature;
        }
        GeomSequence geomSequence = geomFeature2.getSequence();
        return geomSequence.isCurrentStateCorrectIgnoreCumSelKey(geomSequence.getPreceding(geomFeature2.buildTag()));
    }

    private static RenderDrawGeom a(IGeomContainer iGeomContainer, int n2) {
        RenderDraw renderDraw = null;
        if (iGeomContainer instanceof GeomObject) {
            renderDraw = ((GeomObject)iGeomContainer).getRenderDraw(n2);
        } else {
            IModel iModel = iGeomContainer.getModel();
            if (iModel instanceof Model && ((Model)iModel).isCreateReset()) {
                return null;
            }
            RenderLevel renderLevel = RenderLevel.c;
            RenderLevel[] renderLevelArray = RenderLevel.values();
            int n3 = renderLevelArray.length;
            int n4 = 0;
            while (n4 < n3) {
                RenderLevel renderLevel2 = renderLevelArray[n4];
                if (renderLevel2.level == n2) {
                    renderLevel = renderLevel2;
                }
                ++n4;
            }
            renderDraw = iGeomContainer.getRenderGeom(renderLevel, 0);
        }
        return renderDraw;
    }

    public static int[] findEntitiesInBall(IGeomContainer iGeomContainer, int n2, double[] dArray, double d2, int n3, boolean bl2, int[] nArray) {
        RenderDrawGeom renderDrawGeom = GeomSequenceUtil.a(iGeomContainer, n2);
        if (renderDrawGeom == null) {
            return new int[0];
        }
        nArray = q.b((int[])nArray, (int)-1);
        int[] nArray2 = renderDrawGeom.a(dArray, d2, n3, bl2, nArray);
        nArray2 = q.b((int[])nArray2, (int)1);
        return nArray2;
    }

    public static boolean isInBall(GeomObject geomObject, int n2, double[] dArray, double d2, int n3, boolean bl2) {
        RenderDraw renderDraw = geomObject.getRenderDraw(n2);
        if (renderDraw == null) {
            return false;
        }
        int[] nArray = q.a((int)0, (int)1, (int)(geomObject.getNEntities()[n3] - 1));
        return renderDraw.b(dArray, d2, n3, bl2, nArray);
    }

    public static CsBitSet findVerticesInBall(IGeomContainer iGeomContainer, int n2, double d2, double[] dArray) {
        int n3 = iGeomContainer.getNVertices();
        CsBitSet csBitSet = new CsBitSet(n3 + 1);
        csBitSet.a(false);
        double[][] dArray2 = iGeomContainer.getVertexCoord();
        double d3 = d2 * d2;
        int n4 = 0;
        while (n4 < dArray2[0].length) {
            double d4 = 0.0;
            int n5 = 0;
            while (n5 < n2) {
                double d5 = dArray[n5] - dArray2[n5][n4];
                d4 += d5 * d5;
                ++n5;
            }
            if (d4 <= d3) {
                csBitSet.a(n4 + 1);
            }
            ++n4;
        }
        return csBitSet;
    }

    public static int[] findEntitiesInDisk(IGeomContainer iGeomContainer, int n2, double[] dArray, double d2, double d3, double d4, double d5, int n3, boolean bl2, int[] nArray) {
        RenderDrawGeom renderDrawGeom = GeomSequenceUtil.a(iGeomContainer, n2);
        if (renderDrawGeom == null) {
            return new int[0];
        }
        nArray = q.b((int[])nArray, (int)-1);
        int[] nArray2 = renderDrawGeom.a(dArray, d2, d3, d4, d5, n3, bl2, nArray);
        nArray2 = q.b((int[])nArray2, (int)1);
        return nArray2;
    }

    public static boolean isInDisk(GeomObject geomObject, int n2, double[] dArray, double d2, double d3, double d4, double d5, int n3, boolean bl2) {
        RenderDraw renderDraw = geomObject.getRenderDraw(n2);
        if (renderDraw == null) {
            return false;
        }
        int[] nArray = q.a((int)0, (int)1, (int)(geomObject.getNEntities()[n3] - 1));
        return renderDraw.b(dArray, d2, d3, d4, d5, n3, bl2, nArray);
    }

    public static CsBitSet findVerticesInDisk(IGeomContainer iGeomContainer, double[] dArray, double d2, double d3, double d4, double d5) {
        int n2 = iGeomContainer.getNVertices();
        CsBitSet csBitSet = new CsBitSet(n2 + 1);
        csBitSet.a(false);
        double[][] dArray2 = iGeomContainer.getVertexCoord();
        double d6 = d2 * d2;
        double d7 = d3 * d3;
        double d8 = Math.abs(d5 - d4);
        double[] dArray3 = new double[]{Math.cos(d4), Math.sin(d4)};
        double[] dArray4 = new double[]{Math.cos(d5), Math.sin(d5)};
        int n3 = 0;
        while (n3 < dArray2[0].length) {
            if (GeomSequenceUtil.isVertexInsideDisk(new double[]{dArray2[0][n3], dArray2[1][n3]}, dArray, d6, d7, d8, dArray3, dArray4)) {
                csBitSet.a(n3 + 1);
            }
            ++n3;
        }
        return csBitSet;
    }

    public static boolean isVertexInsideDisk(double[] dArray, double[] dArray2, double d2, double d3, double d4, double[] dArray3, double[] dArray4) {
        boolean bl2;
        boolean bl3;
        assert (dArray.length == 2 && dArray2.length == 2 && dArray3.length == 2 && dArray4.length == 2);
        double[] dArray5 = q.e((double[])dArray, (double[])dArray2);
        double d5 = q.c((double[])dArray5, (double[])dArray5);
        boolean bl4 = bl3 = d5 <= d2 && d5 >= d3;
        if (!bl3) {
            return false;
        }
        double d6 = q.b((double[])dArray5);
        if (d6 != 0.0) {
            dArray5 = q.b((double[])dArray5, (double)(1.0 / d6));
        }
        if (d4 > 6.283185307178586) {
            bl2 = true;
        } else {
            boolean bl5;
            boolean bl6 = dArray3[0] * dArray5[1] - dArray3[1] * dArray5[0] > -1.0E-6;
            boolean bl7 = bl5 = dArray4[0] * dArray5[1] - dArray4[1] * dArray5[0] < 1.0E-6;
            bl2 = d4 < 1.0E-6 ? q.c((double[])dArray5, (double[])dArray3) > -1.0E-6 && bl6 && bl5 : (d4 <= Math.PI ? bl6 && bl5 : bl6 || bl5);
        }
        return bl2;
    }

    public static int[] findEntitiesInBox(IGeomContainer iGeomContainer, int n2, double[] dArray, int n3, boolean bl2, int[] nArray) {
        RenderDrawGeom renderDrawGeom = GeomSequenceUtil.a(iGeomContainer, n2);
        if (renderDrawGeom == null) {
            return new int[0];
        }
        nArray = q.b((int[])nArray, (int)-1);
        int[] nArray2 = renderDrawGeom.a(dArray, n3, bl2, nArray);
        nArray2 = q.b((int[])nArray2, (int)1);
        return nArray2;
    }

    public static boolean isInBox(GeomObject geomObject, int n2, double[] dArray, int n3, boolean bl2) {
        RenderDraw renderDraw = geomObject.getRenderDraw(n2);
        if (renderDraw == null) {
            return false;
        }
        int[] nArray = q.a((int)0, (int)1, (int)(geomObject.getNEntities()[n3] - 1));
        return renderDraw.b(dArray, n3, bl2, nArray);
    }

    public static CsBitSet findVerticesInBox(IGeomContainer iGeomContainer, int n2, double[] dArray) {
        int n3 = iGeomContainer.getNVertices();
        CsBitSet csBitSet = new CsBitSet(n3 + 1);
        csBitSet.a(false);
        double[][] dArray2 = iGeomContainer.getVertexCoord();
        int n4 = 0;
        while (n4 < dArray2[0].length) {
            boolean bl2 = true;
            int n5 = 0;
            while (n5 < n2) {
                double d2 = dArray2[n5][n4];
                if (d2 < dArray[2 * n5] || d2 > dArray[2 * n5 + 1]) {
                    bl2 = false;
                    break;
                }
                ++n5;
            }
            if (bl2) {
                csBitSet.a(n4 + 1);
            }
            ++n4;
        }
        return csBitSet;
    }

    public static int[] findEntitiesInCylinder(IGeomContainer iGeomContainer, int n2, double[] dArray, double[] dArray2, double[] dArray3, double d2, double d3, double d4, double d5, double d6, double d7, int n3, boolean bl2, int[] nArray) {
        RenderDrawGeom renderDrawGeom = GeomSequenceUtil.a(iGeomContainer, n2);
        if (renderDrawGeom == null) {
            return new int[0];
        }
        nArray = q.b((int[])nArray, (int)-1);
        int[] nArray2 = renderDrawGeom.a(dArray, dArray2, dArray3, d2, d3, d4, d5, d6, d7, n3, bl2, nArray);
        nArray2 = q.b((int[])nArray2, (int)1);
        return nArray2;
    }

    public static boolean isInCylinder(GeomObject geomObject, int n2, double[] dArray, double[] dArray2, double[] dArray3, double d2, double d3, double d4, double d5, double d6, double d7, int n3, boolean bl2) {
        RenderDraw renderDraw = geomObject.getRenderDraw(n2);
        if (renderDraw == null) {
            return false;
        }
        int[] nArray = q.a((int)0, (int)1, (int)(geomObject.getNEntities()[n3] - 1));
        return renderDraw.b(dArray, dArray2, dArray3, d2, d3, d4, d5, d6, d7, n3, bl2, nArray);
    }

    public static CsBitSet findVerticesInCylinder(IGeomContainer iGeomContainer, double[] dArray, double[] dArray2, double[] dArray3, double d2, double d3, double d4, double d5, double d6, double d7) {
        int n2 = iGeomContainer.getNVertices();
        CsBitSet csBitSet = new CsBitSet(n2 + 1);
        csBitSet.a(false);
        double[][] dArray4 = iGeomContainer.getVertexCoord();
        double d8 = d2 * d2;
        double d9 = d3 * d3;
        double[] dArray5 = dArray2;
        q.c((double[])dArray5);
        double d10 = Math.abs(d7 - d6);
        double[] dArray6 = GeomSequenceUtil.rotate3Dvector(dArray5, dArray3, d6);
        double[] dArray7 = GeomSequenceUtil.rotate3Dvector(dArray5, dArray3, d7);
        double[] dArray8 = q.b((double[])dArray5, (double[])dArray6);
        double[] dArray9 = q.b((double[])dArray5, (double[])dArray7);
        int n3 = 0;
        while (n3 < dArray4[0].length) {
            double[] dArray10 = new double[]{dArray4[0][n3], dArray4[1][n3], dArray4[2][n3]};
            if (GeomSequenceUtil.isVertexInsideCylinder(dArray10, dArray, d8, d9, d4, d5, dArray5, d10, dArray6, dArray7, dArray8, dArray9)) {
                csBitSet.a(n3 + 1);
            }
            ++n3;
        }
        return csBitSet;
    }

    public static boolean isVertexInsideCylinder(double[] dArray, double[] dArray2, double d2, double d3, double d4, double d5, double[] dArray3, double d6, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7) {
        boolean bl2;
        boolean bl3;
        assert (dArray.length == 3 && dArray2.length == 3 && dArray3.length == 3 && dArray4.length == 3 && dArray5.length == 3 && dArray6.length == 3 && dArray7.length == 3);
        double[] dArray8 = q.e((double[])dArray, (double[])dArray2);
        double d7 = q.c((double[])dArray8, (double[])dArray8);
        double d8 = q.c((double[])dArray8, (double[])dArray3);
        double d9 = Math.abs(d7 - d8 * d8);
        boolean bl4 = bl3 = d5 <= d8 && d8 <= d4 && d3 <= d9 && d9 <= d2;
        if (!bl3) {
            return false;
        }
        double d10 = q.b((double[])dArray8);
        if (d10 != 0.0) {
            dArray8 = q.b((double[])dArray8, (double)(1.0 / d10));
        }
        if (d6 > 6.283185307178586) {
            bl2 = true;
        } else {
            boolean bl5;
            boolean bl6 = q.c((double[])dArray8, (double[])dArray6) > -1.0E-6;
            boolean bl7 = bl5 = q.c((double[])dArray8, (double[])dArray7) < 1.0E-6;
            bl2 = d6 < 1.0E-6 ? q.c((double[])dArray8, (double[])dArray4) > -1.0E-6 && bl6 && bl5 : (d6 <= Math.PI ? bl6 && bl5 : bl6 || bl5);
        }
        return bl2;
    }

    public static double[] rotate3Dvector(double[] dArray, double[] dArray2, double d2) {
        q.c((double[])dArray);
        double[] dArray3 = q.b((double[])dArray2, (double)Math.cos(d2));
        double[] dArray4 = q.b((double[])q.b((double[])dArray, (double[])dArray2), (double)Math.sin(d2));
        double[] dArray5 = q.b((double[])dArray, (double)(q.c((double[])dArray, (double[])dArray2) * (1.0 - Math.cos(d2))));
        double[] dArray6 = q.d((double[])q.d((double[])dArray3, (double[])dArray4), (double[])dArray5);
        return dArray6;
    }

    public static int[] findEntitiesAdjacentToVertices(IGeomContainer iGeomContainer, int n2, boolean bl2, CsBitSet csBitSet, int[] nArray) {
        int n3;
        int n4;
        Object object;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (n2 == 0) {
            object = nArray;
            n4 = nArray.length;
            n3 = 0;
            while (n3 < n4) {
                int n5 = object[n3];
                if (csBitSet.b(n5)) {
                    hashSet.add(n5);
                }
                ++n3;
            }
        } else {
            int n6;
            int n7;
            int[] nArray2;
            int[][] nArray3 = iGeomContainer.getAdj(n2, 0);
            if (bl2) {
                nArray2 = nArray;
                int n8 = nArray.length;
                n4 = 0;
                while (n4 < n8) {
                    n3 = nArray2[n4];
                    n7 = 1;
                    n6 = 0;
                    while (n6 < nArray3[n3].length) {
                        int n9 = nArray3[n3][n6];
                        if (!csBitSet.b(n9)) {
                            n7 = 0;
                            break;
                        }
                        ++n6;
                    }
                    if (n7 != 0) {
                        hashSet.add(n3);
                    }
                    ++n4;
                }
            } else {
                nArray2 = nArray;
                int n10 = nArray.length;
                n4 = 0;
                while (n4 < n10) {
                    n3 = nArray2[n4];
                    n7 = 0;
                    while (n7 < nArray3[n3].length) {
                        n6 = nArray3[n3][n7];
                        if (csBitSet.b(n6)) {
                            hashSet.add(n3);
                            break;
                        }
                        ++n7;
                    }
                    ++n4;
                }
            }
        }
        int[] nArray4 = new int[hashSet.size()];
        n3 = 0;
        object = hashSet.iterator();
        while (object.hasNext()) {
            n4 = (Integer)object.next();
            nArray4[n3++] = n4;
        }
        return nArray4;
    }

    public static int[] handleContinuousTangentMode(IGeomContainer iGeomContainer, int[] nArray, int[] nArray2, PropFeature propFeature) {
        int n2 = iGeomContainer.getSDim();
        int n3 = propFeature.getInt("entitydim");
        String string = propFeature.getString("condition");
        if ((n2 == 3 && (n3 == 2 || n3 == 1) || n2 == 2 && n3 == 1) && propFeature.getBoolean("groupcontang")) {
            try {
                double d2 = propFeature.getDouble("angletol");
                nArray = string.equals("intersects") || string.equals("somevertex") ? iGeomContainer.fillContinuousAdjacencyClasses(nArray, d2, n3, nArray2) : iGeomContainer.removeIncompleteContinuousAdjacencyClasses(nArray, d2, n3, nArray2);
            }
            catch (InvalidPropertyValueException invalidPropertyValueException) {
                return new int[0];
            }
            catch (CsParserException csParserException) {
                return new int[0];
            }
        }
        return nArray;
    }

    public static int[] fillContinuousAdjacencyClasses(IGeomContainer iGeomContainer, int[] nArray, double d2, int n2, int[] nArray2) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int[] nArray3 = nArray;
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray3[n4];
            if (!hashSet.contains(n5)) {
                int[] nArray4;
                int[] nArray5 = nArray4 = GeomSequenceUtil.getContinuousAdjacencyClass(iGeomContainer, n5, d2, n2, nArray2);
                int n6 = nArray4.length;
                int n7 = 0;
                while (n7 < n6) {
                    int n8 = nArray5[n7];
                    hashSet.add(n8);
                    ++n7;
                }
            }
            ++n4;
        }
        return q.a((Integer[])hashSet.toArray(new Integer[hashSet.size()]));
    }

    public static int[] removeIncompleteContinuousAdjacencyClasses(IGeomContainer iGeomContainer, int[] nArray, double d2, int n2, int[] nArray2) {
        int n3;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        HashSet<Integer> hashSet3 = new HashSet<Integer>();
        int[] nArray3 = nArray;
        int n4 = nArray.length;
        int n5 = 0;
        while (n5 < n4) {
            n3 = nArray3[n5];
            hashSet.add(n3);
            ++n5;
        }
        nArray3 = nArray;
        n4 = nArray.length;
        n5 = 0;
        while (n5 < n4) {
            n3 = nArray3[n5];
            if (!hashSet2.contains(n3) && !hashSet3.contains(n3)) {
                int[] nArray4;
                int[] nArray5 = nArray4 = GeomSequenceUtil.getContinuousAdjacencyClass(iGeomContainer, n3, d2, n2, nArray2);
                int n6 = nArray4.length;
                int n7 = 0;
                while (n7 < n6) {
                    int n8 = nArray5[n7];
                    hashSet3.add(n8);
                    if (!hashSet.contains(n8)) {
                        int[] nArray6 = nArray4;
                        int n9 = nArray4.length;
                        int n10 = 0;
                        while (n10 < n9) {
                            int n11 = nArray6[n10];
                            hashSet2.add(n11);
                            ++n10;
                        }
                        break;
                    }
                    ++n7;
                }
            }
            ++n5;
        }
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            n3 = (Integer)iterator.next();
            hashSet.remove(n3);
        }
        return q.a((Integer[])hashSet.toArray(new Integer[hashSet.size()]));
    }

    public static int[] getContinuousAdjacencyClass(IGeomContainer iGeomContainer, int n2, double d2, int n3, int[] nArray) {
        CsAngleInfo csAngleInfo = iGeomContainer.getMaxAngles(n3);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        int[] nArray2 = nArray;
        int n4 = nArray.length;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = nArray2[n5];
            hashSet2.add(n6);
            ++n5;
        }
        String string = GeomSequenceUtil.getAngularUnit(iGeomContainer);
        d2 = GeomSequenceUtil.getRadian(d2, string);
        int[][] nArray3 = iGeomContainer.getAdj(n3, n3 - 1);
        int[][] nArray4 = GeomSequenceUtil.a(iGeomContainer.getAdj(n3 - 1, n3), hashSet2);
        GeomSequenceUtil.a(n2, d2, nArray3, nArray4, n3, hashSet2, hashSet, csAngleInfo);
        return q.a((Integer[])hashSet.toArray(new Integer[hashSet.size()]));
    }

    public static String getAngularUnit(IGeomContainer iGeomContainer) {
        String string = "deg";
        if (iGeomContainer instanceof IGeomSequence) {
            GeomSequence geomSequence;
            IModel iModel = iGeomContainer.getModel();
            string = iModel.isSavePoint() ? ((geomSequence = iModel.getCurrentModel().savePoint(iModel.getTag()).geom().getCurrentGeom((IGeomSequence)iGeomContainer)) != null ? geomSequence.getAngularUnit() : ((GeomSequence)iGeomContainer).getAngularUnit()) : ((GeomSequence)iGeomContainer).getAngularUnit();
        } else if (iGeomContainer instanceof GeomObject) {
            GeomSequence geomSequence = ((GeomObject)iGeomContainer).getSequence();
            if (geomSequence != null) {
                string = geomSequence.angularUnit();
            }
        } else {
            throw new RuntimeException("Invalid IGeomContainer type");
        }
        return string;
    }

    private static int[][] a(int[][] nArray, HashSet<Integer> hashSet) {
        int[][] nArrayArray = new int[nArray.length][];
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3;
            arrayList.clear();
            int[] nArray2 = nArray[n2];
            int n4 = nArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                n3 = nArray2[n5];
                if (hashSet.contains(n3)) {
                    arrayList.add(n3);
                }
                ++n5;
            }
            int[] nArray3 = new int[arrayList.size()];
            n3 = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                n5 = (Integer)iterator.next();
                nArray3[n3++] = n5;
            }
            nArrayArray[n2] = nArray3;
            ++n2;
        }
        return nArrayArray;
    }

    private static void a(int n2, double d2, int[][] nArray, int[][] nArray2, int n3, HashSet<Integer> hashSet, HashSet<Integer> hashSet2, CsAngleInfo csAngleInfo) {
        if (!hashSet.contains(n2)) {
            return;
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        linkedList.add(n2);
        hashSet2.add(n2);
        while (!linkedList.isEmpty()) {
            int[] nArray3;
            int n4 = (Integer)linkedList.poll();
            int[] nArray4 = nArray3 = nArray[n4];
            int n5 = nArray3.length;
            int n6 = 0;
            while (n6 < n5) {
                double d3;
                int n7;
                int[] nArray5;
                int n8 = nArray4[n6];
                int n9 = -1;
                int[] nArray6 = nArray5 = nArray2[n8];
                int n10 = nArray5.length;
                int n11 = 0;
                while (n11 < n10) {
                    n7 = nArray6[n11];
                    if (n7 != n4 && hashSet.contains(n7)) {
                        if (!csAngleInfo.b(n8, n4, n7)) {
                            throw new FlException(String.valueOf(n3 == 2 ? "Edge " : "Vertex ") + n8 + " not adjacent to " + (n3 == 2 ? "faces " : "edges ") + n4 + ", " + n7);
                        }
                        d3 = csAngleInfo.a(n8, n4, n7);
                        if (d3 < d2) {
                            if (n9 != -1) {
                                n9 = -1;
                                break;
                            }
                            n9 = n7;
                        }
                    }
                    ++n11;
                }
                if (n9 != -1 && !hashSet2.contains(n9) && csAngleInfo.a(n8, n4, n9) < d2) {
                    n7 = 1;
                    int[] nArray7 = nArray5;
                    int n12 = nArray5.length;
                    n10 = 0;
                    while (n10 < n12) {
                        n11 = nArray7[n10];
                        if (n11 != n9 && n11 != n4 && (d3 = csAngleInfo.a(n8, n9, n11)) < d2) {
                            n7 = 0;
                            break;
                        }
                        ++n10;
                    }
                    if (n7 != 0) {
                        linkedList.add(n9);
                        hashSet2.add(n9);
                    }
                }
                ++n6;
            }
        }
    }

    public static int[][] getRealToVirtualMap(Geom geom, IModel iModel, String string) {
        Geom3 geom3 = (Geom3)geom;
        if (geom3 == null) {
            return null;
        }
        if (string == null) {
            return geom3.c(null);
        }
        MeshSequence meshSequence = (MeshSequence)iModel.mesh(string);
        return geom3.c(meshSequence.getConstructionEntitiesToKeep());
    }

    public static boolean exportManifoldBodies(Geom geom, String string, double d2) {
        if (geom == null) {
            return false;
        }
        File file = FileManagerUtil.c((String)string, (String)m.a);
        if (new FlFileTypes(FlFileTypes.Type.M).accept(new File(string))) {
            g g2 = new g(file, false);
            String string2 = "7.0";
            g2.a(new Geom3[]{(Geom3)geom}, false, d2, string2, true);
        } else {
            h h2 = new h(file.getAbsolutePath(), null, null);
            h2.a((Geom[])new Geom3[]{(Geom3)geom}, true, 1.0 / d2, -1, true);
        }
        FileManagerUtil.a((File)file, (String)string, (String)m.a);
        return true;
    }

    public static void copySettingsFrom(IGeomSequence iGeomSequence, GeomSequence geomSequence) {
        geomSequence.axisymmetric(iGeomSequence.isAxisymmetric());
        geomSequence.setUnits(iGeomSequence.lengthUnit(), iGeomSequence.angularUnit());
        geomSequence.setRepairtol(iGeomSequence.getRepairtol());
    }

    public static int[][] getUpDownBnds(GeomInfo geomInfo, int[] nArray) {
        int[][] nArray2 = geomInfo.getUpDown();
        boolean[] blArray = new boolean[geomInfo.getNDomains() + 1];
        int[] nArray3 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray3[n3];
            if (n4 > 0 && n4 < blArray.length) {
                blArray[n4] = true;
            }
            ++n3;
        }
        int[][] nArrayArray = new int[2][];
        n3 = 0;
        while (n3 < 2) {
            n2 = 0;
            int n5 = 0;
            while (n5 < nArray2[n3].length) {
                if (nArray2[n3][n5] > 0 && blArray[nArray2[n3][n5]]) {
                    ++n2;
                }
                ++n5;
            }
            nArrayArray[n3] = new int[n2];
            n5 = 0;
            int n6 = 0;
            while (n6 < nArray2[n3].length) {
                if (nArray2[n3][n6] > 0 && blArray[nArray2[n3][n6]]) {
                    nArrayArray[n3][n5++] = n6 + 1;
                }
                ++n6;
            }
            ++n3;
        }
        return nArrayArray;
    }

    public static String trimmedTag(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.lastIndexOf(".");
        if (n2 != -1) {
            return string.substring(0, n2);
        }
        return string;
    }

    public static String getLevelLabel(int n2, int n3) {
        if (n3 == -1) {
            return "obj";
        }
        if (n3 == n2) {
            return "dom";
        }
        if (n3 == n2 - 1) {
            return "bnd";
        }
        if (n3 == 1) {
            return "edg";
        }
        return "pnt";
    }

    public static int getLevelLabelInv(int n2, String string) {
        if ("obj".equals(string)) {
            return -1;
        }
        if ("dom".equals(string)) {
            return n2;
        }
        if ("bnd".equals(string)) {
            return n2 - 1;
        }
        if ("edg".equals(string)) {
            return 1;
        }
        return 0;
    }

    public static String getShowSelectionDescription(GEOMSEQUENCE_TYPES gEOMSEQUENCE_TYPES) {
        if (gEOMSEQUENCE_TYPES == GEOMSEQUENCE_TYPES.SUBSEQUENCE) {
            return "Show_in_instances";
        }
        if (gEOMSEQUENCE_TYPES == GEOMSEQUENCE_TYPES.WORK_PLANE) {
            return "Show_in_3D";
        }
        return "Show_in_physics";
    }

    public static String get3DSelectionFullTag(String string, String string2, int n2) {
        String string3 = String.valueOf(string) + "_" + GeomSequenceUtil.trimmedTag(string2);
        String string4 = string2.contains(".") ? GeomSequenceUtil.getLevelLabel(3, n2) : null;
        return string4 != null ? String.valueOf(string3) + "." + string4 : string3;
    }

    public static GeomObjectSelectionFeature get3DSelection(WorkPlaneFeature workPlaneFeature, GeomObjectSelectionFeature geomObjectSelectionFeature, boolean bl2) {
        String string = GeomSequenceUtil.get3DSelectionFullTag(workPlaneFeature.tag(), geomObjectSelectionFeature.tag(), geomObjectSelectionFeature.getDim());
        GeomObjectSelectionFeatureList<? extends GeomObjectSelectionFeature> geomObjectSelectionFeatureList = workPlaneFeature.getSequence().selection();
        int n2 = geomObjectSelectionFeatureList.index(string);
        if (n2 >= 0) {
            String string2;
            GeomObjectSelectionFeature geomObjectSelectionFeature2 = (GeomObjectSelectionFeature)geomObjectSelectionFeatureList.get(n2);
            if (bl2 && !(string2 = geomObjectSelectionFeature.label()).equals(geomObjectSelectionFeature2.getEntityName())) {
                geomObjectSelectionFeature2.setEntityName(string2);
            }
            return geomObjectSelectionFeature2;
        }
        if (bl2) {
            GeomObjectSelectionFeature geomObjectSelectionFeature3 = workPlaneFeature.getCreateObjectSelection(string);
            geomObjectSelectionFeature3.setEntityName(geomObjectSelectionFeature.label());
            geomObjectSelectionFeature3.setCategory(6);
            workPlaneFeature.update3DSelection(geomObjectSelectionFeature);
            return geomObjectSelectionFeature3;
        }
        return null;
    }

    public static String get2DSelectionFullTag(String string, String string2, int n2) {
        String string3 = String.valueOf(string) + "_" + GeomSequenceUtil.trimmedTag(string2);
        String string4 = string2.contains(".") ? GeomSequenceUtil.getLevelLabel(2, n2 - 1) : null;
        return string4 != null ? String.valueOf(string3) + "." + string4 : string3;
    }

    public static GeomObjectSelectionFeature get2DSelection(WorkPlaneFeature workPlaneFeature, GeomObjectSelectionFeature geomObjectSelectionFeature) {
        String string = String.valueOf(workPlaneFeature.tag()) + "_";
        if (geomObjectSelectionFeature.tag().startsWith(string)) {
            String string2 = GeomSequenceUtil.trimmedTag(geomObjectSelectionFeature.tag().substring(string.length()));
            return workPlaneFeature.getSequence2D().method().getSelection(string2, geomObjectSelectionFeature.getDim());
        }
        return null;
    }

    public static String makeUniqueTagForSelectionFromGeom(GeomSequence geomSequence, String string, String string2) {
        String string3 = String.valueOf(geomSequence.tag()) + "_" + string.replace(".", "_");
        if (string2 != null && string2.equals(string3)) {
            return string3;
        }
        if (geomSequence.getModel().selection().index(string3) != -1) {
            string3 = geomSequence.getModel().selection().uniquetag(string3);
        }
        return string3;
    }

    public static CsBitSet hDimToDim(CsBitSet csBitSet, IGeomContainer iGeomContainer, int n2, int n3, List<HL_TYPES> list) {
        HL_TYPES hL_TYPES2;
        if (csBitSet == null) {
            throw new IllegalArgumentException("Internal error in selection.");
        }
        int n4 = iGeomContainer.getSDim();
        if (n2 >= n3 || n3 > n4 || n2 < 0) {
            throw new RuntimeException("Internal error in selection.");
        }
        boolean bl2 = false;
        boolean bl3 = false;
        for (HL_TYPES hL_TYPES2 : list) {
            switch (GeomSequenceUtil.a()[hL_TYPES2.ordinal()]) {
                case 1: {
                    bl2 = true;
                    break;
                }
                case 2: {
                    bl3 = true;
                    break;
                }
            }
        }
        hL_TYPES2 = new CsBitSet(iGeomContainer.getNEntities()[n2] + 1);
        GeomAdj geomAdj = iGeomContainer.getGeomAdj();
        if (bl3) {
            CsBitSet csBitSet2 = GeomSequenceUtil.a(csBitSet, n2, n3, geomAdj);
            if (bl2) {
                hL_TYPES2 = csBitSet2;
            } else {
                CsBitSet csBitSet3 = GeomSequenceUtil.b(csBitSet, n2, n3, geomAdj);
                hL_TYPES2 = csBitSet2.c(csBitSet3);
            }
        } else if (bl2) {
            hL_TYPES2 = GeomSequenceUtil.b(csBitSet, n2, n3, geomAdj);
        }
        return hL_TYPES2;
    }

    private static CsBitSet a(CsBitSet csBitSet, int n2, int n3, GeomAdj geomAdj) {
        CsBitSet csBitSet2 = new CsBitSet(geomAdj.a(n2) + 1);
        int[][] nArray = geomAdj.a(n3, n2);
        int n4 = geomAdj.b(n3);
        int[] nArray2 = csBitSet.g();
        int n5 = nArray2.length;
        int n6 = 0;
        while (n6 < n5) {
            int n7 = nArray2[n6];
            int[] nArray3 = nArray[n7 + n4];
            int n8 = nArray3.length;
            int n9 = 0;
            while (n9 < n8) {
                int n10 = nArray3[n9];
                csBitSet2.a(n10);
                ++n9;
            }
            ++n6;
        }
        return csBitSet2;
    }

    private static CsBitSet b(CsBitSet csBitSet, int n2, int n3, GeomAdj geomAdj) {
        CsBitSet csBitSet2 = GeomSequenceUtil.a(csBitSet, n3, geomAdj);
        if (n3 == n2 + 1) {
            return csBitSet2;
        }
        return GeomSequenceUtil.a(csBitSet2, n2, n3 - 1, geomAdj);
    }

    private static CsBitSet a(CsBitSet csBitSet, int n2, GeomAdj geomAdj) {
        int[][] nArray = geomAdj.a(n2, n2 - 1);
        byte[][] byArray = geomAdj.b(n2, n2 - 1);
        int n3 = geomAdj.b(n2);
        int n4 = geomAdj.a(n2 - 1) + 1;
        int[] nArray2 = new int[n4];
        int[] nArray3 = csBitSet.g();
        int n5 = nArray3.length;
        int n6 = 0;
        while (n6 < n5) {
            int n7 = nArray3[n6];
            int[] nArray4 = nArray[n7 + n3];
            byte[] byArray2 = byArray[n7 + n3];
            int n8 = nArray4.length;
            int n9 = 0;
            while (n9 < n8) {
                int n10 = nArray4[n9];
                nArray2[n10] = nArray2[n10] + Math.abs(byArray2[n9]);
                ++n9;
            }
            ++n6;
        }
        CsBitSet csBitSet2 = new CsBitSet(n4);
        n6 = 0;
        while (n6 < nArray2.length) {
            if (nArray2[n6] == 1) {
                csBitSet2.a(n6);
            }
            ++n6;
        }
        return csBitSet2;
    }

    public static boolean hasObjectLevelSourceSelection(SelectionFeature selectionFeature) {
        String string;
        IGeomOperation iGeomOperation;
        GeomFeature geomFeature;
        GeomObjectSelectionFeature geomObjectSelectionFeature = selectionFeature.getSourceSelection();
        return geomObjectSelectionFeature != null && (geomFeature = selectionFeature.getSourceSelection().getOwner()) != null && (iGeomOperation = geomFeature.getOperation()) != null && iGeomOperation.isGeomSelection() && (string = geomObjectSelectionFeature.tag()) != null && string.contains(".");
    }

    public static GeomFeature resolveGeomFeature(String[] stringArray, Model model) {
        if (stringArray.length < 2) {
            throw new FlException("Found_no_feature_to_copy");
        }
        GeomSequence geomSequence = model.geom(stringArray[0]);
        GeomFeature geomFeature = geomSequence.feature(stringArray[1]);
        boolean bl2 = false;
        int n2 = 2;
        while (n2 < stringArray.length) {
            geomSequence = null;
            if (geomFeature instanceof WorkPlaneFeature) {
                geomSequence = ((WorkPlaneFeature)geomFeature).getSequence2D();
            } else if (geomFeature instanceof GeomSubsequenceCallFeature) {
                geomSequence = bl2 ? ((GeomSubsequenceCallFeature)geomFeature).getStoredLocalSubsequence() : ((GeomSubsequenceCallFeature)geomFeature).getLocalSubsequence();
            }
            String string = stringArray[n2];
            bl2 = string.endsWith("$");
            if (bl2) {
                string = string.substring(0, string.length() - 1);
            }
            geomFeature = geomSequence == null ? geomFeature.feature(string) : geomSequence.feature(string);
            ++n2;
        }
        return geomFeature;
    }

    public static GeomSequence resolveGeomSequence(String[] stringArray, Model model) {
        GeomSequence geomSequence = model.geom(stringArray[0]);
        int n2 = 1;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            boolean bl2 = string.endsWith("$");
            if (bl2) {
                string = string.substring(0, string.length() - 1);
            }
            GeomFeature geomFeature = geomSequence.feature(string);
            geomSequence = null;
            if (geomFeature instanceof WorkPlaneFeature) {
                geomSequence = ((WorkPlaneFeature)geomFeature).getSequence2D();
            } else if (geomFeature instanceof GeomSubsequenceCallFeature) {
                geomSequence = bl2 ? ((GeomSubsequenceCallFeature)geomFeature).getStoredLocalSubsequence() : ((GeomSubsequenceCallFeature)geomFeature).getLocalSubsequence();
            }
            ++n2;
        }
        return geomSequence;
    }

    public static boolean containsCadLicense(LicenseRequirement[] licenseRequirementArray) {
        LicenseRequirement[] licenseRequirementArray2 = licenseRequirementArray;
        int n2 = licenseRequirementArray.length;
        int n3 = 0;
        while (n3 < n2) {
            LicenseRequirement licenseRequirement = licenseRequirementArray2[n3];
            boolean bl2 = false;
            LicenseType[] licenseTypeArray = licenseRequirement.getProducts();
            int n4 = licenseTypeArray.length;
            int n5 = 0;
            while (n5 < n4) {
                LicenseType licenseType = licenseTypeArray[n5];
                if (!(LicenseType.CADIMPORT.equals((Object)licenseType) || LicenseType.DESIGN.equals((Object)licenseType) || LicenseType.CATIA5.equals((Object)licenseType) || LicenseType.LLAUTOCAD.equals((Object)licenseType) || LicenseType.LLCREOPARAMETRIC.equals((Object)licenseType) || LicenseType.LLINVENTOR.equals((Object)licenseType) || LicenseType.LLPROENGINEER.equals((Object)licenseType) || LicenseType.LLSOLIDEDGE.equals((Object)licenseType) || LicenseType.LLSOLIDWORKS.equals((Object)licenseType) || LicenseType.LLREVIT.equals((Object)licenseType))) {
                    bl2 = true;
                    break;
                }
                ++n5;
            }
            if (!bl2) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static void checkOutCad(GeomFeature geomFeature) {
        try {
            com.comsol.nativeutil.d.b.e((LicenseType)LicenseType.CADIMPORT);
        }
        catch (LicenseException licenseException) {
            String string = "This_feature_requires_CAD_Import_Module_functionality";
            if (geomFeature != null) {
                GeomSequenceUtil.createFeatureErrorNode(geomFeature, string);
                licenseException.prependMessage("Feature_X#" + geomFeature.label());
            }
            licenseException.prependMessage(string);
            throw licenseException;
        }
    }

    public static void throwCadKernelException(GeomFeature geomFeature) {
        GeomSequenceUtil.createFeatureErrorNode(geomFeature, "This_feature_requires_the_CAD_kernel");
        throw new CadKernelException(geomFeature.label(), geomFeature.getSequence().label());
    }

    public static void createFeatureErrorNode(GeomFeature geomFeature, String string) {
        History history = geomFeature.getModel().hist();
        history.disable();
        try {
            geomFeature.resetProblems();
            GeomProblemFeatureList<? extends GeomFeature> geomProblemFeatureList = geomFeature.problem();
            GeomProblemFeature geomProblemFeature = (GeomProblemFeature)geomProblemFeatureList.create("error", "GeomError");
            geomProblemFeature.set("message", string);
            geomFeature.setBuildStatus(FEATURE_STATUS.ERROR);
        }
        finally {
            history.enable();
        }
    }

    public static long getModifyTime(Model model) {
        long l2 = model.getEntityModifyTime();
        if (l2 == 0L) {
            l2 = model.getEntityCreationTime();
        }
        return l2;
    }

    public static String resolveLinkedSubsequenceFile(Model model, String string) {
        IModelManager iModelManager = ModelInternalUtil.getModelManager();
        String string2 = model.tag();
        String string3 = null;
        try {
            string3 = iModelManager.getModelPath(string2);
        }
        catch (FlException flException) {}
        m m2 = af.g();
        string = string.replace("\\", SystemUtil.getClientFileSeparator()).replace("/", SystemUtil.getClientFileSeparator());
        String string4 = m2.a(string, string3, GeomSequenceUtil.getSubsequenceSearchPath(model.modelPath()), string2);
        if (string4 != null) {
            return string4;
        }
        FlException flException = new FlException("File_not_found");
        flException.addParameterPair("Filename", string);
        throw flException;
    }

    public static Model loadPartModel(IModelInternal iModelInternal, String string, String string2) throws IOException {
        String string3;
        boolean bl2;
        if (iModelInternal.getModelType() == ModelType.APPLICATION_MODEL || af.g().b(string)) {
            bl2 = true;
            string3 = AppMethodFileUtil.resolveFile(iModelInternal, string, false).getAbsolutePath();
        } else {
            bl2 = false;
            string3 = GeomSequenceUtil.resolveLinkedSubsequenceFile(iModelInternal, string);
        }
        return ModelInternalUtil.load(string2, string3, (b.b)new b.d(), bl2);
    }

    public static boolean isPartModelProtected(Model model, String string) {
        String string2;
        boolean bl2;
        if (model.getModelType() == ModelType.APPLICATION_MODEL || af.g().b(string)) {
            bl2 = true;
            string2 = AppMethodFileUtil.resolveFile(model, string, false).getAbsolutePath();
        } else {
            bl2 = false;
            string2 = GeomSequenceUtil.resolveLinkedSubsequenceFile(model, string);
        }
        return FlFileUtil.b((String)string2, (boolean)bl2);
    }

    public static String getSubsequenceSearchPath(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = Preferences.getInstance().getUserLibraryPaths("geometry.library.userpartlibraries");
        String string2 = SystemUtil.getClientPathSeparator();
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string3 = stringArray2[n3];
            stringBuilder.append(string3).append(string2);
            ++n3;
        }
        stringBuilder.append(SystemUtil.getPartsRoot());
        if (string != null && (string = string.trim()).length() > 0) {
            stringBuilder.append(string2).append(string);
        }
        return stringBuilder.toString();
    }

    public static String getType(GeomSequence geomSequence) {
        if (geomSequence.isMeshPart()) {
            return "MESH_PART";
        }
        ModelNode modelNode = geomSequence.getParentModel();
        if (modelNode != null && modelNode.getModelType() == MODEL_NODE_TYPES.EXTRA_DIMENSION) {
            if (modelNode.getDerivedFrom() != null) {
                return "HIDDEN";
            }
            return "EXTRA_DIMENSION";
        }
        GEOMSEQUENCE_TYPES gEOMSEQUENCE_TYPES = geomSequence.getSequenceType();
        if (gEOMSEQUENCE_TYPES == GEOMSEQUENCE_TYPES.PARTICLE || gEOMSEQUENCE_TYPES == GEOMSEQUENCE_TYPES.RAY) {
            return "HIDDEN";
        }
        return gEOMSEQUENCE_TYPES.getDisplayName();
    }

    public static boolean containsProgrammingNodes(GeomSequence geomSequence) {
        for (PropFeature propFeature : geomSequence.feature()) {
            GeomFeature geomFeature = (GeomFeature)propFeature;
            if (geomFeature.getOperation().isProgramming()) {
                return true;
            }
            if (!(geomFeature instanceof WorkPlaneFeature) || !GeomSequenceUtil.containsProgrammingNodes(geomFeature.geom())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsVirtual(GeomSequence geomSequence) {
        if (!geomSequence.hasFinalizedGeometry()) {
            return false;
        }
        if (geomSequence.exists() && geomSequence.hasVirtualRep()) {
            return true;
        }
        for (PropFeature propFeature : geomSequence.feature()) {
            if (!((GeomFeature)propFeature).getOperation().isVirtual()) continue;
            return true;
        }
        return false;
    }

    public static boolean containsMeshControl(GeomSequence geomSequence) {
        if (!geomSequence.hasFinalizedGeometry() || !geomSequence.exists()) {
            return false;
        }
        return !Arrays.equals(geomSequence.getNEntities(), geomSequence.getNEntitiesMesh());
    }

    public static String getLiveLinkNodeType(GeomSequence geomSequence) {
        for (PropFeature propFeature : geomSequence.feature()) {
            LicenseType[] licenseTypeArray;
            IGeomOperation iGeomOperation = ((GeomFeature)propFeature).getOperation();
            if (!iGeomOperation.isLiveLink() || (licenseTypeArray = iGeomOperation.getRequiredLicense()) == null) continue;
            return licenseTypeArray[0].getProductTag();
        }
        return null;
    }

    public static int combineDim(int n2, int n3) {
        if (n2 == -2) {
            return n3;
        }
        if (n3 == n2 || n3 == -2) {
            return n2;
        }
        return -1;
    }

    public static double[][] getOrderedVtxCoord(GeomObject geomObject, int n2) {
        double[][] dArray = geomObject.getVertexCoord();
        int[] nArray = geomObject.getAdj(1, 0, n2);
        int[] nArray2 = geomObject.getAdjOrient(1, 0, n2);
        double[][] dArrayArray = new double[2][];
        int n3 = 0;
        while (n3 < 2) {
            int n4 = nArray2[n3] == 1 ? 0 : 1;
            dArrayArray[n4] = new double[]{dArray[0][nArray[n3] - 1], dArray[1][nArray[n3] - 1]};
            ++n3;
        }
        return dArrayArray;
    }

    public static void throwMethodNotAllowed(String string) {
        FlException flException = new FlException("This_method_is_not_allowed_in_this_context");
        flException.addParameterPair("Method", string);
        throw flException;
    }

    public static String getCoordName(GeomSequence geomSequence, int n2) {
        if (geomSequence == null) {
            return "#x" + n2;
        }
        return geomSequence.getCoordName(n2, geomSequence.isWorkPlane());
    }

    public static double getScaleFactor(GeomSequence geomSequence, GeomSequence geomSequence2) {
        if (geomSequence2.hasAnyUnit() && geomSequence.hasAnyUnit()) {
            return geomSequence.getUnitConverter().convertUnit(geomSequence2.getLengthUnit())[1];
        }
        return 1.0;
    }

    public static boolean isInCorrectStateForShowingInputSelection(GeomSequence geomSequence, GeomProblemFeature geomProblemFeature) {
        if (geomProblemFeature.getContainer() == null) {
            return false;
        }
        GeomFeature geomFeature = (GeomFeature)geomProblemFeature.getContainer().getContainer();
        String string = geomFeature.tag();
        if (geomProblemFeature.getOperation().isError()) {
            string = geomSequence.getPreceding(string);
        }
        return geomSequence.isCurrentStateCorrect(string);
    }

    public static boolean isInCorrectStateForShowingInputSelection(GeomSequence geomSequence, GeomFeature geomFeature, String string) {
        String string2 = geomSequence.getPreceding(string);
        return geomSequence.isCurrentStateCorrect(string2);
    }

    public static int getRenderEventViewDim(GeomSequence geomSequence) {
        PrimitiveModelEntity primitiveModelEntity = geomSequence.getContainer();
        if (primitiveModelEntity instanceof WorkPlaneFeature && ((WorkPlaneFeature)primitiveModelEntity).getBoolean("workplane3d")) {
            return 3;
        }
        return geomSequence.getSDim();
    }

    static /* synthetic */ int[] a() {
        if (b != null) {
            return b;
        }
        int[] nArray = new int[HL_TYPES.values().length];
        try {
            nArray[HL_TYPES.EXTERIOR.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HL_TYPES.INTERIOR.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HL_TYPES.MESHINTERIOR.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        b = nArray;
        return nArray;
    }
}

