/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util;

import com.comsol.model.dbimodel.CopiedPrimitiveObject;
import com.comsol.model.dbimodel.CopyPasteInfo;
import com.comsol.model.dbimodel.MODEL_NODE_TYPES;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.ModelEntityList;
import com.comsol.model.dbimodel.ModelNode;
import com.comsol.model.dbimodel.NodeGroup;
import com.comsol.model.dbimodel.NodeGroupList;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.SelectionContainer;
import com.comsol.model.dbimodel.View;
import com.comsol.model.dbimodel.design.Design;
import com.comsol.model.dbimodel.physics.Physics;
import com.comsol.model.definitions.IDefinitionsList;
import com.comsol.model.operations.IDesignBaseOperation;
import com.comsol.model.operations.OperationManager;
import com.comsol.model.operations.OperationType;
import com.comsol.model.operations.operationID.NodeGroupOperationID;
import com.comsol.model.util.ModelEntityUtil;
import com.comsol.model.util.ModelType;
import com.comsol.util.methods.l;
import com.comsol.util.methods.q;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class NodeGroupUtil {
    public static Object NULL_CONTEXT = new Object();
    private static /* synthetic */ int[] a;

    public static void addToGroup(NodeGroup nodeGroup, ModelEntity modelEntity) {
        String string = nodeGroup.getOperation().getTypeForEntity(modelEntity);
        if (string == null) {
            nodeGroup.add(modelEntity.tag());
        } else {
            nodeGroup.add(string, modelEntity.tag());
        }
    }

    public static void removeFromGroup(NodeGroup nodeGroup, ModelEntity modelEntity, boolean bl2) {
        String string = nodeGroup.getOperation().getTypeForEntity(modelEntity);
        if (string == null) {
            nodeGroup.remove(modelEntity.tag(), bl2);
        } else {
            nodeGroup.remove(string, modelEntity.tag(), bl2);
        }
    }

    public static void placeAfter(NodeGroup nodeGroup, ModelEntity modelEntity) {
        if (modelEntity == null) {
            nodeGroup.placeAfter(null);
        } else {
            String string = nodeGroup.getOperation().getTypeForEntity(modelEntity);
            if (string == null) {
                nodeGroup.placeAfter(modelEntity.tag());
            } else {
                nodeGroup.placeAfter(string, modelEntity.tag());
            }
        }
    }

    public static void placeAfterLastInNoGroupOrAfterSiblingGroups(NodeGroup nodeGroup, ModelEntityList<? extends ModelEntity> modelEntityList, Predicate<ModelEntity> predicate) {
        Object object;
        Object object2 = null;
        int n2 = -1;
        int n3 = modelEntityList.size() - 1;
        while (n3 >= 0) {
            object = modelEntityList.get(n3);
            if (object.getNodeGroup() == null && predicate.test((ModelEntity)object)) {
                object2 = object;
                n2 = n3;
                break;
            }
            --n3;
        }
        NodeGroupList<? extends NodeGroup> nodeGroupList = nodeGroup.getModel().nodeGroup();
        object = nodeGroup.getOperation();
        int n4 = nodeGroupList.size() - 1;
        while (n4 >= 0) {
            NodeGroup nodeGroup2 = (NodeGroup)nodeGroupList.get(n4);
            if (nodeGroup2 != nodeGroup && object.areSiblings(nodeGroup, nodeGroup2)) {
                int n5;
                ModelEntity modelEntity = nodeGroup2.getAfter();
                int n6 = n5 = modelEntity != null ? modelEntityList.index(modelEntity.tag()) : -1;
                if (n2 > n5) {
                    NodeGroupUtil.placeAfter(nodeGroup, (ModelEntity)object2);
                } else {
                    nodeGroupList.move(nodeGroup.tag(), n4 + 1);
                }
                return;
            }
            --n4;
        }
        NodeGroupUtil.placeAfter(nodeGroup, (ModelEntity)object2);
    }

    public static int getEdimForPhysicsGroup(NodeGroup nodeGroup) {
        if (!(nodeGroup.getContext() instanceof Physics)) {
            throw new IllegalArgumentException("Not a node group for a physics interface. Group tag: " + nodeGroup.tag());
        }
        Physics physics = (Physics)nodeGroup.getContext();
        int n2 = physics.getGeom() != null ? physics.getGeom().getSDim() : 0;
        String string = nodeGroup.getString("edim");
        int n3 = -1;
        while (n3 <= n2) {
            if (string.equals(l.a((int)n2, (int)n3, (boolean)false).toLowerCase(Locale.ENGLISH))) {
                return n3;
            }
            ++n3;
        }
        throw new IllegalStateException("Could not determine edim for " + nodeGroup.getDisplayString());
    }

    public static String getEdimStringValueForPhysicsGroup(Physics physics, int n2) {
        return l.a((int)(physics.getGeom() != null ? physics.getGeom().getSDim() : 0), (int)n2, (boolean)false).toLowerCase(Locale.ENGLISH);
    }

    public static ModelEntityList<? extends ModelEntity> getListForResultsNodeGroupTypeString(Model model, String string) {
        switch (string) {
            case "plotgroup": {
                return model.result().getFeature();
            }
            case "evaluationgroup": {
                return model.result().evaluationGroup();
            }
            case "dataset": {
                return model.result().dataset();
            }
            case "numerical": {
                return model.result().numerical();
            }
            case "export": {
                return model.result().export();
            }
            case "table": {
                return model.result().table();
            }
            case "report": {
                return model.result().report();
            }
            case "view": {
                return model.view();
            }
        }
        throw new IllegalStateException("Could not determine list for " + string);
    }

    public static String getTypeStringValueForResultsGroup(ModelEntity modelEntity) {
        return NodeGroupUtil.getTypeStringValueForResultsGroup((ModelEntityList)modelEntity.getContainer());
    }

    public static String getTypeStringValueForResultsGroup(ModelEntityList<?> modelEntityList) {
        Model model = modelEntityList.getModel();
        if (modelEntityList == model.result().getFeature()) {
            return "plotgroup";
        }
        if (modelEntityList == model.result().evaluationGroup()) {
            return "evaluationgroup";
        }
        if (modelEntityList == model.result().dataset()) {
            return "dataset";
        }
        if (modelEntityList == model.result().numerical()) {
            return "numerical";
        }
        if (modelEntityList == model.result().export()) {
            return "export";
        }
        if (modelEntityList == model.result().table()) {
            return "table";
        }
        if (modelEntityList == model.result().report()) {
            return "report";
        }
        if (modelEntityList == model.view()) {
            return "view";
        }
        throw new IllegalArgumentException("Cannot find type value for " + modelEntityList.getDisplayString());
    }

    public static String getTypeStringDescriptionForResultsGroup(ModelEntity modelEntity) {
        Model model = modelEntity.getModel();
        PrimitiveModelEntity primitiveModelEntity = modelEntity.getContainer();
        if (primitiveModelEntity == model.result().getFeature()) {
            return "Plot_groups";
        }
        if (primitiveModelEntity == model.result().evaluationGroup()) {
            return "Evaluation_groups";
        }
        if (primitiveModelEntity == model.result().dataset()) {
            return "Data_sets";
        }
        if (primitiveModelEntity == model.result().numerical()) {
            return "Derived_values";
        }
        if (primitiveModelEntity == model.result().export()) {
            return "Export";
        }
        if (primitiveModelEntity == model.result().table()) {
            return "Tables";
        }
        if (primitiveModelEntity == model.result().report()) {
            return "Reports";
        }
        if (primitiveModelEntity == model.view()) {
            return "Views";
        }
        throw new IllegalArgumentException("Cannot find type value for " + modelEntity.getDisplayString());
    }

    public static Predicate<ModelEntity> getEntityFilterForResultList(ModelEntityList<? extends ModelEntity> modelEntityList) {
        if (modelEntityList == modelEntityList.getModel().view()) {
            return modelEntity -> ((View)modelEntity).getGeomSequence() == null;
        }
        return modelEntity -> true;
    }

    public static ModelEntityList<? extends ModelEntity>[] getGlobalDefinitionsMemberLists(Model model) {
        return new ModelEntityList[]{model.param().group(), model.variable(), model.func(), model.methodCall(), model.form(), model.group(), model.common(), model.geom(), model.mesh(), model.material(), model.modelNode(), model.reduced()};
    }

    public static ModelEntityList<? extends ModelEntity>[] getDefinitionsMemberLists(Model model, ModelNode modelNode) {
        boolean bl2 = modelNode.getModelType() == MODEL_NODE_TYPES.STANDARD;
        boolean bl3 = modelNode.getGeom() != null;
        ArrayList<ModelEntityList<SelectionContainer>> arrayList = new ArrayList<ModelEntityList<SelectionContainer>>();
        arrayList.add(model.variable());
        arrayList.add(model.common());
        if (bl2) {
            arrayList.add(model.massProp());
            arrayList.add(model.func());
            arrayList.add(model.probe());
        }
        if (bl3) {
            if (bl2) {
                arrayList.add(model.cpl());
            }
            arrayList.add(model.selection());
            if (bl2) {
                arrayList.add(model.pair());
            }
            arrayList.add(model.coordSystem());
            arrayList.add(model.extraDim());
            arrayList.add(model.view());
        }
        return arrayList.toArray(new ModelEntityList[arrayList.size()]);
    }

    public static ModelEntityList<? extends ModelEntity> getListForGlobalDefNodeListType(Model model, String string) {
        ModelEntityList<? extends ModelEntity>[] modelEntityListArray = NodeGroupUtil.getGlobalDefinitionsMemberLists(model);
        int n2 = modelEntityListArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ModelEntityList<? extends ModelEntity> modelEntityList = modelEntityListArray[n3];
            if (string.equals(((IDefinitionsList)((Object)modelEntityList)).getDefinitionsInfo().getListType())) {
                return modelEntityList;
            }
            ++n3;
        }
        throw new IllegalArgumentException("Could not find list for type value: " + string);
    }

    public static ModelEntityList<? extends ModelEntity> getListForDefinitionsNodeListType(Model model, ModelNode modelNode, String string) {
        ModelEntityList<? extends ModelEntity>[] modelEntityListArray = NodeGroupUtil.getDefinitionsMemberLists(model, modelNode);
        int n2 = modelEntityListArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ModelEntityList<? extends ModelEntity> modelEntityList = modelEntityListArray[n3];
            if (string.equals(((IDefinitionsList)((Object)modelEntityList)).getDefinitionsInfo().getListType())) {
                return modelEntityList;
            }
            ++n3;
        }
        throw new IllegalArgumentException("Could not find list for type value: " + string);
    }

    /*
     * Unable to fully structure code
     */
    public static void addChildrenIncludingNodeGroups(List<Object> var0, ModelEntityList<? extends ModelEntity> var1_1, List<? extends NodeGroup> var2_2, Predicate<ModelEntity> var3_3) {
        var4_4 = var1_1.stream().filter(var3_3).collect(Collectors.toList());
        var5_5 = null;
        var6_6 = 0;
        var7_7 = 0;
        ** GOTO lbl23
        {
            var0.add(var2_2.get(var7_7));
            ++var7_7;
            block1: do {
                if (var7_7 < var2_2.size() && var2_2.get(var7_7).getAfter() == var5_5) continue block0;
                if (var7_7 < var2_2.size()) {
                    var5_5 = var2_2.get(var7_7).getAfter();
                }
                while (var6_6 < var4_4.size() && ((ModelEntity)var4_4.get(var6_6)).getNodeGroup() != null) {
                    ++var6_6;
                }
                while (var6_6 < var4_4.size() && ((ModelEntity)var4_4.get(var6_6)).getNodeGroup() == null) {
                    var8_8 = (ModelEntity)var4_4.get(var6_6);
                    var0.add(var8_8);
                    ++var6_6;
                    if (var8_8 == var5_5) continue block1;
                }
lbl23:
                // 3 sources

            } while (var6_6 < var4_4.size() || var7_7 < var2_2.size());
        }
    }

    public static OperationType getApplicationOperationType(NodeGroupOperationID nodeGroupOperationID) {
        switch (NodeGroupUtil.a()[nodeGroupOperationID.ordinal()]) {
            case 1: {
                return OperationType.APPLICATION_INPUT_OUTPUT;
            }
            case 2: {
                return OperationType.APPLICATION_FORMS;
            }
            case 3: {
                return OperationType.APPLICATION_EVENTS;
            }
            case 4: {
                return OperationType.APPLICATION_FIELDS;
            }
            case 5: {
                return OperationType.APPLICATION_METHODS;
            }
        }
        return null;
    }

    public static boolean iterateBackwards(NodeGroup nodeGroup) {
        return nodeGroup.getContext() instanceof Physics && ((Physics)nodeGroup.getContext()).groupBySpaceDimension() && "none".equals(nodeGroup.getString("edim"));
    }

    public static ModelEntityList<?>[] getPhysicsBuilderTopLevelListsForId(Design design, NodeGroupOperationID nodeGroupOperationID) {
        switch (NodeGroupUtil.a()[nodeGroupOperationID.ordinal()]) {
            case 14: {
                return new ModelEntityList[]{design.physicsMaker(), design.materialGroup()};
            }
            case 12: {
                return new ModelEntityList[]{design.physicsMaker()};
            }
            case 13: {
                return new ModelEntityList[]{design.materialGroup()};
            }
        }
        return new ModelEntityList[]{design.include(), design.physicsFeature(), design.physicsProperty(), design.multiphysicsCoupling(), design.physicsInterface(), design.physicsArea(), design.xdimComponent()};
    }

    public static NodeGroupOperationID getGroupIdForPhysicsBuilderGroup(ModelEntity modelEntity) {
        if (modelEntity.getModel().getModelType() != ModelType.DESIGN) {
            return null;
        }
        Object t2 = ModelEntityUtil.getContainingList(modelEntity);
        if (t2 == null) {
            return null;
        }
        if (!(modelEntity instanceof PropFeature)) {
            return null;
        }
        Design design = (Design)modelEntity.getModel();
        PropFeature propFeature = (PropFeature)modelEntity;
        if (!(propFeature.getOperation() instanceof IDesignBaseOperation)) {
            return null;
        }
        if (t2.getContainer() != design) {
            return NodeGroupOperationID.PHYSICS_BUILDER;
        }
        String string = propFeature.getOperationID();
        NodeGroupOperationID[] nodeGroupOperationIDArray = NodeGroupOperationID.PHYSICS_BUILDER_IDS;
        int n2 = NodeGroupOperationID.PHYSICS_BUILDER_IDS.length;
        int n3 = 0;
        while (n3 < n2) {
            NodeGroupOperationID nodeGroupOperationID = nodeGroupOperationIDArray[n3];
            Object[] objectArray = NodeGroupUtil.getPhysicsBuilderIdsFromGroupId(nodeGroupOperationID);
            if (objectArray != null && q.a((Object[])objectArray, (Object)string)) {
                return nodeGroupOperationID;
            }
            ++n3;
        }
        return NodeGroupOperationID.PHYSICS_BUILDER;
    }

    public static String[] getPhysicsBuilderIdsFromGroupId(NodeGroupOperationID nodeGroupOperationID) {
        Object[] objectArray = OperationManager.getAllowedSequenceOperations(OperationType.DESIGN_SELECTIONS, null);
        if (nodeGroupOperationID == NodeGroupOperationID.PHYSICS_BUILDER_SELECTION) {
            return objectArray;
        }
        switch (NodeGroupUtil.a()[nodeGroupOperationID.ordinal()]) {
            case 12: {
                return (String[])q.b((Object[])OperationManager.getAllowedSequenceOperations(OperationType.DESIGNMAKER, null), (Object[])objectArray);
            }
            case 13: {
                return (String[])q.b((Object[])OperationManager.getAllowedSequenceOperations(OperationType.DESIGN_DEFINITIONS_LIBRARY, null), (Object[])objectArray);
            }
        }
        return null;
    }

    public static String getMembersAsString(NodeGroup nodeGroup) {
        StringBuilder stringBuilder = new StringBuilder("[");
        nodeGroup.stream().map(modelEntity -> ((PropFeature)modelEntity).getOperationID()).distinct().forEach(string -> {
            StringBuilder stringBuilder2 = stringBuilder.append((String)string).append(", ");
        });
        int n2 = stringBuilder.length();
        if (n2 == 1) {
            stringBuilder.append(']');
        } else {
            stringBuilder.setCharAt(n2 - 2, ']');
            stringBuilder.setLength(n2 - 1);
        }
        return stringBuilder.toString();
    }

    public static String[] getMembersSafe(NodeGroup nodeGroup) {
        if (nodeGroup.isClipboardCopy()) {
            CopyPasteInfo copyPasteInfo = nodeGroup.getPasteInfo();
            String string2 = copyPasteInfo.getCopiedPath(nodeGroup);
            CopiedPrimitiveObject copiedPrimitiveObject = copyPasteInfo.getReferencedObject(string2);
            return Optional.ofNullable(copiedPrimitiveObject.getString("memberIDs")).map(string -> q.b((String)string)).orElse(null);
        }
        return (String[])nodeGroup.stream().map(modelEntity -> ((PropFeature)modelEntity).getOperationID()).distinct().toArray(String[]::new);
    }

    public static void handleNodeGroupReferenceInPaste(ModelEntity modelEntity, ModelEntity modelEntity2, CopyPasteInfo copyPasteInfo) {
        ModelEntity modelEntity3;
        String string;
        if (modelEntity2.getNodeGroup() != null && (string = copyPasteInfo.getPastedPath(copyPasteInfo.getCopiedPath(modelEntity2.getNodeGroup()))) != null && (modelEntity3 = ModelEntityUtil.findEntity(null, modelEntity.getModel(), string.split("/"), 1)) instanceof NodeGroup) {
            ((NodeGroup)modelEntity3).moveOnAddRemove(false);
            try {
                NodeGroupUtil.addToGroup((NodeGroup)modelEntity3, modelEntity);
            }
            finally {
                ((NodeGroup)modelEntity3).moveOnAddRemove(true);
            }
        }
    }

    static /* synthetic */ int[] a() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[NodeGroupOperationID.values().length];
        try {
            nArray[NodeGroupOperationID.APP_DECLARATION.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeGroupOperationID.APP_EVENT.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeGroupOperationID.APP_FORM.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeGroupOperationID.APP_INPUT_OUTPUT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeGroupOperationID.APP_METHOD.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeGroupOperationID.DEFINITIONS.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeGroupOperationID.GLOBALDEFINITIONS.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeGroupOperationID.MATERIAL.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeGroupOperationID.PHYSICS.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeGroupOperationID.PHYSICS_BUILDER.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeGroupOperationID.PHYSICS_BUILDER_AUX.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeGroupOperationID.PHYSICS_BUILDER_MAKER.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeGroupOperationID.PHYSICS_BUILDER_SELECTION.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeGroupOperationID.RESULTS.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }
}

