/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util;

import com.comsol.model.applapi.SimpleSelection;
import com.comsol.model.applapi.XDSimpleSelection;
import com.comsol.model.data.Node;
import com.comsol.model.data.Root;
import com.comsol.model.data.primitive.DReference;
import com.comsol.model.data.primitive.LocalSelectionPrim;
import com.comsol.model.data.primitive.PrimitiveParent;
import com.comsol.model.data.primitive.XDLocalSelectionPrim;
import com.comsol.model.dbimodel.ExtraDimFeature;
import com.comsol.model.dbimodel.GeomInfo;
import com.comsol.model.dbimodel.GeomObject;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.IXDSelection;
import com.comsol.model.dbimodel.LocalSelection;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.PropValue;
import com.comsol.model.dbimodel.SavePointData;
import com.comsol.model.dbimodel.SavePointGeom;
import com.comsol.model.dbimodel.Selection;
import com.comsol.model.dbimodel.SelectionFeature;
import com.comsol.model.dbimodel.SelectionList;
import com.comsol.model.dbimodel.XDLocalSelection;
import com.comsol.model.dbimodel.physics.Physics;
import com.comsol.model.savepoint.interfaces.IGeomSequence;
import com.comsol.model.selections.ISelectionFilter;
import com.comsol.util.classes.an;
import com.comsol.util.classes.bg;
import com.comsol.util.exceptions.PhysicsAPIException;
import com.comsol.util.methods.FlLocale;
import com.comsol.util.methods.FlStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class SelectionModelUtil {
    private static Set<String> a = new HashSet<String>();
    private static boolean b = true;

    public static boolean byPassUsedNamedSelectionCheck(Model model, boolean bl2) {
        if (model == null) {
            return false;
        }
        Model model2 = model.getCurrentModel();
        boolean bl3 = a.contains(model2.tag());
        if (bl2) {
            a.add(model2.tag());
        } else {
            a.remove(model2.tag());
        }
        return bl3;
    }

    public static boolean isUsedNamedSelection(SelectionFeature selectionFeature) {
        if (selectionFeature == null || !(selectionFeature.getContainer() instanceof SelectionList)) {
            return false;
        }
        String string = selectionFeature.tag();
        Model model = selectionFeature.getModel();
        if (a.contains(model.getCurrentModel().tag())) {
            return false;
        }
        Boolean bl2 = selectionFeature.getUsedSelectionCache();
        if (bl2 != null) {
            return bl2;
        }
        for (SelectionList selectionList : SelectionModelUtil.getAllSelectionLists(model)) {
            if (!selectionList.hasTag(string)) continue;
            Root root = model.getNode().getRoot();
            Object t2 = selectionList.get(string);
            List<bg<Node, DReference>> list = root.getReferenceDatabase().getReferrerNodes(t2.getNode());
            for (bg<Node, DReference> bg2 : list) {
                PrimitiveParent primitiveParent = ((DReference)bg2.b).getOwner();
                if (!(primitiveParent instanceof Selection) && !(primitiveParent instanceof PropValue)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<SelectionList> getAllSelectionLists(Model model) {
        LinkedHashSet<SelectionList> linkedHashSet = new LinkedHashSet<SelectionList>();
        linkedHashSet.add(model.selection());
        for (GeomSequence geomSequence : model.physicsGeom()) {
            linkedHashSet.addAll(SelectionModelUtil.getAllSelectionLists(model, geomSequence, false));
        }
        return linkedHashSet;
    }

    public static Set<SelectionList> getAllSelectionLists(Model model, IGeomSequence iGeomSequence, boolean bl2) {
        LinkedHashSet<SelectionList> linkedHashSet = new LinkedHashSet<SelectionList>();
        IGeomSequence iGeomSequence2 = iGeomSequence;
        if (iGeomSequence.getModel().isSavePoint()) {
            String object = iGeomSequence.getModel().tag();
            if (model.savePoint().hasTag(object)) {
                iGeomSequence2 = model.savePoint(object).geom().getCurrentGeom(iGeomSequence);
                if (iGeomSequence2 == null) {
                    return linkedHashSet;
                }
            } else {
                return linkedHashSet;
            }
        }
        linkedHashSet.add(model.selection());
        for (SavePointData savePointData : model.savePoint()) {
            SavePointGeom savePointGeom = savePointData.geom().getSavePointGeom(iGeomSequence2);
            if (savePointGeom == null || bl2 && savePointGeom.isSelectionsLocked()) continue;
            linkedHashSet.add(savePointGeom.selection());
        }
        return linkedHashSet;
    }

    public static int[] assocLight(int n2, int n3, int[] nArray) {
        an an2 = new an();
        int[] nArray2 = nArray;
        int n4 = nArray.length;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = nArray2[n5];
            if (n2 <= n6 && n6 <= n3) {
                an2.add(n6);
            }
            ++n5;
        }
        return an2.toArray();
    }

    public static boolean allEntitiesValid(Selection selection, int n2, int[] nArray) {
        int n3 = selection.getNEntities(n2);
        int[] nArray2 = nArray;
        int n4 = nArray.length;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = nArray2[n5];
            if (n6 > n3) {
                return false;
            }
            ++n5;
        }
        return true;
    }

    public static boolean isFeatureUsedBySelection(PropFeature propFeature) {
        Root root = propFeature.getModel().getNode().getRoot();
        List<bg<Node, DReference>> list = root.getReferenceDatabase().getReferrerNodes(propFeature.getNode());
        for (bg<Node, DReference> bg2 : list) {
            PrimitiveParent primitiveParent = ((DReference)bg2.b).getOwner();
            if (!(primitiveParent instanceof XDLocalSelection)) continue;
            return true;
        }
        return false;
    }

    public static void resetXDSelections(ExtraDimFeature extraDimFeature) {
        Root root = extraDimFeature.getModel().getNode().getRoot();
        List<bg<Node, DReference>> list = root.getReferenceDatabase().getReferrerNodes(extraDimFeature.getNode());
        for (bg<Node, DReference> bg2 : list) {
            PrimitiveParent primitiveParent = ((DReference)bg2.b).getOwner();
            if (!(primitiveParent instanceof XDLocalSelection)) continue;
            ((XDLocalSelection)((Object)primitiveParent)).extraDim("");
        }
    }

    public static boolean isExtraDimProductSelection(Selection selection) {
        return selection instanceof IXDSelection && !"".equals(((IXDSelection)selection).extraDim());
    }

    public static int getMinEntityIndex(GeomInfo geomInfo, int n2) {
        if (geomInfo instanceof GeomObject) {
            return 1;
        }
        if (b && n2 == geomInfo.getSDim()) {
            return -geomInfo.getNFiniteVoids();
        }
        return 1;
    }

    public static int getMinEntityIndex(IGeomSequence iGeomSequence, int n2) {
        if (b && n2 > 0 && n2 == iGeomSequence.getSDim()) {
            return -iGeomSequence.getNFiniteVoids();
        }
        return 1;
    }

    public static int getMinEntityIndex(int n2, int n3, int n4) {
        if (b && n4 > 0 && n4 == n2) {
            return -n3;
        }
        return 1;
    }

    public static int getMinEntityIndex(GeomSequence geomSequence, int n2) {
        return SelectionModelUtil.getMinEntityIndex((GeomInfo)geomSequence, n2);
    }

    public static int getMinEntityIndexFiltered(Selection selection, IGeomSequence iGeomSequence) {
        if (!b) {
            return 1;
        }
        if (selection.inputDimension() != iGeomSequence.getSDim()) {
            return 1;
        }
        ISelectionFilter iSelectionFilter = selection.getSelectionFilter();
        if (iSelectionFilter == null || !iSelectionFilter.allowVoidDomains()) {
            return 1;
        }
        return -iGeomSequence.getNFiniteVoids();
    }

    public static int getMinEntityIndexFiltered(Selection selection) {
        return SelectionModelUtil.getMinEntityIndexFiltered(selection, selection.getGeomSequence());
    }

    public static String[] getDomainDescriptions(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            stringArray[n2] = SelectionModelUtil.getDomainDescription(nArray[n2]);
            ++n2;
        }
        return stringArray;
    }

    public static String getDomainDescription(int n2) {
        if (n2 > 0) {
            return String.valueOf(n2);
        }
        if (n2 < 0) {
            return FlLocale.getString((String)("Finite_void_X#" + String.valueOf(Math.abs(n2))));
        }
        return FlLocale.getString((String)"Infinite_void");
    }

    public static boolean anyPhysicsAllowVoids(Model model, String string) {
        if (!model.modelNode().hasTag(string)) {
            return false;
        }
        for (Physics physics : model.physics()) {
            if (!string.equals(physics.model()) || !physics.getApp().allowVoidDomains()) continue;
            return true;
        }
        return false;
    }

    public static int getSDimMax(Model model, GeomSequence geomSequence, int[] nArray, int n2) {
        int n3 = -1;
        Object object = model.physics().iterator();
        while (object.hasNext()) {
            Physics physics = (Physics)object.next();
            if (!geomSequence.model().equals(physics.model())) continue;
            n3 = Math.max(n3, physics.getApp().getSDimMax());
        }
        int n4 = nArray[n2 != -1 ? n2 : nArray.length - 1];
        if (n3 != -1) {
            n4 = Math.min(n3, n4);
        }
        if ((object = (Object)geomSequence.getNEntities())[n4] == false) {
            int n5 = nArray.length - 2;
            while (n5 >= 0) {
                if (object[nArray[n5]] > 0) {
                    return nArray[n5];
                }
                --n5;
            }
        }
        return n4;
    }

    private static boolean a(Selection selection, Selection selection2) {
        if (selection instanceof SimpleSelection) {
            return ((SimpleSelection)selection).isEquals(selection2);
        }
        if (!selection.geom().equals(selection2.geom())) {
            return false;
        }
        if (selection.getDim() != selection2.getDim()) {
            return false;
        }
        return Arrays.equals(selection.entities(selection.getDim()), selection2.entities(selection2.getDim()));
    }

    public static Selection doXDUnionOperator(IXDSelection iXDSelection, Selection selection3, Function<Selection, Selection> function) {
        if (SelectionModelUtil.isExtraDimProductSelection(selection3)) {
            boolean bl2 = SelectionModelUtil.a(iXDSelection, selection3);
            if (bl2) {
                IXDSelection iXDSelection2 = (IXDSelection)iXDSelection.copySelection();
                List<Selection> list = SelectionModelUtil.applyXDOperator(iXDSelection2.getXdSelection(), ((IXDSelection)selection3).getXdSelection(), (selection, selection2) -> selection.union((Selection)selection2));
                SelectionModelUtil.setXDselections(iXDSelection2, list);
                return iXDSelection2;
            }
            if (SelectionModelUtil.isXDEqual(iXDSelection.getXdSelection(), ((IXDSelection)selection3).getXdSelection())) {
                return function.apply(selection3);
            }
            throw SelectionModelUtil.a(iXDSelection, selection3, "Multiple_production_selections_is_not_allowed");
        }
        if (SelectionModelUtil.isExtraDimProductSelection(iXDSelection)) {
            throw SelectionModelUtil.a(iXDSelection, selection3, "union");
        }
        return function.apply(selection3);
    }

    private static PhysicsAPIException a(IXDSelection iXDSelection, Selection selection, String string) {
        PhysicsAPIException physicsAPIException = new PhysicsAPIException("Union_is_not_supported_for_those_selections");
        physicsAPIException.appendMessage(string);
        physicsAPIException.addParameterPair("Selection 1", iXDSelection.toString());
        physicsAPIException.addParameterPair("Selection 2", selection.toString());
        return physicsAPIException;
    }

    public static Selection doXDIntersectionOperator(IXDSelection iXDSelection, Selection selection3, Function<Selection, Selection> function) {
        Selection selection4 = function.apply(selection3);
        if (SelectionModelUtil.isExtraDimProductSelection(selection3)) {
            IXDSelection iXDSelection2 = (IXDSelection)selection4;
            List<Selection> list = SelectionModelUtil.applyXDOperator(iXDSelection2.getXdSelection(), ((IXDSelection)selection3).getXdSelection(), (selection, selection2) -> selection.intersection((Selection)selection2));
            SelectionModelUtil.setXDselections(iXDSelection2, list);
        }
        return selection4;
    }

    public static Selection setXDselections(IXDSelection iXDSelection, List<Selection> list) {
        if (iXDSelection instanceof XDSimpleSelection) {
            ListIterator<Selection> listIterator = ((XDSimpleSelection)iXDSelection).getXdSelection().listIterator();
            Iterator<Selection> iterator = list.iterator();
            while (listIterator.hasNext()) {
                listIterator.next();
                listIterator.set(iterator.next());
            }
            return iXDSelection;
        }
        if (iXDSelection instanceof XDLocalSelectionPrim) {
            XDLocalSelectionPrim xDLocalSelectionPrim = (XDLocalSelectionPrim)iXDSelection;
            List<? extends LocalSelectionPrim> list2 = xDLocalSelectionPrim.getXdSelection();
            Iterator<? extends LocalSelectionPrim> iterator = list2.iterator();
            Iterator<Selection> iterator2 = list.iterator();
            while (iterator.hasNext()) {
                LocalSelectionPrim localSelectionPrim = iterator.next();
                LocalSelection localSelection = xDLocalSelectionPrim.extraDimSel(localSelectionPrim.geom());
                localSelection.set(iterator2.next().entities(localSelectionPrim.getDim()));
            }
            return iXDSelection;
        }
        throw new RuntimeException("Internal error");
    }

    public static Selection doXDDifferenceOperator(IXDSelection iXDSelection, Selection selection3, Function<Selection, Selection> function) {
        if (SelectionModelUtil.isExtraDimProductSelection(selection3)) {
            IXDSelection iXDSelection2;
            List<? extends Selection> list;
            List<? extends Selection> list2 = iXDSelection.getXdSelection();
            if (SelectionModelUtil.isXDEqual(list2, list = (iXDSelection2 = (IXDSelection)iXDSelection.intersection(selection3)).getXdSelection())) {
                return function.apply(selection3);
            }
            if (SelectionModelUtil.isXDEmpty(list)) {
                return iXDSelection;
            }
            if (SelectionModelUtil.a(iXDSelection, iXDSelection2)) {
                List<Selection> list3 = SelectionModelUtil.applyXDOperator(list2, list, (selection, selection2) -> selection.difference((Selection)selection2));
                SelectionModelUtil.setXDselections(iXDSelection, list3);
                return iXDSelection;
            }
            PhysicsAPIException physicsAPIException = new PhysicsAPIException("Multiple_production_selections_is_not_allowed");
            physicsAPIException.addParameterPair("Selection 1", iXDSelection.toString());
            physicsAPIException.addParameterPair("Selection 2", selection3.toString());
            throw physicsAPIException;
        }
        return function.apply(selection3);
    }

    public static List<Selection> applyXDOperator(List<? extends Selection> list, List<? extends Selection> list2, BiFunction<Selection, Selection, Selection> biFunction) {
        if (list.size() != list2.size()) {
            throw new RuntimeException("Internal error");
        }
        ArrayList<Selection> arrayList = new ArrayList<Selection>();
        Iterator<? extends Selection> iterator = list.iterator();
        Iterator<? extends Selection> iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            arrayList.add(biFunction.apply(iterator.next(), iterator2.next()));
        }
        return arrayList;
    }

    public static boolean isXDEmpty(List<? extends Selection> list) {
        Iterator<? extends Selection> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean isXDDimEqual(List<? extends Selection> list, List<? extends Selection> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        Iterator<? extends Selection> iterator = list.iterator();
        Iterator<? extends Selection> iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getDim() == iterator2.next().getDim()) continue;
            return false;
        }
        return true;
    }

    public static boolean isXDEqual(List<? extends Selection> list, List<? extends Selection> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        Iterator<? extends Selection> iterator = list.iterator();
        Iterator<? extends Selection> iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            Selection selection;
            Selection selection2 = iterator.next();
            if (SelectionModelUtil.a(selection2, selection = iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean checkSelectionsForUnion(Selection selection, Selection selection2) {
        if (selection.isEmpty() || selection.isGlobal()) {
            return true;
        }
        if (selection2.isEmpty() || selection2.isGlobal()) {
            return true;
        }
        if (selection.isIncludeMeshInterior() != selection2.isIncludeMeshInterior()) {
            return false;
        }
        if (!selection.geom().equals(selection2.geom())) {
            return false;
        }
        if (selection.isGeom() || selection2.isGeom()) {
            return true;
        }
        int[] nArray = selection.dimension();
        int[] nArray2 = selection2.dimension();
        return nArray.length == 1 && nArray2.length == 1 && nArray[0] == nArray2[0];
    }

    public static boolean checkXDSelectionsForUnion(IXDSelection iXDSelection, Selection selection) {
        if (SelectionModelUtil.checkSelectionsForUnion(iXDSelection, selection) && SelectionModelUtil.isExtraDimProductSelection(iXDSelection) && SelectionModelUtil.isExtraDimProductSelection(selection)) {
            IXDSelection iXDSelection2 = (IXDSelection)selection;
            boolean bl2 = SelectionModelUtil.a(iXDSelection, selection);
            if (bl2) {
                return SelectionModelUtil.isXDDimEqual(iXDSelection.getXdSelection(), iXDSelection2.getXdSelection());
            }
            if (SelectionModelUtil.isXDEqual(iXDSelection.getXdSelection(), iXDSelection2.getXdSelection())) {
                return true;
            }
        }
        return false;
    }

    public static Selection unionCheckOrThrow(Selection selection, Selection selection2, Function<Selection, Selection> function) {
        if (selection.isGlobal() || selection2 == null) {
            return (Selection)selection.copySelection();
        }
        if (selection2.isGlobal()) {
            return function.apply(selection2);
        }
        if (selection.isIncludeMeshInterior() != selection2.isIncludeMeshInterior()) {
            throw new PhysicsAPIException("Union_not_supported_between_an_ordinary_selection_and_a_mesh_interior_selection");
        }
        if (!selection.geom().equals(selection2.geom())) {
            throw new PhysicsAPIException("Union_not_supported_between_selections_on_different_geometries");
        }
        if (!SelectionModelUtil.compatibleXd(selection, selection2)) {
            throw new PhysicsAPIException("Union_not_supported_between_selections_on_different_extra_dimension");
        }
        if (selection.isGeom()) {
            return (Selection)selection.copySelection();
        }
        if (selection2.isGeom()) {
            return (Selection)selection2.copySelection();
        }
        return null;
    }

    public static Selection differenceCheckOrThrow(Selection selection, Selection selection2, Supplier<Selection> supplier, Supplier<Selection> supplier2) {
        if (selection2 == null) {
            return (Selection)selection.copySelection();
        }
        if (selection.isGlobal() && selection2.isGlobal()) {
            return supplier.get();
        }
        if (selection.isGlobal()) {
            throw new PhysicsAPIException("Difference_not_supported_when_removing_entities_from_a_global_selection");
        }
        if (selection2.isGlobal()) {
            return supplier2.get();
        }
        if (selection.geom() != null && !selection.geom().equals(selection2.geom()) || selection.isIncludeMeshInterior() != selection2.isIncludeMeshInterior()) {
            return (Selection)selection.copySelection();
        }
        if (selection2.isGeom()) {
            return supplier.get();
        }
        if (!selection.geom().equals(selection2.geom())) {
            return (Selection)selection.copySelection();
        }
        if (!SelectionModelUtil.compatibleXd(selection, selection2)) {
            return (Selection)selection.copySelection();
        }
        return null;
    }

    public static Selection intersectionCheckOrThrow(Selection selection, Selection selection2, Supplier<Selection> supplier, Function<Selection, Selection> function) {
        if (selection2 == null || selection2.isGlobal()) {
            return function.apply(selection);
        }
        if (selection.isGlobal()) {
            return function.apply(selection2);
        }
        if (selection2.geom() == null) {
            return function.apply(selection);
        }
        if (selection.geom() == null) {
            return function.apply(selection2);
        }
        if (!selection.geom().equals(selection2.geom()) || selection.isIncludeMeshInterior() != selection2.isIncludeMeshInterior()) {
            return supplier.get();
        }
        if (selection2.isGeom()) {
            return function.apply(selection);
        }
        if (selection.isGeom()) {
            return function.apply(selection2);
        }
        if (!SelectionModelUtil.compatibleXd(selection, selection2)) {
            return supplier.get();
        }
        return null;
    }

    public static SimpleSelection getNewSimpleSelection(Selection selection) {
        if (SelectionModelUtil.isExtraDimProductSelection(selection)) {
            return new XDSimpleSelection(selection);
        }
        return new SimpleSelection(selection);
    }

    public static SimpleSelection getSimpleSelection(Selection selection) {
        if (SelectionModelUtil.isExtraDimProductSelection(selection)) {
            return selection instanceof XDSimpleSelection ? (XDSimpleSelection)selection : new XDSimpleSelection(selection);
        }
        return selection instanceof SimpleSelection ? (SimpleSelection)selection : new SimpleSelection(selection);
    }

    public static SimpleSelection getEmptySimpleSelection(Selection selection) {
        return SelectionModelUtil.getEmptySimpleSelection(selection, selection.getDim());
    }

    public static SimpleSelection getEmptySimpleSelection(Selection selection, int n2) {
        if (selection instanceof SimpleSelection) {
            return ((SimpleSelection)selection).getEmptyCopy();
        }
        IGeomSequence iGeomSequence = selection.getGeomSequence();
        if (iGeomSequence != null && n2 >= 0) {
            if (SelectionModelUtil.isExtraDimProductSelection(selection)) {
                return new XDSimpleSelection(iGeomSequence, n2);
            }
            return new SimpleSelection(iGeomSequence, n2);
        }
        if (SelectionModelUtil.isExtraDimProductSelection(selection)) {
            return new XDSimpleSelection();
        }
        return new SimpleSelection();
    }

    public static boolean equalsXD(Selection selection, Selection selection2) {
        if (!SelectionModelUtil.equalsGeom(selection, selection2)) {
            return false;
        }
        return SelectionModelUtil.compatibleXd(selection, selection2);
    }

    public static boolean equalsGeom(Selection selection, Selection selection2) {
        if (selection.isGlobal() && selection2.isGlobal()) {
            return true;
        }
        if (selection.isGlobal() || selection2.isGlobal()) {
            return false;
        }
        return FlStringUtil.equals((String)selection.geom(), (String)selection2.geom());
    }

    public static boolean compatibleXd(Selection selection, Selection selection2) {
        boolean bl2 = selection instanceof IXDSelection;
        boolean bl3 = selection2 instanceof IXDSelection;
        if (!bl2 && !bl3) {
            return true;
        }
        if (!bl2 || !bl3) {
            IXDSelection iXDSelection = (IXDSelection)(bl2 ? selection : selection2);
            return "".equals(iXDSelection.extraDim());
        }
        IXDSelection iXDSelection = (IXDSelection)selection;
        IXDSelection iXDSelection2 = (IXDSelection)selection2;
        if (!iXDSelection.extraDim().equals(iXDSelection2.extraDim())) {
            return false;
        }
        if (iXDSelection.getXdSelection().size() != iXDSelection2.getXdSelection().size()) {
            return false;
        }
        Iterator<? extends Selection> iterator = iXDSelection.getXdSelection().iterator();
        Iterator<? extends Selection> iterator2 = iXDSelection2.getXdSelection().iterator();
        while (iterator.hasNext()) {
            if (!iterator2.hasNext()) {
                return false;
            }
            Selection selection3 = iterator.next();
            Selection selection4 = iterator2.next();
            if (selection3.geom().equals(selection4.geom())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }
}

