/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util;

import com.comsol.loader.ModelLoader;
import com.comsol.model.applapi.IPhysicalQuantity;
import com.comsol.model.applapi.PhysicalQuantityID;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.Unit;
import com.comsol.model.dbimodel.UnitList;
import com.comsol.model.dbimodel.UnitSystem;
import com.comsol.model.dbimodel.UnitSystemList;
import com.comsol.model.method.internal.IUnitInternal;
import com.comsol.model.method.internal.IUnitSystemInternal;
import com.comsol.model.plugin.internal.CsPlugin;
import com.comsol.model.savepoint.interfaces.IModel;
import com.comsol.model.savepoint.interfaces.IModelEntity;
import com.comsol.model.util.BuilderAreaManager;
import com.comsol.model.util.ModelCustomDataTypeConverter;
import com.comsol.model.util.ModelInternalUtil;
import com.comsol.model.util.ModelType;
import com.comsol.systemutils.SystemUtil;
import com.comsol.util.classes.CsAbstractPlugin;
import com.comsol.util.classes.bx;
import com.comsol.util.interfaces.IUnitConverter;
import com.comsol.util.interfaces.b;
import com.comsol.util.interfaces.c;
import com.comsol.util.interfaces.d;
import com.comsol.util.logger.FlLogger;
import com.comsol.util.methods.BaseDimensions;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.ae;
import com.comsol.util.methods.q;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UnitUtil {
    public static final IPhysicalQuantity[] baseDimensions = new IPhysicalQuantity[BaseDimensions.h];
    public static final int[] baseUnitOrder;
    private static Collection<String> a;
    private static Map<String, prefix[]> b;
    public static final String SI = "SI";
    public static final String SIName = "SI";
    public static final String none = "none";
    public static final String noneDescr = "None";
    public static final String useGlobal = "useglobal";
    public static final String useGlobalDescr = "Same_as_global_system";
    private static Model c;

    static {
        int n2 = 0;
        BaseDimensions[] baseDimensionsArray = BaseDimensions.values();
        int n3 = baseDimensionsArray.length;
        int n4 = 0;
        while (n4 < n3) {
            BaseDimensions baseDimensions = baseDimensionsArray[n4];
            UnitUtil.baseDimensions[n2++] = PhysicalQuantityID.valueOf(baseDimensions.name());
            ++n4;
        }
        int[] nArray = new int[7];
        nArray[0] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        baseUnitOrder = nArray;
        a = new HashSet<String>();
        b = new HashMap<String, prefix[]>();
        c = null;
    }

    private static synchronized Model a() {
        if (c == null) {
            c = ModelInternalUtil.createLocalModel(ModelType.MODEL, false, false).getModel();
            ModelInternalUtil.getModelManager().addStaticModel(c);
            boolean bl2 = BuilderAreaManager.preventLoadingOfBuilderFiles(true);
            try {
                c.hist().disable();
                UnitUtil.a(c);
                UnitUtil.b(c);
                UnitSystem unitSystem = c.unitSystem().create(none);
                unitSystem.label(noneDescr);
            }
            finally {
                c.hist().enable();
                BuilderAreaManager.preventLoadingOfBuilderFiles(bl2);
            }
        }
        return c;
    }

    public static IUnitConverter getUnitConverter() {
        return UnitUtil.a().getConverter();
    }

    public static UnitSystem unitSystem(String string) {
        Model model = UnitUtil.a();
        if (model.unitSystem().hasTag(string)) {
            return model.unitSystem(string);
        }
        return null;
    }

    public static UnitSystemList<? extends UnitSystem> unitSystem() {
        return UnitUtil.a().unitSystem();
    }

    public static boolean checkBuiltInSystems(String string, IModel iModel) {
        if (iModel == c) {
            return false;
        }
        return UnitUtil.a().unitSystem().hasTag(string);
    }

    private static void a(Model model) {
        try {
            UnitSystem unitSystem;
            UnitSystemList<? extends UnitSystem> unitSystemList = model.unitSystem();
            if (unitSystemList == null) {
                CsPlugin.log(CsAbstractPlugin.LogLevel.ERROR, "unitSystem is not set.");
                bx.b((boolean)true, (CsAbstractPlugin.LogLevel)CsAbstractPlugin.LogLevel.ERROR);
            }
            if ((unitSystem = unitSystemList.create("SI")) == null) {
                CsPlugin.log(CsAbstractPlugin.LogLevel.ERROR, "SISystem is not set.");
                bx.b((boolean)true, (CsAbstractPlugin.LogLevel)CsAbstractPlugin.LogLevel.ERROR);
            }
            unitSystem.label("SI");
            UnitUtil.a(model, unitSystem);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static void a(Model model, UnitSystem unitSystem) {
        UnitList<? extends Unit> unitList = unitSystem.baseUnit();
        unitList.create("meter", BaseDimensions.a.b(), BaseDimensions.a.toString()).aliases(new String[]{"metre"});
        unitList.create("kilogram", BaseDimensions.b.b(), BaseDimensions.b.toString()).setPrefixAllowed(false);
        unitList.create("second", BaseDimensions.c.b(), BaseDimensions.c.toString());
        b.put("second", new prefix[]{prefix.femto, prefix.giga});
        unitList.create("ampere", BaseDimensions.d.b(), BaseDimensions.d.toString());
        unitList.create("kelvin", BaseDimensions.e.b(), BaseDimensions.e.toString());
        b.put("kelvin", new prefix[]{prefix.micro, prefix.mega});
        unitList.create("mole", BaseDimensions.f.b(), BaseDimensions.f.toString());
        unitList.create("candela", BaseDimensions.g.b(), BaseDimensions.g.toString());
        for (Unit unit : unitList) {
            if (!unit.isPrefixAllowed()) continue;
            UnitUtil.a(unitSystem.additionalUnit(), unit, 1.0);
        }
        unitList = unitSystem.derivedUnit();
        unitList.create("one_per_second", new String[]{"s"}, new int[]{-1}).setPrefixAllowed(false);
        unitList.create("one_per_second_square", new String[]{"s"}, new int[]{-2}).setPrefixAllowed(false);
        unitList.create("one_per_meter", new String[]{"m"}, new int[]{-1}).setPrefixAllowed(false);
        unitList.create("one", "1", PhysicalQuantityID.DIMENSIONLESS.fieldName()).setPrefixAllowed(false);
        UnitUtil.d(unitList);
        UnitUtil.c(unitList);
        UnitUtil.a(unitList);
        UnitUtil.b(unitList);
        for (Unit unit : unitList) {
            if (!unit.isPrefixAllowed()) continue;
            UnitUtil.a(unitSystem.additionalUnit(), unit, 1.0);
        }
        unitList = unitSystem.additionalUnit();
        UnitUtil.e(unitList);
        ArrayList<Unit> arrayList = new ArrayList<Unit>();
        for (Unit unit : unitList) {
            if (!unit.isPrefixAllowed()) continue;
            arrayList.add(unit);
        }
        for (Unit unit : arrayList) {
            UnitUtil.a(unitList, unit, unit.scale());
        }
        UnitUtil.f(unitList);
    }

    private static void a(UnitList unitList) {
        Unit unit = unitList.create("mass_per_meter_second", new String[]{"kg", "m", "s"}, new int[]{1, -1, -1});
        unit.setPrefixAllowed(false);
        unit.setPriority(1);
        unitList.create("volt_per_second", new String[]{"V", "s"}, new int[]{1, -1}).setPrefixAllowed(false);
        unitList.create("volt_per_second_square", new String[]{"V", "s"}, new int[]{1, -2}).setPrefixAllowed(false);
        unitList.create("volt_per_meter_square", new String[]{"V", "m"}, new int[]{1, -2}).setPrefixAllowed(false);
        unitList.create("pascal_per_second", new String[]{"Pa", "s"}, new int[]{1, -1}).setPrefixAllowed(false);
        unitList.create("pascal_per_second_square", new String[]{"Pa", "s"}, new int[]{1, -2}).setPrefixAllowed(false);
        unitList.create("pascal_per_kelvin", new String[]{"Pa", "K"}, new int[]{1, -1}).setPrefixAllowed(false);
        unitList.create("joule_per_kilogram", new String[]{"J", "kg"}, new int[]{1, -1}).setPrefixAllowed(false);
        unitList.create("volt_per_kelvin", new String[]{"V", "K"}, new int[]{1, -1}).setPrefixAllowed(false);
        unitList.create("radian_per_second_square", new String[]{"rad", "s"}, new int[]{1, -2}).setPrefixAllowed(false);
        unitList.create("newton_per_second", new String[]{"N", "s"}, new int[]{1, -1}).setPrefixAllowed(false);
        unitList.create("newton_meter_per_second", new String[]{"N", "m", "s"}, new int[]{1, 1, -1}).setPrefixAllowed(false);
        unitList.create("one_over_farad", new String[]{"F"}, new int[]{-1}).setPrefixAllowed(true);
        b.put("one_over_farad", new prefix[]{prefix.femto, prefix.milli});
        unitList.create("ohm_per_meter", new String[]{"\u03a9", "m"}, new int[]{1, -1}).setPrefixAllowed(false);
        unitList.create("one_over_volt", new String[]{"V"}, new int[]{-1}).setPrefixAllowed(false);
        unitList.create("ampere_over_volt_squared", new String[]{"A", "V"}, new int[]{1, -2}).setPrefixAllowed(false);
        unitList.create("ampere_meter", new String[]{"A", "m"}, new int[]{1, 1}).setPrefixAllowed(false);
        unitList.create("newton_meter_per_radian", new String[]{"N", "m", "rad"}, new int[]{1, 1, -1}).setPrefixAllowed(false);
        unitList.create("joule_second", new String[]{"J", "s"}, new int[]{1, 1}).setPrefixAllowed(false);
        unitList.create("newton_meter_second", new String[]{"N", "m", "s"}, new int[]{1, 1, 1}).setPrefixAllowed(false);
        unitList.create("newton_meter_second_per_radian", new String[]{"N", "m", "s", "rad"}, new int[]{1, 1, 1, -1}).setPrefixAllowed(false);
        unitList.create("joule_second_per_radian", new String[]{"J", "s", "rad"}, new int[]{1, 1, -1}).setPrefixAllowed(false);
        unitList.create("kelvin_square_meter_per_watt", new String[]{"K", "m", "W"}, new int[]{1, 2, -1}).setPrefixAllowed(false);
        unitList.create("kelvin_per_watt", new String[]{"K", "W"}, new int[]{1, -1}).setPrefixAllowed(false);
        unitList.create("columb_per_mole", new String[]{"C", "mol"}, new int[]{1, -1}).setPrefixAllowed(false);
        unitList.create("newton_second", new String[]{"N", "s"}, new int[]{1, 1}).setPrefixAllowed(false);
        unitList.create("newton_per_radian", new String[]{"N", "rad"}, new int[]{1, -1}).setPrefixAllowed(false);
        unitList.create("newton_second_per_radian", new String[]{"N", "s", "rad"}, new int[]{1, 1, -1}).setPrefixAllowed(false);
        unitList.create("watt_per_kelvin", new String[]{"W", "K"}, new int[]{1, -1}).setPrefixAllowed(false);
        unitList.create("watt_per_kelvin_meter", new String[]{"W", "K", "m"}, new int[]{1, -1, -1}).setPrefixAllowed(false);
        unitList.create("coulomb_per_kg", new String[]{"C", "kg"}, new int[]{1, -1}).setPrefixAllowed(false);
    }

    private static void b(UnitList unitList) {
        for (IUnitInternal iUnitInternal : new ArrayList(unitList.getListView())) {
            String string = iUnitInternal.getSymbol();
            if (string == null) continue;
            String[] stringArray = new String[]{"", "_meter", "_meter_square", "_meter_cube"};
            int[] nArray = iUnitInternal.dimension();
            if (Arrays.equals(nArray, BaseDimensions.c()) || Arrays.equals(nArray, PhysicalQuantityID.LENGTH.dimension()) || Arrays.equals(nArray, PhysicalQuantityID.FREQUENCY.dimension())) continue;
            int n2 = 1;
            while (n2 <= 3) {
                nArray[0] = nArray[0] + 1;
                String string2 = String.valueOf(iUnitInternal.tag()) + stringArray[n2];
                List list = unitList.getUnits(nArray);
                if (!unitList.hasTag(string2) && list == null) {
                    String[] stringArray2 = new String[]{string, "m"};
                    int[] nArray2 = new int[]{1, n2};
                    Unit unit = unitList.create(string2, stringArray2, nArray2);
                    unit.setPrefixAllowed(false);
                    unit.setPriority(-1);
                }
                ++n2;
            }
        }
    }

    private static void c(UnitList unitList) {
        unitList.create("volt_squaremeter", null, PhysicalQuantityID.REDUCEDELECTRICFIELD.toString()).definition(new String[]{"V", "m"}, new int[]{1, 2});
        unitList.create("meter_per_second", null, PhysicalQuantityID.VELOCITY.toString()).definition(new String[]{"m", "s"}, new int[]{1, -1});
        unitList.create("meter_per_second_square", null, PhysicalQuantityID.ACCELERATION.toString()).definition(new String[]{"m", "s"}, new int[]{1, -2});
        unitList.create("radians_per_second_square", null, PhysicalQuantityID.ANGULARACCELERATION.toString()).definition(new String[]{"rad", "s"}, new int[]{1, -2});
        unitList.create("radians_per_second", null, PhysicalQuantityID.ANGULARFREQUENCY.toString()).definition(new String[]{"rad", "s"}, new int[]{1, -1});
        unitList.create("radians_per_meter", null, PhysicalQuantityID.PLANEANGLEPERLENGTH.toString()).definition(new String[]{"rad", "m"}, new int[]{1, -1});
        unitList.create("rad_per_meter", null, PhysicalQuantityID.WAVENUMBER.toString()).definition(new String[]{"rad", "m"}, new int[]{1, -1});
        unitList.create("cubicmeter", null, PhysicalQuantityID.VOLUME.toString()).definition(new String[]{"m"}, new int[]{3});
        unitList.create("squaremeter", null, PhysicalQuantityID.AREA.toString()).definition(new String[]{"m"}, new int[]{2});
        unitList.create("joules_per_mole", null, PhysicalQuantityID.ENERGYPERAMOUNT.toString()).definition(new String[]{"J", "mol"}, new int[]{1, -1});
        unitList.create("joules_per_cubicmeter", null, PhysicalQuantityID.ENERGYDENSITY.toString()).definition(new String[]{"J", "m"}, new int[]{1, -3});
        unitList.create("joules_per_mole_per_kelvin", null, PhysicalQuantityID.MOLARHEATCAPACITY.toString()).definition(new String[]{"J", "mol", "K"}, new int[]{1, -1, -1});
        unitList.create("joules_per_kelvin", new String[]{"J", "K"}, new int[]{1, -1});
        unitList.create("coulomb_meter", null, PhysicalQuantityID.DIPOLEMOMENT.toString()).definition(new String[]{"C", "m"}, new int[]{1, 1});
        unitList.create("coulomb_per_meter", null, PhysicalQuantityID.LINECHARGE.toString()).definition(new String[]{"C", "m"}, new int[]{1, -1});
        unitList.create("kg_per_meter", null, PhysicalQuantityID.MASSPERLENGTH.toString()).definition(new String[]{"kg", "m"}, new int[]{1, -1}).setPrefixAllowed(false);
        unitList.create("kg_per_square_meter", null, PhysicalQuantityID.MASSPERAREA.toString()).definition(new String[]{"kg", "m"}, new int[]{1, -2}).setPrefixAllowed(false);
        unitList.create("kg_per_square_meter_second", null, PhysicalQuantityID.MASSFLUX.toString()).definition(new String[]{"kg", "m", "s"}, new int[]{1, -2, -1}).setPrefixAllowed(false);
        unitList.create("kg_per_cubic_meter_second", null, PhysicalQuantityID.MASSSOURCE.toString()).definition(new String[]{"kg", "m", "s"}, new int[]{1, -3, -1}).setPrefixAllowed(false);
        unitList.create("newton_meter", null, PhysicalQuantityID.TORQUE.toString()).definition(new String[]{"N", "m"}, new int[]{1, 1});
        unitList.create("newton_per_squaremeter", null, PhysicalQuantityID.STRESS.toString()).definition(new String[]{"N", "m"}, new int[]{1, -2});
        Unit unit = unitList.create("stress_pascal", null, PhysicalQuantityID.STRESS.toString()).definition(new String[]{"Pa"}, new int[]{1});
        unit.setPriority(-1);
        unitList.create("newton_per_meter", null, PhysicalQuantityID.SURFACETENSIONCOEFFICIENT.toString()).definition(new String[]{"N", "m"}, new int[]{1, -1});
        unitList.create("newton_per_meter_edge_load", null, PhysicalQuantityID.EDGELOAD.toString()).definition(new String[]{"N", "m"}, new int[]{1, -1});
        unitList.create("newton_per_square_meter", null, PhysicalQuantityID.FACELOAD.toString()).definition(new String[]{"N", "m"}, new int[]{1, -2});
        unitList.create("newton_per_cubic_meter", null, PhysicalQuantityID.FORCEDENSITY.toString()).definition(new String[]{"N", "m"}, new int[]{1, -3});
        unitList.create("newton_meter_per_meter", null, PhysicalQuantityID.TORQUEPERLENGTH.toString()).definition(new String[]{"N", "m", "m"}, new int[]{1, 1, -1});
        unitList.create("newton_meter_per_squaremeter", null, PhysicalQuantityID.TORQUEPERAREA.toString()).definition(new String[]{"N", "m", "m"}, new int[]{1, 1, -2});
        unitList.create("newton_meter_per_cubic_meter", null, PhysicalQuantityID.TORQUEPERVOL.toString()).definition(new String[]{"N", "m", "m"}, new int[]{1, 1, -3});
        unitList.create("joule_per_kg", null, PhysicalQuantityID.FORCEPOTENTIAL.toString()).definition(new String[]{"J", "kg"}, new int[]{1, -1});
        unitList.create("pascal_cubic_meter_per_mole", null, PhysicalQuantityID.HENRYSCONSTANT.toString()).definition(new String[]{"Pa", "m", "mol"}, new int[]{1, 3, -1});
        unitList.create("pascal_second", null, PhysicalQuantityID.DYNAMICVISCOSITY.toString()).definition(new String[]{"Pa", "s"}, new int[]{1, 1});
        unitList.create("pascal_second_bulkviscosity", null, PhysicalQuantityID.BULKVISCOSITY.toString()).definition(new String[]{"Pa", "s"}, new int[]{1, 1});
        unitList.create("siemens_per_meter", null, PhysicalQuantityID.ELECTRICCONDUCTIVITY.toString()).definition(new String[]{"S", "m"}, new int[]{1, -1});
        unitList.create("siemens_per_meter_squared", null, PhysicalQuantityID.SURFACECONDUCTIVITY.toString()).definition(new String[]{"S", "m"}, new int[]{1, -2});
        unitList.create("squared_velocity", null, PhysicalQuantityID.SLIPVELOCITY.toString()).definition(new String[]{"m", "s"}, new int[]{2, -2});
        unitList.create("weber_per_meter", null, PhysicalQuantityID.MAGNETICVECTORPOTENTIAL.toString()).definition(new String[]{"Wb", "m"}, new int[]{1, -1});
        unitList.create("ohm_meter", null, PhysicalQuantityID.RESISTIVITY.toString()).definition(new String[]{"\u03a9", "m"}, new int[]{1, 1});
        unitList.create("ohm_meter_square", null, PhysicalQuantityID.SURFACERESISTANCE.toString()).definition(new String[]{"\u03a9", "m"}, new int[]{1, 2});
        unitList.create("pascal_second_per_meter", null, PhysicalQuantityID.ACOUSTICIMPEDANCE.toString()).definition(new String[]{"Pa", "s", "m"}, new int[]{1, 1, -1});
        unitList.create("pascal_second_per_squaremeter", null, PhysicalQuantityID.PRESSURETIMEPERAREA.toString()).definition(new String[]{"Pa", "s", "m"}, new int[]{1, 1, -2});
        unitList.create("watt_per_cubic_meter", null, PhysicalQuantityID.POWERDENSITY.toString()).definition(new String[]{"W", "m"}, new int[]{1, -3});
        unitList.create("watt_per_kilogram", null, PhysicalQuantityID.POWERPERMASS.toString()).definition(new String[]{"W", "kg"}, new int[]{1, -1});
        unitList.create("watt_per_square_meter", null, PhysicalQuantityID.HEATFLUX.toString()).definition(new String[]{"W", "m"}, new int[]{1, -2});
        unitList.create("watt_per_meter", null, PhysicalQuantityID.POWERPERMETER.toString()).definition(new String[]{"W", "m"}, new int[]{1, -1});
        unitList.create("joule_per_kilogram_per_kelvin", null, PhysicalQuantityID.HEATCAPACITY.toString()).definition(new String[]{"J", "kg", "K"}, new int[]{1, -1, -1});
        unitList.create("joule_per_cubic_meter_per_kelvin", null, PhysicalQuantityID.VOLUMETRICHEATCAPACITY.toString()).definition(new String[]{"J", "m", "K"}, new int[]{1, -3, -1});
        unitList.create("watt_per_meter_per_kelvin", null, PhysicalQuantityID.THERMALCONDUCTIVITY.toString()).definition(new String[]{"W", "m", "K"}, new int[]{1, -1, -1});
        unitList.create("watt_per_square_meter_per_kelvin", null, PhysicalQuantityID.HEATPRODUCTION.toString()).definition(new String[]{"W", "m", "K"}, new int[]{1, -3, -1});
        unitList.create("watt_per_cubic_meter_per_kelvin", null, PhysicalQuantityID.HEATTRANSFERCOEFFICIENT.toString()).definition(new String[]{"W", "m", "K"}, new int[]{1, -2, -1});
        unitList.create("coulomb_per_meter_square", null, PhysicalQuantityID.SURFACECHARGEDENSITY.toString()).definition(new String[]{"C", "m"}, new int[]{1, -2});
        unitList.create("coulomb_per_meter_cube", null, PhysicalQuantityID.SPACECHARGEDENSITY.toString()).definition(new String[]{"C", "m"}, new int[]{1, -3});
        unitList.create("coulomb_per_newton", null, PhysicalQuantityID.COUPLINGSTRAINCHARGE.toString()).definition(new String[]{"C", "N"}, new int[]{1, -1});
        unitList.create("volt_per_meter", null, PhysicalQuantityID.ELECTRICFIELD.toString()).definition(new String[]{"V", "m"}, new int[]{1, -1});
        unitList.create("per_second", null, PhysicalQuantityID.FLUIDCONDUCTANCE.toString()).definition(new String[]{"s"}, new int[]{-1}).setPrefixAllowed(false);
        unitList.create("per_pascal", null, PhysicalQuantityID.COMPLIANCE.toString()).definition(new String[]{"Pa"}, new int[]{-1}).setPrefixAllowed(false);
        unitList.create("m_square_per_second_square", null, PhysicalQuantityID.TURBULENTKINETICENERGY.toString()).definition(new String[]{"m", "s"}, new int[]{2, -2});
        unitList.create("m_square_per_second_cube", null, PhysicalQuantityID.TURBULENTDISSIPATIONRATE.toString()).definition(new String[]{"m", "s"}, new int[]{2, -3});
        unitList.create("volt_per_meter_square_per_second", null, PhysicalQuantityID.ENERGYFLUX.toString()).definition(new String[]{"V", "m", "s"}, new int[]{1, -2, -1});
        unitList.create("meter_square_per_volt_per_second", null, PhysicalQuantityID.ELECTRONMOBILITY.toString()).definition(new String[]{"V", "m", "s"}, new int[]{-1, 2, -1});
        unitList.create("per_volt_per_meter_per_second", null, PhysicalQuantityID.REDUCEDMOBILITY.toString()).definition(new String[]{"V", "m", "s"}, new int[]{-1, -1, -1});
        unitList.create("farad_per_meter", null, PhysicalQuantityID.PERMITTIVITY.toString()).definition(new String[]{"F", "m"}, new int[]{1, -1}).setPrefixAllowed(false);
        unitList.create("farad_per_meter_squared", null, PhysicalQuantityID.SURFACECAPACITANCE.toString()).definition(new String[]{"F", "m"}, new int[]{1, -2}).setPrefixAllowed(false);
        unitList.create("henry_per_meter", null, PhysicalQuantityID.PERMEABILITY.toString()).definition(new String[]{"H", "m"}, new int[]{1, -1}).setPrefixAllowed(false);
        unitList.create("joule_per_meter_squared", null, PhysicalQuantityID.SURFACEENERGYDENSITY.toString()).definition(new String[]{"J", "m"}, new int[]{1, -2}).setPrefixAllowed(false);
        unitList.create("cubic_meter_per_second", null, PhysicalQuantityID.VOLUMEPERTIME.toString()).definition(new String[]{"m", "s"}, new int[]{3, -1});
        unitList.create("joules_per_squaremeter", null, PhysicalQuantityID.ENERGYDENSITYPERAREA.toString()).definition(new String[]{"J", "m"}, new int[]{1, -2});
        unitList.create("joules_per_meter", null, PhysicalQuantityID.ENERGYDENSITYPERLENGTH.toString()).definition(new String[]{"J", "m"}, new int[]{1, -1});
        unit = unitList.create("newton_per_meter_per_square_meter", null, PhysicalQuantityID.SPRINGCONSTANTPERAREA.toString()).definition(new String[]{"N", "m", "m"}, new int[]{1, -1, -2});
        unit.setPriority(-1);
        unit = unitList.create("newton_per_meter_per_meter", null, PhysicalQuantityID.SPRINGCONSTANTPERLENGTH.toString()).definition(new String[]{"N", "m", "m"}, new int[]{1, -1, -1});
        unit.setPriority(-1);
        unit = unitList.create("newton_per_meter_per_cubic_meter", null, PhysicalQuantityID.SPRINGCONSTANTPERVOLUME.toString()).definition(new String[]{"N", "m", "m"}, new int[]{1, -1, -3});
        unit.setPriority(-1);
        unit = unitList.create("newton_per_meter_spring", null, PhysicalQuantityID.SPRINGCONSTANT.toString()).definition(new String[]{"N", "m"}, new int[]{1, -1});
        unit.setPriority(-1);
        unit = unitList.create("newton_second_per_meter_per_square_meter", null, PhysicalQuantityID.DAMPINGCONSTANTPERAREA.toString()).definition(new String[]{"N", "s", "m", "m"}, new int[]{1, 1, -1, -2});
        unit.setPriority(-1);
        unit = unitList.create("newton_second_per_meter_per_meter", null, PhysicalQuantityID.DAMPINGCONSTANTPERLENGTH.toString()).definition(new String[]{"N", "s", "m", "m"}, new int[]{1, 1, -1, -1});
        unit.setPriority(-1);
        unit = unitList.create("newton_second_per_meter_per_cubic_meter", null, PhysicalQuantityID.DAMPINGCONSTANTPERVOLUME.toString()).definition(new String[]{"N", "s", "m", "m"}, new int[]{1, 1, -1, -3});
        unit.setPriority(-1);
        unit = unitList.create("newton_second_per_meter", null, PhysicalQuantityID.DAMPINGCONSTANT.toString()).definition(new String[]{"N", "s", "m"}, new int[]{1, 1, -1});
        unit.setPriority(-1);
        unit = unitList.create("decibel_per_meter", null, PhysicalQuantityID.LOGARITHMICRATIOPERUNITLENGTH.toString()).definition(new String[]{"dB", "m"}, new int[]{1, -1});
        unit.setPriority(-1);
        unit = unitList.create("neper_per_meter", null, PhysicalQuantityID.NATURALLOGARITHMICRATIOPERUNITLENGTH.toString()).definition(new String[]{"Np", "m"}, new int[]{1, -1});
        unit.setPriority(-1);
        unitList.create("watt_per_square_meter_per_steradian", null, PhysicalQuantityID.RADIATIVEINTENSITY.toString()).definition(new String[]{"W", "m", "sr"}, new int[]{1, -2, -1});
        unitList.create("watt_per_cube_meter_per_steradian", null, PhysicalQuantityID.RADIATIVEINTENSITYSOURCE.toString()).definition(new String[]{"W", "m", "sr"}, new int[]{1, -3, -1});
        unitList.create("hertz_per_second", null, PhysicalQuantityID.FREQUENCYRATE.toString()).definition(new String[]{"Hz", "s"}, new int[]{1, -1}).setPriority(-1);
    }

    private static void d(UnitList unitList) {
        unitList.create("hertz", "Hz", PhysicalQuantityID.FREQUENCY.toString());
        b.put("hertz", new prefix[]{prefix.milli, prefix.tera});
        unitList.create("newton", "N", PhysicalQuantityID.FORCE.toString());
        unitList.create("watt", "W", PhysicalQuantityID.POWER.toString());
        unitList.create("pascal", "Pa", PhysicalQuantityID.PRESSURE.toString());
        b.put("pascal", new prefix[]{prefix.centi, prefix.giga});
        unitList.create("volt", "V", PhysicalQuantityID.ELECTRICPOTENTIAL.toString());
        unitList.create("joule", "J", PhysicalQuantityID.ENERGY.toString());
        unitList.create("ohm", "\u03a9", PhysicalQuantityID.RESISTANCE.toString()).aliases(new String[]{"\u2126"});
        a.add("ohm");
        unitList.create("radian", "rad", PhysicalQuantityID.PLANEANGLE.toString());
        unitList.create("steradian", "sr", PhysicalQuantityID.SOLIDANGLE.toString());
        unitList.create("farad", "F", PhysicalQuantityID.CAPACITANCE.toString());
        b.put("farad", new prefix[]{prefix.femto, prefix.milli});
        unitList.create("henry", "H", PhysicalQuantityID.INDUCTANCE.toString());
        unitList.create("siemens", "S", PhysicalQuantityID.CONDUCTANCE.toString());
        unitList.create("weber", "Wb", PhysicalQuantityID.MAGNETICFLUX.toString());
        unitList.create("tesla", "T", PhysicalQuantityID.MAGNETICFLUXDENSITY.toString());
        unitList.create("coulomb", "C", PhysicalQuantityID.CHARGE.toString());
        unitList.create("gray", "Gy", PhysicalQuantityID.ABSORBEDDOSE.toString()).setPriority(-1);
        unitList.create("sievert", "Sv", PhysicalQuantityID.DOSEEQUIVALENT.toString()).setPriority(-1);
        unitList.create("becquerel", "Bq", PhysicalQuantityID.RADIOACTIVITY.toString());
        unitList.create("decibel", "dB", PhysicalQuantityID.LOGARITHMICRATIO.toString()).setPrefixAllowed(false);
        unitList.create("neper", "Np", PhysicalQuantityID.NATURALLOGARITHMICRATIO.toString()).setPrefixAllowed(false);
        unitList.create("rayleigh", "rayl", PhysicalQuantityID.ACOUSTICIMPEDANCE.toString()).setPrefixAllowed(false);
    }

    private static void e(UnitList unitList) {
        unitList.create("degree", "\u00b0", PhysicalQuantityID.PLANEANGLE.toString()).scale(Math.PI / 180).aliases(new String[]{"deg"}).setPrefixAllowed(false);
        unitList.create("arcminute", "arcmin", PhysicalQuantityID.PLANEANGLE.toString()).scale(2.908882086657216E-4).setPrefixAllowed(false);
        unitList.create("arcsecond", "arcsec", PhysicalQuantityID.PLANEANGLE.toString()).scale(4.84813681109536E-6).setPrefixAllowed(false);
        unitList.create("Celcius", "degC", PhysicalQuantityID.TEMPERATURE.toString()).scale(1.0).offset(273.15).setPrefixAllowed(false);
        unitList.create("Fahrenheit", "degF", PhysicalQuantityID.TEMPERATURE.toString()).scale(0.55555555555556).offset(459.67).setPrefixAllowed(false);
        unitList.create("Rankine", "R", PhysicalQuantityID.TEMPERATURE.toString()).scale(0.55555555555556).aliases(new String[]{"Ra"}).setPrefixAllowed(false);
        unitList.create("debye", "D", PhysicalQuantityID.DIPOLEMOMENT.toString()).scale(3.33564095E-30).setPrefixAllowed(false);
        unitList.create("bar", "bar", PhysicalQuantityID.PRESSURE.toString()).scale(100000.0);
        b.put("bar", new prefix[]{prefix.nano, prefix.kilo});
        unitList.create("torr", "Torr", PhysicalQuantityID.PRESSURE.toString()).scale(133.322).aliases(new String[]{"mmHg"}).setPrefixAllowed(false);
        unitList.create("atmosphere", "atm", PhysicalQuantityID.PRESSURE.toString()).scale(101325.0).setPrefixAllowed(false);
        unitList.create("psi", "psi", PhysicalQuantityID.PRESSURE.toString()).scale(6894.757).setPrefixAllowed(false);
        unitList.create("barye", "ba", PhysicalQuantityID.PRESSURE.toString()).scale(0.1).setPrefixAllowed(false);
        Unit unit = unitList.create("inches_water", "inH2O", PhysicalQuantityID.PRESSURE.toString()).scale(249.089).aliases(new String[]{"inAq"});
        unit.setPrefixAllowed(false);
        unit.setPriority(-1);
        unit.setShow(false);
        Unit unit2 = unitList.create("millimeter_water", "mmH2O", PhysicalQuantityID.PRESSURE.toString()).scale(9.806653543307087).aliases(new String[]{"mmAq"});
        unit2.setPrefixAllowed(false);
        unit2.setPriority(-1);
        unit2.setShow(false);
        unitList.create("ksi", "ksi", PhysicalQuantityID.PRESSURE.toString()).scale(6894757.0).setPrefixAllowed(false);
        unitList.create("psi_stress", "psi", PhysicalQuantityID.STRESS.toString()).scale(6894.757).setPrefixAllowed(false);
        unitList.create("ton", "t", PhysicalQuantityID.MASS.toString()).scale(1000.0).aliases(new String[]{"tonne"});
        unitList.create("gram", "g", PhysicalQuantityID.MASS.toString()).scale(0.001);
        unitList.create("pound", "lb", PhysicalQuantityID.MASS.toString()).scale(0.45359237).aliases(new String[]{"lbm", "pound-mass"}).setPrefixAllowed(false);
        unitList.create("stone", "st", PhysicalQuantityID.MASS.toString()).scale(6.35029318).setPrefixAllowed(false);
        unitList.create("dalton", "u", PhysicalQuantityID.MASS.toString()).scale(1.660538782E-27).aliases(new String[]{"Da", "amu"});
        unitList.create("slug", "slug", PhysicalQuantityID.MASS.toString()).scale(14.59390293720636).aliases(new String[]{"Geepound"}).setPrefixAllowed(false);
        unitList.create("ounce", "oz", PhysicalQuantityID.MASS.toString()).scale(0.028349523125).setPrefixAllowed(false);
        unitList.create("pound_force", "lbf", PhysicalQuantityID.FORCE.toString()).scale(4.4482216152605).setPrefixAllowed(false);
        unitList.create("poundal", "pdl", PhysicalQuantityID.FORCE.toString()).scale(0.138254954376).setPrefixAllowed(false);
        unitList.create("dyne", "dyn", PhysicalQuantityID.FORCE.toString()).scale(1.0E-5).setPrefixAllowed(false);
        unitList.create("kilopond", "kp", PhysicalQuantityID.FORCE.toString()).scale(9.80665).aliases(new String[]{"kpf"}).setPrefixAllowed(false);
        unitList.create("BTU", "Btu", PhysicalQuantityID.ENERGY.toString()).scale(1055.05585).setPrefixAllowed(false);
        unitList.create("erg", "erg", PhysicalQuantityID.ENERGY.toString()).scale(1.0E-7).setPrefixAllowed(false);
        unitList.create("calorie", "cal", PhysicalQuantityID.ENERGY.toString()).scale(4.184);
        unitList.create("electronvolt", "eV", PhysicalQuantityID.ENERGY.toString()).scale(1.6021766208E-19);
        unitList.create("watthour", "Wh", PhysicalQuantityID.ENERGY.toString()).scale(3600.0);
        b.put("watthour", new prefix[]{prefix.milli, prefix.giga});
        unitList.create("minute", "min", PhysicalQuantityID.TIME.toString()).scale(60.0).setPrefixAllowed(false);
        unitList.create("hour", "h", PhysicalQuantityID.TIME.toString()).scale(3600.0).setPrefixAllowed(false);
        unitList.create("day", "d", PhysicalQuantityID.TIME.toString()).scale(86400.0).setPrefixAllowed(false);
        unitList.create("year", "a", PhysicalQuantityID.TIME.toString()).scale(3.1556952E7).aliases(new String[]{"yr"}).setPrefixAllowed(false);
        unitList.create("liter", "l", PhysicalQuantityID.VOLUME.toString()).scale(0.001).aliases(new String[]{"litre", "L"});
        unitList.create("imperialgallon", "impgal", PhysicalQuantityID.VOLUME.toString()).scale(0.00454609).setPrefixAllowed(false);
        unitList.create("gallon", "gal", PhysicalQuantityID.VOLUME.toString()).scale(0.003785411784).setPrefixAllowed(false);
        unitList.create("pint", "pt", PhysicalQuantityID.VOLUME.toString()).scale(4.73176473E-4).setPrefixAllowed(false);
        unitList.create("quart", "qt", PhysicalQuantityID.VOLUME.toString()).scale(9.46352946E-4).setPrefixAllowed(false);
        unitList.create("fluid_ounce", "fl_oz", PhysicalQuantityID.VOLUME.toString()).scale(2.84130625E-5).setPrefixAllowed(false);
        unitList.create("inch", "in", PhysicalQuantityID.LENGTH.toString()).scale(0.0254).setPrefixAllowed(false);
        unitList.create("milliinch", "mil", PhysicalQuantityID.LENGTH.toString()).scale(2.54E-5).aliases(new String[]{"thou"}).setPrefixAllowed(false);
        unitList.create("microinch", "\u00b5in", PhysicalQuantityID.LENGTH.toString()).scale(2.54E-8).aliases(new String[]{"uin"}).setPrefixAllowed(false);
        unitList.create("foot", "ft", PhysicalQuantityID.LENGTH.toString()).scale(0.3048).setPrefixAllowed(false);
        unitList.create("mile", "mi", PhysicalQuantityID.LENGTH.toString()).scale(1609.344).setPrefixAllowed(false);
        unitList.create("nautimile", "nmi", PhysicalQuantityID.LENGTH.toString()).scale(1852.0).setPrefixAllowed(false);
        unitList.create("yard", "yd", PhysicalQuantityID.LENGTH.toString()).scale(0.9144).setPrefixAllowed(false);
        unitList.create("angstrom", "\u00c5", PhysicalQuantityID.LENGTH.toString()).scale(1.0E-10).setPrefixAllowed(false);
        unitList.create("mph", "mph", PhysicalQuantityID.VELOCITY.toString()).scale(0.44704).aliases(new String[]{"MPH"}).setPrefixAllowed(false);
        unitList.create("knot", "knot", PhysicalQuantityID.VELOCITY.toString()).scale(0.5144444444444445).setPrefixAllowed(false);
        unitList.create("galileo", "Gal", PhysicalQuantityID.ACCELERATION.toString()).scale(0.01).setPrefixAllowed(false);
        unitList.create("CFM", "cfm", PhysicalQuantityID.VOLUMEPERTIME.toString()).scale(Math.pow(0.3048, 3.0) / 60.0).setPrefixAllowed(false);
        unitList.create("rpm", new String[]{"min"}, new int[]{-1}).symbol("RPM").scale(0.016666666666666666).setPrefixAllowed(false);
        unitList.create("gauss", "G", PhysicalQuantityID.MAGNETICFLUXDENSITY.toString()).scale(1.0E-4);
        unitList.create("oersted", "Oe", PhysicalQuantityID.MAGNETICFIELD.toString()).scale(79.57747154594767).setPrefixAllowed(false);
        unitList.create("amperehour", "Ah", PhysicalQuantityID.CHARGE.toString()).scale(3600.0);
        b.put("amperehour", new prefix[]{prefix.milli, prefix.kilo});
        unitList.create("millidarcy", "mD", PhysicalQuantityID.HYDRAULICPERMEABILITY.toString()).scale(9.869233E-16).setPrefixAllowed(false);
        unitList.create("poise", "P", PhysicalQuantityID.DYNAMICVISCOSITY.toString()).scale(0.1).setPriority(-1);
        unitList.create("molarity", "M", PhysicalQuantityID.CONCENTRATION.toString()).definition(new String[]{"mol", "l"}, new int[]{1, -1}).scale(1000.0).setPrefixAllowed(true);
        b.put("molarity", new prefix[0]);
        unitList.create("Townsends", "Td", PhysicalQuantityID.REDUCEDELECTRICFIELD.toString()).scale(1.0E-21);
        unitList.create("percent", "%", PhysicalQuantityID.DIMENSIONLESS.toString()).scale(0.01).setPrefixAllowed(false);
        unitList.create("partspermillion", "ppm", PhysicalQuantityID.DIMENSIONLESS.toString()).scale(1.0E-6).setPrefixAllowed(false);
        unitList.create("rayleigh_cgs", "rayl_cgs", PhysicalQuantityID.ACOUSTICIMPEDANCE.toString()).scale(10.0).setPrefixAllowed(false);
    }

    private static void f(UnitList unitList) {
        unitList.create("kilometer_per_hour", null, PhysicalQuantityID.VELOCITY.toString()).definition(new String[]{"km", "h"}, new int[]{1, -1});
        unitList.create("millimeter_per_year", null, PhysicalQuantityID.VELOCITY.toString()).definition(new String[]{"mm", "yr"}, new int[]{1, -1});
        unitList.create("gram_per_cm_cube", null, PhysicalQuantityID.DENSITY.toString()).definition(new String[]{"g", "cm"}, new int[]{1, -3});
        unitList.create("newton_per_millimeter", null, PhysicalQuantityID.SURFACETENSIONCOEFFICIENT.toString()).definition(new String[]{"N", "mm"}, new int[]{1, -1});
        unitList.create("newton_per_centimeter", null, PhysicalQuantityID.SURFACETENSIONCOEFFICIENT.toString()).definition(new String[]{"N", "cm"}, new int[]{1, -1});
        unitList.create("newton_per_mm_square", null, PhysicalQuantityID.FACELOAD.toString()).definition(new String[]{"N", "mm"}, new int[]{1, -2});
        unitList.create("newton_per_cm_square", null, PhysicalQuantityID.FACELOAD.toString()).definition(new String[]{"N", "cm"}, new int[]{1, -2});
    }

    private static void a(UnitList unitList, Unit unit, double d2) {
        prefix[] prefixArray;
        String string = unit.symbol();
        if (string == null || string.isEmpty()) {
            FlLogger.c((String)String.format("Ignored prefixes for unit '%s' since it has no symbol", unit.tag()));
            return;
        }
        String[] stringArray = null;
        int[] nArray = null;
        if (FlStringUtil.isDigit((char)string.charAt(0))) {
            prefixArray = (prefix[])unit;
            stringArray = prefixArray.getUnits();
            if (stringArray == null || stringArray.length == 0) {
                FlLogger.c((String)String.format("Ignored prefixes for unit '%s' since it has a symbol starting with a number%nand no powers of derived unit are defined.", unit.tag()));
                return;
            }
            nArray = prefixArray.getPowers();
        }
        prefixArray = b.get(unit.tag());
        prefix[] prefixArray2 = prefix.values();
        int n2 = prefixArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            boolean bl2;
            Unit unit2;
            prefix prefix2 = prefixArray2[n3];
            String string2 = String.valueOf(prefix2.name()) + unit.tag();
            if (stringArray != null) {
                String[] stringArray2 = (String[])stringArray.clone();
                stringArray2[0] = String.valueOf(prefix2.symbol()) + stringArray[0];
                unit2 = unitList.create(string2, stringArray2, nArray).scale(Math.pow(prefix2.scale(), nArray[0]) * d2).quantity(unit.quantity());
            } else {
                unit2 = unitList.create(string2, unit.dimension()).symbol(String.valueOf(prefix2.symbol()) + string).scale(prefix2.scale() * d2).quantity(unit.quantity());
            }
            unit2.setPriority(((IUnitInternal)unit).getPriority());
            if (prefixArray == null) {
                bl2 = prefix2.showUnit();
            } else if (prefixArray.length == 0) {
                bl2 = false;
            } else {
                boolean bl3 = bl2 = prefixArray[0].scale() <= prefix2.scale() && prefix2.scale() <= prefixArray[1].scale();
                if (!prefix2.isPowerOfThousand()) {
                    bl2 &= prefix2.showUnit();
                }
            }
            unit2.setShow(bl2);
            unit2.setPrefixAllowed(false);
            ArrayList<String> arrayList = new ArrayList<String>();
            boolean bl4 = a.contains(unit.tag());
            alternatePrefix[] alternatePrefixArray = alternatePrefix.values();
            int n4 = alternatePrefixArray.length;
            int n5 = 0;
            while (n5 < n4) {
                alternatePrefix alternatePrefix2 = alternatePrefixArray[n5];
                if (alternatePrefix2.name().equals(prefix2.name())) {
                    String[] stringArray3 = alternatePrefix2.symbols();
                    int n6 = stringArray3.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        String string3 = stringArray3[n7];
                        arrayList.add(String.valueOf(string3) + unit.symbol());
                        if (bl4) {
                            arrayList.add(String.valueOf(string3) + unit.tag());
                        }
                        ++n7;
                    }
                }
                ++n5;
            }
            if (bl4) {
                arrayList.add(String.valueOf(prefix2.symbol()) + unit.tag());
            }
            unit2.aliases(arrayList.toArray(new String[arrayList.size()]));
            ++n3;
        }
    }

    private static void a(UnitList unitList, Unit unit) {
        String string = unit.tag();
        if (q.a((Object[])unitList.tags(), (Object)string)) {
            string = unitList.uniquetag(unit.tag());
        }
        String string2 = unit.symbol();
        Unit unit2 = unitList.create(string, unit.dimension()).symbol(string2).scale(unit.getSiScale() * unit.scale()).quantity(unit.quantity());
        unit2.setPrefixAllowed(unit.isPrefixAllowed());
        unit2.setShow(unit.isShow());
    }

    public static int[] getBaseDimension(IPhysicalQuantity iPhysicalQuantity) {
        int[] nArray = new int[baseDimensions.length];
        int n2 = 0;
        while (n2 < baseDimensions.length) {
            if (baseDimensions[n2].hasSameID(iPhysicalQuantity)) {
                nArray[n2] = 1;
                break;
            }
            ++n2;
        }
        return nArray;
    }

    public static String dimHashCode(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            stringBuilder.append(n4);
            ++n3;
        }
        return stringBuilder.toString();
    }

    public static String getBaseUnitPowers(UnitSystem unitSystem, int[] nArray) {
        if (nArray == null) {
            throw new RuntimeException("Powers of base units cannot be null");
        }
        String[] stringArray = new String[nArray.length];
        if (unitSystem == null) {
            unitSystem = UnitUtil.a().unitSystem("SI");
        }
        int[] nArray2 = new int[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            List<? extends Unit> list = unitSystem.baseUnit().getUnits(baseDimensions[n2].dimension());
            if (list == null) {
                throw new RuntimeException("Corrupt SI system");
            }
            stringArray[UnitUtil.baseUnitOrder[n2]] = list.get(0).getSymbol();
            nArray2[UnitUtil.baseUnitOrder[n2]] = nArray[n2];
            ++n2;
        }
        return FlStringUtil.getUnitExpr((String[])stringArray, (int[])nArray2);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void b(Model model) {
        b[] bArray;
        ArrayList<Unit> arrayList;
        ArrayList<Unit> arrayList2;
        InputStreamReader inputStreamReader;
        block28: {
            UnitSystem unitSystem = c.unitSystem("SI");
            String string = File.separator;
            String string2 = String.valueOf(SystemUtil.getCsRoot()) + string + "data" + string + "unitsystems" + string + "unitsystems.xml";
            inputStreamReader = null;
            d d2 = new d("xml-root", null);
            arrayList2 = new ArrayList<Unit>();
            arrayList = new ArrayList<Unit>();
            for (Unit unit : unitSystem.derivedUnit()) {
                if (!Arrays.equals(unit.dimension(), BaseDimensions.c())) continue;
                arrayList2.add(unit);
            }
            for (Unit unit : unitSystem.additionalUnit()) {
                if (!Arrays.equals(unit.dimension(), BaseDimensions.c())) continue;
                arrayList.add(unit);
            }
            model.hist().disable();
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string2), "UTF-8");
            ae.a((Reader)inputStreamReader, (c)d2);
            bArray = d2.a("unitsystem");
            if (bArray.length != 0) break block28;
            model.hist().enable();
            if (inputStreamReader == null) return;
            try {
                inputStreamReader.close();
                return;
            }
            catch (IOException iOException) {
                FlLogger.a((String)"Failed to load other unit systems");
            }
            return;
        }
        try {
            b[] bArray2 = bArray[0].a("systems");
            int n2 = bArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                Unit unit;
                Iterator iterator = bArray2[n3];
                String string = iterator.b("tag");
                if (FlStringUtil.contains((String[])model.unitSystem().tags(), (String)string)) {
                    model.unitSystem().remove(string);
                }
                IUnitSystemInternal iUnitSystemInternal = (IUnitSystemInternal)model.unitSystem().create(string);
                if (iterator.b("name") != null) {
                    iUnitSystemInternal.label(iterator.b("name"));
                }
                UnitUtil.a(iUnitSystemInternal.baseUnit(), (b)iterator, "baseUnit");
                UnitUtil.a(iUnitSystemInternal.derivedUnit(), (b)iterator, "derivedUnit");
                UnitUtil.a(iUnitSystemInternal.additionalUnit(), (b)iterator, "additionalUnit");
                for (Unit unit2 : arrayList2) {
                    unit = iUnitSystemInternal.getUnit(unit2.symbol(), true);
                    if (unit != null) continue;
                    UnitUtil.a(iUnitSystemInternal.derivedUnit(), unit2);
                }
                for (Unit unit3 : arrayList) {
                    unit = iUnitSystemInternal.getUnit(unit3.symbol(), true);
                    if (unit != null) continue;
                    UnitUtil.a(iUnitSystemInternal.additionalUnit(), unit3);
                }
                ++n3;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            FlLogger.a((String)"Failed to load other unit systems");
            model.hist().enable();
            if (inputStreamReader == null) return;
            try {
                inputStreamReader.close();
                return;
            }
            catch (IOException iOException) {
                FlLogger.a((String)"Failed to load other unit systems");
            }
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FlLogger.a((String)"Failed to load other unit systems");
            model.hist().enable();
            if (inputStreamReader == null) return;
            try {
                inputStreamReader.close();
                return;
            }
            catch (IOException iOException) {
                FlLogger.a((String)"Failed to load other unit systems");
            }
            return;
        }
        catch (ModelLoader.NotConvertedException notConvertedException) {
            FlLogger.a((String)"Failed to load other unit systems");
            model.hist().enable();
            if (inputStreamReader == null) return;
            {
                catch (Throwable throwable) {
                    model.hist().enable();
                    if (inputStreamReader == null) throw throwable;
                    try {
                        inputStreamReader.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        FlLogger.a((String)"Failed to load other unit systems");
                    }
                    throw throwable;
                }
            }
            try {
                inputStreamReader.close();
                return;
            }
            catch (IOException iOException) {
                FlLogger.a((String)"Failed to load other unit systems");
            }
            return;
        }
        model.hist().enable();
        if (inputStreamReader == null) return;
        try {
            inputStreamReader.close();
            return;
        }
        catch (IOException iOException) {
            FlLogger.a((String)"Failed to load other unit systems");
        }
    }

    private static void a(UnitList unitList, b b2, String string) throws ModelLoader.NotConvertedException {
        b[] bArray = b2.a(string);
        if (bArray.length == 0) {
            return;
        }
        b b3 = bArray[0];
        b[] bArray2 = b3.a("units");
        int n2 = bArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            Unit unit;
            Object object;
            b b4 = bArray2[n3];
            String string2 = b4.b("tag");
            if (b4.b("units") != null && b4.b("powers") != null) {
                object = ModelCustomDataTypeConverter.createStringArrayFromString(b4.b("units"));
                int[] nArray = ModelCustomDataTypeConverter.createIntArrayFromString(b4.b("powers"));
                unit = unitList.create(string2, (String[])object, nArray);
            } else {
                object = ModelCustomDataTypeConverter.createIntArrayFromString(b4.b("dimension"));
                unit = unitList.create(string2, (int[])object);
            }
            String[] stringArray = b4.g();
            int n4 = stringArray.length;
            int n5 = 0;
            while (n5 < n4) {
                object = stringArray[n5];
                String string3 = b4.b((String)object);
                if (((String)object).equals("siScale")) {
                    unit.setSiScale(Double.parseDouble(string3));
                } else if (((String)object).equals("prefixAllowed")) {
                    unit.setPrefixAllowed(Boolean.parseBoolean(string3));
                } else if (((String)object).equals("priority")) {
                    unit.setPriority(Integer.parseInt(string3));
                } else if (((String)object).equals("scale")) {
                    unit.scale(Double.parseDouble(string3));
                } else if (((String)object).equals("aliases")) {
                    unit.aliases(ModelCustomDataTypeConverter.createStringArrayFromString(string3));
                } else if (((String)object).equals("scale")) {
                    unit.scale(Double.parseDouble(string3));
                } else if (((String)object).equals("scale")) {
                    unit.scale(Double.parseDouble(string3));
                } else if (((String)object).equals("scale")) {
                    unit.scale(Double.parseDouble(string3));
                } else if (((String)object).equals("symbol")) {
                    unit.symbol(string3);
                } else if (((String)object).equals("offset")) {
                    unit.offset(Double.parseDouble(string3));
                } else if (((String)object).equals("quantity")) {
                    unit.quantity(string3);
                }
                ++n5;
            }
            ++n3;
        }
    }

    public static boolean isConsistent(String string, IModelEntity iModelEntity, String string2, IModelEntity iModelEntity2) {
        if (string == null || iModelEntity == null || !iModelEntity.isInModel() || string2 == null || iModelEntity2 == null || !iModelEntity2.isInModel()) {
            return true;
        }
        IUnitConverter iUnitConverter = iModelEntity.getConverter();
        IUnitConverter iUnitConverter2 = iModelEntity2.getConverter();
        if (!iUnitConverter.useUnitSystems() || !iUnitConverter2.useUnitSystems()) {
            return true;
        }
        int[] nArray = iUnitConverter.getDimension("1[" + string + "]", 0);
        int[] nArray2 = iUnitConverter2.getDimension("1[" + string2 + "]", 0);
        return iUnitConverter.isConsistent(nArray, nArray2, nArray == null || nArray2 == null);
    }

    public static boolean isConsistent(String string, IModelEntity iModelEntity, int[] nArray) {
        int[] nArray2;
        if (string == null || iModelEntity == null || !iModelEntity.isInModel() || nArray == null) {
            return true;
        }
        IUnitConverter iUnitConverter = iModelEntity.getConverter();
        if (!iUnitConverter.useUnitSystems()) {
            return true;
        }
        return iUnitConverter.isConsistent(nArray2, nArray, (nArray2 = iUnitConverter.getDimension("1[" + string + "]", 0)) == null);
    }

    public static boolean hasExprUnit(String string, IUnitConverter iUnitConverter) {
        try {
            String string2 = iUnitConverter.getUnitExpr(string, 0);
            return string2 != null;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static enum alternatePrefix {
        micro("\u03bc", "u");

        private final String[] symbols;

        private alternatePrefix(String ... stringArray) {
            this.symbols = stringArray;
        }

        public String[] symbols() {
            return this.symbols;
        }
    }

    public static enum prefix {
        yotta("Y", 1.0E24, false),
        zetta("Z", 1.0E21, false),
        exa("E", 1.0E18, false),
        peta("P", 1.0E15, false),
        tera("T", 1.0E12, false),
        giga("G", 1.0E9, true),
        mega("M", 1000000.0, true),
        kilo("k", 1000.0, true),
        hecto("h", 100.0, false),
        deca("da", 10.0, false),
        deci("d", 0.1, true),
        centi("c", 0.01, true),
        milli("m", 0.001, true),
        micro("\u00b5", 1.0E-6, true),
        nano("n", 1.0E-9, true),
        pico("p", 1.0E-12, false),
        femto("f", 1.0E-15, false),
        atto("a", 1.0E-18, false),
        zepto("z", 1.0E-21, false),
        yocto("y", 1.0E-24, false);

        private final String symbol;
        private final double scale;
        private final boolean showUnit;
        private final boolean powerOfThousand;

        private prefix(String string2, double d2, boolean bl2) {
            this.symbol = string2;
            this.scale = d2;
            this.showUnit = bl2;
            this.powerOfThousand = Math.log10(d2) % 3.0 == 0.0;
        }

        public String symbol() {
            return this.symbol;
        }

        public double scale() {
            return this.scale;
        }

        public boolean showUnit() {
            return this.showUnit;
        }

        public boolean isPowerOfThousand() {
            return this.powerOfThousand;
        }
    }
}

