/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util;

import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.HideDraw;
import com.comsol.model.dbimodel.HideGeom;
import com.comsol.model.dbimodel.HideGeomList;
import com.comsol.model.dbimodel.HideMesh;
import com.comsol.model.dbimodel.MeshSequence;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.SavePointData;
import com.comsol.model.dbimodel.SavePointGeom;
import com.comsol.model.dbimodel.View;
import com.comsol.model.dbimodel.ViewBase;
import com.comsol.model.dbimodel.ViewFeature;
import com.comsol.model.dbimodel.ViewFeatureList;
import com.comsol.model.dbimodel.ViewList;
import com.comsol.model.operations.operationID.ViewOperationID;
import com.comsol.model.savepoint.interfaces.IGeomSequence;
import com.comsol.model.savepoint.interfaces.IModel;
import com.comsol.nativeutil.properties.PropAnnotationInfo;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.q;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ViewUtil {
    public static void createDefaultLights(ViewBase viewBase) {
        if (viewBase instanceof View) {
            View view = (View)viewBase;
            ViewFeatureList<? extends PropFeature> viewFeatureList = view.light();
            if (viewFeatureList == null) {
                return;
            }
            ViewFeature viewFeature = viewFeatureList.create(viewFeatureList.uniquetag("lgt"), "DirectionalLight");
            viewFeature.set("lightdirection", new double[]{4.0, 3.7, -5.0});
            viewFeature.set("intensity", 0.8);
            viewFeature.set("cameracoord", true);
            viewFeature = viewFeatureList.create(viewFeatureList.uniquetag("lgt"), "DirectionalLight");
            viewFeature.set("lightdirection", new double[]{-4.0, -2.0, -1.0});
            viewFeature.set("intensity", 0.4);
            viewFeature.set("cameracoord", true);
            viewFeature = viewFeatureList.create(viewFeatureList.uniquetag("lgt"), "DirectionalLight");
            viewFeature.set("lightdirection", new double[]{0.5, -5.0, 4.0});
            viewFeature.set("intensity", 0.55);
            viewFeature.set("cameracoord", true);
        }
    }

    public static Set<ViewList> getAllViewLists(Model model) {
        HashSet<ViewList> hashSet = new HashSet<ViewList>();
        hashSet.add(model.view());
        for (GeomSequence geomSequence : model.geom()) {
            hashSet.addAll(ViewUtil.getAllViewLists(model, geomSequence));
        }
        return hashSet;
    }

    public static Set<ViewList> getAllViewLists(Model model, IGeomSequence iGeomSequence) {
        HashSet<ViewList> hashSet = new HashSet<ViewList>();
        IGeomSequence iGeomSequence2 = iGeomSequence;
        if (iGeomSequence.getModel().isSavePoint()) {
            String object = iGeomSequence.getModel().tag();
            if (model.savePoint().index(object) >= 0) {
                iGeomSequence2 = model.savePoint(object).geom().getCurrentGeom(iGeomSequence);
                if (iGeomSequence2 == null) {
                    return hashSet;
                }
            } else {
                return hashSet;
            }
        }
        for (SavePointData savePointData : model.savePoint()) {
            hashSet.add(model.view());
            SavePointGeom savePointGeom = savePointData.geom().getSavePointGeom(iGeomSequence2);
            if (savePointGeom == null) continue;
            hashSet.add(savePointGeom.view());
        }
        return hashSet;
    }

    public static Set<HideGeomList> getAllHideGeomLists(Model model, String string) {
        HashSet<HideGeomList> hashSet = new HashSet<HideGeomList>();
        for (GeomSequence geomSequence : model.physicsGeom()) {
            hashSet.addAll(ViewUtil.getAllHideGeomLists(model, geomSequence, string));
        }
        return hashSet;
    }

    public static Set<HideGeomList> getAllHideGeomLists(Model model, IGeomSequence iGeomSequence, String string) {
        HashSet<HideGeomList> hashSet = new HashSet<HideGeomList>();
        IGeomSequence iGeomSequence2 = iGeomSequence;
        if (iGeomSequence.getModel().isSavePoint()) {
            String object = iGeomSequence.getModel().tag();
            if (model.savePoint().index(object) >= 0) {
                iGeomSequence2 = model.savePoint(object).geom().getCurrentGeom(iGeomSequence);
                if (iGeomSequence2 == null) {
                    return hashSet;
                }
            } else {
                return hashSet;
            }
        }
        if (model.view().index(string) >= 0) {
            hashSet.add(model.view(string).hideEntities());
        }
        for (SavePointData savePointData : model.savePoint()) {
            SavePointGeom savePointGeom = savePointData.geom().getSavePointGeom(iGeomSequence2);
            if (savePointGeom == null || savePointGeom.view().index(string) < 0) continue;
            hashSet.add(savePointGeom.view(string).hideEntities());
        }
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Set<Integer>> getHiddenEntities(View view, IGeomSequence iGeomSequence, MeshSequence meshSequence, HideDraw hideDraw, HideGeom hideGeom, HideMesh hideMesh) {
        ArrayList<Set<Integer>> arrayList;
        block29: {
            int n2;
            int n3;
            int n4;
            int[] nArray;
            Object object;
            Object object2;
            View view2;
            SavePointGeom savePointGeom;
            block28: {
                int n5;
                int n6;
                int[][] nArray2;
                arrayList = new ArrayList<Set<Integer>>();
                int n7 = 0;
                while (n7 <= iGeomSequence.getSDim()) {
                    arrayList.add(new HashSet());
                    ++n7;
                }
                IModel iModel = iGeomSequence.getModel();
                savePointGeom = null;
                view2 = null;
                if (iModel.isSavePoint()) {
                    object2 = iModel.getCurrentModel();
                    savePointGeom = object2.savePoint(iModel.tag()).geom().getSavePointGeom(iGeomSequence);
                    if (savePointGeom.getGeom() != null) {
                        view2 = object2.view(view.tag());
                    }
                } else {
                    view2 = view;
                }
                object2 = new int[iGeomSequence.getSDim() + 1][];
                if (view2 != null && view2.hideObjects() != null) {
                    if (hideDraw != null && hideDraw.isInModel()) {
                        object2 = ViewUtil.a(hideDraw, savePointGeom, meshSequence, iGeomSequence);
                    }
                    for (HideDraw n20 : view2.hideObjects()) {
                        if (!n20.isActive() || n20.equals(hideDraw)) continue;
                        nArray2 = ViewUtil.a(n20, savePointGeom, meshSequence, iGeomSequence);
                        n6 = 0;
                        while (n6 < nArray2.length) {
                            if (nArray2[n6] != null && nArray2[n6].length > 0) {
                                object = (Set)arrayList.get(n6);
                                nArray = object2[n6] != null ? q.b((int[])nArray2[n6], (int[])object2[n6]) : nArray2[n6];
                                n5 = nArray.length;
                                int n8 = 0;
                                while (n8 < n5) {
                                    n4 = nArray[n8];
                                    object.add(n4);
                                    ++n8;
                                }
                            }
                            ++n6;
                        }
                    }
                }
                object2 = new int[iGeomSequence.getSDim() + 1][];
                if (hideGeom != null && hideGeom.isInModel()) {
                    object2 = ViewUtil.a(hideGeom, iGeomSequence, meshSequence);
                }
                for (HideGeom hideGeom2 : view.hideEntities()) {
                    if (!hideGeom2.isActive() || hideGeom2.equals(hideGeom)) continue;
                    nArray2 = ViewUtil.a(hideGeom2, iGeomSequence, meshSequence);
                    int[] nArray3 = hideGeom2.dimension();
                    n4 = nArray3.length;
                    int n9 = 0;
                    while (n9 < n4) {
                        n6 = nArray3[n9];
                        Set set = (Set)arrayList.get(n6);
                        int[] nArray4 = object2[n6] != null ? q.b((int[])nArray2[n6], (int[])object2[n6]) : nArray2[n6];
                        n3 = nArray4.length;
                        n2 = 0;
                        while (n2 < n3) {
                            int n10 = nArray4[n2];
                            set.add(n10);
                            ++n2;
                        }
                        ++n9;
                    }
                }
                if (meshSequence == null) break block28;
                object2 = new int[iGeomSequence.getSDim() + 1][];
                if (hideMesh != null && hideMesh.isInModel()) {
                    void n19;
                    int[] nArray5 = hideMesh.dimension();
                    int n11 = nArray5.length;
                    boolean bl2 = false;
                    while (n19 < n11) {
                        int n12 = nArray5[n19];
                        object2[n12] = hideMesh.entities(n12);
                        ++n19;
                    }
                }
                for (HideMesh hideMesh2 : view.hideMesh()) {
                    if (!hideMesh2.isActive() || hideMesh2.getMesh() != meshSequence || hideMesh2.equals(hideMesh)) continue;
                    int[] nArray6 = hideMesh2.dimension();
                    int n13 = nArray6.length;
                    int n14 = 0;
                    while (n14 < n13) {
                        int n15 = nArray6[n14];
                        Set set = (Set)arrayList.get(n15);
                        int[] nArray7 = object2[n15] != null ? q.b((int[])hideMesh2.entities(n15), (int[])object2[n15]) : hideMesh2.entities(n15);
                        n2 = nArray7.length;
                        int n16 = 0;
                        while (n16 < n2) {
                            n5 = nArray7[n16];
                            set.add(n5);
                            ++n16;
                        }
                        ++n14;
                    }
                }
                break block29;
            }
            if (!iGeomSequence.isDefinedByMesh() || view2 == null) break block29;
            object2 = new int[iGeomSequence.getSDim() + 1][];
            if (hideMesh != null && hideMesh.isInModel()) {
                void var12_18;
                int[] nArray8 = hideMesh.dimension();
                int n17 = nArray8.length;
                boolean hideMesh3 = false;
                while (var12_18 < n17) {
                    int n18 = nArray8[var12_18];
                    object = hideMesh.finalizedEntities(n18);
                    if (savePointGeom != null) {
                        object = savePointGeom.mapEntCurrentToSP(n18, (int[])object, 1, 1, iGeomSequence.getNEntities()[n18]);
                    }
                    object2[n18] = object;
                    ++var12_18;
                }
            }
            Object var11_27 = null;
            for (MeshSequence meshSequence2 : view2.getModel().mesh()) {
                if (meshSequence2.getGeom() != iGeomSequence.getMainGeometryOrSubsequence()) continue;
                MeshSequence meshSequence3 = meshSequence2;
                break;
            }
            for (HideMesh hideMesh3 : view2.hideMesh()) {
                void var11_29;
                if (!hideMesh3.isActive() || hideMesh3.getMesh() != var11_29 || hideMesh3.equals(hideMesh)) continue;
                int[] nArray9 = hideMesh3.dimension();
                n4 = nArray9.length;
                int n19 = 0;
                while (n19 < n4) {
                    int n20 = nArray9[n19];
                    Set set = (Set)arrayList.get(n20);
                    nArray = hideMesh3.finalizedEntities(n20);
                    if (savePointGeom != null) {
                        nArray = savePointGeom.mapEntCurrentToSP(n20, nArray, 1, 1, iGeomSequence.getNEntities()[n20]);
                    }
                    if (nArray != null) {
                        int[] nArray10 = object2[n20] != null ? q.b((int[])nArray, (int[])object2[n20]) : nArray;
                        int n21 = nArray10.length;
                        n3 = 0;
                        while (n3 < n21) {
                            n2 = nArray10[n3];
                            set.add(n2);
                            ++n3;
                        }
                    }
                    ++n19;
                }
            }
        }
        return arrayList;
    }

    private static int[][] a(HideDraw hideDraw, SavePointGeom savePointGeom, MeshSequence meshSequence, IGeomSequence iGeomSequence) {
        int[][] nArray = hideDraw.mapToFinalizedGeometry(meshSequence != null);
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2].length > 0 && savePointGeom != null) {
                assert (meshSequence == null);
                nArray[n2] = savePointGeom.mapEntCurrentToSP(n2, nArray[n2], 1, 1, iGeomSequence.getNEntities()[n2]);
            }
            ++n2;
        }
        return nArray;
    }

    private static int[][] a(HideGeom hideGeom, IGeomSequence iGeomSequence, MeshSequence meshSequence) {
        int[][] nArrayArray = new int[iGeomSequence.getSDim() + 1][];
        int[] nArray = hideGeom.dimension();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            if (meshSequence == null) {
                nArrayArray[n4] = hideGeom.entities(n4);
            } else if (iGeomSequence.isDefinedByMesh()) {
                int[] nArray2 = hideGeom.entities(n4);
                if (nArray2.length > 0) {
                    nArray2 = meshSequence.mapFinalizedToCurrent(n4, nArray2);
                }
                nArrayArray[n4] = nArray2;
            } else {
                nArrayArray[n4] = hideGeom.meshControlEntities(meshSequence.tag(), n4);
            }
            ++n3;
        }
        return nArrayArray;
    }

    public static View getCurrentView(ViewList<? extends View> viewList, IGeomSequence iGeomSequence, String string) {
        List list = viewList.getListView();
        if (iGeomSequence.getUndefGeom() != null) {
            iGeomSequence = iGeomSequence.getUndefGeom();
        }
        if (iGeomSequence.getModel().isSavePoint()) {
            Object object = iGeomSequence.getModel().tag();
            SavePointGeom savePointGeom = viewList.getModel().savePoint((String)object).geom().getSavePointGeom(iGeomSequence);
            if (savePointGeom == null) {
                return null;
            }
            list = savePointGeom.view().getListView();
        }
        for (Object object : list) {
            if (!object.isCurrent() || !iGeomSequence.equals(object.getGeomSequence()) || !FlStringUtil.equals((String)string, (String)object.getTargetAxis())) continue;
            return object;
        }
        return null;
    }

    public static View getGlobalCurrent(Model model) {
        return model.view().stream().filter(view -> view.isGlobalcurrent()).findFirst().orElse(null);
    }

    private static boolean a(View view) {
        IGeomSequence iGeomSequence = view.getGeomSequence();
        if (iGeomSequence instanceof GeomSequence && iGeomSequence.isWorkPlane()) {
            return ((GeomSequence)iGeomSequence).getWorkplane3d();
        }
        return false;
    }

    public static PropAnnotationInfo.o createDisablerForViewWorkPlaneGeometryIn3D(View view) {
        return () -> ViewUtil.a(view);
    }

    public static PropAnnotationInfo.o createDisablerForViewInSketchMode(ViewFeature viewFeature) {
        return () -> viewFeature.getBoolean("forcenoviewscaling");
    }

    public static View getModelView2D(PropFeature propFeature) {
        if (propFeature == null) {
            return null;
        }
        if (propFeature instanceof View && ViewOperationID.MODELVIEW2D.toString().equals(propFeature.getOperationID())) {
            return (View)propFeature;
        }
        if (propFeature.getContainer() instanceof View && ViewOperationID.MODELVIEW2D.toString().equals(((View)propFeature.getContainer()).getOperationID())) {
            return (View)propFeature.getContainer();
        }
        return null;
    }

    public static View getModelView3D(PropFeature propFeature) {
        if (propFeature == null) {
            return null;
        }
        if (propFeature instanceof View && ViewOperationID.MODELVIEW3D.toString().equals(propFeature.getOperationID())) {
            return (View)propFeature;
        }
        if (propFeature.getContainer() instanceof View && ViewOperationID.MODELVIEW3D.toString().equals(((View)propFeature.getContainer()).getOperationID())) {
            return (View)propFeature.getContainer();
        }
        return null;
    }

    public static boolean isResultViewFeature(PropFeature propFeature) {
        ViewFeature viewFeature;
        View view;
        return propFeature instanceof ViewFeature && (view = ViewUtil.getView(viewFeature = (ViewFeature)propFeature)) != null && FlStringUtil.contains((String[])ViewOperationID.RESULTVIEWS, (String)view.getOperationID());
    }

    public static View getView(ViewFeature viewFeature) {
        if (viewFeature == null || viewFeature.getContainer() == null) {
            return null;
        }
        if (viewFeature.getContainer() instanceof View) {
            return (View)viewFeature.getContainer();
        }
        if (viewFeature.getContainer().getContainer() instanceof View) {
            return (View)viewFeature.getContainer().getContainer();
        }
        return null;
    }

    public static void sanityCheckViews(ViewList<? extends View> viewList, String string) {
        HashMap<IGeomSequence, Object> hashMap = new HashMap<IGeomSequence, Object>();
        for (View entry : viewList) {
            IGeomSequence iGeomSequence;
            if (!FlStringUtil.equals((String)string, (String)entry.getTargetAxis()) || !((iGeomSequence = entry.getGeomSequence()) instanceof GeomSequence)) continue;
            Object object = (Boolean)hashMap.get(iGeomSequence);
            if (object == null) {
                object = entry.isCurrent();
                hashMap.put(iGeomSequence, object);
                continue;
            }
            if (!entry.isCurrent()) continue;
            hashMap.put(iGeomSequence, true);
        }
        block1: for (Map.Entry entry : hashMap.entrySet()) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            for (View view : viewList) {
                IGeomSequence iGeomSequence;
                if (!FlStringUtil.equals((String)string, (String)view.getTargetAxis()) || (iGeomSequence = view.getGeomSequence()) != entry.getKey()) continue;
                view.setCurrent(true);
                continue block1;
            }
        }
    }
}

