/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util.saveload;

import com.comsol.dbmigration.framework.ModelTypes;
import com.comsol.model.data.Node;
import com.comsol.model.data.Root;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.design.Design;
import com.comsol.model.dbimodel.design.DesignMigrationVersion;
import com.comsol.model.dbmodel.ModelDb;
import com.comsol.model.dbmodel.ModelDbUtil;
import com.comsol.model.dbmodel.design.DesignDb;
import com.comsol.model.operations.IDesignOperation;
import com.comsol.model.plugin.internal.CsPlugin;
import com.comsol.model.savepoint.interfaces.IModel;
import com.comsol.model.simple.SimpleUtil;
import com.comsol.model.util.BuilderUtil;
import com.comsol.model.util.IStoredModel;
import com.comsol.model.util.SaveLoadFile;
import com.comsol.model.util.saveload.AbstractModelSaver;
import com.comsol.model.util.saveload.IModelMiscSaver;
import com.comsol.nativeutil.runnable.k;
import com.comsol.systemutils.SystemUtil;
import com.comsol.util.classes.CsAbstractPlugin;
import com.comsol.util.classes.CsXMLWriter;
import com.comsol.util.classes.FileManagerUtil;
import com.comsol.util.classes.FlVersion;
import com.comsol.util.interfaces.m;
import com.comsol.util.logger.FlLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class PhysicsBuilderSaver
extends AbstractModelSaver {
    private File a;
    private CsXMLWriter b;

    public PhysicsBuilderSaver(IStoredModel iStoredModel, SaveLoadFile saveLoadFile, boolean bl2, IModelMiscSaver iModelMiscSaver) throws IOException {
        super(iStoredModel, saveLoadFile, iModelMiscSaver);
        if (iStoredModel.getModel().isReadOnly()) {
            throw new IllegalStateException("Saving a read-only model is not necessary nor permitted");
        }
        String string = saveLoadFile.getAbsolutePath();
        if (!FileManagerUtil.a()) {
            this.a = SystemUtil.createTempFile((String)"");
            string = this.a.getAbsolutePath();
        }
        OutputStream outputStream = SimpleUtil.wrapWithEncryptOutputStream(new FileOutputStream(string), bl2, null);
        this.b = new CsXMLWriter(new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8)));
        this.b.startDocument();
        this.b.startSection("PhysicsBuilder", new String[]{"fileversion", this.getFileVersionString(ModelTypes.a)});
    }

    @Override
    protected void prepairForResave() throws IOException {
    }

    @Override
    protected void doSave(k k2) throws IOException {
        Model model = this.getModel();
        this.a();
        ((ModelDb)model).updateEntityModified();
        ((ModelDb)model).setComsolVersion(FlVersion.currentProductVersionLongString());
        model.setSavedInVersion(this.migrator.a(ModelTypes.a));
        this.saveLicenceNumber(model);
        model.label(this.modelFile.getName());
        ArrayList<ModelDb> arrayList = new ArrayList<ModelDb>();
        arrayList.add(ModelDbUtil.copy((ModelDb)model, new String[0]));
        for (PropFeature modelEntity : ((DesignDb)model).migration()) {
            Design design = ((DesignMigrationVersion)modelEntity).getSavedModel();
            if (!(design instanceof DesignDb)) continue;
            ModelDb modelDb = ModelDbUtil.copy((DesignDb)design, new String[0]);
            modelDb.tag(design.tag());
            arrayList.add(modelDb);
            if (String.valueOf(((DesignMigrationVersion)modelEntity).getModelVersion()).equals(design.version())) continue;
            FlLogger.c((String)"Version differ from version string in saved model");
        }
        for (Model model2 : arrayList) {
            this.a((Design)model2);
        }
        k2.a(10.0);
        for (Model model3 : arrayList) {
            ((Root)model3.getNode()).toXML(this.b);
        }
        k2.a(90.0);
    }

    private void a() {
        Model model = this.getModel();
        for (IModel iModel : model.getSavePointModels()) {
            CsPlugin.log(CsAbstractPlugin.LogLevel.DEBUG, "Disposing obsolete save point model, " + iModel.tag() + ".");
            model.disposeSavePointModel(iModel.tag(), false);
        }
    }

    private void a(Design design) {
        boolean bl2 = this.modelFile.getAbsolutePath().endsWith(".mphgen");
        boolean bl3 = bl2 || design.isVersion();
        BuilderUtil.CompilationHandler compilationHandler = BuilderUtil.getCompilationHandler(!bl3);
        if (!bl2) {
            BuilderUtil.compileBuilder(design, IDesignOperation.CompilationPass.Save, new HashMap(), compilationHandler, design);
        } else {
            BuilderUtil.compileBuilder(design, IDesignOperation.CompilationPass.Encrypt, new HashMap(), compilationHandler, design);
        }
        if (bl2) {
            BuilderUtil.compileBuilder(design, IDesignOperation.CompilationPass.Optimize, new HashMap(), compilationHandler, design);
        } else if (design.isVersion()) {
            BuilderUtil.compileBuilder(design, IDesignOperation.CompilationPass.ToVersion, new HashMap(), compilationHandler, design);
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Node object : design.getNode().getChildren()) {
            if (object.getType().startsWith("Design")) continue;
            hashSet.add(object.tag());
        }
        hashSet.remove("result");
        hashSet.remove("nodeGroup");
        if (hashSet.remove("common")) {
            design.getNode().removeChild("common");
        }
        for (String string : hashSet) {
            design.getNode().getChild(string).clearChildren();
        }
    }

    @Override
    public void addArchiveEntry(String string, String string2, InputStream inputStream, boolean bl2) throws IOException {
    }

    public CsXMLWriter getWriter() {
        return this.b;
    }

    @Override
    public OutputStream getOutputStream(String string, String string2) throws IOException {
        return null;
    }

    @Override
    protected void finalizeSave(boolean bl2) throws IOException {
        if (bl2) {
            this.b.endSection();
            this.b.endDocument();
            if (this.a != null) {
                FileManagerUtil.a((File)this.a, (String)this.modelFile.getAbsolutePath(), (String)m.a);
                this.a.delete();
            }
        }
    }
}

