/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util.saveload;

import com.comsol.model.data.Root;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbmodel.ModelDb;
import com.comsol.model.util.IStoredModel;
import com.comsol.model.util.ModelInternalUtil;
import com.comsol.model.util.ModelLoadUtil;
import com.comsol.model.util.SaveLoadFile;
import com.comsol.model.util.saveload.AbstractMphArchiveSaver;
import com.comsol.model.util.saveload.ClusterIgnoreXmlUtil;
import com.comsol.model.util.saveload.CorruptZipArchiveException;
import com.comsol.model.util.saveload.IModelMiscSaver;
import com.comsol.nativemph.binary.BinaryManager;
import com.comsol.nativeutil.preferences.Preferences;
import com.comsol.systemutils.SystemUtil;
import com.comsol.util.classes.FileManagerUtil;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.file.b;
import com.comsol.util.file.c;
import com.comsol.util.library.LibraryResourceUtil;
import com.comsol.util.methods.FlFileUtil;
import com.comsol.util.methods.FlLocale;
import de.schlichtherle.util.zip.ZipEntry;
import de.schlichtherle.util.zip.ZipOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;

public class ZipMphSaver
extends AbstractMphArchiveSaver {
    public static boolean simulateCorruptZipArchive;
    protected File tmpFile;
    protected ZipOutputStream zipOutput;
    private static /* synthetic */ int[] a;

    public ZipMphSaver(IStoredModel iStoredModel, SaveLoadFile saveLoadFile, c[] cArray, boolean bl2) throws IOException {
        super(iStoredModel, saveLoadFile, cArray, bl2);
        this.init();
    }

    public ZipMphSaver(IStoredModel iStoredModel, SaveLoadFile saveLoadFile, c[] cArray, boolean bl2, IModelMiscSaver iModelMiscSaver) throws IOException {
        super(iStoredModel, saveLoadFile, cArray, bl2, iModelMiscSaver);
        this.init();
    }

    protected void init() throws IOException {
        this.tmpFile = this.getTemporaryFile(this.modelFile);
        this.zipOutput = this.createZipOutputStream(this.tmpFile);
    }

    @Override
    protected void prepairForResave() throws IOException {
        this.init();
    }

    @Override
    protected void saveClusterIgnore(Model model, com.comsol.nativemph.binary.a a2, Map<BinaryManager.g, String> map) throws IOException {
        File file = SystemUtil.createTempFile((String)".xml");
        ClusterIgnoreXmlUtil.writeClusterIgnoreXml(model, a2, file, map);
        this.addArchiveEntry("", "clusterignore.xml", file, true);
    }

    protected File getTemporaryFile(SaveLoadFile saveLoadFile) throws IOException {
        if (SystemUtil.isDotNet()) {
            try {
                String string;
                if (FileManagerUtil.a()) {
                    return this.makeTmpFile(saveLoadFile.getAbsolutePath());
                }
                if (this.getModel() != null && this.getModel().allowsRecovery() && (string = this.getModel().getRecoveryDir()) != null) {
                    return File.createTempFile("model", ".mph", new File(string));
                }
                return SystemUtil.createTempFile((String)".mph");
            }
            catch (SecurityException securityException) {
                return SystemUtil.createTempFile((String)".mph");
            }
        }
        return this.makeTmpFile(saveLoadFile.getAbsolutePath());
    }

    protected File makeTmpFile(String string) throws IOException {
        File file = new File(string).getParentFile();
        return File.createTempFile("~model", ".mph", file);
    }

    protected ZipOutputStream createZipOutputStream(File file) throws IOException {
        if (file == null) {
            throw new FlException("No_filename_given");
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)new FileOutputStream(file.getAbsolutePath()));
        zipOutputStream.setLevel(this.getCompressionLevel());
        return zipOutputStream;
    }

    protected int getCompressionLevel() {
        return "speed".equals(Preferences.getInstance().getPreference("tempfiles.saving.optimize")) ? 0 : 1;
    }

    @Override
    protected String getArchivePath() {
        return this.tmpFile.getAbsolutePath();
    }

    public static void addArchiveEntryToStream(String string, String string2, InputStream inputStream, boolean bl2, ZipOutputStream zipOutputStream, int n2) throws IOException {
        if (bl2) {
            zipOutputStream.setLevel(0);
        }
        String string3 = string.length() > 0 ? String.valueOf(string) + "/" + string2 : string2;
        try {
            FlFileUtil.a((String)string3, (InputStream)inputStream, (ZipOutputStream)zipOutputStream);
        }
        finally {
            inputStream.close();
            if (bl2) {
                zipOutputStream.setLevel(n2);
            }
        }
    }

    @Override
    public void addArchiveEntry(String string, String string2, InputStream inputStream, boolean bl2) throws IOException {
        ZipMphSaver.addArchiveEntryToStream(string, string2, inputStream, bl2, this.zipOutput, this.getCompressionLevel());
    }

    @Override
    public OutputStream getOutputStream(String string, String string2) throws IOException {
        this.zipOutput.putNextEntry(new ZipEntry(string.length() > 0 ? String.valueOf(string) + "/" + string2 : string2));
        return new a();
    }

    @Override
    protected BinaryManager.b getBinaryResourceSaver() throws IOException {
        return new AbstractMphArchiveSaver.BinaryResourceIDWriter(this, new BinaryManager.b(){

            public BinaryManager.d entryAdded(String string, long l2) {
                return null;
            }

            public OutputStream getOutputStream(String string) throws IOException {
                return ZipMphSaver.this.getOutputStream("", string);
            }

            public boolean isFile() {
                return false;
            }

            public File getTargetFile(String string) {
                return null;
            }

            public File getTargetParent() {
                return ZipMphSaver.this.tmpFile;
            }

            public boolean trySaveFromMetaData(BinaryManager.d d2, String string) {
                return false;
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void finalizeSave(boolean bl2) throws IOException {
        if (this.zipOutput == null) {
            return;
        }
        this.zipOutput.close();
        com.comsol.nativemph.binary.a a2 = ((Root)this.getModel().getNode()).getBinaryManager();
        if (!this.tmpFile.getAbsolutePath().equals(this.modelFile.getAbsolutePath())) {
            if (bl2) {
                if (!this.c(this.tmpFile) || simulateCorruptZipArchive) {
                    this.tmpFile.delete();
                    throw new CorruptZipArchiveException();
                }
                if (SystemUtil.isDotNet() && !FileManagerUtil.a() && this.modelFile.getClientPath() != null) {
                    void var3_6;
                    File file;
                    if (!this.saveCopy) {
                        String string = ((BinaryManager)a2).getZipFilePath(Integer.valueOf(this.getModel().getModelID()), true);
                        if (string != null && (file = new File(string)).exists()) {
                            a2.extractUsedFilesFromArchive(file);
                        }
                        this.unlockMphFile(a2);
                    }
                    Object var3_4 = null;
                    try {
                        FileManagerUtil.a((File)this.tmpFile, (String)this.modelFile.getClientPath(), (String)this.getModel().tag(), (boolean)false);
                    }
                    catch (FlException flException) {
                        FlException flException2 = flException;
                    }
                    if (this.saveCopy) {
                        this.tmpFile.delete();
                    } else {
                        file = this.tmpFile;
                        File file2 = ((ModelDb)this.getModel()).getTemporaryServerFile();
                        IOException iOException = null;
                        if (file2 != null && file2.exists()) {
                            try {
                                this.copyTmpToFinalFile(file2);
                                file = file2;
                                this.tmpFile.delete();
                            }
                            catch (IOException iOException2) {
                                iOException = iOException2;
                            }
                        }
                        ((BinaryManager)a2).updateResourcePointersAfterSave(this.tmpFile, file);
                        this.lockMphFile(a2, file);
                        ((ModelDb)this.getModel()).setTemporaryServerFile(file);
                        if (iOException != null) {
                            throw iOException;
                        }
                    }
                    if (var3_6 == null) return;
                    throw var3_6;
                }
                boolean bl3 = true;
                try {
                    String string = this.modelFile.getClientPath();
                    File file = string != null ? new File(string) : this.modelFile.getServerFile();
                    String string2 = null;
                    try {
                        File file3;
                        if (!this.saveCopy) {
                            string2 = ((BinaryManager)a2).getZipFilePath(Integer.valueOf(this.getModel().getModelID()), true);
                            if (string2 != null && (file3 = new File(string2)).exists()) {
                                a2.extractUsedFilesFromArchive(file3);
                            }
                            this.unlockMphFile(a2);
                        }
                        this.copyTmpToFinalFile(file);
                        if (!this.saveCopy && !SystemUtil.isApplicationServer()) {
                            ((ModelDb)this.getModel()).setTemporaryServerFile(null);
                        }
                        if (!this.saveCopy) {
                            file3 = ((ModelDb)this.getModel()).getTemporaryFileAfterFailedSave();
                            ((ModelDb)this.getModel()).setTemporaryFileAfterFailedSave(null, !file.equals(file3));
                        }
                    }
                    catch (IOException iOException) {
                        if (string2 == null || this.saveCopy) throw iOException;
                        File file4 = new File(string2);
                        if (file4.exists()) {
                            this.lockMphFile(a2, file4);
                            if (((ModelDb)this.getModel()).getTemporaryFileAfterFailedSave() == null) throw iOException;
                            FlException flException = new FlException("Failed_to_save_to_X_The_file_may_be_temporarily_locked_by_another_program_The_model_is_saved_in_the_temporary_file_Y_which_will_be_deleted_after_the_next_successful_save#" + file.getName() + "#" + file4.getName());
                            flException.addParameterPair("Error", iOException.getMessage());
                            throw flException;
                        }
                        boolean bl4 = false;
                        this.lockMphFile(a2, this.tmpFile);
                        ((ModelDb)this.getModel()).setTemporaryFileAfterFailedSave(this.tmpFile, true);
                        FlException flException = new FlException("Failed_to_save_to_X_The_file_may_be_temporarily_locked_by_another_program_The_model_is_saved_in_the_temporary_file_Y_which_will_be_deleted_after_the_next_successful_save#" + file.getName() + "#" + this.tmpFile.getName());
                        flException.addParameterPair("Error", iOException.getMessage());
                        throw flException;
                    }
                    if (this.saveCopy) return;
                    ((BinaryManager)a2).updateResourcePointersAfterSave(this.tmpFile, file);
                    this.lockMphFile(a2, file);
                    return;
                }
                finally {
                    if (bl3) {
                        this.tmpFile.delete();
                    }
                }
            }
            this.tmpFile.delete();
            return;
        }
        this.unlockMphFile(a2);
    }

    protected void copyTmpToFinalFile(File file) throws IOException {
        if (file.exists() && !file.canWrite()) {
            throw new IOException(FlLocale.getErrorString((String)"Failed_to_save_model"));
        }
        if (file.exists() && !file.delete()) {
            this.a(file);
        } else if (!this.tmpFile.renameTo(file)) {
            FlFileUtil.a((File)this.tmpFile, (File)file);
        }
    }

    private void a(File file) throws IOException {
        switch (ZipMphSaver.b()[this.b(file).ordinal()]) {
            case 1: 
            case 4: {
                FlFileUtil.a((File)this.tmpFile, (File)file);
                break;
            }
            case 2: {
                throw new IOException(FlLocale.getErrorString((String)("Failed_to_save_model_The_file_X_is_locked_by_another_program#" + file.getName())));
            }
            case 3: {
                throw new IOException(FlLocale.getErrorString((String)("Failed_to_save_model_The_file_X_is_locked_by_another_model#" + file.getName())));
            }
        }
    }

    private ModelLoadUtil.Locking b(File file) throws IOException {
        return ModelLoadUtil.testIfLocked(file.getAbsolutePath(), ModelInternalUtil.getModelManager());
    }

    private boolean c(File file) {
        b b2 = null;
        try {
            try {
                b2 = new b(file);
                Enumeration enumeration = b2.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                    Throwable throwable = null;
                    Object var6_6 = null;
                    try {
                        InputStream inputStream = b2.getInputStream(zipEntry);
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
            catch (IOException iOException) {
                if (b2 != null) {
                    try {
                        b2.close();
                    }
                    catch (IOException iOException2) {}
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            if (b2 != null) {
                try {
                    b2.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (b2 != null) {
            try {
                b2.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    protected void lockMphFile(com.comsol.nativemph.binary.a a2, File file) throws IOException {
        Model model = this.getModel();
        ModelInternalUtil.getModelManager().lockFile(model.getModelID(), model.tag(), a2, file, null);
    }

    protected void unlockMphFile(com.comsol.nativemph.binary.a a2) throws IOException {
        Model model = this.getModel();
        ModelInternalUtil.getModelManager().unlockFile(model.getModelID(), model.tag(), a2);
    }

    @Override
    protected boolean supportsLibraryIndexing() {
        return "COMSOL".equals(System.getProperty("cs.modeluser")) && LibraryResourceUtil.i((String)this.modelFile.getName());
    }

    static /* synthetic */ int[] b() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[ModelLoadUtil.Locking.values().length];
        try {
            nArray[ModelLoadUtil.Locking.LOCKEDBYME.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModelLoadUtil.Locking.LOCKEDBYOTHER.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModelLoadUtil.Locking.NOACCESS.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModelLoadUtil.Locking.UNLOCKED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }

    private class a
    extends OutputStream {
        private a() {
        }

        @Override
        public void write(int n2) throws IOException {
            ZipMphSaver.this.zipOutput.write(n2);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            ZipMphSaver.this.zipOutput.write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            ZipMphSaver.this.zipOutput.write(byArray, n2, n3);
        }

        @Override
        public void close() throws IOException {
            ZipMphSaver.this.zipOutput.closeEntry();
        }

        @Override
        public void flush() throws IOException {
            ZipMphSaver.this.zipOutput.flush();
        }
    }
}

